/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.codeWithMe.ClientId;
import com.intellij.database.DbScopeProvider;
import com.intellij.database.Dbms;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.csv.CsvFormatsSettings;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.DatabaseTableGridDataHookUp;
import com.intellij.database.datagrid.DbGridDataHookUpUtil;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.DbExtractorConfig;
import com.intellij.database.extractors.DbObjectFormatter;
import com.intellij.database.extractors.ExtractorConfig;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.SqlInsertsExtractorFactory;
import com.intellij.database.extractors.SqlUpdatesExtractorFactory;
import com.intellij.database.extractors.XlsxExtractorFactory;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.remote.jdbc.helpers.MongoJdbcHelper;
import com.intellij.database.run.actions.DbTablesSource;
import com.intellij.database.run.actions.DumpAction;
import com.intellij.database.run.actions.DumpSource;
import com.intellij.database.settings.CsvSettings;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.Version;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.view.DbDumpDataFormKt;
import com.intellij.database.view.ui.DumpDataDialog;
import com.intellij.database.view.ui.DumpDataForm;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.util.containers.JBIterable;
import java.awt.Window;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0001\"B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007H\u0014J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J\u0012\u0010\u0014\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J\u0012\u0010\u0015\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J\u001c\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0014J\u001e\u0010\u0018\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0018\u00010\u00192\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0014J\u0018\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u00192\u0006\u0010\u0006\u001a\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0006\u001a\u00020\u001cJ\u001e\u0010\u001f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010 \u0018\u00010\u00192\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0014J\u0018\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u00192\u0006\u0010\u0006\u001a\u00020\u001cH\u0002R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/database/view/DbDumpDataForm;", "Lcom/intellij/database/view/ui/DumpDataForm;", "dialog", "Lcom/intellij/database/view/ui/DumpDataDialog;", "project", "Lcom/intellij/openapi/project/Project;", "source", "Lcom/intellij/database/run/actions/DumpSource;", "<init>", "(Lcom/intellij/database/view/ui/DumpDataDialog;Lcom/intellij/openapi/project/Project;Lcom/intellij/database/run/actions/DumpSource;)V", "myDbTableGridDataHookUp", "Lcom/intellij/database/datagrid/DatabaseTableGridDataHookUp;", "myCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "getSourceText", "", "supportsAddComputedOrGeneratedColumns", "", "factory", "Lcom/intellij/database/extractors/DataExtractorFactory;", "supportsTranspose", "supportsAddTableDefinition", "createConfig", "Lcom/intellij/database/extractors/ExtractorConfig;", "getRows", "", "Lcom/intellij/database/datagrid/GridRow;", "getRowPreviewsForDbTable", "Lcom/intellij/database/run/actions/DbTablesSource;", "createDbTableGridHookAndFetchData", "", "getColumns", "Lcom/intellij/database/datagrid/GridColumn;", "getColumnsPreviewsForDbTable", "Companion", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbDumpDataForm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbDumpDataForm.kt\ncom/intellij/database/view/DbDumpDataForm\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n42#2,3:189\n1#3:192\n*S KotlinDebug\n*F\n+ 1 DbDumpDataForm.kt\ncom/intellij/database/view/DbDumpDataForm\n*L\n55#1:189,3\n*E\n"})
public final class DbDumpDataForm
extends DumpDataForm {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private DatabaseTableGridDataHookUp myDbTableGridDataHookUp;
    @NotNull
    private final CoroutineScope myCoroutineScope;
    @NotNull
    private static final List<DataConsumer.Column> MONGO_PREVIEW_COLUMNS;
    @NotNull
    private static final List<DataConsumer.Row> MONGO_PREVIEW_ROWS;

    public DbDumpDataForm(@NotNull DumpDataDialog dialog, @NotNull Project project, @NotNull DumpSource<?> source) {
        Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(source, (String)"source");
        super(project, source, () -> DbDumpDataForm._init_$lambda$0(dialog), (CsvFormatsSettings)CsvSettings.getSettings(), dialog.getDisposable(), true);
        boolean $i$f$service = false;
        Class<DbScopeProvider> serviceClass$iv = DbScopeProvider.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        CoroutineScope coroutineScope = ((DbScopeProvider)object).getCs();
        String string = ((Object)((Object)this)).getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.myCoroutineScope = CoroutineScopeKt.childScope$default((CoroutineScope)coroutineScope, (String)string, null, (boolean)false, (int)6, null);
        Disposer.register((Disposable)this.myDisposable, () -> DbDumpDataForm._init_$lambda$1(this));
    }

    @Nullable
    protected String getSourceText(@Nullable DumpSource<?> source) {
        if (source instanceof DumpSource.DataGridSource) {
            DasObject table;
            DasObject dasObject = table = DataGridUtilCore.getDatabaseTable((CoreGrid)((CoreGrid)((DumpSource.DataGridSource)source).getGrid()));
            return dasObject == null ? null : QNameUtil.getQualifiedName((DasObject)dasObject);
        }
        if (source instanceof DbTablesSource) {
            JBIterable jBIterable;
            JBIterable it = jBIterable = ((DbTablesSource)source).getSources().map(arg_0 -> DbDumpDataForm.getSourceText$lambda$1(DbDumpDataForm::getSourceText$lambda$0, arg_0));
            boolean bl = false;
            JBIterable jBIterable2 = it.isNotEmpty() ? jBIterable : null;
            return jBIterable2 != null ? CollectionsKt.joinToString$default((Iterable)((Iterable)jBIterable2), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) : null;
        }
        return null;
    }

    protected boolean supportsAddComputedOrGeneratedColumns(@Nullable DataExtractorFactory factory) {
        return factory instanceof SqlInsertsExtractorFactory;
    }

    protected boolean supportsTranspose(@Nullable DataExtractorFactory factory) {
        return super.supportsTranspose(factory) || !(factory instanceof SqlInsertsExtractorFactory) && !(factory instanceof SqlUpdatesExtractorFactory) && !(factory instanceof XlsxExtractorFactory);
    }

    protected boolean supportsAddTableDefinition(@Nullable DataExtractorFactory factory) {
        return factory instanceof SqlInsertsExtractorFactory;
    }

    @NotNull
    protected ExtractorConfig createConfig(@NotNull Project project, @NotNull DumpSource<?> source) {
        DbDataSource system;
        DasObject dasObject;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(source, (String)"source");
        DataGrid grid = source instanceof DumpSource.DataGridSource ? ((DumpSource.DataGridSource)source).getGrid() : null;
        DataGrid dataGrid = grid;
        if (dataGrid != null) {
            dasObject = DataGridUtilCore.getDatabaseTable((CoreGrid)((CoreGrid)dataGrid));
        } else if (source instanceof DbTablesSource) {
            JBIterable<DbTable> jBIterable = ((DbTablesSource)source).getSources();
            Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"getSources(...)");
            dasObject = (DasObject)CollectionsKt.firstOrNull((Iterable)((Iterable)jBIterable));
        } else {
            dasObject = null;
        }
        DasObject table = dasObject;
        Dbms dbms = DumpAction.getDbms(source);
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        DataGrid dataGrid2 = grid;
        ObjectFormatter formatter = dataGrid2 != null ? dataGrid2.getObjectFormatter() : (ObjectFormatter)new DbObjectFormatter(dbms2);
        DbDataSource dbDataSource = system = DataGridUtilCore.getDatabaseSystem((CoreGrid)((CoreGrid)grid));
        return (ExtractorConfig)new DbExtractorConfig(project, dbms2, formatter, table, (Version)(dbDataSource != null ? dbDataSource.getVersion() : null));
    }

    @Nullable
    protected List<GridRow> getRows(@NotNull DumpSource<?> source) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        Dbms dbms = DumpAction.getDbms(source);
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        if (source instanceof DbTablesSource) {
            return this.getRowPreviewsForDbTable((DbTablesSource)source);
        }
        return dbms2.isMongo() ? MONGO_PREVIEW_ROWS : super.getRows(source);
    }

    private final List<GridRow> getRowPreviewsForDbTable(DbTablesSource source) {
        if (this.myDbTableGridDataHookUp != null) {
            DatabaseTableGridDataHookUp databaseTableGridDataHookUp = this.myDbTableGridDataHookUp;
            Intrinsics.checkNotNull((Object)((Object)databaseTableGridDataHookUp));
            List list = databaseTableGridDataHookUp.getDataModel().getRows();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRows(...)");
            return list;
        }
        this.createDbTableGridHookAndFetchData(source);
        return CollectionsKt.emptyList();
    }

    public final void createDbTableGridHookAndFetchData(@NotNull DbTablesSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (this.myDbTableGridDataHookUp == null) {
            DbTable dbTable = (DbTable)source.getSources().get(0);
            if (dbTable == null) {
                return;
            }
            DbTable dbTable2 = dbTable;
            DatabaseElementVirtualFileImpl databaseElementVirtualFileImpl = DatabaseElementVirtualFileImpl.findFile((DbElement)((DbElement)dbTable2), (boolean)false);
            if (databaseElementVirtualFileImpl == null) {
                return;
            }
            DatabaseElementVirtualFileImpl virtualFile = databaseElementVirtualFileImpl;
            Project project = dbTable2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            ModalityState modalityState = ModalityState.defaultModalityState();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"defaultModalityState(...)");
            ModalityState modalityState2 = modalityState;
            DGDepartment.DataEditor editor2 = new DGDepartment.DataEditor(SessionsUtil.getQualifiedClientTitle((Project)project2, (DasDataSource)((DasDataSource)dbTable2.getDataSource()), (VirtualFile)((VirtualFile)virtualFile)));
            this.myDbTableGridDataHookUp = DbGridDataHookUpUtil.getOrCreateLightweight(project2, (VirtualFile)virtualFile, this.myDisposable, (DatabaseDepartment)editor2);
            if (this.myDbTableGridDataHookUp == null) {
                return;
            }
            DatabaseTableGridDataHookUp databaseTableGridDataHookUp = this.myDbTableGridDataHookUp;
            Intrinsics.checkNotNull((Object)((Object)databaseTableGridDataHookUp));
            DatabaseTableGridDataHookUp dbTableGridDataHookUp = databaseTableGridDataHookUp;
            dbTableGridDataHookUp.getPageModel().setPageSize(10);
            BuildersKt.launch$default((CoroutineScope)this.myCoroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE).plus(ModalityKt.asContextElement((ModalityState)modalityState2)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(dbTableGridDataHookUp, this, null){
                Object L$0;
                int label;
                final /* synthetic */ DatabaseTableGridDataHookUp $dbTableGridDataHookUp;
                final /* synthetic */ DbDumpDataForm this$0;
                {
                    this.$dbTableGridDataHookUp = $dbTableGridDataHookUp;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            gridRequestSource = new GridRequestSource(null);
                            this.$dbTableGridDataHookUp.getLoader().loadFirstPage(gridRequestSource);
                            v0 = gridRequestSource.getActionCallback();
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getActionCallback(...)");
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)gridRequestSource);
                            this.label = 1;
                            v1 = com.intellij.openapi.util.CoroutinesKt.await((ActionCallback)v0, (Continuation)((Continuation)this));
                            ** if (v1 != var3_2) goto lbl16
lbl15:
                            // 1 sources

                            return var3_2;
lbl16:
                            // 1 sources

                            ** GOTO lbl23
                        }
                        case 1: {
                            gridRequestSource = (GridRequestSource)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl23:
                                // 2 sources

                                this.this$0.updatePreview();
                            }
                            catch (CancellationException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                DbDumpDataFormKt.access$getLOG$p().warn((Throwable)e);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    @Nullable
    protected List<GridColumn> getColumns(@NotNull DumpSource<?> source) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        Dbms dbms = DumpAction.getDbms(source);
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        if (source instanceof DbTablesSource) {
            return this.getColumnsPreviewsForDbTable((DbTablesSource)source);
        }
        return dbms2.isMongo() ? MONGO_PREVIEW_COLUMNS : super.getColumns(source);
    }

    private final List<GridColumn> getColumnsPreviewsForDbTable(DbTablesSource source) {
        if (this.myDbTableGridDataHookUp != null) {
            DatabaseTableGridDataHookUp databaseTableGridDataHookUp = this.myDbTableGridDataHookUp;
            Intrinsics.checkNotNull((Object)((Object)databaseTableGridDataHookUp));
            List list = databaseTableGridDataHookUp.getDataModel().getColumns();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getColumns(...)");
            return list;
        }
        this.createDbTableGridHookAndFetchData(source);
        return CollectionsKt.emptyList();
    }

    private static final Window _init_$lambda$0(DumpDataDialog $dialog) {
        return $dialog.getWindow();
    }

    private static final void _init_$lambda$1(DbDumpDataForm this$0) {
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this$0.myCoroutineScope, null, (int)1, null);
    }

    private static final String getSourceText$lambda$0(DbTable it) {
        return QNameUtil.getQualifiedName((DbElement)((DbElement)it));
    }

    private static final String getSourceText$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    static {
        Object[] objectArray = new DataConsumer.Column[]{new DataConsumer.Column(0, "_id", 1111, "objectId", "org.bson.types.ObjectId"), new DataConsumer.Column(1, "first_name", 12, "string", "java.lang.String"), new DataConsumer.Column(2, "last_name", 12, "string", "java.lang.String"), new DataConsumer.Column(3, "gender", 12, "string", "java.lang.String"), new DataConsumer.Column(4, "phones", 1111, "array", "java.lang.List")};
        MONGO_PREVIEW_COLUMNS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new DataConsumer.Row[10];
        Object[] objectArray2 = new Object[5];
        objectArray2[0] = new MongoJdbcHelper.MongoObjectIdValue("5e5e7711f704714f53ebf2af");
        objectArray2[1] = "Georgi";
        objectArray2[2] = "Facello";
        objectArray2[3] = "M";
        Object[] objectArray3 = new String[]{"136-73018", "458-97405"};
        objectArray2[4] = CollectionsKt.listOf((Object[])objectArray3);
        objectArray[0] = DataConsumer.Row.create((int)0, (Object[])objectArray2);
        objectArray2 = new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5ca4bbcea2dd94ee58162a6a"), "Bezalel", "Simmel", "F", CollectionsKt.listOf((Object)"869-28540")};
        objectArray[1] = DataConsumer.Row.create((int)1, (Object[])objectArray2);
        objectArray2 = new Object[5];
        objectArray2[0] = new MongoJdbcHelper.MongoObjectIdValue("5e580fcbbdfc015d7d5d401e");
        objectArray2[1] = "Parto";
        objectArray2[2] = "Bamford";
        objectArray2[3] = "M";
        objectArray3 = new String[]{"752-48018", "752-25445"};
        objectArray2[4] = CollectionsKt.listOf((Object[])objectArray3);
        objectArray[2] = DataConsumer.Row.create((int)2, (Object[])objectArray2);
        objectArray2 = new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5e580fcbbdfc015d7d5d401f"), "Chirstian", "Koblick", "M", CollectionsKt.emptyList()};
        objectArray[3] = DataConsumer.Row.create((int)3, (Object[])objectArray2);
        objectArray2 = new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5ca4bbcea2dd94ee58162a70"), "Kyoichi", "Maliniak", "M", CollectionsKt.listOf((Object)"985-85742")};
        objectArray[4] = DataConsumer.Row.create((int)4, (Object[])objectArray2);
        objectArray2 = new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5ca4bbcea2dd94ee58162a6e"), "Anneke", "Preusig", "F", CollectionsKt.emptyList()};
        objectArray[5] = DataConsumer.Row.create((int)5, (Object[])objectArray2);
        objectArray2 = new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5ca4bbcea2dd94ee58162a6c"), "Tzvetan", "Zielinski", "F", CollectionsKt.listOf((Object)"574-76427")};
        objectArray[6] = DataConsumer.Row.create((int)6, (Object[])objectArray2);
        objectArray2 = new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5ca4bbcea2dd94ee58162a79"), "Saniya", "Kalloufi", "M", CollectionsKt.listOf((Object)"362-98543")};
        objectArray[7] = DataConsumer.Row.create((int)7, (Object[])objectArray2);
        objectArray2 = new Object[5];
        objectArray2[0] = new MongoJdbcHelper.MongoObjectIdValue("5ca4bbcea2dd94ee58162a7a");
        objectArray2[1] = "Sumant";
        objectArray2[2] = "Peac";
        objectArray2[3] = "F";
        objectArray3 = new String[]{"462-24753", "324524"};
        objectArray2[4] = CollectionsKt.listOf((Object[])objectArray3);
        objectArray[8] = DataConsumer.Row.create((int)8, (Object[])objectArray2);
        objectArray2 = new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5ca4bbcea2dd94ee58162a7c"), "Duangkaew", "Piveteau", "F", CollectionsKt.listOf((Object)"356-08750")};
        objectArray[9] = DataConsumer.Row.create((int)9, (Object[])objectArray2);
        MONGO_PREVIEW_ROWS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/database/view/DbDumpDataForm$Companion;", "", "<init>", "()V", "MONGO_PREVIEW_COLUMNS", "", "Lcom/intellij/database/datagrid/DataConsumer$Column;", "MONGO_PREVIEW_ROWS", "Lcom/intellij/database/datagrid/DataConsumer$Row;", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

