/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.completion.frontend.split;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.completion.frontend.split.FrontendLookupElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.thinclient.quickDoc.ThinClientCompletionDocumentationService;
import com.jetbrains.thinclient.quickDoc.ThinClientDocumentationTarget;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/platform/completion/frontend/split/FrontendCompletionDocumentationService;", "Lcom/jetbrains/thinclient/quickDoc/ThinClientCompletionDocumentationService;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "documentationTarget", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "lookupElement", "Lcom/intellij/codeInsight/lookup/LookupElement;", "intellij.platform.completion.frontend.split"})
public final class FrontendCompletionDocumentationService
implements ThinClientCompletionDocumentationService {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope scope;

    public FrontendCompletionDocumentationService(@NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project;
        this.scope = scope;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final CoroutineScope getScope() {
        return this.scope;
    }

    @Nullable
    public DocumentationTarget documentationTarget(@NotNull Editor editor, @NotNull PsiFile file, @NotNull LookupElement lookupElement) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)lookupElement, (String)"lookupElement");
        if (!Registry.Companion.is("remdev.completion.on.frontend")) {
            return null;
        }
        if (!(lookupElement instanceof FrontendLookupElement)) {
            return null;
        }
        TextControlId textControlId = DocumentExKt.getTextControlId((Editor)editor);
        if (textControlId == null) {
            return null;
        }
        TextControlId editorId = textControlId;
        String itemId = ((FrontendLookupElement)lookupElement).getItem().getId().getId().getId();
        String requestId = ((FrontendLookupElement)lookupElement).getRequest().getId().getId().getId();
        return (DocumentationTarget)ThinClientDocumentationTarget.Companion.create(this.project, editorId, editor.getCaretModel().getOffset(), requestId, itemId);
    }
}

