/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.completion.frontend.split;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.platform.completion.common.protocol.RpcCompletionArrangementId;
import com.intellij.platform.completion.common.protocol.RpcCompletionItem;
import com.intellij.platform.completion.common.protocol.RpcCompletionRequest;
import com.intellij.platform.completion.common.protocol.RpcCompletionResponseEvent;
import com.intellij.platform.completion.common.protocol.RpcPrefixCondition;
import com.intellij.platform.completion.common.protocol.RpcPrefixConditionKt;
import com.intellij.platform.completion.common.protocol.RpcPrefixMatcher;
import com.intellij.platform.completion.common.split.RpcCompletionService;
import com.intellij.platform.completion.frontend.split.FrontendAsyncRendering;
import com.intellij.platform.completion.frontend.split.FrontendCompletionClassifierKt;
import com.intellij.platform.completion.frontend.split.FrontendCompletionLoggerKt;
import com.intellij.platform.completion.frontend.split.FrontendCompletionSession;
import com.intellij.platform.completion.frontend.split.FrontendCompletionSessionImplKt;
import com.intellij.platform.completion.frontend.split.FrontendCompletionState;
import com.intellij.platform.completion.frontend.split.FrontendCoroutineScopeServiceKt;
import com.intellij.platform.completion.frontend.split.FrontendExpensiveRenderer;
import com.intellij.platform.completion.frontend.split.FrontendLookupElement;
import com.intellij.platform.completion.frontend.split.FrontendPrefixMatcher;
import fleet.rpc.core.RpcFlow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.sync.Semaphore;
import kotlinx.coroutines.sync.SemaphoreKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\b\u0010!\u001a\u00020\u0018H\u0016J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010&\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\u00182\u0006\u0010&\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020\u00182\u0006\u0010&\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020\u00182\u0006\u0010&\u001a\u00020/H\u0002J\b\u00100\u001a\u00020\u0018H\u0002J\u0010\u00101\u001a\u00020\u00182\u0006\u00102\u001a\u000203H\u0002J\u0016\u00104\u001a\u0004\u0018\u000105*\u0002062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\f\u00107\u001a\u000208*\u000209H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006:"}, d2={"Lcom/intellij/platform/completion/frontend/split/FrontendCompletionSessionImpl;", "Lcom/intellij/platform/completion/frontend/split/FrontendCompletionSession;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "resultSet", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "<init>", "(Lcom/intellij/codeInsight/completion/CompletionParameters;Lcom/intellij/codeInsight/completion/CompletionResultSet;)V", "completionState", "Lcom/intellij/platform/completion/frontend/split/FrontendCompletionState;", "sorter", "Lcom/intellij/codeInsight/completion/CompletionSorter;", "result", "rpcRequest", "Lcom/intellij/platform/completion/common/protocol/RpcCompletionRequest;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "itemsReceivedSemaphore", "Lkotlinx/coroutines/sync/Semaphore;", "asyncRendering", "Lcom/intellij/platform/completion/frontend/split/FrontendAsyncRendering;", "start", "", "scheduleBackendCompletion", "request", "getRequest", "()Lcom/intellij/platform/completion/common/protocol/RpcCompletionRequest;", "currentArrangementId", "Lcom/intellij/platform/completion/common/protocol/RpcCompletionArrangementId;", "getCurrentArrangementId", "()Lcom/intellij/platform/completion/common/protocol/RpcCompletionArrangementId;", "awaitAllItemsReceivedBlocking", "registerCancellationOn", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "processEvent", "event", "Lcom/intellij/platform/completion/common/protocol/RpcCompletionResponseEvent;", "updatePresentations", "Lcom/intellij/platform/completion/common/protocol/RpcCompletionResponseEvent$ExpensivePresentations;", "addWatchedPrefix", "Lcom/intellij/platform/completion/common/protocol/RpcCompletionResponseEvent$AddWatchedPrefix;", "processArrangement", "Lcom/intellij/platform/completion/common/protocol/RpcCompletionResponseEvent$NewArrangement;", "processAdvertisement", "Lcom/intellij/platform/completion/common/protocol/RpcCompletionResponseEvent$Advertisement;", "onCompletionItemFinish", "processCompletionItems", "items", "Lcom/intellij/platform/completion/common/protocol/RpcCompletionResponseEvent$NewItems;", "toCompletionResult", "Lcom/intellij/codeInsight/completion/CompletionResult;", "Lcom/intellij/platform/completion/common/protocol/RpcCompletionItem;", "toPrefixMather", "Lcom/intellij/codeInsight/completion/PrefixMatcher;", "Lcom/intellij/platform/completion/common/protocol/RpcPrefixMatcher;", "intellij.platform.completion.frontend.split"})
@SourceDebugExtension(value={"SMAP\nFrontendCompletionSessionImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendCompletionSessionImpl.kt\ncom/intellij/platform/completion/frontend/split/FrontendCompletionSessionImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n67#2,4:172\n1642#3,10:176\n1915#3:186\n1916#3:188\n1652#3:189\n1#4:187\n*S KotlinDebug\n*F\n+ 1 FrontendCompletionSessionImpl.kt\ncom/intellij/platform/completion/frontend/split/FrontendCompletionSessionImpl\n*L\n86#1:172,4\n127#1:176,10\n127#1:186\n127#1:188\n127#1:189\n127#1:187\n*E\n"})
public final class FrontendCompletionSessionImpl
implements FrontendCompletionSession {
    @NotNull
    private final FrontendCompletionState completionState;
    @NotNull
    private final CompletionSorter sorter;
    @NotNull
    private final CompletionResultSet result;
    @NotNull
    private final RpcCompletionRequest rpcRequest;
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Semaphore itemsReceivedSemaphore;
    @NotNull
    private final FrontendAsyncRendering asyncRendering;

    public FrontendCompletionSessionImpl(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet resultSet) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        this.completionState = new FrontendCompletionState();
        this.sorter = FrontendCompletionClassifierKt.frontendCompletionSorter(this.completionState);
        CompletionResultSet completionResultSet = resultSet.withRelevanceSorter(this.sorter);
        Intrinsics.checkNotNullExpressionValue((Object)completionResultSet, (String)"withRelevanceSorter(...)");
        this.result = completionResultSet;
        this.rpcRequest = FrontendCompletionSessionImplKt.access$prepareCompletionRequest(parameters);
        Project project = parameters.getPosition().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
        this.scope = FrontendCoroutineScopeServiceKt.frontendCompletionScope(this.project, "FrontendCompletionProcess " + this);
        this.itemsReceivedSemaphore = SemaphoreKt.Semaphore((int)1, (int)1);
        this.asyncRendering = new FrontendAsyncRendering(this.rpcRequest.getId(), this.scope);
    }

    public final void start() {
        FrontendCompletionLoggerKt.getFcLogger().info("Starting frontend completion process for request: " + this.rpcRequest);
        ProgressIndicator indicator = ProgressManager.getGlobalProgressIndicator();
        Intrinsics.checkNotNull((Object)indicator);
        this.registerCancellationOn(indicator);
        this.scheduleBackendCompletion();
    }

    private final void scheduleBackendCompletion() {
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ FrontendCompletionSessionImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = RpcCompletionService.Companion.getInstance((Continuation)this);
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        rpcCompletionService = (RpcCompletionService)v0;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)rpcCompletionService);
                        this.label = 2;
                        v1 = rpcCompletionService.getResponse(FrontendCompletionSessionImpl.access$getRpcRequest$p(this.this$0), (Continuation)this);
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl24
                    }
                    case 2: {
                        rpcCompletionService = (RpcCompletionService)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl24:
                        // 2 sources

                        response = (RpcFlow)v1;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)rpcCompletionService);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)response);
                        this.label = 3;
                        v2 = response.toFlow().collect(new FlowCollector(this.this$0){
                            final /* synthetic */ FrontendCompletionSessionImpl this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            public final Object emit(RpcCompletionResponseEvent event, Continuation<? super Unit> $completion) {
                                if (FrontendCompletionLoggerKt.getFcLogger().isDebugEnabled()) {
                                    FrontendCompletionSessionImpl.access$getCompletionState$p(this.this$0).getAllEvents().add(event);
                                }
                                FrontendCompletionSessionImpl.access$processEvent(this.this$0, event);
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (v2 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl37
                    }
                    case 3: {
                        response = (RpcFlow)this.L$1;
                        rpcCompletionService = (RpcCompletionService)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl37:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    @NotNull
    public RpcCompletionRequest getRequest() {
        return this.rpcRequest;
    }

    @Override
    @NotNull
    public RpcCompletionArrangementId getCurrentArrangementId() {
        return this.completionState.getCurrentArrangementId();
    }

    @Override
    public void awaitAllItemsReceivedBlocking() {
        com.intellij.openapi.progress.CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ FrontendCompletionSessionImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FrontendCompletionSessionImpl.access$getItemsReceivedSemaphore$p(this.this$0).acquire((Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        FrontendCompletionLoggerKt.getFcLogger().info("All items are received: " + this.rpcRequest);
    }

    private final void registerCancellationOn(ProgressIndicator progressIndicator) {
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(progressIndicator, this, null){
            int label;
            final /* synthetic */ ProgressIndicator $progressIndicator;
            final /* synthetic */ FrontendCompletionSessionImpl this$0;
            {
                this.$progressIndicator = $progressIndicator;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
lbl6:
                        // 3 sources

                        while (true) {
                            this.label = 1;
                            v0 = DelayKt.delay((long)50L, (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl15
                            break;
                        }
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        if (!this.$progressIndicator.isCanceled()) ** GOTO lbl6
                        FrontendCompletionLoggerKt.getFcLogger().info("Progress indicator canceled, cancelling frontend completion process for request: " + FrontendCompletionSessionImpl.access$getRpcRequest$p(this.this$0));
                        CoroutineScopeKt.cancel$default((CoroutineScope)FrontendCompletionSessionImpl.access$getScope$p(this.this$0), null, (int)1, null);
                        ** continue;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void processEvent(RpcCompletionResponseEvent event) {
        Logger $this$trace$iv = FrontendCompletionLoggerKt.getFcLogger();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Processing event: " + event + ", request: " + this.rpcRequest);
        }
        RpcCompletionResponseEvent rpcCompletionResponseEvent = event;
        if (rpcCompletionResponseEvent instanceof RpcCompletionResponseEvent.NewItems) {
            this.processCompletionItems((RpcCompletionResponseEvent.NewItems)event);
        } else if (rpcCompletionResponseEvent instanceof RpcCompletionResponseEvent.Advertisement) {
            this.processAdvertisement((RpcCompletionResponseEvent.Advertisement)event);
        } else if (rpcCompletionResponseEvent instanceof RpcCompletionResponseEvent.CompletionItemsFinished) {
            this.onCompletionItemFinish();
        } else if (rpcCompletionResponseEvent instanceof RpcCompletionResponseEvent.SkipCompletion) {
            this.onCompletionItemFinish();
        } else if (rpcCompletionResponseEvent instanceof RpcCompletionResponseEvent.NewArrangement) {
            this.processArrangement((RpcCompletionResponseEvent.NewArrangement)event);
        } else if (rpcCompletionResponseEvent instanceof RpcCompletionResponseEvent.AddWatchedPrefix) {
            this.addWatchedPrefix((RpcCompletionResponseEvent.AddWatchedPrefix)event);
        } else if (rpcCompletionResponseEvent instanceof RpcCompletionResponseEvent.ExpensivePresentations) {
            this.updatePresentations((RpcCompletionResponseEvent.ExpensivePresentations)event);
        } else if (!Intrinsics.areEqual((Object)rpcCompletionResponseEvent, (Object)RpcCompletionResponseEvent.CompletionFinished.INSTANCE)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void updatePresentations(RpcCompletionResponseEvent.ExpensivePresentations event) {
        this.asyncRendering.onReceivingExpensivePresentation(event);
    }

    private final void addWatchedPrefix(RpcCompletionResponseEvent.AddWatchedPrefix event) {
        ElementPattern condition = RpcPrefixConditionKt.fromRpc((RpcPrefixCondition)event.getCondition());
        this.result.restartCompletionOnPrefixChange(condition);
    }

    private final void processArrangement(RpcCompletionResponseEvent.NewArrangement event) {
        this.completionState.updateArrangement(event.getCompletionArrangement());
        BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ FrontendCompletionSessionImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        LookupEx lookupEx = LookupManager.getInstance((Project)FrontendCompletionSessionImpl.access$getProject$p(this.this$0)).getActiveLookup();
                        LookupImpl lookupImpl = lookupEx instanceof LookupImpl ? (LookupImpl)lookupEx : null;
                        if (lookupImpl == null) {
                            return Unit.INSTANCE;
                        }
                        LookupImpl lookup = lookupImpl;
                        lookup.getArranger().prefixChanged((Lookup)lookup);
                        lookup.refreshUi(true, false);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void processAdvertisement(RpcCompletionResponseEvent.Advertisement event) {
        this.result.addLookupAdvertisement(event.getMessage());
    }

    private final void onCompletionItemFinish() {
        this.itemsReceivedSemaphore.release();
    }

    /*
     * WARNING - void declaration
     */
    private final void processCompletionItems(RpcCompletionResponseEvent.NewItems items) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = items.getNewItems();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            CompletionResult it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            RpcCompletionItem item = (RpcCompletionItem)element$iv$iv;
            boolean bl2 = false;
            if (this.toCompletionResult(item, this.sorter) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List completionResults = (List)destination$iv$iv;
        this.completionState.updateArrangement(items.getCompletionArrangement());
        for (CompletionResult element : completionResults) {
            this.result.passResult(element);
        }
    }

    private final CompletionResult toCompletionResult(RpcCompletionItem $this$toCompletionResult, CompletionSorter sorter) {
        FrontendExpensiveRenderer frontendExpensiveRenderer;
        boolean bl = $this$toCompletionResult.getHasExpensiveRenderer();
        if (bl) {
            frontendExpensiveRenderer = new FrontendExpensiveRenderer(this.asyncRendering, $this$toCompletionResult.getId());
        } else if (!bl) {
            frontendExpensiveRenderer = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        FrontendExpensiveRenderer expensiveRenderer = frontendExpensiveRenderer;
        FrontendLookupElement element = new FrontendLookupElement($this$toCompletionResult, this.project, this.rpcRequest, (LookupElementRenderer<? extends LookupElement>)((LookupElementRenderer)expensiveRenderer));
        PrefixMatcher prefixMatcher = this.toPrefixMather($this$toCompletionResult.getPrefixMatcher());
        return CompletionResult.wrap((LookupElement)element, (PrefixMatcher)prefixMatcher, (CompletionSorter)sorter);
    }

    private final PrefixMatcher toPrefixMather(RpcPrefixMatcher $this$toPrefixMather) {
        PrefixMatcher prefixMatcher;
        RpcPrefixMatcher rpcPrefixMatcher = $this$toPrefixMather;
        if (rpcPrefixMatcher instanceof RpcPrefixMatcher.Frontend) {
            prefixMatcher = ((RpcPrefixMatcher.Frontend)$this$toPrefixMather).getDescriptor().recreateMatcher();
        } else if (rpcPrefixMatcher instanceof RpcPrefixMatcher.Backend) {
            prefixMatcher = new FrontendPrefixMatcher(((RpcPrefixMatcher.Backend)$this$toPrefixMather).getPrefix(), this.completionState, ((RpcPrefixMatcher.Backend)$this$toPrefixMather).getId());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return prefixMatcher;
    }

    public static final /* synthetic */ RpcCompletionRequest access$getRpcRequest$p(FrontendCompletionSessionImpl $this) {
        return $this.rpcRequest;
    }

    public static final /* synthetic */ FrontendCompletionState access$getCompletionState$p(FrontendCompletionSessionImpl $this) {
        return $this.completionState;
    }

    public static final /* synthetic */ void access$processEvent(FrontendCompletionSessionImpl $this, RpcCompletionResponseEvent event) {
        $this.processEvent(event);
    }

    public static final /* synthetic */ Semaphore access$getItemsReceivedSemaphore$p(FrontendCompletionSessionImpl $this) {
        return $this.itemsReceivedSemaphore;
    }

    public static final /* synthetic */ CoroutineScope access$getScope$p(FrontendCompletionSessionImpl $this) {
        return $this.scope;
    }

    public static final /* synthetic */ Project access$getProject$p(FrontendCompletionSessionImpl $this) {
        return $this.project;
    }
}

