/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.completion.frontend.split;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.platform.completion.common.protocol.RpcCompletionItemId;
import com.intellij.platform.completion.frontend.split.FrontendCompletionClassifierKt;
import com.intellij.platform.completion.frontend.split.FrontendCompletionLoggerKt;
import com.intellij.platform.completion.frontend.split.FrontendCompletionState;
import com.intellij.platform.completion.frontend.split.FrontendLookupElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/completion/frontend/split/WeightingSession;", "", "completionState", "Lcom/intellij/platform/completion/frontend/split/FrontendCompletionState;", "<init>", "(Lcom/intellij/platform/completion/frontend/split/FrontendCompletionState;)V", "getCompletionState", "()Lcom/intellij/platform/completion/frontend/split/FrontendCompletionState;", "errorReported", "", "getWeight", "", "lookupElement", "Lcom/intellij/codeInsight/lookup/LookupElement;", "reportError", "", "Lcom/intellij/platform/completion/frontend/split/FrontendLookupElement;", "id", "Lcom/intellij/platform/completion/common/protocol/RpcCompletionItemId;", "intellij.platform.completion.frontend.split"})
@SourceDebugExtension(value={"SMAP\nFrontendCompletionClassifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendCompletionClassifier.kt\ncom/intellij/platform/completion/frontend/split/WeightingSession\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
final class WeightingSession {
    @NotNull
    private final FrontendCompletionState completionState;
    private boolean errorReported;

    public WeightingSession(@NotNull FrontendCompletionState completionState) {
        Intrinsics.checkNotNullParameter((Object)completionState, (String)"completionState");
        this.completionState = completionState;
    }

    @NotNull
    public final FrontendCompletionState getCompletionState() {
        return this.completionState;
    }

    public final int getWeight(@NotNull LookupElement lookupElement) {
        int n;
        Intrinsics.checkNotNullParameter((Object)lookupElement, (String)"lookupElement");
        RpcCompletionItemId id = ((FrontendLookupElement)lookupElement).getItem().getId();
        Integer n2 = this.completionState.getWeight(id);
        int it = ((Number)n2).intValue();
        boolean bl = false;
        Integer n3 = !(it == -1) ? n2 : null;
        if (n3 != null) {
            n = n3;
        } else {
            n2 = Integer.MAX_VALUE;
            it = ((Number)n2).intValue();
            boolean bl2 = false;
            this.reportError((FrontendLookupElement)lookupElement, id);
            n = ((Number)n2).intValue();
        }
        int weight = n;
        return weight;
    }

    private final void reportError(FrontendLookupElement lookupElement, RpcCompletionItemId id) {
        if (this.errorReported) {
            return;
        }
        this.errorReported = true;
        if (FrontendCompletionLoggerKt.getFcLogger().isDebugEnabled()) {
            int indexAdded = FrontendCompletionClassifierKt.access$findFirstEvent(this.completionState, id);
            List sortingEvents = FrontendCompletionClassifierKt.access$findSortingEvents(this.completionState, id);
            FrontendCompletionLoggerKt.getFcLogger().debug("Weight for id: " + id + " not found, added at index: " + indexAdded + ", sorting events: " + sortingEvents);
        }
        FrontendCompletionLoggerKt.getFcLogger().error("Weight for id: " + id + " not found, " + lookupElement.getLookupString());
    }
}

