/*
 * Decompiled with CFR 0.152.
 */
package training.learn;

import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.dsl.LessonUtil;
import training.dsl.impl.LessonContextImpl;
import training.dsl.impl.LessonExecutor;
import training.lang.LangManager;
import training.lang.LangSupport;
import training.learn.CourseManager;
import training.learn.LearnBundle;
import training.learn.NewLearnProjectUtil;
import training.learn.OpenLessonActivities;
import training.learn.OpenLessonParameters;
import training.learn.course.KLesson;
import training.learn.course.Lesson;
import training.learn.course.LessonType;
import training.learn.exceptons.LessonPreparationException;
import training.learn.lesson.LessonListener;
import training.learn.lesson.LessonManager;
import training.project.ProjectUtils;
import training.statistic.LessonStartingWay;
import training.statistic.StatisticBase;
import training.statistic.StatisticLessonListener;
import training.ui.LearnToolWindow;
import training.ui.LearningUiManager;
import training.util.UtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u001a\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u001a\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J,\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0018H\u0002J\u0018\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0018H\u0002J\u001a\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u001d2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0007J\u0012\u0010#\u001a\u00020\u00072\b\u0010!\u001a\u0004\u0018\u00010\"H\u0007J\u0018\u0010$\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0003J \u0010(\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*H\u0002J\u0018\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0018H\u0002J\u001a\u0010-\u001a\u0004\u0018\u00010\u00102\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0013\u001a\u00020\u001dH\u0002J?\u00100\u001a\u00020\u00072\b\u00101\u001a\u0004\u0018\u00010\u00182\b\u0010!\u001a\u0004\u0018\u00010\"2!\u00102\u001a\u001d\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b4\u0012\b\b5\u0012\u0004\b\b(,\u0012\u0004\u0012\u00020\u000703H\u0003J3\u00106\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u00182!\u00102\u001a\u001d\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b4\u0012\b\b5\u0012\u0004\b\b(,\u0012\u0004\u0012\u00020\u000703H\u0002J\u0012\u00107\u001a\u0004\u0018\u00010\u00182\u0006\u0010.\u001a\u00020/H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Ltraining/learn/OpenLessonActivities;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "openLesson", "", "params", "Ltraining/learn/OpenLessonParameters;", "prepareAndOpenLesson", "withCleanup", "", "openLessonForPreparedProject", "openLessonWhenLearnPanelIsReady", "vf", "Lcom/intellij/openapi/vfs/VirtualFile;", "waitLearningToolwindow", "processDslLesson", "lesson", "Ltraining/learn/course/KLesson;", "textEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "projectWhereToStartLesson", "Lcom/intellij/openapi/project/Project;", "hideOtherViews", "project", "addStatisticLessonListenerIfNeeded", "currentProject", "Ltraining/learn/course/Lesson;", "openReadme", "openOnboardingFromWelcomeScreen", "onboarding", "selectedSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "openLearnProjectFromWelcomeScreen", "showLearnPanel", "preferredAnchor", "Lcom/intellij/openapi/wm/ToolWindowAnchor;", "openLessonWhenLearnProjectStart", "getScratchFile", "filename", "", "askSwitchToLearnProjectBack", "learnProject", "getFileInLearnProject", "langSupport", "Ltraining/lang/LangSupport;", "initLearnProject", "projectToClose", "postInitCallback", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "finishProjectInitialization", "findLearnProjectInOpenedProjects", "intellij.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nOpenLessonActivities.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenLessonActivities.kt\ntraining/learn/OpenLessonActivities\n+ 2 progress.kt\ncom/intellij/openapi/progress/ProgressKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,509:1\n42#2,10:510\n1807#3,3:520\n1401#4,2:523\n13#5:525\n*S KotlinDebug\n*F\n+ 1 OpenLessonActivities.kt\ntraining/learn/OpenLessonActivities\n*L\n167#1:510,10\n318#1:520,3\n506#1:523,2\n64#1:525\n*E\n"})
public final class OpenLessonActivities {
    @NotNull
    public static final OpenLessonActivities INSTANCE = new OpenLessonActivities();
    @NotNull
    private static final Logger LOG;

    private OpenLessonActivities() {
    }

    @RequiresEdt
    public final void openLesson(@NotNull OpenLessonParameters params) {
        LearnToolWindow activeToolWindow;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Project projectWhereToStartLesson = params.getProjectWhereToStartLesson();
        LOG.debug(projectWhereToStartLesson.getName() + ": start openLesson method");
        LessonManager.Companion.getInstance().stopLesson();
        LearnToolWindow learnToolWindow = LearningUiManager.INSTANCE.getActiveToolWindow$intellij_featuresTrainer();
        if (learnToolWindow == null) {
            LearnToolWindow learnToolWindow2;
            LearnToolWindow it = learnToolWindow2 = UtilsKt.getLearnToolWindowForProject(projectWhereToStartLesson);
            boolean bl = false;
            LearningUiManager.INSTANCE.setActiveToolWindow$intellij_featuresTrainer(it);
            learnToolWindow = learnToolWindow2;
        }
        if ((activeToolWindow = learnToolWindow) != null && !Intrinsics.areEqual((Object)activeToolWindow.getProject(), (Object)projectWhereToStartLesson)) {
            activeToolWindow.setModulesPanel$intellij_featuresTrainer();
        }
        if (!params.getForceStartLesson() && LessonManager.Companion.getInstance().lessonShouldBeOpenedCompleted(params.getLesson())) {
            LearnToolWindow learnToolWindow3 = LearningUiManager.INSTANCE.getActiveToolWindow$intellij_featuresTrainer();
            if (learnToolWindow3 == null) {
                throw new IllegalStateException(("No active toolwindow in " + projectWhereToStartLesson).toString());
            }
            learnToolWindow3.setLearnPanel$intellij_featuresTrainer();
            LessonManager lessonManager = LessonManager.Companion.getInstance();
            Lesson lesson = params.getLesson();
            Intrinsics.checkNotNull((Object)lesson, (String)"null cannot be cast to non-null type training.learn.course.KLesson");
            lessonManager.openLessonPassed$intellij_featuresTrainer((KLesson)lesson, projectWhereToStartLesson);
            return;
        }
        try {
            LangSupport langSupport = LangManager.Companion.getInstance().getLangSupport();
            if (langSupport == null) {
                throw new Exception("Language for learning plugin is not defined");
            }
            LangSupport langSupport2 = langSupport;
            Project learnProject = LearningUiManager.INSTANCE.getLearnProject();
            if (learnProject != null && !UtilsKt.isLearningProject(learnProject, langSupport2.getPrimaryLanguage())) {
                learnProject = null;
            }
            LOG.debug(projectWhereToStartLesson.getName() + ": trying to get cached LearnProject " + (learnProject != null));
            if (learnProject == null) {
                learnProject = this.findLearnProjectInOpenedProjects(langSupport2);
            }
            LOG.debug(projectWhereToStartLesson.getName() + ": trying to find LearnProject in opened projects " + (learnProject != null));
            if (learnProject != null) {
                LearningUiManager.INSTANCE.setLearnProject(learnProject);
            }
            LessonType lessonType = params.getLesson().getLessonType();
            if (lessonType == LessonType.SCRATCH && !params.getForceLearningProject() && langSupport2.isSdkConfigured(projectWhereToStartLesson)) {
                LOG.debug(projectWhereToStartLesson.getName() + ": scratch based lesson");
            } else if (lessonType == LessonType.USER_PROJECT) {
                LOG.debug("The lesson opened in user project " + projectWhereToStartLesson.getName());
            } else if (learnProject == null || learnProject.isDisposed()) {
                if (!UtilsKt.isLearningProject(projectWhereToStartLesson, langSupport2.getPrimaryLanguage())) {
                    LOG.debug(projectWhereToStartLesson.getName() + ": 1. learnProject is null or disposed");
                    this.initLearnProject(projectWhereToStartLesson, null, (Function1<? super Project, Unit>)((Function1)arg_0 -> OpenLessonActivities.openLesson$lambda$1(projectWhereToStartLesson, params, arg_0)));
                    return;
                }
                LOG.debug(projectWhereToStartLesson.getName() + ": 0. learnProject is null but the current project (" + projectWhereToStartLesson.getName() + ")is LearnProject then just getFileInLearnProject");
                LearningUiManager.INSTANCE.setLearnProject(projectWhereToStartLesson);
                learnProject = projectWhereToStartLesson;
            } else {
                if (learnProject.isOpen() && !Intrinsics.areEqual((Object)projectWhereToStartLesson, (Object)learnProject)) {
                    LOG.debug(projectWhereToStartLesson.getName() + ": 3. LearnProject is opened but not focused. Ask user to focus to LearnProject");
                    this.askSwitchToLearnProjectBack(learnProject, projectWhereToStartLesson);
                    return;
                }
                if (learnProject.isOpen() && Intrinsics.areEqual((Object)projectWhereToStartLesson, (Object)learnProject)) {
                    LOG.debug(projectWhereToStartLesson.getName() + ": 4. LearnProject is the current project");
                } else {
                    throw new Exception("Unable to start Learn project");
                }
            }
            if (lessonType.isProject$intellij_featuresTrainer()) {
                if (lessonType == LessonType.USER_PROJECT) {
                    this.prepareAndOpenLesson(params, false);
                } else {
                    if (!Intrinsics.areEqual((Object)projectWhereToStartLesson, (Object)learnProject)) {
                        LOG.error((Throwable)new Exception("Invalid learning project initialization: projectWhereToStartLesson = " + projectWhereToStartLesson + ", learnProject = " + learnProject));
                        return;
                    }
                    OpenLessonActivities.prepareAndOpenLesson$default(this, params, false, 2, null);
                }
            } else {
                this.openLessonForPreparedProject(params);
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void prepareAndOpenLesson(OpenLessonParameters params, boolean withCleanup) {
        void title$iv;
        String string = LearnBundle.INSTANCE.message("learn.project.initializing.process", new Object[0]);
        Project project$iv = params.getProjectWhereToStartLesson();
        boolean cancellable$iv = true;
        boolean $i$f$runBackgroundableTask = false;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project$iv, (String)title$iv, cancellable$iv, params, withCleanup){
            final /* synthetic */ OpenLessonParameters $params$inlined;
            final /* synthetic */ boolean $withCleanup$inlined;
            {
                this.$params$inlined = openLessonParameters;
                this.$withCleanup$inlined = bl;
                super($project, $title, $cancellable);
            }

            public void run(ProgressIndicator indicator) {
                block5: {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    ProgressIndicator it = indicator;
                    boolean bl = false;
                    Project project = this.$params$inlined.getProjectWhereToStartLesson();
                    Lesson lessonToOpen = this.$params$inlined.getLesson();
                    try {
                        LangSupport langSupport = LangManager.Companion.getInstance().getLangSupport();
                        if (langSupport == null) {
                            throw new IllegalStateException(("No lang support for lesson: " + lessonToOpen.getId()).toString());
                        }
                        LangSupport langSupport2 = langSupport;
                        if (this.$withCleanup$inlined) {
                            langSupport2.cleanupBeforeLessons(project);
                        }
                        lessonToOpen.prepare(project);
                        VirtualFile root = ProjectUtils.INSTANCE.getProjectRoot(langSupport2);
                        VirtualFile[] virtualFileArray = new VirtualFile[]{root};
                        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])virtualFileArray);
                    }
                    catch (LessonPreparationException e) {
                        OpenLessonActivities $this$thisLogger$iv = OpenLessonActivities.INSTANCE;
                        boolean $i$f$thisLogger = false;
                        Logger logger = Logger.getInstance(OpenLessonActivities.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.warn("Error occurred when preparing the lesson " + lessonToOpen.getId(), (Throwable)e);
                        break block5;
                    }
                    catch (Throwable t) {
                        OpenLessonActivities $this$thisLogger$iv = OpenLessonActivities.INSTANCE;
                        boolean $i$f$thisLogger = false;
                        Logger logger = Logger.getInstance(OpenLessonActivities.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.error("Error occurred when preparing the lesson " + lessonToOpen.getId(), t);
                        break block5;
                    }
                    ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this.$params$inlined){
                        final /* synthetic */ OpenLessonParameters $params;
                        {
                            this.$params = $params;
                        }

                        public final void invoke() {
                            OpenLessonActivities.access$openLessonForPreparedProject(OpenLessonActivities.INSTANCE, this.$params);
                        }
                    }), (int)1, null);
                }
            }
        });
    }

    static /* synthetic */ void prepareAndOpenLesson$default(OpenLessonActivities openLessonActivities, OpenLessonParameters openLessonParameters, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        openLessonActivities.prepareAndOpenLesson(openLessonParameters, bl);
    }

    private final void openLessonForPreparedProject(OpenLessonParameters params) {
        VirtualFile vf;
        LangSupport langSupport = LangManager.Companion.getInstance().getLangSupport();
        if (langSupport == null) {
            throw new Exception("Language should be defined by now");
        }
        LangSupport langSupport2 = langSupport;
        Project project = params.getProjectWhereToStartLesson();
        Lesson lesson = params.getLesson();
        if (lesson.getLessonType() == LessonType.SCRATCH) {
            LOG.debug(project.getName() + ": scratch based lesson");
            String string = lesson.getSampleFilePath();
            if (string == null) {
                string = langSupport2.getScratchFileName();
            }
            v2 = this.getScratchFile(project, lesson, string);
        } else {
            LOG.debug(project.getName() + ": 4. LearnProject is the current project");
            v2 = vf = this.getFileInLearnProject(langSupport2, lesson);
        }
        if (lesson.getLessonType() != LessonType.SCRATCH) {
            FileEditorManagerEx.Companion.getInstanceEx(project).closeOpenedEditors();
        }
        if (lesson.getLessonType() != LessonType.SCRATCH || Intrinsics.areEqual((Object)LearningUiManager.INSTANCE.getLearnProject(), (Object)project)) {
            this.hideOtherViews(project);
        }
        if (this.showLearnPanel(project, lesson.preferredLearnWindowAnchor(project))) {
            this.openLessonWhenLearnPanelIsReady(params, vf);
        } else {
            this.waitLearningToolwindow(params, vf);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void openLessonWhenLearnPanelIsReady(OpenLessonParameters params, VirtualFile vf) {
        LearnToolWindow learnToolWindow;
        Project project = params.getProjectWhereToStartLesson();
        LOG.debug(project.getName() + ": Add listeners to lesson");
        this.addStatisticLessonListenerIfNeeded(project, params.getLesson());
        LOG.debug(project.getName() + ": Set lesson view");
        LearningUiManager learningUiManager = LearningUiManager.INSTANCE;
        LearnToolWindow learnToolWindow2 = UtilsKt.getLearnToolWindowForProject(project);
        if (learnToolWindow2 != null) {
            void it;
            LearnToolWindow learnToolWindow3;
            LearnToolWindow learnToolWindow4 = learnToolWindow3 = learnToolWindow2;
            LearningUiManager learningUiManager2 = learningUiManager;
            boolean bl = false;
            it.setLearnPanel$intellij_featuresTrainer();
            learningUiManager = learningUiManager2;
            learnToolWindow = learnToolWindow3;
        } else {
            learnToolWindow = null;
        }
        learningUiManager.setActiveToolWindow$intellij_featuresTrainer(learnToolWindow);
        LOG.debug(project.getName() + ": XmlLesson onStart()");
        params.getLesson().onStart$intellij_featuresTrainer(params.getStartingWay());
        LOG.debug(project.getName() + ": PREPARING TO START LESSON:");
        LOG.debug(project.getName() + ": 1. Open or find editor");
        TextEditor textEditor = null;
        if (vf != null && FileEditorManager.getInstance((Project)project).isFileOpen(vf)) {
            FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)project).getEditors(vf);
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getEditors(...)");
            for (FileEditor fileEditor : fileEditorArray) {
                if (!(fileEditor instanceof TextEditor)) continue;
                textEditor = (TextEditor)fileEditor;
            }
        }
        if (vf != null && textEditor == null) {
            FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)project).openFile(vf, true, true);
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"openFile(...)");
            for (FileEditor fileEditor : fileEditorArray) {
                if (!(fileEditor instanceof TextEditor)) continue;
                textEditor = (TextEditor)fileEditor;
            }
            if (textEditor == null) {
                LOG.error("Cannot open editor for " + vf);
                if (params.getLesson().getLessonType() == LessonType.SCRATCH) {
                    ActionsKt.invokeLater$default(null, () -> OpenLessonActivities.openLessonWhenLearnPanelIsReady$lambda$1(vf), (int)1, null);
                }
            }
        }
        LOG.debug(project.getName() + ": 2. Set the focus on this editor");
        if (vf != null) {
            FileEditorManager.getInstance((Project)project).openEditor(new OpenFileDescriptor(project, vf), true);
        }
        LOG.debug(project.getName() + ": 4. Process lesson");
        if (!(params.getLesson() instanceof KLesson)) {
            throw new IllegalStateException("Unknown lesson format".toString());
        }
        this.processDslLesson((KLesson)params.getLesson(), textEditor, project, vf);
    }

    private final void waitLearningToolwindow(OpenLessonParameters params, VirtualFile vf) {
        Project project = params.getProjectWhereToStartLesson();
        MessageBusConnection connect = project.getMessageBus().connect();
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connect.subscribe(topic, (Object)new ToolWindowManagerListener(connect, project, params, vf){
            final /* synthetic */ MessageBusConnection $connect;
            final /* synthetic */ Project $project;
            final /* synthetic */ OpenLessonParameters $params;
            final /* synthetic */ VirtualFile $vf;
            {
                this.$connect = $connect;
                this.$project = $project;
                this.$params = $params;
                this.$vf = $vf;
            }

            public void toolWindowsRegistered(List<String> ids, ToolWindowManager toolWindowManager) {
                ToolWindow toolWindow;
                Intrinsics.checkNotNullParameter(ids, (String)"ids");
                Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                if (ids.contains("Learn") && (toolWindow = toolWindowManager.getToolWindow("Learn")) != null) {
                    this.$connect.disconnect();
                    ApplicationManager.getApplication().invokeLater(() -> waitLearningToolwindow.1.toolWindowsRegistered$lambda$0(this.$project, this.$params, this.$vf), toolWindow.getProject().getDisposed());
                }
            }

            private static final void toolWindowsRegistered$lambda$0(Project $project, OpenLessonParameters $params, VirtualFile $vf) {
                OpenLessonActivities.access$showLearnPanel(OpenLessonActivities.INSTANCE, $project, $params.getLesson().preferredLearnWindowAnchor($project));
                OpenLessonActivities.access$openLessonWhenLearnPanelIsReady(OpenLessonActivities.INSTANCE, $params, $vf);
            }
        });
    }

    private final void processDslLesson(KLesson lesson, TextEditor textEditor, Project projectWhereToStartLesson, VirtualFile vf) {
        TextEditor textEditor2 = textEditor;
        LessonExecutor executor = new LessonExecutor(lesson, projectWhereToStartLesson, (Editor)(textEditor2 != null ? textEditor2.getEditor() : null), vf);
        LessonContextImpl lessonContext = new LessonContextImpl(executor);
        TextEditor textEditor3 = textEditor;
        LessonManager.Companion.getInstance().initDslLesson$intellij_featuresTrainer((Editor)(textEditor3 != null ? textEditor3.getEditor() : null), lesson, executor);
        lesson.getFullLessonContent().invoke((Object)lessonContext);
        executor.startLesson();
    }

    private final void hideOtherViews(Project project) {
        ApplicationManager.getApplication().invokeLater(() -> OpenLessonActivities.hideOtherViews$lambda$0(project));
    }

    private final void addStatisticLessonListenerIfNeeded(Project currentProject, Lesson lesson) {
        boolean bl;
        StatisticLessonListener statLessonListener;
        block4: {
            statLessonListener = new StatisticLessonListener(currentProject);
            Iterable $this$any$iv = lesson.getLessonListeners$intellij_featuresTrainer();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LessonListener it = (LessonListener)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof StatisticLessonListener)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (!bl) {
            lesson.addLessonListener(statLessonListener);
        }
    }

    private final void openReadme(Project project) {
        VirtualFile root = ProjectUtils.INSTANCE.getCurrentLearningProjectRoot();
        VirtualFile virtualFile = root.findFileByRelativePath("README.md");
        if (virtualFile == null) {
            return;
        }
        VirtualFile readme = virtualFile;
        TextEditorWithPreview.Companion.openPreviewForFile(project, readme);
    }

    @RequiresEdt
    public final void openOnboardingFromWelcomeScreen(@NotNull Lesson onboarding, @Nullable Sdk selectedSdk) {
        Intrinsics.checkNotNullParameter((Object)onboarding, (String)"onboarding");
        StatisticBase.INSTANCE.logLearnProjectOpenedForTheFirstTime(StatisticBase.LearnProjectOpeningWay.ONBOARDING_PROMOTER);
        this.initLearnProject(null, selectedSdk, (Function1<? super Project, Unit>)((Function1)arg_0 -> OpenLessonActivities.openOnboardingFromWelcomeScreen$lambda$0(onboarding, arg_0)));
    }

    @RequiresEdt
    public final void openLearnProjectFromWelcomeScreen(@Nullable Sdk selectedSdk) {
        StatisticBase.INSTANCE.logLearnProjectOpenedForTheFirstTime(StatisticBase.LearnProjectOpeningWay.LEARN_IDE);
        this.initLearnProject(null, selectedSdk, (Function1<? super Project, Unit>)((Function1)OpenLessonActivities::openLearnProjectFromWelcomeScreen$lambda$0));
    }

    private final boolean showLearnPanel(Project project, ToolWindowAnchor preferredAnchor) {
        ToolWindow toolWindow = UtilsKt.learningToolWindow(project);
        if (toolWindow == null) {
            return false;
        }
        ToolWindow learn = toolWindow;
        if (!Intrinsics.areEqual((Object)learn.getAnchor(), (Object)preferredAnchor) && learn.getType() == ToolWindowType.DOCKED) {
            learn.setAnchor(preferredAnchor, null);
        }
        learn.show();
        return true;
    }

    @RequiresEdt
    private final void openLessonWhenLearnProjectStart(OpenLessonParameters params) {
        if (params.getLesson().getProperties().getCanStartInDumbMode()) {
            this.prepareAndOpenLesson(params, false);
            return;
        }
        Project myLearnProject = params.getProjectWhereToStartLesson();
        StartupManager startupManager = StartupManager.getInstance((Project)myLearnProject);
        if (startupManager instanceof StartupManagerEx && ((StartupManagerEx)startupManager).postStartupActivityPassed()) {
            OpenLessonActivities.openLessonWhenLearnProjectStart$openLesson(myLearnProject, params);
        } else {
            startupManager.runAfterOpened(() -> OpenLessonActivities.openLessonWhenLearnProjectStart$lambda$1(myLearnProject, params));
        }
    }

    private final VirtualFile getScratchFile(Project project, Lesson lesson, String filename) {
        String string = lesson.getLanguageId();
        if (string == null) {
            throw new IllegalStateException(("Scratch lesson " + lesson.getId() + " should define language").toString());
        }
        String languageId = string;
        Language languageByID = UtilsKt.findLanguageByID(languageId);
        VirtualFile virtualFile = ScratchFileService.getInstance().findFile((RootType)ScratchRootType.getInstance(), filename, ScratchFileService.Option.create_if_missing);
        if (virtualFile == null) {
            throw new IllegalStateException(("Cannot create scratch file " + filename + " for " + languageByID + " language ID in " + project.getName()).toString());
        }
        VirtualFile vf = virtualFile;
        ScratchFileService.getInstance().getScratchesMapping().setMapping(vf, (Object)languageByID);
        FileEditorManager.getInstance((Project)project).closeFile(vf);
        return vf;
    }

    private final void askSwitchToLearnProjectBack(Project learnProject, Project currentProject) {
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)learnProject.getName(), (String)"getName(...)");
        Messages.showInfoMessage((Project)currentProject, (String)LearnBundle.INSTANCE.message("dialog.askToSwitchToLearnProject.message", objectArray), (String)LearnBundle.INSTANCE.message("dialog.askToSwitchToLearnProject.title", new Object[0]));
    }

    private final VirtualFile getFileInLearnProject(LangSupport langSupport, Lesson lesson) {
        boolean bl;
        if (!lesson.getProperties().getOpenFileAtStart()) {
            LOG.debug(lesson.getName() + " does not open any file at the start");
            return null;
        }
        Computable<VirtualFile> function2 = new Computable<VirtualFile>(lesson, langSupport){
            final /* synthetic */ Lesson $lesson;
            final /* synthetic */ LangSupport $langSupport;
            {
                this.$lesson = $lesson;
                this.$langSupport = $langSupport;
            }

            public VirtualFile compute() {
                String string;
                VirtualFile dir;
                String string2 = this.$lesson.getSampleFilePath();
                if (string2 == null && (string2 = this.$lesson.getModule().getSampleFilePath()) == null) {
                    LangSupport langSupport = this.$lesson.getModule().getPrimaryLanguage();
                    string2 = langSupport != null ? langSupport.getSampleFilePath() : null;
                    if (string2 == null) {
                        throw new IllegalStateException(("No file provided to start lesson " + this.$lesson.getName() + " (" + this.$lesson.getId() + ") for " + this.$langSupport.getPrimaryLanguage() + " course").toString());
                    }
                }
                String relativeFilePath = string2;
                VirtualFile root = ProjectUtils.INSTANCE.getProjectRoot(this.$langSupport);
                VirtualFile virtualFile = root.findFileByRelativePath(relativeFilePath);
                if (virtualFile != null) {
                    VirtualFile it = virtualFile;
                    boolean bl = false;
                    return it;
                }
                int lastSeparator = StringsKt.lastIndexOf$default((CharSequence)relativeFilePath, (String)"/", (int)0, (boolean)false, (int)6, null);
                if (lastSeparator != -1) {
                    String string3 = relativeFilePath.substring(0, lastSeparator);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    v3 = VfsUtil.createDirectoryIfMissing((VirtualFile)root, (String)string3);
                } else {
                    v3 = dir = root;
                }
                if (lastSeparator == -1) {
                    string = relativeFilePath;
                } else {
                    String string4 = relativeFilePath.substring(lastSeparator + 1);
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                }
                String fileName = string;
                VirtualFile virtualFile2 = dir.createChildData((Object)this, fileName);
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"createChildData(...)");
                return virtualFile2;
            }
        };
        VirtualFile vf = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)function2);
        boolean bl2 = bl = vf != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return vf;
    }

    @RequiresEdt
    private final void initLearnProject(Project projectToClose, Sdk selectedSdk, Function1<? super Project, Unit> postInitCallback) {
        LangSupport langSupport = LangManager.Companion.getInstance().getLangSupport();
        if (langSupport == null) {
            throw new Exception("Language for learning plugin is not defined");
        }
        LangSupport langSupport2 = langSupport;
        Project project = this.findLearnProjectInOpenedProjects(langSupport2);
        if (project != null) {
            Project it = project;
            boolean bl = false;
            postInitCallback.invoke((Object)it);
            return;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && projectToClose != null && !NewLearnProjectUtil.INSTANCE.showDialogOpenLearnProject(projectToClose)) {
            return;
        }
        try {
            NewLearnProjectUtil.INSTANCE.createLearnProject(projectToClose, langSupport2, selectedSdk, (Function1<? super Project, Unit>)((Function1)arg_0 -> OpenLessonActivities.initLearnProject$lambda$1(langSupport2, postInitCallback, arg_0)));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private final void finishProjectInitialization(Project learnProject, Function1<? super Project, Unit> postInitCallback) {
        LearningUiManager.INSTANCE.setLearnProject(learnProject);
        ActionsKt.runInEdt$default(null, () -> OpenLessonActivities.finishProjectInitialization$lambda$0(postInitCallback, learnProject), (int)1, null);
    }

    private final Project findLearnProjectInOpenedProjects(LangSupport langSupport) {
        Project project;
        block1: {
            Project[] openProjects;
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            Project[] $this$firstOrNull$iv = openProjects = projectArray;
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                Project element$iv;
                Project it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!UtilsKt.isLearningProject(it, langSupport.getPrimaryLanguage())) continue;
                project = element$iv;
                break block1;
            }
            project = null;
        }
        return project;
    }

    private static final Unit openLesson$lambda$1(Project $projectWhereToStartLesson, OpenLessonParameters $params, Project it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LOG.debug($projectWhereToStartLesson.getName() + ": 1. ... LearnProject has been started");
        INSTANCE.openLessonWhenLearnProjectStart(new OpenLessonParameters(it, $params.getLesson(), $params.getForceStartLesson(), $params.getStartingWay(), true));
        LOG.debug($projectWhereToStartLesson.getName() + ": 1. ... open lesson when learn project has been started");
        return Unit.INSTANCE;
    }

    private static final Unit openLessonWhenLearnPanelIsReady$lambda$1$0(VirtualFile $vf) {
        $vf.delete((Object)INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit openLessonWhenLearnPanelIsReady$lambda$1(VirtualFile $vf) {
        ActionsKt.runWriteAction(() -> OpenLessonActivities.openLessonWhenLearnPanelIsReady$lambda$1$0($vf));
        return Unit.INSTANCE;
    }

    private static final void hideOtherViews$lambda$0(Project $project) {
        LessonUtil.INSTANCE.hideStandardToolwindows($project);
    }

    private static final void openOnboardingFromWelcomeScreen$lambda$0$0$0$0(Project $project, Lesson $onboarding) {
        CourseManager.openLesson$default(CourseManager.Companion.getInstance(), $project, $onboarding, LessonStartingWay.ONBOARDING_PROMOTER, true, false, 16, null);
    }

    private static final Unit openOnboardingFromWelcomeScreen$lambda$0$0$0(Lesson $onboarding, Project $project) {
        if ($onboarding.getProperties().getCanStartInDumbMode()) {
            CourseManager.openLesson$default(CourseManager.Companion.getInstance(), $project, $onboarding, LessonStartingWay.ONBOARDING_PROMOTER, true, false, 16, null);
        } else {
            DumbService.Companion.getInstance($project).runWhenSmart(() -> OpenLessonActivities.openOnboardingFromWelcomeScreen$lambda$0$0$0$0($project, $onboarding));
        }
        return Unit.INSTANCE;
    }

    private static final void openOnboardingFromWelcomeScreen$lambda$0$0(Lesson $onboarding, Project $project) {
        ActionsKt.invokeLater$default(null, () -> OpenLessonActivities.openOnboardingFromWelcomeScreen$lambda$0$0$0($onboarding, $project), (int)1, null);
    }

    private static final Unit openOnboardingFromWelcomeScreen$lambda$0(Lesson $onboarding, Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        StartupManager.getInstance((Project)project).runAfterOpened(() -> OpenLessonActivities.openOnboardingFromWelcomeScreen$lambda$0$0($onboarding, project));
        return Unit.INSTANCE;
    }

    private static final void openLearnProjectFromWelcomeScreen$lambda$0$0$0$0$0(Project $project, ToolWindowAnchor $anchor) {
        INSTANCE.showLearnPanel($project, $anchor);
    }

    private static final Unit openLearnProjectFromWelcomeScreen$lambda$0$0$0$0(Project $project, ToolWindowAnchor $anchor) {
        INSTANCE.showLearnPanel($project, $anchor);
        DumbService.Companion.getInstance($project).runWhenSmart(() -> OpenLessonActivities.openLearnProjectFromWelcomeScreen$lambda$0$0$0$0$0($project, $anchor));
        return Unit.INSTANCE;
    }

    private static final void openLearnProjectFromWelcomeScreen$lambda$0$0$0$1(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final Unit openLearnProjectFromWelcomeScreen$lambda$0$0$0(Project $project) {
        INSTANCE.openReadme($project);
        INSTANCE.hideOtherViews($project);
        LangSupport langSupport = LangManager.Companion.getInstance().getLangSupport();
        if (langSupport == null || (langSupport = langSupport.getToolWindowAnchor()) == null) {
            ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.LEFT;
            langSupport = toolWindowAnchor;
            Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"LEFT");
        }
        LangSupport anchor = langSupport;
        INSTANCE.showLearnPanel($project, (ToolWindowAnchor)anchor);
        CourseManager.Companion.getInstance().setUnfoldModuleOnInit(null);
        Function0 openWhenSmart = () -> OpenLessonActivities.openLearnProjectFromWelcomeScreen$lambda$0$0$0$0($project, (ToolWindowAnchor)anchor);
        new Alarm().addRequest(() -> OpenLessonActivities.openLearnProjectFromWelcomeScreen$lambda$0$0$0$1(openWhenSmart), 500);
        return Unit.INSTANCE;
    }

    private static final void openLearnProjectFromWelcomeScreen$lambda$0$0(Project $project) {
        ActionsKt.invokeLater$default(null, () -> OpenLessonActivities.openLearnProjectFromWelcomeScreen$lambda$0$0$0($project), (int)1, null);
    }

    private static final Unit openLearnProjectFromWelcomeScreen$lambda$0(Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        StartupManager.getInstance((Project)project).runAfterOpened(() -> OpenLessonActivities.openLearnProjectFromWelcomeScreen$lambda$0$0(project));
        return Unit.INSTANCE;
    }

    private static final void openLessonWhenLearnProjectStart$openLesson$lambda$0$0$0(OpenLessonParameters $params) {
        INSTANCE.prepareAndOpenLesson($params, false);
    }

    private static final Unit openLessonWhenLearnProjectStart$openLesson$lambda$0$0(Project $myLearnProject, OpenLessonParameters $params) {
        DumbService.Companion.getInstance($myLearnProject).runWhenSmart(() -> OpenLessonActivities.openLessonWhenLearnProjectStart$openLesson$lambda$0$0$0($params));
        return Unit.INSTANCE;
    }

    private static final void openLessonWhenLearnProjectStart$openLesson$lambda$0$1(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final void openLessonWhenLearnProjectStart$openLesson$lambda$0(Project $myLearnProject, OpenLessonParameters $params) {
        Function0 openWhenSmart = () -> OpenLessonActivities.openLessonWhenLearnProjectStart$openLesson$lambda$0$0($myLearnProject, $params);
        new Alarm().addRequest(() -> OpenLessonActivities.openLessonWhenLearnProjectStart$openLesson$lambda$0$1(openWhenSmart), 500);
    }

    private static final void openLessonWhenLearnProjectStart$openLesson(Project myLearnProject, OpenLessonParameters $params) {
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(myLearnProject);
        ToolWindow learnToolWindow = toolWindowManager.getToolWindow("Learn");
        if (learnToolWindow != null) {
            DumbService.Companion.getInstance(myLearnProject).runWhenSmart(() -> OpenLessonActivities.openLessonWhenLearnProjectStart$openLesson$lambda$0(myLearnProject, $params));
        }
    }

    private static final void openLessonWhenLearnProjectStart$lambda$1(Project $myLearnProject, OpenLessonParameters $params) {
        OpenLessonActivities.openLessonWhenLearnProjectStart$openLesson($myLearnProject, $params);
    }

    private static final void initLearnProject$lambda$1$0(LangSupport $langSupport, Project $learnProject, Function1 $postInitCallback) {
        $langSupport.applyToProjectAfterConfigure().invoke((Object)$learnProject);
        INSTANCE.finishProjectInitialization($learnProject, (Function1<? super Project, Unit>)$postInitCallback);
    }

    private static final Unit initLearnProject$lambda$1(LangSupport $langSupport, Function1 $postInitCallback, Project learnProject) {
        Intrinsics.checkNotNullParameter((Object)learnProject, (String)"learnProject");
        try {
            $langSupport.applyToProjectAfterConfigure().invoke((Object)learnProject);
        }
        catch (Throwable e) {
            LOG.error(e);
            LOG.error("The configuration will be retried after 2 seconds");
            new Alarm().addRequest(() -> OpenLessonActivities.initLearnProject$lambda$1$0($langSupport, learnProject, $postInitCallback), 2000);
            return Unit.INSTANCE;
        }
        INSTANCE.finishProjectInitialization(learnProject, (Function1<? super Project, Unit>)$postInitCallback);
        return Unit.INSTANCE;
    }

    private static final Unit finishProjectInitialization$lambda$0(Function1 $postInitCallback, Project $learnProject) {
        $postInitCallback.invoke((Object)$learnProject);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$openLessonForPreparedProject(OpenLessonActivities $this, OpenLessonParameters params) {
        $this.openLessonForPreparedProject(params);
    }

    public static final /* synthetic */ boolean access$showLearnPanel(OpenLessonActivities $this, Project project, ToolWindowAnchor preferredAnchor) {
        return $this.showLearnPanel(project, preferredAnchor);
    }

    public static final /* synthetic */ void access$openLessonWhenLearnPanelIsReady(OpenLessonActivities $this, OpenLessonParameters params, VirtualFile vf) {
        $this.openLessonWhenLearnPanelIsReady(params, vf);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(OpenLessonActivities.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

