/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.httpClient.http.request.HttpRequestFileType;
import com.intellij.httpClient.http.request.completion.HttpRequestBodyAutoPopupHandlerKt;
import com.intellij.httpClient.http.request.psi.HttpMessageBody;
import com.intellij.json.psi.JsonFile;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/httpClient/http/request/completion/HttpRequestBodyAutoPopupHandler;", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate;", "<init>", "()V", "checkAutoPopup", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "charTyped", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isHttpRequestBody", "", "isHttp", "isCharOrQuoteTyped", "isAfterPropertyOrInTheBeginningOfBody", "intellij.restClient"})
public final class HttpRequestBodyAutoPopupHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, @NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!this.isHttp(file)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        boolean charOrQuoteTyped = this.isCharOrQuoteTyped(charTyped);
        if (!charOrQuoteTyped) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        AutoPopupController.getInstance((Project)project).scheduleAutoPopup(editor2, arg_0 -> HttpRequestBodyAutoPopupHandler.checkAutoPopup$lambda$1(arg_0 -> HttpRequestBodyAutoPopupHandler.checkAutoPopup$lambda$0(this, project, editor2, arg_0), arg_0));
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private final boolean isHttpRequestBody(PsiFile file, Project project) {
        return this.isHttp(file) && InjectedLanguageManager.getInstance((Project)project).getInjectionHost((PsiElement)file) instanceof HttpMessageBody;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isHttp(PsiFile file) {
        if (!(file instanceof JsonFile)) return false;
        String[] stringArray = HttpRequestFileType.INSTANCE.getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getExtensions(...)");
        if (!ArraysKt.contains((Object[])stringArray, (Object)FileUtilRt.getExtension((String)((JsonFile)file).getName()))) return false;
        return true;
    }

    private final boolean isCharOrQuoteTyped(char charTyped) {
        return charTyped == '\"' || Character.isLetter(charTyped);
    }

    private final boolean isAfterPropertyOrInTheBeginningOfBody(Editor editor2) {
        int offset = Math.max(editor2.getCaretModel().getOffset() - 1, 0);
        HighlighterIterator highlighterIterator = editor2.getHighlighter().createIterator(offset);
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
        HighlighterIterator iterator = highlighterIterator;
        IElementType currentToken = iterator.getTokenType();
        do {
            iterator.retreat();
        } while (Intrinsics.areEqual((Object)(currentToken = iterator.getTokenType()), (Object)TokenType.WHITE_SPACE));
        return HttpRequestBodyAutoPopupHandlerKt.access$getExpectedTokensToShowCompletionPopupAfter$p().contains(currentToken);
    }

    private static final boolean checkAutoPopup$lambda$0(HttpRequestBodyAutoPopupHandler this$0, Project $project, Editor $editor, PsiFile psiFile) {
        Intrinsics.checkNotNull((Object)psiFile);
        return this$0.isHttpRequestBody(psiFile, $project) && this$0.isAfterPropertyOrInTheBeginningOfBody($editor);
    }

    private static final boolean checkAutoPopup$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

