/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.registry.cloud.registry;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueSource;
import com.intellij.openapi.util.registry.ValueWithSource;
import com.intellij.platform.registry.cloud.CommonKt;
import com.intellij.platform.registry.cloud.Update;
import com.intellij.platform.registry.cloud.UpdateConfig;
import com.intellij.platform.registry.cloud.Updater;
import com.intellij.platform.registry.cloud.dto.RegistryUpdateDto;
import com.intellij.platform.registry.cloud.dto.UpdatesRoot;
import com.intellij.platform.registry.cloud.registry.RegistryUpdate;
import com.intellij.platform.registry.cloud.registry.RegistryUpdater;
import com.intellij.platform.registry.cloud.registry.RegistryUpdaterKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0096@\u00a2\u0006\u0002\u0010\u000eJ\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u0002J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J2\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0082@\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0013H\u0082@\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/platform/registry/cloud/registry/RegistryUpdater;", "Lcom/intellij/platform/registry/cloud/Updater;", "config", "Lcom/intellij/platform/registry/cloud/UpdateConfig;", "<init>", "(Lcom/intellij/platform/registry/cloud/UpdateConfig;)V", "read", "Lcom/intellij/platform/registry/cloud/Update;", "document", "Lcom/intellij/platform/registry/cloud/dto/UpdatesRoot;", "apply", "", "updates", "", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "uniqueOverlapping", "Lcom/intellij/platform/registry/cloud/dto/RegistryUpdateDto;", "data", "jsonToString", "", "value", "Lkotlinx/serialization/json/JsonElement;", "applyChange", "key", "reason", "registryValue", "Lcom/intellij/openapi/util/registry/RegistryValue;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/util/registry/RegistryValue;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "rollback", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.registry.cloud"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nRegistryUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegistryUpdater.kt\ncom/intellij/platform/registry/cloud/registry/RegistryUpdater\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,126:1\n777#2:127\n873#2,2:128\n812#2,12:130\n1#3:142\n*S KotlinDebug\n*F\n+ 1 RegistryUpdater.kt\ncom/intellij/platform/registry/cloud/registry/RegistryUpdater\n*L\n29#1:127\n29#1:128,2\n35#1:130,12\n*E\n"})
public final class RegistryUpdater
implements Updater {
    @NotNull
    private final UpdateConfig config;
    public static final int $stable = 8;

    public RegistryUpdater(@NotNull UpdateConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Update read(@NotNull UpdatesRoot document) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Iterable $this$filter$iv = document.getRegistry();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RegistryUpdateDto it = (RegistryUpdateDto)element$iv$iv;
            boolean bl = false;
            if (!(CommonKt.matchesProducts(this.config, it) && CommonKt.matchesDate(this.config, it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List values = (List)destination$iv$iv;
        return new RegistryUpdate(this.uniqueOverlapping(values));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object apply(@NotNull List<? extends Update> updates, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof apply.1)) ** GOTO lbl-1000
        var15_3 = $completion;
        if ((var15_3.label & -2147483648) != 0) {
            var15_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                /* synthetic */ Object result;
                final /* synthetic */ RegistryUpdater this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.apply(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var16_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$filterIsInstance$iv = updates;
                $i$f$filterIsInstance = false;
                var7_10 = $this$filterIsInstance$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof RegistryUpdate)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                v0 = (RegistryUpdate)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
                v1 = registryValues = v0 != null ? v0.getRegistryValues() : null;
                if (registryValues == null) {
                    return Unit.INSTANCE;
                }
                keysFromCloudConfig = new LinkedHashSet<E>();
                $this$filterIsInstance$iv = registryValues.iterator();
lbl28:
                // 8 sources

                while ($this$filterIsInstance$iv.hasNext()) {
                    dto = (RegistryUpdateDto)$this$filterIsInstance$iv.next();
                    registryValue = Registry.Companion.get(dto.getKey());
                    try {
                        $i$f$filterIsInstanceTo = registryValue.asString();
                    }
                    catch (MissingResourceException <unused var>) {
                        RegistryUpdaterKt.access$getLog$p().debug("No such key '" + dto.getKey() + "' in registry");
                        continue;
                    }
                    currentValue = $i$f$filterIsInstanceTo;
                    if (registryValue.getPluginId() != null) {
                        $i$a$-let-RegistryUpdater$apply$registryPlugin$1 = false;
                        v2 = PluginManagerCore.getPlugin((PluginId)PluginId.Companion.getId(it));
                    } else {
                        v2 = registryPlugin = null;
                    }
                    if (registryPlugin != null && !PluginManagerCore.isDevelopedByJetBrains((PluginDescriptor)((PluginDescriptor)registryPlugin))) {
                        RegistryUpdaterKt.access$getLog$p().debug("Assigning '" + dto.getKey() + "' values for plugin with vendor " + registryPlugin.getVendor() + " is not allowed");
                        continue;
                    }
                    desiredValue = this.jsonToString(dto.getValue());
                    v3 = registryValue.getSource();
                    if (v3 == null) {
                        v3 = RegistryValueSource.MANAGER;
                    }
                    if ((valueSource = v3) != RegistryValueSource.MANAGER) continue;
                    keysFromCloudConfig.add(dto.getKey());
                    if (Intrinsics.areEqual((Object)currentValue, (Object)desiredValue)) continue;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)updates);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)registryValues);
                    $continuation.L$2 = keysFromCloudConfig;
                    $continuation.L$3 = $this$filterIsInstance$iv;
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)dto);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)registryValue);
                    $continuation.L$6 = currentValue;
                    $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)registryPlugin);
                    $continuation.L$8 = desiredValue;
                    $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)valueSource);
                    $continuation.label = 1;
                    v4 = this.applyChange(dto.getKey(), desiredValue, dto.getReason(), registryValue, (Continuation<? super Unit>)$continuation);
                    if (v4 != var16_5) continue;
                    return var16_5;
                }
                break;
            }
            case 1: {
                valueSource = (RegistryValueSource)$continuation.L$9;
                desiredValue = (String)$continuation.L$8;
                registryPlugin = (IdeaPluginDescriptor)$continuation.L$7;
                currentValue = (String)$continuation.L$6;
                registryValue = (RegistryValue)$continuation.L$5;
                dto = (RegistryUpdateDto)$continuation.L$4;
                $this$filterIsInstance$iv = (Iterator)$continuation.L$3;
                keysFromCloudConfig = (Set)$continuation.L$2;
                registryValues = (List<E>)$continuation.L$1;
                updates = (List)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
                }
                catch (Exception e) {
                    RegistryUpdaterKt.access$getLog$p().error("Could not apply registry value '" + desiredValue + "' to '" + currentValue + "'", (Throwable)e);
                }
                ** GOTO lbl28
            }
        }
        storedProperties = MapsKt.toMap((Map)Registry.Companion.getInstance().getStoredProperties());
        var6_9 = storedProperties.entrySet().iterator();
lbl93:
        // 5 sources

        while (var6_9.hasNext()) {
            keyData = (Map.Entry)var6_9.next();
            if (keysFromCloudConfig.contains(keyData.getKey()) || ((ValueWithSource)keyData.getValue()).getSource() != RegistryValueSource.MANAGER) continue;
            $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)updates);
            $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)registryValues);
            $continuation.L$2 = keysFromCloudConfig;
            $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)storedProperties);
            $continuation.L$4 = var6_9;
            $continuation.L$5 = keyData;
            $continuation.L$6 = null;
            $continuation.L$7 = null;
            $continuation.L$8 = null;
            $continuation.L$9 = null;
            $continuation.label = 2;
            v5 = this.rollback((String)keyData.getKey(), (Continuation<? super Unit>)$continuation);
            if (v5 != var16_5) continue;
            return var16_5;
        }
        {
            break;
            case 2: {
                keyData = (Map.Entry)$continuation.L$5;
                var6_9 = (Iterator<Map.Entry<K, V>>)$continuation.L$4;
                storedProperties = (Map)$continuation.L$3;
                keysFromCloudConfig = (Set)$continuation.L$2;
                registryValues = (List<E>)$continuation.L$1;
                updates = (List)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v5 = $result;
                }
                catch (Exception e) {
                    RegistryUpdaterKt.access$getLog$p().error("Could not rollback registry value '" + keyData.getKey() + "'", (Throwable)e);
                }
                ** GOTO lbl93
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final List<RegistryUpdateDto> uniqueOverlapping(List<RegistryUpdateDto> data) {
        LinkedHashMap map = new LinkedHashMap();
        for (RegistryUpdateDto item : data) {
            ((Map)map).put(item.getKey(), item);
        }
        Collection collection = map.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.toList((Iterable)collection);
    }

    private final String jsonToString(JsonElement value) {
        if (value == null) {
            return null;
        }
        return value instanceof JsonPrimitive ? (((JsonPrimitive)value).isString() ? ((JsonPrimitive)value).getContent() : ((JsonPrimitive)value).toString()) : value.toString();
    }

    private final Object applyChange(String key, String value, String reason, RegistryValue registryValue, Continuation<? super Unit> $completion) {
        RegistryUpdaterKt.access$getLog$p().info("Updating registry key '" + key + "' to value '" + value + "' because of: " + reason);
        Object object = CoroutinesKt.edtWriteAction(() -> RegistryUpdater.applyChange$lambda$0(value, registryValue), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object rollback(String key, Continuation<? super Unit> $completion) {
        RegistryUpdaterKt.access$getLog$p().info("Resetting registry value '" + key + "'");
        Object object = CoroutinesKt.edtWriteAction(() -> RegistryUpdater.rollback$lambda$0(key), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final Unit applyChange$lambda$0(String $value, RegistryValue $registryValue) {
        if ($value == null) {
            $registryValue.resetToDefault();
        } else {
            $registryValue.setValue($value, RegistryValueSource.MANAGER);
        }
        return Unit.INSTANCE;
    }

    private static final Unit rollback$lambda$0(String $key) {
        try {
            Registry.Companion.get($key).resetToDefault();
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$applyChange(RegistryUpdater $this, String key, String value, String reason, RegistryValue registryValue, Continuation $completion) {
        return $this.applyChange(key, value, reason, registryValue, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$rollback(RegistryUpdater $this, String key, Continuation $completion) {
        return $this.rollback(key, (Continuation<? super Unit>)$completion);
    }
}

