/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.inspection;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.ProblemDescriptorWithReporterName;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.DynamicGroupTool;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.dupLocator.iterators.CountingNodeIterator;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextLikeFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ui.CustomInspectionActions;
import com.intellij.profile.codeInspection.ui.InspectionMetaDataDialog;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.structuralsearch.DefaultMatchResultSink;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.compiler.PatternCompiler;
import com.intellij.structuralsearch.impl.matcher.filters.LexicalNodesFilter;
import com.intellij.structuralsearch.impl.matcher.iterators.SsrFilteringNodeIterator;
import com.intellij.structuralsearch.impl.matcher.strategies.MatchingStrategy;
import com.intellij.structuralsearch.inspection.MatchResultForPreview;
import com.intellij.structuralsearch.inspection.StructuralSearchInspectionToolWrapper;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

public class SSBasedInspection
extends LocalInspectionTool
implements DynamicGroupTool {
    private static final Logger LOG = Logger.getInstance(SSBasedInspection.class);
    public static final Comparator<? super Configuration> CONFIGURATION_COMPARATOR = Comparator.comparing(Configuration::getName, NaturalComparator.INSTANCE).thenComparingInt(Configuration::getOrder);
    private static final Key<Map<Configuration, Matcher>> COMPILED_PATTERNS = Key.create((String)"SSR_COMPILED_PATTERNS");
    private final MultiMapEx<Configuration, Matcher> myCompiledPatterns = new MultiMapEx();
    @NonNls
    public static final String SHORT_NAME = "SSBasedInspection";
    private final List<Configuration> myConfigurations = ContainerUtil.createLockFreeCopyOnWriteList();
    private volatile List<LocalInspectionToolWrapper> myChildrenCached = null;
    private final Set<String> myProblemsReported = new HashSet<String>(1);
    private InspectionProfileImpl mySessionProfile;

    @NotNull
    public static SSBasedInspection getStructuralSearchInspection(@NotNull InspectionProfile profile) {
        if (profile == null) {
            SSBasedInspection.$$$reportNull$$$0(0);
        }
        SSBasedInspection sSBasedInspection = (SSBasedInspection)CustomInspectionActions.getInspection((InspectionProfile)profile, (String)SHORT_NAME);
        if (sSBasedInspection == null) {
            SSBasedInspection.$$$reportNull$$$0(1);
        }
        return sSBasedInspection;
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            SSBasedInspection.$$$reportNull$$$0(2);
        }
        ArrayList<Configuration> configurations = new ArrayList<Configuration>(this.myConfigurations);
        Collections.sort(configurations, CONFIGURATION_COMPARATOR);
        ConfigurationManager.writeConfigurations(node, configurations);
        for (Element child : node.getChildren()) {
            child.removeAttribute("order");
        }
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            SSBasedInspection.$$$reportNull$$$0(3);
        }
        this.myProblemsReported.clear();
        this.myConfigurations.clear();
        this.myChildrenCached = null;
        ConfigurationManager.readConfigurations(node, this.myConfigurations);
        Configuration previous = null;
        boolean sorted = true;
        for (Configuration configuration : this.myConfigurations) {
            if (configuration.getOrder() != 0 || previous != null && CONFIGURATION_COMPARATOR.compare(previous, configuration) > 0) {
                sorted = false;
                break;
            }
            previous = configuration;
        }
        if (sorted) {
            previous = null;
            for (Configuration configuration : this.myConfigurations) {
                if (previous != null && previous.getUuid().equals(configuration.getUuid())) {
                    configuration.setOrder(previous.getOrder() + 1);
                }
                previous = configuration;
            }
        }
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = SSBasedInspection.getGeneralGroupName();
        if (string == null) {
            SSBasedInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return SHORT_NAME;
    }

    public void initialize(@NotNull GlobalInspectionContext context) {
        if (context == null) {
            SSBasedInspection.$$$reportNull$$$0(5);
        }
        super.initialize(context);
        this.mySessionProfile = ((GlobalInspectionContextBase)context).getCurrentProfile();
    }

    public void cleanup(@NotNull Project project) {
        if (project == null) {
            SSBasedInspection.$$$reportNull$$$0(6);
        }
        super.cleanup(project);
        this.mySessionProfile = null;
        this.myCompiledPatterns.clear();
    }

    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder problemsHolder) {
        Map compiledPatterns;
        if (session == null) {
            SSBasedInspection.$$$reportNull$$$0(7);
        }
        if (problemsHolder == null) {
            SSBasedInspection.$$$reportNull$$$0(8);
        }
        if ((compiledPatterns = (Map)session.getUserData(COMPILED_PATTERNS)) != null) {
            this.checkInCompiledPatterns(compiledPatterns);
        }
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            SSBasedInspection.$$$reportNull$$$0(9);
        }
        if (session == null) {
            SSBasedInspection.$$$reportNull$$$0(10);
        }
        if (this.myConfigurations.isEmpty()) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                SSBasedInspection.$$$reportNull$$$0(11);
            }
            return psiElementVisitor;
        }
        PsiFile file = holder.getFile();
        FileType fileType = file.getFileType();
        if (fileType instanceof PlainTextLikeFileType) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                SSBasedInspection.$$$reportNull$$$0(12);
            }
            return psiElementVisitor;
        }
        Project project = holder.getProject();
        InspectionProfileImpl profile = this.mySessionProfile != null && !isOnTheFly ? this.mySessionProfile : InspectionProfileManager.getInstance((Project)project).getCurrentProfile();
        SmartList configurations = new SmartList();
        for (Configuration configuration : this.myConfigurations) {
            ToolsImpl tools;
            if (configuration.getFileType() != fileType && !configuration.getMatchOptions().isSearchInjectedCode() || (tools = profile.getToolsOrNull(configuration.getUuid(), project)) == null || !tools.isEnabled((PsiElement)file)) continue;
            configurations.add(configuration);
            SSBasedInspection.register(configuration);
        }
        if (configurations.isEmpty()) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                SSBasedInspection.$$$reportNull$$$0(13);
            }
            return psiElementVisitor;
        }
        ConcurrentHashMap.KeySetView duplicates = ConcurrentHashMap.newKeySet();
        Map<Configuration, Matcher> compiledPatterns = this.checkOutCompiledPatterns((List<? extends Configuration>)configurations, project, holder, duplicates);
        session.putUserData(COMPILED_PATTERNS, compiledPatterns);
        return new SSBasedVisitor(compiledPatterns);
    }

    public static void register(@NotNull Configuration configuration) {
        if (configuration == null) {
            SSBasedInspection.$$$reportNull$$$0(14);
        }
        if (configuration.getOrder() != 0) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            String shortName = configuration.getUuid();
            HighlightDisplayKey key = HighlightDisplayKey.find((String)shortName);
            if (key != null) {
                if (!SSBasedInspection.isMetaDataChanged(configuration, key)) {
                    return;
                }
                HighlightDisplayKey.unregister((String)shortName);
            }
            String suppressId = configuration.getSuppressId();
            String name = configuration.getName();
            HighlightDisplayKey.register((String)shortName, () -> name, (String)(StringUtil.isEmpty((String)suppressId) ? SHORT_NAME : suppressId), null, (Object)configuration);
        }, ModalityState.nonModal());
    }

    private static boolean isMetaDataChanged(@NotNull Configuration configuration, @NotNull HighlightDisplayKey key) {
        if (configuration == null) {
            SSBasedInspection.$$$reportNull$$$0(15);
        }
        if (key == null) {
            SSBasedInspection.$$$reportNull$$$0(16);
        }
        if (StringUtil.isEmpty((String)configuration.getSuppressId()) ? !SHORT_NAME.equals(key.getID()) : !configuration.getSuppressId().equals(key.getID())) {
            return true;
        }
        return !configuration.getName().equals(HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)key));
    }

    @NotNull
    public List<LocalInspectionToolWrapper> getChildren() {
        if (this.myChildrenCached == null) {
            this.myChildrenCached = this.myConfigurations.stream().filter(configuration -> configuration.getOrder() == 0).map(configuration -> new StructuralSearchInspectionToolWrapper(this.getConfigurationsWithUuid(configuration.getUuid()))).collect(Collectors.toList());
        }
        List<LocalInspectionToolWrapper> list = this.myChildrenCached;
        if (list == null) {
            SSBasedInspection.$$$reportNull$$$0(17);
        }
        return list;
    }

    private static LocalQuickFix createQuickFix(@NotNull Project project, @NotNull MatchResult matchResult, @NotNull Configuration configuration) {
        if (project == null) {
            SSBasedInspection.$$$reportNull$$$0(18);
        }
        if (matchResult == null) {
            SSBasedInspection.$$$reportNull$$$0(19);
        }
        if (configuration == null) {
            SSBasedInspection.$$$reportNull$$$0(20);
        }
        if (!(configuration instanceof ReplaceConfiguration)) {
            return null;
        }
        return new StructuralQuickFix(project, matchResult, configuration.getReplaceOptions());
    }

    @NotNull
    private Configuration getMainConfiguration(@NotNull Configuration configuration) {
        if (configuration == null) {
            SSBasedInspection.$$$reportNull$$$0(21);
        }
        if (configuration.getOrder() == 0) {
            Configuration configuration2 = configuration;
            if (configuration2 == null) {
                SSBasedInspection.$$$reportNull$$$0(22);
            }
            return configuration2;
        }
        String uuid = configuration.getUuid();
        Configuration configuration3 = this.myConfigurations.stream().filter(c -> c.getOrder() == 0 && uuid.equals(c.getUuid())).findFirst().orElse(configuration);
        if (configuration3 == null) {
            SSBasedInspection.$$$reportNull$$$0(23);
        }
        return configuration3;
    }

    @NotNull
    public List<Configuration> getConfigurations() {
        return new SmartList(this.myConfigurations);
    }

    @NotNull
    public @Unmodifiable List<Configuration> getConfigurationsWithUuid(@NotNull String uuid) {
        if (uuid == null) {
            SSBasedInspection.$$$reportNull$$$0(24);
        }
        List list = ContainerUtil.sorted((Collection)ContainerUtil.filter(this.myConfigurations, c -> uuid.equals(c.getUuid())), Comparator.comparingInt(Configuration::getOrder));
        if (list == null) {
            SSBasedInspection.$$$reportNull$$$0(25);
        }
        return list;
    }

    public boolean addConfiguration(@NotNull Configuration configuration) {
        if (configuration == null) {
            SSBasedInspection.$$$reportNull$$$0(26);
        }
        if (this.myConfigurations.contains(configuration)) {
            return false;
        }
        this.myConfigurations.add(configuration);
        this.myChildrenCached = null;
        return true;
    }

    public boolean addConfigurations(@NotNull Collection<? extends Configuration> configurations) {
        if (configurations == null) {
            SSBasedInspection.$$$reportNull$$$0(27);
        }
        boolean modified = false;
        for (Configuration configuration : configurations) {
            modified |= this.addConfiguration(configuration);
        }
        return modified;
    }

    public boolean removeConfiguration(@NotNull Configuration configuration) {
        boolean removed;
        if (configuration == null) {
            SSBasedInspection.$$$reportNull$$$0(28);
        }
        if (removed = this.myConfigurations.remove(configuration)) {
            this.myChildrenCached = null;
        }
        return removed;
    }

    public boolean removeConfigurationsWithUuid(@NotNull String uuid) {
        boolean removed;
        if (uuid == null) {
            SSBasedInspection.$$$reportNull$$$0(29);
        }
        if (removed = this.myConfigurations.removeIf(c -> c.getUuid().equals(uuid))) {
            this.myChildrenCached = null;
        }
        return removed;
    }

    public InspectionMetaDataDialog createMetaDataDialog(Project project, @NotNull String profileName, @Nullable Configuration configuration) {
        if (profileName == null) {
            SSBasedInspection.$$$reportNull$$$0(30);
        }
        List<Configuration> configurations = this.getConfigurations();
        Function<String, @NlsContexts.DialogMessage @Nullable String> nameValidator = name -> {
            for (Configuration current : configurations) {
                if (current.getOrder() != 0 || !current.getName().equals(name) || configuration != null && current.getUuid().equals(configuration.getUuid())) continue;
                return SSRBundle.message("inspection.with.name.exists.warning", name);
            }
            return null;
        };
        if (configuration == null) {
            return new InspectionMetaDataDialog(project, profileName, nameValidator);
        }
        return new InspectionMetaDataDialog(project, profileName, nameValidator, configuration.getName(), configuration.getDescription(), configuration.getProblemDescriptor(), configuration.getSuppressId());
    }

    @NotNull
    private Map<Configuration, Matcher> checkOutCompiledPatterns(@NotNull List<? extends Configuration> configurations, @NotNull Project project, @NotNull ProblemsHolder holder, @NotNull Set<? super SmartPsiElementPointer<?>> duplicates) {
        if (configurations == null) {
            SSBasedInspection.$$$reportNull$$$0(31);
        }
        if (project == null) {
            SSBasedInspection.$$$reportNull$$$0(32);
        }
        if (holder == null) {
            SSBasedInspection.$$$reportNull$$$0(33);
        }
        if (duplicates == null) {
            SSBasedInspection.$$$reportNull$$$0(34);
        }
        HashMap<Configuration, Matcher> result = new HashMap<Configuration, Matcher>();
        for (Configuration configuration : configurations) {
            Matcher matcher = this.myCompiledPatterns.popValue(configuration);
            if (matcher == Matcher.EMPTY) continue;
            if (matcher != null) {
                result.put(configuration, matcher);
            } else {
                matcher = SSBasedInspection.buildCompiledConfiguration(configuration, project);
                result.put(configuration, matcher);
            }
            if (matcher == null) continue;
            MatchContext context = matcher.getMatchContext();
            context.setSink(new InspectionResultSink(configuration, holder, duplicates));
            context.setShouldRecursivelyMatch(false);
        }
        HashMap<Configuration, Matcher> hashMap = result;
        if (hashMap == null) {
            SSBasedInspection.$$$reportNull$$$0(35);
        }
        return hashMap;
    }

    @ApiStatus.Internal
    @TestOnly
    public void compileAllConfigurations(@NotNull Project project) {
        if (project == null) {
            SSBasedInspection.$$$reportNull$$$0(36);
        }
        for (Configuration configuration : this.myConfigurations) {
            SSBasedInspection.buildCompiledConfiguration(configuration, project);
        }
    }

    private static Matcher buildCompiledConfiguration(@NotNull Configuration configuration, @NotNull Project project) {
        if (configuration == null) {
            SSBasedInspection.$$$reportNull$$$0(37);
        }
        if (project == null) {
            SSBasedInspection.$$$reportNull$$$0(38);
        }
        try {
            MatchOptions matchOptions = configuration.getMatchOptions();
            CompiledPattern compiledPattern = PatternCompiler.compilePattern(project, matchOptions, false, true);
            return compiledPattern == null ? null : new Matcher(project, matchOptions, compiledPattern);
        }
        catch (StructuralSearchException e) {
            LOG.warn("Malformed structural search inspection pattern \"" + configuration.getName() + "\"", (Throwable)e);
            return null;
        }
    }

    private void checkInCompiledPatterns(@NotNull Map<Configuration, Matcher> compiledPatterns) {
        if (compiledPatterns == null) {
            SSBasedInspection.$$$reportNull$$$0(39);
        }
        for (Map.Entry<Configuration, Matcher> entry : compiledPatterns.entrySet()) {
            Configuration configuration = entry.getKey();
            Matcher matcher = entry.getValue();
            if (matcher == null) {
                this.myCompiledPatterns.putValue(configuration, Matcher.EMPTY);
                continue;
            }
            matcher.getMatchContext().getSink().matchingFinished();
            this.myCompiledPatterns.putValue(configuration, matcher);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 11, 12, 13, 17, 22, 23, 25, 35 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 22: 
            case 23: 
            case 25: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/inspection/SSBasedInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 18: 
            case 32: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 9: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 26: 
            case 28: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchResult";
                break;
            }
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uuid";
                break;
            }
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileName";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicates";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiledPatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/inspection/SSBasedInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStructuralSearchInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainConfiguration";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationsWithUuid";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "checkOutCompiledPatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStructuralSearchInspection";
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 22: 
            case 23: 
            case 25: 
            case 35: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "cleanup";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "inspectionFinished";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isMetaDataChanged";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createQuickFix";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getMainConfiguration";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationsWithUuid";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addConfiguration";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addConfigurations";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "removeConfiguration";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "removeConfigurationsWithUuid";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createMetaDataDialog";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "checkOutCompiledPatterns";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "compileAllConfigurations";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "buildCompiledConfiguration";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "checkInCompiledPatterns";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 11, 12, 13, 17, 22, 23, 25, 35 -> new IllegalStateException(string);
        };
    }

    private static class MultiMapEx<K, V>
    extends MultiMap<K, V> {
        MultiMapEx() {
            super(new ConcurrentHashMap());
        }

        @NotNull
        protected Collection<V> createCollection() {
            return new ConcurrentLinkedDeque();
        }

        V popValue(K k) {
            Deque vs = (Deque)this.myMap.get(k);
            return vs == null ? null : (V)vs.pollLast();
        }
    }

    private class SSBasedVisitor
    extends PsiElementVisitor {
        private final Map<Configuration, Matcher> myCompiledOptions;

        SSBasedVisitor(Map<Configuration, Matcher> compiledOptions) {
            this.myCompiledOptions = compiledOptions;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                SSBasedVisitor.$$$reportNull$$$0(0);
            }
            if (LexicalNodesFilter.getInstance().accepts(element)) {
                return;
            }
            for (Map.Entry<Configuration, Matcher> entry : this.myCompiledOptions.entrySet()) {
                MatchingStrategy strategy;
                Matcher matcher = entry.getValue();
                if (matcher == null || !(strategy = matcher.getMatchContext().getPattern().getStrategy()).continueMatching(element)) continue;
                Configuration configuration = entry.getKey();
                this.processElement(element, configuration, matcher);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processElement(@Nullable PsiElement element, @NotNull Configuration configuration, @NotNull Matcher matcher) {
            NodeIterator matchedNodes;
            if (configuration == null) {
                SSBasedVisitor.$$$reportNull$$$0(1);
            }
            if (matcher == null) {
                SSBasedVisitor.$$$reportNull$$$0(2);
            }
            if (!matcher.checkIfShouldAttemptToMatch(matchedNodes = SsrFilteringNodeIterator.create(element))) {
                return;
            }
            MatchContext matchContext = matcher.getMatchContext();
            int nodeCount = matchContext.getPattern().getNodeCount();
            try {
                matcher.processMatchesInElement((NodeIterator)new CountingNodeIterator(nodeCount, matchedNodes));
            }
            catch (StructuralSearchException e) {
                if (SSBasedInspection.this.myProblemsReported.add(configuration.getName())) {
                    String message = e.getMessage().replace("a3cd264774bf4efb9ab609b250c5165c", "");
                    NotificationGroupManager.getInstance().getNotificationGroup("Structural Search").createNotification(SSRBundle.message("inspection.script.problem", message, configuration.getName()), NotificationType.ERROR).setImportant(true).notify(element != null ? element.getProject() : null);
                }
            }
            finally {
                matchedNodes.reset();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matcher";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/structuralsearch/inspection/SSBasedInspection$SSBasedVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class StructuralQuickFix
    implements LocalQuickFix {
        private final ReplacementInfo myReplacementInfo;
        private final Replacer myReplacer;
        private final ReplaceOptions myReplaceOptions;

        StructuralQuickFix(@NotNull Project project, @NotNull MatchResult matchResult, @NotNull ReplaceOptions replaceOptions) {
            if (project == null) {
                StructuralQuickFix.$$$reportNull$$$0(0);
            }
            if (matchResult == null) {
                StructuralQuickFix.$$$reportNull$$$0(1);
            }
            if (replaceOptions == null) {
                StructuralQuickFix.$$$reportNull$$$0(2);
            }
            this.myReplaceOptions = replaceOptions;
            this.myReplacer = new Replacer(project, replaceOptions);
            this.myReplacementInfo = this.myReplacer.buildReplacement(matchResult);
        }

        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myReplacementInfo.getReplacement()});
            if (string == null) {
                StructuralQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                StructuralQuickFix.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                StructuralQuickFix.$$$reportNull$$$0(5);
            }
            if ((element = descriptor.getPsiElement()) != null) {
                this.myReplacer.replace(this.myReplacementInfo);
            }
        }

        @Nullable
        public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
            if (target == null) {
                StructuralQuickFix.$$$reportNull$$$0(6);
            }
            return new StructuralQuickFix(target.getProject(), new MatchResultForPreview(this.myReplacementInfo.getMatchResult(), target), this.myReplaceOptions);
        }

        @NotNull
        public String getFamilyName() {
            String string = SSRBundle.message("SSRInspection.family.name", new Object[0]);
            if (string == null) {
                StructuralQuickFix.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matchResult";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replaceOptions";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/structuralsearch/inspection/SSBasedInspection$StructuralQuickFix";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/structuralsearch/inspection/SSBasedInspection$StructuralQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 7: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getFileModifierForPreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 7 -> new IllegalStateException(string);
            };
        }
    }

    private final class InspectionResultSink
    extends DefaultMatchResultSink {
        private final Configuration myConfiguration;
        private ProblemsHolder myHolder;
        private final Set<? super SmartPsiElementPointer<?>> duplicates;

        InspectionResultSink(@NotNull Configuration configuration, @NotNull ProblemsHolder holder, Set<? super SmartPsiElementPointer<?>> duplicates) {
            if (configuration == null) {
                InspectionResultSink.$$$reportNull$$$0(0);
            }
            if (holder == null) {
                InspectionResultSink.$$$reportNull$$$0(1);
            }
            if (duplicates == null) {
                InspectionResultSink.$$$reportNull$$$0(2);
            }
            this.myConfiguration = configuration;
            this.myHolder = holder;
            this.duplicates = duplicates;
        }

        @Override
        public void newMatch(@NotNull MatchResult result) {
            if (result == null) {
                InspectionResultSink.$$$reportNull$$$0(3);
            }
            if (!this.duplicates.add(result.getMatchRef())) {
                return;
            }
            this.registerProblem(result, this.myConfiguration, this.myHolder);
        }

        private void registerProblem(@NotNull MatchResult matchResult, @NotNull Configuration configuration, @NotNull ProblemsHolder holder) {
            if (matchResult == null) {
                InspectionResultSink.$$$reportNull$$$0(4);
            }
            if (configuration == null) {
                InspectionResultSink.$$$reportNull$$$0(5);
            }
            if (holder == null) {
                InspectionResultSink.$$$reportNull$$$0(6);
            }
            PsiElement element = matchResult.getMatch();
            PsiFile containingFile = element.getContainingFile();
            PsiFile templateFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)containingFile);
            if (!element.isPhysical() || holder.getFile() != containingFile && holder.getFile() != templateFile) {
                return;
            }
            LocalQuickFix fix = SSBasedInspection.createQuickFix(element.getProject(), matchResult, configuration);
            Configuration mainConfiguration = SSBasedInspection.this.getMainConfiguration(configuration);
            String name = (String)ObjectUtils.notNull((Object)mainConfiguration.getProblemDescriptor(), (Object)mainConfiguration.getName());
            ProblemDescriptor descriptor = holder.getManager().createProblemDescriptor(element, name, fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, holder.isOnTheFly());
            final String uuid = mainConfiguration.getUuid();
            descriptor.setProblemGroup(new ProblemGroup(){

                public String getProblemName() {
                    return uuid;
                }
            });
            holder.registerProblem((ProblemDescriptor)new ProblemDescriptorWithReporterName((ProblemDescriptorBase)descriptor, uuid));
        }

        @Override
        public void matchingFinished() {
            this.duplicates.clear();
            this.myHolder = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "duplicates";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matchResult";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/structuralsearch/inspection/SSBasedInspection$InspectionResultSink";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "newMatch";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerProblem";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

