/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.dap.subprocess;

import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.platform.dap.DapLaunchArgumentsProvider;
import com.intellij.platform.dap.DapProcessStarter;
import com.intellij.platform.dap.LaunchRequestArguments;
import com.intellij.python.dap.subprocess.PythonDapSubprocessConfiguration;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSessionBuilder;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSessionStartedResult;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\tH\u0007J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0003J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/python/dap/subprocess/PythonDapDebugSubprocessService;", "", "<init>", "()V", "runSubprocess", "", "project", "Lcom/intellij/openapi/project/Project;", "args", "", "", "createNewSession", "Lcom/intellij/xdebugger/impl/XDebugSessionImpl;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "createDapSubprocessEnvironment", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "intellij.python.dap"})
@SourceDebugExtension(value={"SMAP\nPythonDapDebugSubprocessService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonDapDebugSubprocessService.kt\ncom/intellij/python/dap/subprocess/PythonDapDebugSubprocessService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n296#2,2:70\n296#2,2:73\n1#3:72\n*S KotlinDebug\n*F\n+ 1 PythonDapDebugSubprocessService.kt\ncom/intellij/python/dap/subprocess/PythonDapDebugSubprocessService\n*L\n31#1:70,2\n61#1:73,2\n*E\n"})
public final class PythonDapDebugSubprocessService {
    @RequiresEdt
    public final void runSubprocess(@NotNull Project project, @NotNull Map<String, ? extends Object> args) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Object object = args.get("name");
        ExecutionEnvironment executionEnv = this.createDapSubprocessEnvironment(project, (RunConfiguration)new PythonDapSubprocessConfiguration(project, args, object instanceof String ? (String)object : null));
        this.createNewSession(project, executionEnv);
    }

    @RequiresEdt
    private final XDebugSessionImpl createNewSession(Project project, ExecutionEnvironment environment) {
        XDebugSessionImpl session;
        block11: {
            RunContentDescriptor runContentDescriptor;
            XDebugSessionListener listener2;
            block10: {
                Unit unit;
                Object v1;
                Object element$iv2;
                RunProfile profile;
                block9: {
                    RunProfile runProfile = environment.getRunProfile();
                    Intrinsics.checkNotNullExpressionValue((Object)runProfile, (String)"getRunProfile(...)");
                    profile = runProfile;
                    Iterable $this$firstOrNull$iv = DapLaunchArgumentsProvider.Companion.getEP_NAME().getExtensionList();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        DapLaunchArgumentsProvider it = (DapLaunchArgumentsProvider)element$iv2;
                        boolean bl = false;
                        if (!it.isApplicable("Debug", profile)) continue;
                        v1 = element$iv2;
                        break block9;
                    }
                    v1 = null;
                }
                DapLaunchArgumentsProvider dapLaunchArgumentsProvider = v1;
                if (dapLaunchArgumentsProvider == null) {
                    return null;
                }
                DapLaunchArgumentsProvider argumentsProvider = dapLaunchArgumentsProvider;
                LaunchRequestArguments arguments = argumentsProvider.getLaunchArguments(project, profile);
                Executor executor = environment.getExecutor();
                Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"getExecutor(...)");
                RunProfileState runProfileState = environment.getState();
                Intrinsics.checkNotNull((Object)runProfileState);
                DapProcessStarter processStarter = new DapProcessStarter(environment, executor, runProfileState, arguments.getAdapterId(), arguments.getRequest(), arguments.getArguments());
                XDebugSessionBuilder xDebugSessionBuilder = XDebuggerManager.getInstance((Project)project).newSessionBuilder((XDebugProcessStarter)processStarter);
                String string = profile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                XSessionStartedResult sessionResult = xDebugSessionBuilder.sessionName(string).icon(profile.getIcon()).environment(environment).startSession();
                element$iv2 = sessionResult.getSession();
                session = element$iv2 instanceof XDebugSessionImpl ? (XDebugSessionImpl)element$iv2 : null;
                listener2 = new XDebugSessionListener(session){
                    final /* synthetic */ XDebugSessionImpl $session;
                    {
                        this.$session = $session;
                    }

                    public void sessionPaused() {
                        block0: {
                            XDebugSessionImpl xDebugSessionImpl = this.$session;
                            if (xDebugSessionImpl == null) break block0;
                            xDebugSessionImpl.showSessionTab();
                        }
                    }
                };
                runContentDescriptor = sessionResult.getRunContentDescriptor();
                if (runContentDescriptor == null) break block10;
                RunContentDescriptor it = runContentDescriptor;
                boolean bl = false;
                XDebugSessionImpl xDebugSessionImpl = session;
                if (xDebugSessionImpl != null) {
                    xDebugSessionImpl.addSessionListener(listener2, (Disposable)it);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                runContentDescriptor = unit;
                if (unit != null) break block11;
            }
            XDebugSessionImpl xDebugSessionImpl = session;
            if (xDebugSessionImpl != null) {
                xDebugSessionImpl.addSessionListener(listener2);
                runContentDescriptor = Unit.INSTANCE;
            } else {
                runContentDescriptor = null;
            }
        }
        return session;
    }

    private final ExecutionEnvironment createDapSubprocessEnvironment(Project project, RunConfiguration configuration) {
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = ProgramRunner.PROGRAM_RUNNER_EP.getExtensionList();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ProgramRunner it = (ProgramRunner)element$iv;
                boolean bl = false;
                if (!it.canRun("Debug", (RunProfile)configuration)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        ProgramRunner programRunner = v0;
        if (programRunner == null) {
            throw new IllegalStateException("No program runner for Debug");
        }
        ProgramRunner programRunner2 = programRunner;
        return new ExecutionEnvironment(DefaultDebugExecutor.getDebugExecutorInstance(), programRunner2, (RunnerAndConfigurationSettings)new RunnerAndConfigurationSettingsImpl(RunManagerImpl.Companion.getInstanceImpl(project), configuration, false, null, 12, null), project);
    }
}

