/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.retain;

import androidx.collection.MutableObjectList;
import androidx.collection.MutableScatterMap;
import androidx.collection.ObjectList;
import androidx.collection.ScatterMap;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.runtime.retain.RetainObserver;
import androidx.compose.runtime.retain.RetainedValuesStore;
import androidx.compose.runtime.retain.impl.PreconditionsKt;
import androidx.compose.runtime.retain.impl.SafeMultiValueMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\u0006\u0010\u0011\u001a\u00020\u000fJ\b\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u000fH\u0002J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\nH\u0016J\u001a\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\n2\b\u0010\u0019\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Landroidx/compose/runtime/retain/ManagedRetainedValuesStore;", "Landroidx/compose/runtime/retain/RetainedValuesStore;", "<init>", "()V", "isEnabled", "", "isDisposed", "isContentComposed", "keptExitedValues", "Landroidx/compose/runtime/retain/impl/SafeMultiValueMap;", "", "Landroidx/collection/MutableScatterMap;", "isRetainingExitedValues", "()Z", "enableRetainingExitedValues", "", "disableRetainingExitedValues", "dispose", "onContentExitComposition", "onContentEnteredComposition", "purgeUnusedExitedValues", "consumeExitedValueOrDefault", "key", "defaultValue", "saveExitingValue", "value", "runtime-retain"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nManagedRetainedValuesStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManagedRetainedValuesStore.kt\nandroidx/compose/runtime/retain/ManagedRetainedValuesStore\n+ 2 Preconditions.kt\nandroidx/compose/runtime/retain/impl/PreconditionsKt\n+ 3 SafeMultiValueMap.kt\nandroidx/compose/runtime/retain/impl/SafeMultiValueMap\n+ 4 ScatterMap.kt\nandroidx/collection/ScatterMap\n+ 5 ScatterMap.kt\nandroidx/collection/ScatterMapKt\n+ 6 ObjectList.kt\nandroidx/collection/ObjectList\n*L\n1#1,194:1\n49#2,4:195\n49#2,4:199\n49#2,4:203\n49#2,4:207\n139#3:211\n140#3,3:228\n144#3,3:237\n147#3:247\n372#4,3:212\n329#4,6:215\n339#4,3:222\n342#4,2:226\n345#4,6:240\n375#4:246\n1399#5:221\n1270#5:225\n287#6,6:231\n*S KotlinDebug\n*F\n+ 1 ManagedRetainedValuesStore.kt\nandroidx/compose/runtime/retain/ManagedRetainedValuesStore\n*L\n68#1:195,4\n116#1:199,4\n121#1:203,4\n131#1:207,4\n141#1:211\n141#1:228,3\n141#1:237,3\n141#1:247\n141#1:212,3\n141#1:215,6\n141#1:222,3\n141#1:226,2\n141#1:240,6\n141#1:246\n141#1:221\n141#1:225\n141#1:231,6\n*E\n"})
public final class ManagedRetainedValuesStore
implements RetainedValuesStore {
    private boolean isEnabled = true;
    private boolean isDisposed;
    private boolean isContentComposed;
    @NotNull
    private final MutableScatterMap<Object, Object> keptExitedValues = SafeMultiValueMap.constructor-impl$default(null, 1, null);
    public static final int $stable = 8;

    public final boolean isRetainingExitedValues() {
        return this.isEnabled && !this.isContentComposed;
    }

    public final void enableRetainingExitedValues() {
        boolean value$iv = !this.isDisposed;
        boolean $i$f$checkPrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            PreconditionsKt.throwIllegalStateException("Cannot call enableRetainingExitedValues on a disposed store");
        }
        this.isEnabled = true;
    }

    public final void disableRetainingExitedValues() {
        this.isEnabled = false;
        this.purgeUnusedExitedValues();
    }

    public final void dispose() {
        this.isDisposed = true;
        this.disableRetainingExitedValues();
    }

    @Override
    public void onContentExitComposition() {
        if (this.isDisposed) {
            return;
        }
        boolean value$iv = this.isContentComposed;
        boolean $i$f$checkPrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            PreconditionsKt.throwIllegalStateException("ManagedValuesStore tried to leave composition twice. Is the store installed in multiple places?");
        }
        value$iv = SafeMultiValueMap.isEmpty-impl(this.keptExitedValues);
        $i$f$checkPrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            PreconditionsKt.throwIllegalStateException("Attempted to start retaining exited values with pending exited values");
        }
        this.isContentComposed = false;
    }

    @Override
    public void onContentEnteredComposition() {
        if (this.isDisposed) {
            return;
        }
        boolean value$iv = !this.isContentComposed;
        boolean $i$f$checkPrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            PreconditionsKt.throwIllegalStateException("ManagedValuesStore tried to enter composition twice. Did you attempt to install the same store multiple times or into two compositions?");
        }
        this.purgeUnusedExitedValues();
        this.isContentComposed = true;
    }

    private final void purgeUnusedExitedValues() {
        MutableScatterMap<Object, Object> mutableScatterMap = this.keptExitedValues;
        boolean bl = false;
        ScatterMap this_$iv$iv = mutableScatterMap;
        boolean $i$f$forEachValue = false;
        Object[] v$iv$iv = this_$iv$iv.values;
        ScatterMap this_$iv$iv$iv = this_$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int i$iv$iv$iv = 0;
        long[] m$iv$iv$iv = this_$iv$iv$iv.metadata;
        int lastIndex$iv$iv$iv = m$iv$iv$iv.length - 2;
        if (i$iv$iv$iv <= lastIndex$iv$iv$iv) {
            while (true) {
                long slot$iv$iv$iv;
                long $this$maskEmptyOrDeleted$iv$iv$iv$iv = slot$iv$iv$iv = m$iv$iv$iv[i$iv$iv$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv$iv$iv = 8 - (~(i$iv$iv$iv - lastIndex$iv$iv$iv) >>> 31);
                    for (int j$iv$iv$iv = 0; j$iv$iv$iv < bitCount$iv$iv$iv; ++j$iv$iv$iv) {
                        long value$iv$iv$iv$iv = slot$iv$iv$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv$iv$iv < 128L) {
                            boolean bl2;
                            Object value;
                            int index$iv$iv$iv;
                            int index$iv$iv = index$iv$iv$iv = (i$iv$iv$iv << 3) + j$iv$iv$iv;
                            boolean bl3 = false;
                            Object it$iv = v$iv$iv[index$iv$iv];
                            boolean bl4 = false;
                            if (it$iv instanceof MutableObjectList) {
                                Object object = it$iv;
                                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type androidx.collection.MutableObjectList<V of androidx.compose.runtime.retain.impl.SafeMultiValueMap>");
                                ObjectList this_$iv$iv2 = (MutableObjectList)object;
                                boolean $i$f$forEach = false;
                                Object[] content$iv$iv = this_$iv$iv2.content;
                                int n = this_$iv$iv2._size;
                                for (int i$iv$iv = 0; i$iv$iv < n; ++i$iv$iv) {
                                    Object value$iv = content$iv$iv[i$iv$iv];
                                    boolean bl5 = false;
                                    value = value$iv;
                                    bl2 = false;
                                    if (!(value instanceof RetainObserver)) continue;
                                    ((RetainObserver)value).onRetired();
                                }
                            } else {
                                value = it$iv;
                                bl2 = false;
                                if (value instanceof RetainObserver) {
                                    ((RetainObserver)value).onRetired();
                                }
                            }
                        }
                        slot$iv$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv$iv != 8) break;
                }
                if (i$iv$iv$iv == lastIndex$iv$iv$iv) break;
                ++i$iv$iv$iv;
            }
        }
        SafeMultiValueMap.clear-impl(this.keptExitedValues);
    }

    @Override
    @Nullable
    public Object consumeExitedValueOrDefault(@NotNull Object key, @Nullable Object defaultValue) {
        return SafeMultiValueMap.removeLast-impl(this.keptExitedValues, key, defaultValue);
    }

    @Override
    public void saveExitingValue(@NotNull Object key, @Nullable Object value) {
        if (this.isRetainingExitedValues()) {
            SafeMultiValueMap.add-impl(this.keptExitedValues, key, value);
        } else if (value instanceof RetainObserver) {
            ((RetainObserver)value).onRetired();
        }
    }
}

