/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.following;

import com.intellij.codeWithMe.ClientId;
import com.intellij.cwm.plugin.following.FollowMeManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileOpenedSyncListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.document.DocumentExKt;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.util.LogLevel;
import com.jetbrains.rd.util.Logger;
import com.jetbrains.rd.util.LoggerKt;
import com.jetbrains.rd.util.SwitchLogger;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdserver.document.BackendDocumentHost;
import com.jetbrains.rdserver.editors.EditorToEditorSynchronizer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0012\u0010!\u001a\u00020\u001b2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\u0006\u0010$\u001a\u00020%R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006&"}, d2={"Lcom/intellij/cwm/plugin/following/EditorFollowMeSynchronizer;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "who", "Lcom/intellij/codeWithMe/ClientId;", "whom", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/codeWithMe/ClientId;Lcom/intellij/codeWithMe/ClientId;Lcom/intellij/openapi/project/Project;)V", "synchronizedEditors", "Ljava/util/HashMap;", "Lcom/intellij/openapi/editor/Editor;", "Lcom/jetbrains/rdserver/editors/EditorToEditorSynchronizer;", "Lkotlin/collections/HashMap;", "logger", "Lcom/jetbrains/rd/util/SwitchLogger;", "openedSyncListener", "Lcom/intellij/openapi/fileEditor/FileOpenedSyncListener;", "getOpenedSyncListener", "()Lcom/intellij/openapi/fileEditor/FileOpenedSyncListener;", "syncFollower", "", "leadEditor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "shouldIgnore", "", "leadFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "selectionChanged", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "followerBreaksFollowing", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "dump", "", "intellij.cwm.plugin"})
@SourceDebugExtension(value={"SMAP\nEditorFollowMeSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorFollowMeSynchronizer.kt\ncom/intellij/cwm/plugin/following/EditorFollowMeSynchronizer\n+ 2 Logger.kt\ncom/jetbrains/rd/util/LoggerKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,152:1\n106#2:153\n98#2,4:154\n105#2:158\n98#2,4:159\n105#2:163\n98#2,4:164\n18#3:168\n*S KotlinDebug\n*F\n+ 1 EditorFollowMeSynchronizer.kt\ncom/intellij/cwm/plugin/following/EditorFollowMeSynchronizer\n*L\n124#1:153\n124#1:154,4\n129#1:158\n129#1:159,4\n130#1:163\n130#1:164,4\n75#1:168\n*E\n"})
public final class EditorFollowMeSynchronizer
implements FileEditorManagerListener {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final ClientId who;
    @NotNull
    private final ClientId whom;
    @NotNull
    private final Project project;
    @NotNull
    private final HashMap<Editor, EditorToEditorSynchronizer> synchronizedEditors;
    @NotNull
    private final SwitchLogger logger;
    @NotNull
    private final FileOpenedSyncListener openedSyncListener;

    public EditorFollowMeSynchronizer(@NotNull Lifetime lifetime, @NotNull ClientId who, @NotNull ClientId whom, @NotNull Project project) {
        EditorImpl leadEditor;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)who, (String)"who");
        Intrinsics.checkNotNullParameter((Object)whom, (String)"whom");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.lifetime = lifetime;
        this.who = who;
        this.whom = whom;
        this.project = project;
        this.synchronizedEditors = new HashMap();
        this.logger = LoggerKt.getLogger((String)("FollowMeSynchronizer(who=" + this.who + ";whom=" + this.whom + ")"));
        EditorImpl editorImpl = leadEditor = (EditorImpl)ClientId.Companion.withExplicitClientId(this.whom, () -> EditorFollowMeSynchronizer._init_$lambda$0(this));
        if (editorImpl != null) {
            EditorImpl it = editorImpl;
            boolean bl = false;
            this.syncFollower(it);
        }
        this.openedSyncListener = new FileOpenedSyncListener(this){
            final /* synthetic */ EditorFollowMeSynchronizer this$0;
            {
                this.this$0 = $receiver;
            }

            public void fileOpenedSync(FileEditorManager source, VirtualFile file2, List<FileEditorWithProvider> editorsWithProviders) {
                FileEditorWithProvider fileEditor;
                Object v0;
                FileEditorWithProvider fileEditorWithProvider;
                block4: {
                    Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                    Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                    Intrinsics.checkNotNullParameter(editorsWithProviders, (String)"editorsWithProviders");
                    Iterable iterable = editorsWithProviders;
                    for (T t : iterable) {
                        fileEditorWithProvider = (FileEditorWithProvider)t;
                        boolean bl = false;
                        FileEditor editor = fileEditorWithProvider.component1();
                        if (!Intrinsics.areEqual((Object)editor.getFile(), (Object)file2)) continue;
                        v0 = t;
                        break block4;
                    }
                    v0 = null;
                }
                FileEditorWithProvider fileEditorWithProvider2 = fileEditor = (FileEditorWithProvider)v0;
                if (EditorFollowMeSynchronizer.access$followerBreaksFollowing(this.this$0, (FileEditor)(fileEditorWithProvider2 != null ? fileEditorWithProvider2.getFileEditor() : null))) {
                    return;
                }
                if (!Intrinsics.areEqual((Object)ClientId.Companion.getCurrent(), (Object)EditorFollowMeSynchronizer.access$getWhom$p(this.this$0))) {
                    return;
                }
                FileEditorWithProvider fileEditorWithProvider3 = fileEditor;
                fileEditorWithProvider = fileEditorWithProvider3 != null ? fileEditorWithProvider3.getFileEditor() : null;
                TextEditor textEditor = fileEditorWithProvider instanceof TextEditor ? (TextEditor)fileEditorWithProvider : null;
                Editor editor = textEditor != null ? textEditor.getEditor() : null;
                EditorImpl editorImpl = editor instanceof EditorImpl ? (EditorImpl)editor : null;
                if (editorImpl == null) {
                    return;
                }
                EditorImpl editorImpl2 = editorImpl;
                EditorFollowMeSynchronizer.access$syncFollower(this.this$0, editorImpl2);
            }
        };
    }

    @NotNull
    public final FileOpenedSyncListener getOpenedSyncListener() {
        return this.openedSyncListener;
    }

    private final void syncFollower(EditorImpl leadEditor) {
        EditorImpl followerEditor = (EditorImpl)ClientId.Companion.withExplicitClientId(this.who, () -> EditorFollowMeSynchronizer.syncFollower$lambda$0(leadEditor, this));
        if (this.synchronizedEditors.containsKey(leadEditor)) {
            return;
        }
        EditorImpl editorImpl = followerEditor;
        if (editorImpl == null) {
            return;
        }
        EditorImpl followerEditorToBind = editorImpl;
        Disposable disposable = leadEditor.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        Lifetime intersectWithLead = RLifetimeKt.intersect((Lifetime)this.lifetime, (Lifetime)LifetimeDisposableExKt.createLifetime((Disposable)disposable));
        Disposable disposable2 = followerEditorToBind.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"getDisposable(...)");
        Lifetime intersectAllLifetime = RLifetimeKt.intersect((Lifetime)intersectWithLead, (Lifetime)LifetimeDisposableExKt.createLifetime((Disposable)disposable2));
        EditorToEditorSynchronizer synchronizer = new EditorToEditorSynchronizer((Editor)leadEditor, (Editor)followerEditorToBind, intersectAllLifetime);
        synchronizer.install();
        ((Map)this.synchronizedEditors).put(leadEditor, synchronizer);
        intersectAllLifetime.onTerminationIfAlive(() -> EditorFollowMeSynchronizer.syncFollower$lambda$1(this, leadEditor));
    }

    private final boolean shouldIgnore(VirtualFile leadFile, EditorImpl leadEditor) {
        if (leadFile instanceof LightVirtualFile) {
            return true;
        }
        if (ClientId.Companion.isCurrentlyUnderLocalId()) {
            return false;
        }
        BackendDocumentHost backendDocumentHost = BackendDocumentHost.Companion.getInstance(ClientSessionsUtil.getCurrentSession((Application)ApplicationKt.getApplication()));
        DocumentEx documentEx = leadEditor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentSynchronizer existingSynchronizer = backendDocumentHost.tryGetSynchronizer((Document)documentEx);
        return existingSynchronizer != null && !DocumentExKt.isLocalFile((RdDocumentId)existingSynchronizer.getDocumentId());
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        FileEditor fileEditor = event.getNewEditor();
        TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
        Editor editor = textEditor != null ? textEditor.getEditor() : null;
        EditorImpl editorImpl = editor instanceof EditorImpl ? (EditorImpl)editor : null;
        if (editorImpl == null) {
            return;
        }
        EditorImpl editorImpl2 = editorImpl;
        if (this.followerBreaksFollowing(event.getNewEditor())) {
            return;
        }
        if (!Intrinsics.areEqual((Object)ClientId.Companion.getCurrent(), (Object)this.whom)) {
            return;
        }
        this.syncFollower(editorImpl2);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean followerBreaksFollowing(FileEditor fileEditor) {
        if (Intrinsics.areEqual((Object)ClientId.Companion.getCurrent(), (Object)this.who) && !FollowMeManager.Companion.getInstance(this.project).isFullSyncBetween(this.who, this.whom)) {
            VirtualFile selectedFile = (VirtualFile)ClientId.Companion.withExplicitClientId(this.whom, () -> EditorFollowMeSynchronizer.followerBreaksFollowing$lambda$0(this));
            FileEditor selectedLeadEditor = (FileEditor)ClientId.Companion.withExplicitClientId(this.whom, () -> EditorFollowMeSynchronizer.followerBreaksFollowing$lambda$1(this));
            if (selectedFile != null && selectedLeadEditor == null) {
                void $this$log$iv$iv;
                Logger $this$warn$iv = (Logger)this.logger;
                boolean $i$f$warn = false;
                Logger logger = $this$warn$iv;
                LogLevel level$iv$iv = LogLevel.Warn;
                boolean $i$f$log = false;
                if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                    LogLevel logLevel = level$iv$iv;
                    void var10_16 = $this$log$iv$iv;
                    boolean bl = false;
                    String string = this.whom + "'s composite is under initialization";
                    var10_16.log(logLevel, (Object)string, null);
                }
                return false;
            }
            FileEditor fileEditor2 = selectedLeadEditor;
            FileEditor fileEditor3 = fileEditor;
            if (!Intrinsics.areEqual((Object)(fileEditor2 != null ? fileEditor2.getFile() : null), (Object)(fileEditor3 != null ? fileEditor3.getFile() : null))) {
                String string;
                Logger logger;
                LogLevel logLevel;
                Logger $this$info$iv = (Logger)this.logger;
                boolean $i$f$info = false;
                Logger $this$log$iv$iv = $this$info$iv;
                LogLevel level$iv$iv = LogLevel.Info;
                boolean $i$f$log = false;
                if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                    logLevel = level$iv$iv;
                    logger = $this$log$iv$iv;
                    boolean bl = false;
                    string = "Navigating outside of a lead's scope. Follower navigation: " + fileEditor + ". Selected lead editor: " + selectedLeadEditor;
                    logger.log(logLevel, (Object)string, null);
                }
                $this$info$iv = (Logger)this.logger;
                $i$f$info = false;
                $this$log$iv$iv = $this$info$iv;
                level$iv$iv = LogLevel.Info;
                $i$f$log = false;
                if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                    logLevel = level$iv$iv;
                    logger = $this$log$iv$iv;
                    boolean bl = false;
                    string = "stopping following " + this.who + " to " + this.whom;
                    logger.log(logLevel, (Object)string, null);
                }
                FollowMeManager.Companion.getInstance(this.project).unregisterFollower(this.who);
                return true;
            }
        }
        return false;
    }

    @NotNull
    public final String dump() {
        StringBuilder stringBuilder;
        StringBuilder $this$dump_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$dump_u24lambda_u240.append("FollowMeSynchronizer").append('\n');
        $this$dump_u24lambda_u240.append("who: " + this.who).append('\n');
        $this$dump_u24lambda_u240.append("whom: " + this.whom).append('\n');
        $this$dump_u24lambda_u240.append("isAlive: " + RLifetimeKt.isAlive((Lifetime)this.lifetime)).append('\n');
        $this$dump_u24lambda_u240.append("EditorToEditorSynchronizers:").append('\n');
        for (Map.Entry synchronizedEditor : ((Map)this.synchronizedEditors).entrySet()) {
            $this$dump_u24lambda_u240.append(((EditorToEditorSynchronizer)synchronizedEditor.getValue()).dump()).append('\n');
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final EditorImpl _init_$lambda$0(EditorFollowMeSynchronizer this$0) {
        Editor editor = FileEditorManager.getInstance((Project)this$0.project).getSelectedTextEditor();
        return editor instanceof EditorImpl ? (EditorImpl)editor : null;
    }

    /*
     * Unable to fully structure code
     */
    private static final EditorImpl syncFollower$lambda$0(EditorImpl $leadEditor, EditorFollowMeSynchronizer this$0) {
        v0 = FileDocumentManager.getInstance().getFile((Document)$leadEditor.getDocument());
        if (v0 == null) {
            return null;
        }
        leadFile = v0;
        if (this$0.shouldIgnore(leadFile, $leadEditor)) {
            return null;
        }
        v1 = FileEditorManager.getInstance((Project)this$0.project).openFile(leadFile, true);
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"openFile(...)");
        openFile = v1;
        v2 = (FileEditor)ArraysKt.firstOrNull((Object[])openFile);
        if (v2 == null) ** GOTO lbl-1000
        $this$asSafely$iv = v2;
        $i$f$asSafely = false;
        v3 = $this$asSafely$iv;
        if (!(v3 instanceof TextEditor)) {
            v3 = null;
        }
        if ((v2 = (TextEditor)v3) != null) {
            v4 = v2.getEditor();
        } else lbl-1000:
        // 2 sources

        {
            v4 = null;
        }
        var4_6 = v4;
        return var4_6 instanceof EditorImpl != false ? (EditorImpl)var4_6 : null;
    }

    private static final Unit syncFollower$lambda$1(EditorFollowMeSynchronizer this$0, EditorImpl $leadEditor) {
        this$0.synchronizedEditors.remove($leadEditor);
        return Unit.INSTANCE;
    }

    private static final VirtualFile followerBreaksFollowing$lambda$0(EditorFollowMeSynchronizer this$0) {
        VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)this$0.project).getSelectedFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSelectedFiles(...)");
        return (VirtualFile)ArraysKt.firstOrNull((Object[])virtualFileArray);
    }

    private static final FileEditor followerBreaksFollowing$lambda$1(EditorFollowMeSynchronizer this$0) {
        return FileEditorManager.getInstance((Project)this$0.project).getSelectedEditor();
    }

    public static final /* synthetic */ boolean access$followerBreaksFollowing(EditorFollowMeSynchronizer $this, FileEditor fileEditor) {
        return $this.followerBreaksFollowing(fileEditor);
    }

    public static final /* synthetic */ ClientId access$getWhom$p(EditorFollowMeSynchronizer $this) {
        return $this.whom;
    }

    public static final /* synthetic */ void access$syncFollower(EditorFollowMeSynchronizer $this, EditorImpl leadEditor) {
        $this.syncFollower(leadEditor);
    }
}

