/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.permissions;

import com.intellij.codeWithMe.ClientId;
import com.intellij.cwm.plugin.CodeWithMeBackendBundle;
import com.intellij.cwm.plugin.common.permissions.AccessLevel;
import com.intellij.cwm.plugin.common.permissions.AccessLevelImpl;
import com.intellij.cwm.plugin.common.permissions.UtilKt;
import com.intellij.cwm.plugin.join.BackendJoinLinkManager;
import com.intellij.cwm.plugin.join.JoinLinkData;
import com.intellij.cwm.plugin.permissions.CwmPermissionInteractionManager;
import com.intellij.cwm.plugin.permissions.CwmSharedPermissionManager;
import com.intellij.cwm.plugin.permissions.CwmSharedPermissionManagerKt;
import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.platform.ide.core.permissions.Permission;
import com.intellij.util.concurrency.EdtExecutorService;
import com.jetbrains.codeWithMe.model.NotPermittedNotification;
import com.jetbrains.codeWithMe.model.PermissionsLevelModel;
import com.jetbrains.codeWithMe.model.UserPermissionModel;
import com.jetbrains.codeWithMe.model.UserPermissionModel_GeneratedKt;
import com.jetbrains.ide.model.uiautomation.BeEmptyText;
import com.jetbrains.ide.model.uiautomation.BeUserAction;
import com.jetbrains.rd.actions.AccessLevelMarker;
import com.jetbrains.rd.actions.AccessRequirements;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.framework.IRdEndpoint;
import com.jetbrains.rd.ide.model.RichStringModel;
import com.jetbrains.rd.ide.model.RichTextModel;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.platform.codeWithMe.permissions.FileAccessLevel;
import com.jetbrains.rd.platform.codeWithMe.permissions.PermissionsDataKt;
import com.jetbrains.rd.platform.codeWithMe.permissions.PermissionsRequestLevel;
import com.jetbrains.rd.platform.codeWithMe.statistics.CodeWithMeLifecycleUsagesCollector;
import com.jetbrains.rd.platform.codeWithMe.statistics.PermissionStatisticsData;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.RootExtListener;
import com.jetbrains.rd.ui.bedsl.extensions.LocalChangeKt;
import com.jetbrains.rd.ui.bedsl.extensions.UpdateFlag;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rdserver.core.RemoteSessionKt;
import com.jetbrains.rdserver.permissions.ClientPermissionListener;
import com.jetbrains.rdserver.permissions.PermissionInteractionManager;
import com.jetbrains.rdserver.permissions.PermissionModel;
import com.jetbrains.rdserver.ui.notification.BackendNotificationsHostKt;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 '2\u00020\u00012\u00020\u0002:\u0003'()B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J%\u0010\r\u001a\u00020\u000e2\r\u0010\u000f\u001a\t\u0018\u00010\u0010\u00a2\u0006\u0002\b\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\u001f\u0010\r\u001a\u00020\u000e2\r\u0010\u000f\u001a\t\u0018\u00010\u0010\u00a2\u0006\u0002\b\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0016\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0016\u0010!\u001a\u00020\u000e2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000e0#H\u0002J\u0016\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020 R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/cwm/plugin/permissions/CwmPermissionInteractionManager;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "Lcom/jetbrains/rdserver/permissions/PermissionInteractionManager;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "<init>", "(Lcom/intellij/openapi/client/ClientProjectSession;)V", "getSession", "()Lcom/intellij/openapi/client/ClientProjectSession;", "requestLifetime", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "suppressNotifications", "Lcom/jetbrains/rd/ui/bedsl/extensions/UpdateFlag;", "notifyNotPermitted", "", "text", "", "Lorg/jetbrains/annotations/Nls;", "permissions", "", "Lcom/intellij/platform/ide/core/permissions/Permission;", "requiredAccessLevel", "Lcom/jetbrains/rd/actions/AccessRequirements;", "getDisabledToolwindowAccessPlaceholder", "Lcom/jetbrains/ide/model/uiautomation/BeEmptyText;", "reportPermissionsRequestFinished", "requestedLevel", "Lcom/jetbrains/rd/platform/codeWithMe/permissions/PermissionsRequestLevel;", "result", "Lcom/jetbrains/rd/platform/codeWithMe/statistics/PermissionStatisticsData$PermissionsRequestResult;", "showPermissionChangeRequest", "requestedPermissions", "Lcom/jetbrains/rdserver/permissions/PermissionModel;", "withSuppressedNotifications", "block", "Lkotlin/Function0;", "notifyPermissionsChanged", "old", "new", "Companion", "ProtocolListener", "MyPermissionListener", "intellij.cwm.plugin"})
@SourceDebugExtension(value={"SMAP\nCwmPermissionInteractionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CwmPermissionInteractionManager.kt\ncom/intellij/cwm/plugin/permissions/CwmPermissionInteractionManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,236:1\n13#2:237\n*S KotlinDebug\n*F\n+ 1 CwmPermissionInteractionManager.kt\ncom/intellij/cwm/plugin/permissions/CwmPermissionInteractionManager\n*L\n50#1:237\n*E\n"})
public final class CwmPermissionInteractionManager
extends LifetimedService
implements PermissionInteractionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientProjectSession session;
    @NotNull
    private final SequentialLifetimes requestLifetime;
    @NotNull
    private final UpdateFlag suppressNotifications;
    @NotNull
    private static final Logger LOG;

    public CwmPermissionInteractionManager(@NotNull ClientProjectSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.requestLifetime = new SequentialLifetimes(this.getServiceLifetime());
        this.suppressNotifications = new UpdateFlag();
    }

    @NotNull
    public final ClientProjectSession getSession() {
        return this.session;
    }

    public void notifyNotPermitted(@Nullable String text, @NotNull List<? extends Permission> permissions) {
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        LOG.warn(text + " requires " + permissions + " so it won't be executed");
        AccessLevel accessLevel = UtilKt.getAccessLevel(permissions);
        AccessLevelImpl accessLevelImpl = accessLevel instanceof AccessLevelImpl ? (AccessLevelImpl)accessLevel : null;
        if (accessLevelImpl == null) {
            return;
        }
        AccessLevelImpl level = accessLevelImpl;
        UserPermissionModel_GeneratedKt.getUserPermissionModel((IProtocol)((IProtocol)RemoteSessionKt.getProtocol((ClientAppSession)this.session.getAppSession()))).getNotifyNotPermitted().fire((Object)new NotPermittedNotification(ProjectUtilKt.getRdProjectId((Project)this.session.getProject()), text, PermissionsDataKt.toModel((PermissionsRequestLevel)level.getLevel())));
    }

    public void notifyNotPermitted(@Nullable String text, @NotNull AccessRequirements requiredAccessLevel) {
        Intrinsics.checkNotNullParameter((Object)requiredAccessLevel, (String)"requiredAccessLevel");
        LOG.warn(text + " requires " + requiredAccessLevel + " so it won't be executed");
        if (Intrinsics.areEqual((Object)requiredAccessLevel, (Object)AccessRequirements.Owner.INSTANCE)) {
            return;
        }
        AccessLevelMarker[] accessLevelMarkerArray = new AccessLevelMarker[]{FileAccessLevel.FullAccess};
        PermissionsLevelModel level = Intrinsics.areEqual((Object)requiredAccessLevel, (Object)AccessRequirements.Companion.of(accessLevelMarkerArray)) ? PermissionsLevelModel.EDIT_FILES : PermissionsLevelModel.FULL_ACCESS;
        UserPermissionModel_GeneratedKt.getUserPermissionModel((IProtocol)((IProtocol)RemoteSessionKt.getProtocol((ClientAppSession)this.session.getAppSession()))).getNotifyNotPermitted().fire((Object)new NotPermittedNotification(ProjectUtilKt.getRdProjectId((Project)this.session.getProject()), text, level));
    }

    @NotNull
    public BeEmptyText getDisabledToolwindowAccessPlaceholder() {
        BeUserAction action = new BeUserAction();
        action.getClick().advise(this.getServiceLifetime(), arg_0 -> CwmPermissionInteractionManager.getDisabledToolwindowAccessPlaceholder$lambda$0(this, arg_0));
        return new BeEmptyText(new RichTextModel(CollectionsKt.listOf((Object)new RichStringModel(CodeWithMeBackendBundle.INSTANCE.message("toolwindow.message.access.denied.label", new Object[0]), null, null, null, null, null, 62, null))), new RichTextModel(CollectionsKt.listOf((Object)new RichStringModel(CodeWithMeBackendBundle.INSTANCE.message("action.ask.full.access.title", new Object[0]), null, null, null, null, null, 62, null))), null, CollectionsKt.listOf((Object)action));
    }

    public final void reportPermissionsRequestFinished(@NotNull PermissionsRequestLevel requestedLevel, @NotNull PermissionStatisticsData.PermissionsRequestResult result) {
        String sessionId;
        Intrinsics.checkNotNullParameter((Object)requestedLevel, (String)"requestedLevel");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        JoinLinkData joinLinkData = BackendJoinLinkManager.Companion.getInstance(this.session.getProject()).getJoinLinkData();
        String string = sessionId = joinLinkData != null ? joinLinkData.getSessionId() : null;
        if (sessionId == null) {
            LOG.warn("sessionId is null on reportPermissionsRequestFinished");
        } else {
            CodeWithMeLifecycleUsagesCollector.CodeWithMeLifecycleLogger.INSTANCE.onPermissionsRequestFinished(sessionId, this.session.getClientId(), requestedLevel, result);
        }
    }

    public void showPermissionChangeRequest(@NotNull PermissionModel requestedPermissions) {
        String string;
        PermissionsRequestLevel permissionsRequestLevel;
        Intrinsics.checkNotNullParameter((Object)requestedPermissions, (String)"requestedPermissions");
        LifetimeDefinition lifetime = this.requestLifetime.next();
        Ref.ObjectRef clientNotificationTitle = new Ref.ObjectRef();
        Ref.ObjectRef hostNotificationTitle = new Ref.ObjectRef();
        Ref.ObjectRef hostNotificationContent = new Ref.ObjectRef();
        Ref.ObjectRef hostApproveActionTitle = new Ref.ObjectRef();
        PermissionModel permissionModel = requestedPermissions;
        if (Intrinsics.areEqual((Object)permissionModel, (Object)PermissionModel.Companion.getEDIT_FILES())) {
            clientNotificationTitle.element = CodeWithMeBackendBundle.INSTANCE.message("ask.edit.files.notification.title", new Object[0]);
            var9_8 = new Object[]{this.session.getName()};
            hostNotificationTitle.element = CodeWithMeBackendBundle.INSTANCE.message("grant.edit.files.notification.title", var9_8);
            hostNotificationContent.element = CodeWithMeBackendBundle.INSTANCE.message("grant.edit.files.notification.content", new Object[0]);
            hostApproveActionTitle.element = CodeWithMeBackendBundle.INSTANCE.message("action.edit.files.allow.title", new Object[0]);
            permissionsRequestLevel = PermissionsRequestLevel.EDIT_FILES;
        } else if (Intrinsics.areEqual((Object)permissionModel, (Object)PermissionModel.Companion.getFULL_ACCESS())) {
            clientNotificationTitle.element = CodeWithMeBackendBundle.INSTANCE.message("ask.full.access.notification.title", new Object[0]);
            var9_8 = new Object[]{this.session.getName()};
            hostNotificationTitle.element = CodeWithMeBackendBundle.INSTANCE.message("grant.full.access.notification.title", var9_8);
            hostNotificationContent.element = CodeWithMeBackendBundle.INSTANCE.message("grant.full.access.notification.content", new Object[0]);
            hostApproveActionTitle.element = CodeWithMeBackendBundle.INSTANCE.message("action.full.access.allow.title", new Object[0]);
            permissionsRequestLevel = PermissionsRequestLevel.FULL_ACCESS;
        } else {
            LOG.warn("Can't request " + requestedPermissions + " permissions");
            return;
        }
        PermissionsRequestLevel level = permissionsRequestLevel;
        if (clientNotificationTitle.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clientNotificationTitle");
            string = null;
        } else {
            string = (String)clientNotificationTitle.element;
        }
        Notification clientNotification = new Notification("RDCT PermissionManager", string, CodeWithMeBackendBundle.INSTANCE.message("ask.notification.content", new Object[0]), NotificationType.INFORMATION);
        clientNotification.setIcon(AllIcons.CodeWithMe.CwmPermissions);
        BackendNotificationsHostKt.notifyClient((Notification)clientNotification, (ClientProjectSession)this.session);
        ClientId.Companion.withExplicitClientId(ClientId.Companion.getLocalId(), () -> CwmPermissionInteractionManager.showPermissionChangeRequest$lambda$0(hostNotificationTitle, hostNotificationContent, hostApproveActionTitle, lifetime, this, clientNotificationTitle, level, requestedPermissions, clientNotification));
    }

    private final void withSuppressedNotifications(Function0<Unit> block) {
        LocalChangeKt.execute((UpdateFlag)this.suppressNotifications, block);
    }

    public final void notifyPermissionsChanged(@NotNull PermissionModel old, @NotNull PermissionModel permissionModel) {
        String sessionId;
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        Intrinsics.checkNotNullParameter((Object)permissionModel, (String)"new");
        if (old.equal(permissionModel)) {
            return;
        }
        JoinLinkData joinLinkData = BackendJoinLinkManager.Companion.getInstance(this.session.getProject()).getJoinLinkData();
        String string = sessionId = joinLinkData != null ? joinLinkData.getSessionId() : null;
        if (sessionId == null) {
            LOG.warn("sesessionId is null during notifyPermissionsChanged");
        } else {
            CodeWithMeLifecycleUsagesCollector.CodeWithMeLifecycleLogger.INSTANCE.onPermissionsChanged(sessionId, this.session.getClientId(), CwmSharedPermissionManagerKt.toStatisticsData(old), CwmSharedPermissionManagerKt.toStatisticsData(permissionModel));
        }
        if (!this.suppressNotifications.getHappening()) {
            int mode = permissionModel.equal(PermissionModel.Companion.getREADONLY()) ? 0 : (permissionModel.equal(PermissionModel.Companion.getEDIT_FILES()) ? 1 : (permissionModel.equal(PermissionModel.Companion.getFULL_ACCESS()) ? 2 : 3));
            Object[] objectArray = new Object[]{mode};
            String string2 = CodeWithMeBackendBundle.INSTANCE.message("notification.permission.changed.title", objectArray);
            objectArray = new Object[]{mode};
            Notification clientNotification = new Notification("RDCT PermissionManager", string2, CodeWithMeBackendBundle.INSTANCE.message("notification.permission.changed.content", objectArray), NotificationType.INFORMATION);
            clientNotification.setIcon(AllIcons.CodeWithMe.CwmPermissions);
            BackendNotificationsHostKt.notifyClient((Notification)clientNotification, (ClientProjectSession)this.session);
        }
    }

    private static final Unit getDisabledToolwindowAccessPlaceholder$lambda$0(CwmPermissionInteractionManager this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.showPermissionChangeRequest(PermissionModel.Companion.getFULL_ACCESS());
        return Unit.INSTANCE;
    }

    private static final boolean showPermissionChangeRequest$lambda$0$0(Ref.ObjectRef $clientNotificationTitle, CwmPermissionInteractionManager this$0, LifetimeDefinition $lifetime) {
        String string;
        if ($clientNotificationTitle.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clientNotificationTitle");
            string = null;
        } else {
            string = (String)$clientNotificationTitle.element;
        }
        Notification declinedNotification = new Notification("RDCT PermissionManager", string, CodeWithMeBackendBundle.INSTANCE.message("ask.notification.declined.content", new Object[0]), NotificationType.INFORMATION);
        declinedNotification.setIcon(AllIcons.CodeWithMe.CwmPermissionsDenied);
        BackendNotificationsHostKt.notifyClient((Notification)declinedNotification, (ClientProjectSession)this$0.session);
        return LifetimeDefinition.terminate$default((LifetimeDefinition)$lifetime, (boolean)false, (int)1, null);
    }

    private static final void showPermissionChangeRequest$lambda$0$1(Notification $notification, Function0 $declineAction, CwmPermissionInteractionManager this$0, PermissionsRequestLevel $level) {
        if (!$notification.isExpired()) {
            $declineAction.invoke();
            this$0.reportPermissionsRequestFinished($level, PermissionStatisticsData.PermissionsRequestResult.Ignored);
        }
    }

    private static final Unit showPermissionChangeRequest$lambda$0$2(Notification $notification, Notification $clientNotification, ScheduledFuture $expireOnTimeout) {
        $notification.expire();
        $clientNotification.expire();
        $expireOnTimeout.cancel(false);
        return Unit.INSTANCE;
    }

    private static final Unit showPermissionChangeRequest$lambda$0(Ref.ObjectRef $hostNotificationTitle, Ref.ObjectRef $hostNotificationContent, Ref.ObjectRef $hostApproveActionTitle, LifetimeDefinition $lifetime, CwmPermissionInteractionManager this$0, Ref.ObjectRef $clientNotificationTitle, PermissionsRequestLevel $level, PermissionModel $requestedPermissions, Notification $clientNotification) {
        String string;
        String string2;
        String string3;
        if ($hostNotificationTitle.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hostNotificationTitle");
            string3 = null;
        } else {
            string3 = (String)$hostNotificationTitle.element;
        }
        if ($hostNotificationContent.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hostNotificationContent");
            string2 = null;
        } else {
            string2 = (String)$hostNotificationContent.element;
        }
        Notification notification = new Notification("RDCT PermissionManager", string3, string2, NotificationType.INFORMATION);
        notification.setIcon(AllIcons.CodeWithMe.CwmAccess);
        if ($hostApproveActionTitle.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hostApproveActionTitle");
            string = null;
        } else {
            string = (String)$hostApproveActionTitle.element;
        }
        String string4 = string;
        notification.addAction(new AnAction(this$0, (Ref.ObjectRef<String>)$clientNotificationTitle, $lifetime, $level, $requestedPermissions, string4){
            final /* synthetic */ CwmPermissionInteractionManager this$0;
            final /* synthetic */ Ref.ObjectRef<String> $clientNotificationTitle;
            final /* synthetic */ LifetimeDefinition $lifetime;
            final /* synthetic */ PermissionsRequestLevel $level;
            final /* synthetic */ PermissionModel $requestedPermissions;
            {
                this.this$0 = $receiver;
                this.$clientNotificationTitle = $clientNotificationTitle;
                this.$lifetime = $lifetime;
                this.$level = $level;
                this.$requestedPermissions = $requestedPermissions;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                String string;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                CwmPermissionInteractionManager.access$withSuppressedNotifications(this.this$0, () -> showPermissionChangeRequest.1.1.actionPerformed$lambda$0(this.this$0, this.$requestedPermissions));
                if (this.$clientNotificationTitle.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"clientNotificationTitle");
                    string = null;
                } else {
                    string = (String)this.$clientNotificationTitle.element;
                }
                Notification approvedNotification = new Notification("RDCT PermissionManager", string, CodeWithMeBackendBundle.INSTANCE.message("ask.notification.approved.content", new Object[0]), NotificationType.INFORMATION);
                approvedNotification.setIcon(AllIcons.CodeWithMe.CwmPermissionsGranted);
                BackendNotificationsHostKt.notifyClient((Notification)approvedNotification, (ClientProjectSession)this.this$0.getSession());
                LifetimeDefinition.terminate$default((LifetimeDefinition)this.$lifetime, (boolean)false, (int)1, null);
                this.this$0.reportPermissionsRequestFinished(this.$level, PermissionStatisticsData.PermissionsRequestResult.Approved);
            }

            private static final Unit actionPerformed$lambda$0(CwmPermissionInteractionManager this$0, PermissionModel $requestedPermissions) {
                CwmSharedPermissionManager.Companion.getInstance(this$0.getSession().getProject()).applyClientPermissionModel(this$0.getSession(), $requestedPermissions);
                return Unit.INSTANCE;
            }
        });
        Function0 declineAction = () -> CwmPermissionInteractionManager.showPermissionChangeRequest$lambda$0$0($clientNotificationTitle, this$0, $lifetime);
        String string5 = CodeWithMeBackendBundle.INSTANCE.message("action.decline.title", new Object[0]);
        notification.addAction(new AnAction((Function0<Boolean>)declineAction, this$0, $level, string5){
            final /* synthetic */ Function0<Boolean> $declineAction;
            final /* synthetic */ CwmPermissionInteractionManager this$0;
            final /* synthetic */ PermissionsRequestLevel $level;
            {
                this.$declineAction = $declineAction;
                this.this$0 = $receiver;
                this.$level = $level;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$declineAction.invoke();
                this.this$0.reportPermissionsRequestFinished(this.$level, PermissionStatisticsData.PermissionsRequestResult.Declined);
            }
        });
        ScheduledExecutorService scheduledExecutorService = EdtExecutorService.getScheduledExecutorInstance();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"getScheduledExecutorInstance(...)");
        ScheduledExecutorService executorService = scheduledExecutorService;
        ScheduledFuture<?> expireOnTimeout = executorService.schedule(() -> CwmPermissionInteractionManager.showPermissionChangeRequest$lambda$0$1(notification, declineAction, this$0, $level), 3L, TimeUnit.MINUTES);
        $lifetime.onTermination(() -> CwmPermissionInteractionManager.showPermissionChangeRequest$lambda$0$2(notification, $clientNotification, expireOnTimeout));
        notification.notify(this$0.session.getProject());
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$withSuppressedNotifications(CwmPermissionInteractionManager $this, Function0 block) {
        $this.withSuppressedNotifications((Function0<Unit>)block);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CwmPermissionInteractionManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/cwm/plugin/permissions/CwmPermissionInteractionManager$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.cwm.plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/cwm/plugin/permissions/CwmPermissionInteractionManager$MyPermissionListener;", "Lcom/jetbrains/rdserver/permissions/ClientPermissionListener;", "<init>", "()V", "permissionsChanged", "", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "old", "Lcom/jetbrains/rdserver/permissions/PermissionModel;", "new", "intellij.cwm.plugin"})
    public static final class MyPermissionListener
    implements ClientPermissionListener {
        public void permissionsChanged(@NotNull ClientAppSession session, @NotNull PermissionModel old, @NotNull PermissionModel permissionModel) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)old, (String)"old");
            Intrinsics.checkNotNullParameter((Object)permissionModel, (String)"new");
            for (ClientProjectSession projectSession : session.getProjectSessions()) {
                PermissionInteractionManager permissionInteractionManager = PermissionInteractionManager.Companion.getInstance(projectSession);
                CwmPermissionInteractionManager cwmPermissionInteractionManager = permissionInteractionManager instanceof CwmPermissionInteractionManager ? (CwmPermissionInteractionManager)permissionInteractionManager : null;
                if (cwmPermissionInteractionManager == null) continue;
                cwmPermissionInteractionManager.notifyPermissionsChanged(old, permissionModel);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/cwm/plugin/permissions/CwmPermissionInteractionManager$ProtocolListener;", "Lcom/jetbrains/rd/protocol/RootExtListener;", "Lcom/jetbrains/codeWithMe/model/UserPermissionModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "model", "intellij.cwm.plugin"})
    public static final class ProtocolListener
    implements RootExtListener<UserPermissionModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientAppSession session, @NotNull UserPermissionModel model2) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            IRdEndpoint.DefaultImpls.set$default((IRdEndpoint)((IRdEndpoint)model2.getRequestPermissionsChange()), null, null, arg_0 -> ProtocolListener.extensionCreated$lambda$0(session, arg_0), (int)3, null);
        }

        private static final Unit extensionCreated$lambda$0(ClientAppSession $session, PermissionsLevelModel permissionsLevelModel) {
            Intrinsics.checkNotNullParameter((Object)permissionsLevelModel, (String)"permissionsLevelModel");
            PermissionModel level = switch (WhenMappings.$EnumSwitchMapping$0[permissionsLevelModel.ordinal()]) {
                case 1 -> PermissionModel.Companion.getFULL_ACCESS();
                case 2 -> PermissionModel.Companion.getEDIT_FILES();
                default -> throw new NoWhenBranchMatchedException();
            };
            PermissionInteractionManager.Companion.showPermissionChangeRequest((ClientSession)$session, level);
            return Unit.INSTANCE;
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[PermissionsLevelModel.values().length];
                try {
                    nArray[PermissionsLevelModel.FULL_ACCESS.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PermissionsLevelModel.EDIT_FILES.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

