/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.api;

import com.intellij.openapi.project.Project;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.api.AttachFailedException;
import com.intellij.profiler.api.AttachableTargetProcess;
import com.intellij.profiler.api.ProfilerAlreadyStartedException;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.profiler.api.ProfilerState;
import com.intellij.profiler.api.ProfilerTargetProcess;
import com.intellij.profiler.api.RunningNowRemover;
import com.intellij.profiler.api.XLocalAttachProfiler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u0006\u0010\u0006\u001a\u00020\u0001\u001a\"\u0010\n\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\r0\f0\u000b*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a%\u0010\u0011\u001a\u00020\u0012\"\u0010\b\u0000\u0010\u0013*\n\u0012\u0006\b\u0001\u0012\u00020\u00030\f2\u0006\u0010\u0014\u001a\u0002H\u0013\u00a2\u0006\u0002\u0010\u0015\u001a4\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00130\u000b\"\u0010\b\u0000\u0010\u0013*\n\u0012\u0006\b\u0001\u0012\u00020\u00030\f2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00130\u000b\u001a\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\t\"\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"attachFailedCantGrubPid", "Lcom/intellij/profiler/api/AttachFailedException;", "target", "Lcom/intellij/profiler/api/AttachableTargetProcess;", "attachFailedTimeout", "unsupportedOS", "cannotInstrumentTranslatedProcess", "runningNow", "Ljava/util/concurrent/ConcurrentHashMap;", "", "attachIfNotAlreadyAttached", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/profiler/api/ProfilerProcess;", "Lcom/intellij/profiler/api/ProfilerTargetProcess;", "Lcom/intellij/profiler/api/XLocalAttachProfiler;", "project", "Lcom/intellij/openapi/project/Project;", "registerRunningProfilerProcess", "", "P", "profilerProcess", "(Lcom/intellij/profiler/api/ProfilerProcess;)V", "attachingPromise", "isProfilerAttached", "", "pid", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nAttachProfilerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttachProfilerUtils.kt\ncom/intellij/profiler/api/AttachProfilerUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n1#2:55\n*E\n"})
public final class AttachProfilerUtilsKt {
    @NotNull
    private static final ConcurrentHashMap<Integer, AttachableTargetProcess> runningNow = new ConcurrentHashMap();

    @NotNull
    public static final AttachFailedException attachFailedCantGrubPid(@NotNull AttachableTargetProcess target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Object[] objectArray = new Object[]{target.getPid()};
        return new AttachFailedException(CommonProfilerBundleKt.profilerMessage("profiler.cant.grub.pid", objectArray));
    }

    @NotNull
    public static final AttachFailedException attachFailedTimeout(@NotNull AttachableTargetProcess target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Object[] objectArray = new Object[]{target.getPid()};
        return new AttachFailedException(CommonProfilerBundleKt.profilerMessage("profiler.attach.timeout", objectArray));
    }

    @NotNull
    public static final AttachFailedException unsupportedOS() {
        return new AttachFailedException(CommonProfilerBundleKt.profilerMessage("profiler.exceptions.unsupported.os", new Object[0]));
    }

    @NotNull
    public static final AttachFailedException cannotInstrumentTranslatedProcess() {
        return new AttachFailedException(CommonProfilerBundleKt.profilerMessage("profiler.cannot.instrument.translated.processes", new Object[0]));
    }

    @NotNull
    public static final Promise<? extends ProfilerProcess<? extends ProfilerTargetProcess>> attachIfNotAlreadyAttached(@NotNull XLocalAttachProfiler $this$attachIfNotAlreadyAttached, @NotNull Project project) {
        Promise<? extends ProfilerProcess<? extends AttachableTargetProcess>> promise;
        Intrinsics.checkNotNullParameter((Object)$this$attachIfNotAlreadyAttached, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        AttachableTargetProcess attachableTargetProcess = runningNow.get($this$attachIfNotAlreadyAttached.getTargetProcess().getPid());
        if (attachableTargetProcess != null) {
            AttachableTargetProcess it = attachableTargetProcess;
            boolean bl = false;
            return Promises.rejectedPromise((Throwable)new ProfilerAlreadyStartedException(it));
        }
        Promise<? extends ProfilerProcess<? extends AttachableTargetProcess>> it = promise = $this$attachIfNotAlreadyAttached.attachProfiler(project);
        boolean bl = false;
        AttachProfilerUtilsKt.registerRunningProfilerProcess($this$attachIfNotAlreadyAttached.getTargetProcess(), it);
        return promise;
    }

    public static final <P extends ProfilerProcess<? extends AttachableTargetProcess>> void registerRunningProfilerProcess(@NotNull P profilerProcess) {
        Intrinsics.checkNotNullParameter(profilerProcess, (String)"profilerProcess");
        ((Map)runningNow).put(profilerProcess.getTargetProcess().getPid(), profilerProcess.getTargetProcess());
        profilerProcess.addStateChangedListener((Function2<ProfilerState, ProfilerState, Unit>)((Function2)new RunningNowRemover<P>(profilerProcess)));
    }

    @NotNull
    public static final <P extends ProfilerProcess<? extends AttachableTargetProcess>> Promise<P> registerRunningProfilerProcess(@NotNull AttachableTargetProcess target, @NotNull Promise<P> attachingPromise) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(attachingPromise, (String)"attachingPromise");
        ((Map)runningNow).put(target.getPid(), target);
        Promise promise = attachingPromise.onError(arg_0 -> AttachProfilerUtilsKt.registerRunningProfilerProcess$lambda$1(arg_0 -> AttachProfilerUtilsKt.registerRunningProfilerProcess$lambda$0(target, arg_0), arg_0)).onSuccess(arg_0 -> AttachProfilerUtilsKt.registerRunningProfilerProcess$lambda$3(AttachProfilerUtilsKt::registerRunningProfilerProcess$lambda$2, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"onSuccess(...)");
        return promise;
    }

    public static final boolean isProfilerAttached(int pid) {
        return runningNow.containsKey(pid);
    }

    private static final Unit registerRunningProfilerProcess$lambda$0(AttachableTargetProcess $target, Throwable it) {
        runningNow.remove($target.getPid());
        return Unit.INSTANCE;
    }

    private static final void registerRunningProfilerProcess$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit registerRunningProfilerProcess$lambda$2(ProfilerProcess process) {
        Intrinsics.checkNotNull((Object)process);
        process.addStateChangedListener((Function2<ProfilerState, ProfilerState, Unit>)((Function2)new RunningNowRemover<ProfilerProcess>(process)));
        return Unit.INSTANCE;
    }

    private static final void registerRunningProfilerProcess$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getRunningNow$p() {
        return runningNow;
    }
}

