/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.IdeUtilIoBundle;
import com.intellij.util.system.OS;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public final class TrashBin {
    private static final NullableLazyValue<Trash> TRASH = NullableLazyValue.volatileLazyNullable(() -> {
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.MOVE_TO_TRASH)) {
            return new DesktopTrashImpl();
        }
        if (OS.isGenericUnix()) {
            String dataDir = Objects.requireNonNullElseGet(System.getenv("XDG_DATA_HOME"), () -> SystemProperties.getUserHome() + "/.local/share");
            Path filesDir = Path.of(dataDir, "Trash/files");
            Path infoDir = Path.of(dataDir, "Trash/info");
            if (Files.isDirectory(filesDir, new LinkOption[0]) && Files.isDirectory(infoDir, new LinkOption[0])) {
                return new XdgTrashImpl(filesDir, infoDir);
            }
        }
        return null;
    });

    private TrashBin() {
    }

    public static boolean isSupported() {
        return TRASH.getValue() != null;
    }

    public static boolean canMoveToTrash(@NotNull Path path) {
        if (path == null) {
            TrashBin.$$$reportNull$$$0(0);
        }
        try {
            return Objects.equals(Files.getFileStore(path), Files.getFileStore(Path.of(SystemProperties.getUserHome(), new String[0])));
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean canMoveToTrash(@NotNull VirtualFile file) {
        if (file == null) {
            TrashBin.$$$reportNull$$$0(1);
        }
        return file.isInLocalFileSystem() && TrashBin.canMoveToTrash(file.toNioPath());
    }

    public static void moveToTrash(@NotNull Path path) throws IOException {
        if (path == null) {
            TrashBin.$$$reportNull$$$0(2);
        }
        Objects.requireNonNull((Trash)TRASH.getValue()).moveToTrash(path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/TrashBin";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canMoveToTrash";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "moveToTrash";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static sealed interface Trash
    permits DesktopTrashImpl, XdgTrashImpl {
        public void moveToTrash(@NotNull Path var1) throws IOException;
    }

    private static final class DesktopTrashImpl
    implements Trash {
        private DesktopTrashImpl() {
        }

        @Override
        public void moveToTrash(@NotNull Path path) throws IOException {
            if (path == null) {
                DesktopTrashImpl.$$$reportNull$$$0(0);
            }
            File ioFile = path.toFile();
            boolean trashed = false;
            try {
                trashed = Desktop.getDesktop().moveToTrash(ioFile);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (!trashed && Files.exists(path, new LinkOption[0])) {
                throw new FileSystemException(path.toString(), null, IdeUtilIoBundle.message("error.message.cannot.trash", new Object[0]));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/io/TrashBin$DesktopTrashImpl", "moveToTrash"));
        }
    }

    private static final class XdgTrashImpl
    implements Trash {
        private static final String DOT_TRASH_INFO = ".trashinfo";
        private final Path filesDir;
        private final Path infoDir;

        private XdgTrashImpl(Path filesDir, Path infoDir) {
            this.filesDir = filesDir;
            this.infoDir = infoDir;
        }

        @Override
        public void moveToTrash(@NotNull Path path) throws IOException {
            if (path == null) {
                XdgTrashImpl.$$$reportNull$$$0(0);
            }
            if (!Files.exists(path = path.toAbsolutePath(), new LinkOption[0])) {
                return;
            }
            String originalName = path.getFileName().toString();
            Path trashFile = this.filesDir.resolve(originalName);
            Path trashInfo = this.infoDir.resolve(originalName + DOT_TRASH_INFO);
            int counter = 2;
            while (Files.exists(trashFile, new LinkOption[0]) || Files.exists(trashInfo, new LinkOption[0])) {
                trashFile = this.filesDir.resolve(originalName + "." + counter);
                trashInfo = this.infoDir.resolve(originalName + "." + counter + DOT_TRASH_INFO);
                ++counter;
            }
            String ts = LocalDateTime.now().truncatedTo(ChronoUnit.SECONDS).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            String infoContent = "[Trash Info]\nPath=" + String.valueOf(path) + "\nDeletionDate=" + ts + "\n";
            try {
                Files.writeString(trashInfo, (CharSequence)infoContent, StandardOpenOption.CREATE_NEW);
                try {
                    Files.move(path, trashFile, StandardCopyOption.ATOMIC_MOVE);
                }
                catch (IOException e) {
                    try {
                        Files.deleteIfExists(trashInfo);
                    }
                    catch (IOException ee) {
                        e.addSuppressed(ee);
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                FileSystemException fse = new FileSystemException(path.toString(), null, IdeUtilIoBundle.message("error.message.cannot.trash", new Object[0]));
                fse.initCause(e);
                throw fse;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/io/TrashBin$XdgTrashImpl", "moveToTrash"));
        }
    }
}

