/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.platform.diagnostic.telemetry.Scope;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.jetbrains.performancePlugin.commands.PerformanceCommandCoroutineAdapter;
import io.opentelemetry.api.trace.Span;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0094@\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u0003H\u0014\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/performancePlugin/commands/HandleSpanCommand;", "Lcom/jetbrains/performancePlugin/commands/PerformanceCommandCoroutineAdapter;", "text", "", "line", "", "<init>", "(Ljava/lang/String;I)V", "doExecute", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "(Lcom/intellij/openapi/ui/playback/PlaybackContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getName", "Companion", "intellij.performanceTesting"})
public final class HandleSpanCommand
extends PerformanceCommandCoroutineAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "handleSpan";
    @NotNull
    public static final String PREFIX = "%handleSpan";
    @NotNull
    private static final Map<String, Span> createdSpans = new LinkedHashMap();

    public HandleSpanCommand(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
    }

    @Override
    @Nullable
    protected Object doExecute(@NotNull PlaybackContext context, @NotNull Continuation<? super Unit> $completion) {
        String spanName = this.extractCommandArgument(PREFIX);
        Span span = createdSpans.get(spanName);
        if (span != null) {
            span.end();
            createdSpans.remove(spanName);
        } else {
            Span newSpan = TelemetryManager.Companion.getTracer(new Scope("HandleSpanCommand", null, false, 6, null)).spanBuilder(spanName).startSpan();
            createdSpans.put(spanName, newSpan);
        }
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    protected String getName() {
        return NAME;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/performancePlugin/commands/HandleSpanCommand$Companion;", "", "<init>", "()V", "NAME", "", "PREFIX", "createdSpans", "", "Lio/opentelemetry/api/trace/Span;", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

