/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.project.ProjectKt;
import com.intellij.spellchecker.BundledDictionaryProvider;
import com.intellij.spellchecker.CustomDictFileListener;
import com.intellij.spellchecker.DictionaryLayer;
import com.intellij.spellchecker.FileLoader;
import com.intellij.spellchecker.ProjectDictFileListener;
import com.intellij.spellchecker.ProjectDictionaryLayer;
import com.intellij.spellchecker.SpellCheckerManagerKt;
import com.intellij.spellchecker.dictionary.CustomDictionaryProvider;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.dictionary.DictionaryChecker;
import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.dictionary.ProjectDictionary;
import com.intellij.spellchecker.dictionary.RuntimeDictionaryProvider;
import com.intellij.spellchecker.dictionary.UserDictionary;
import com.intellij.spellchecker.engine.DictionaryModificationTracker;
import com.intellij.spellchecker.engine.SpellCheckerEngine;
import com.intellij.spellchecker.engine.SuggestionProvider;
import com.intellij.spellchecker.grazie.GrazieSuggestionProvider;
import com.intellij.spellchecker.settings.SpellCheckerSettings;
import com.intellij.spellchecker.state.AppDictionaryState;
import com.intellij.spellchecker.state.DictionaryStateListener;
import com.intellij.spellchecker.state.ProjectDictionaryState;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.util.EventDispatcher;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u001e\n\u0002\b\n\b\u0007\u0018\u0000 S2\u00020\u0001:\u0001SB\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010'\u001a\u00020(J\u0016\u0010)\u001a\u00020(2\u000e\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130+J\u0012\u00102\u001a\u00020(2\b\u0010\"\u001a\u0004\u0018\u00010!H\u0002J\u0010\u00103\u001a\u00020(2\u0006\u0010\"\u001a\u00020!H\u0002J\u000e\u00104\u001a\u00020(2\u0006\u00105\u001a\u00020\u0013J\u0015\u00106\u001a\u0004\u0018\u00010(2\u0006\u00105\u001a\u00020\u0013\u00a2\u0006\u0002\u00107J\u000e\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u0013J\u0010\u0010;\u001a\u0002092\u0006\u0010:\u001a\u00020\u0013H\u0002J\u0016\u0010<\u001a\u00020(2\u0006\u0010:\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003J1\u0010<\u001a\u00020(2\u0006\u0010:\u001a\u00020\u00132\b\u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010?\u001a\u0004\u0018\u00010@H\u0000\u00a2\u0006\u0002\bAJ\u0012\u0010B\u001a\u0004\u0018\u00010\u00132\u0006\u0010:\u001a\u00020\u0013H\u0002J\u0018\u0010C\u001a\u00020(2\u0006\u0010D\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020\u0013H\u0002J\u0018\u0010E\u001a\u00020(2\u0006\u0010D\u001a\u00020\u000f2\u0006\u0010F\u001a\u00020\u0013H\u0002J\u0010\u0010G\u001a\u00020(2\u0006\u0010D\u001a\u00020\u000fH\u0002J\u0014\u0010H\u001a\u00020(2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00130JJ\u0014\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00130+2\u0006\u0010L\u001a\u00020\u0013J\b\u0010M\u001a\u00020(H\u0016J\u000e\u0010N\u001a\u00020(2\u0006\u0010O\u001a\u00020\u0013J\u0018\u0010P\u001a\u00020(2\u0006\u0010Q\u001a\u00020\u001d2\b\u0010R\u001a\u0004\u0018\u00010\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0012\u001a\u00020\u00138GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0018\u001a\u00020\u00138GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0017\u001a\u0004\b\u0019\u0010\u0015R!\u0010\u001b\u001a\u0015\u0012\f\u0012\n \u001e*\u0004\u0018\u00010\u001d0\u001d0\u001c\u00a2\u0006\u0002\b\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\"\u001a\u0004\u0018\u00010!2\b\u0010 \u001a\u0004\u0018\u00010!8\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00130-8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0017\u00100\u001a\b\u0012\u0004\u0012\u00020\u00130-8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010/\u00a8\u0006T"}, d2={"Lcom/intellij/spellchecker/SpellCheckerManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectDictionary", "Lcom/intellij/spellchecker/dictionary/ProjectDictionary;", "getProjectDictionary$intellij_spellchecker", "()Lcom/intellij/spellchecker/dictionary/ProjectDictionary;", "appDictionary", "Lcom/intellij/spellchecker/dictionary/EditableDictionary;", "getAppDictionary$intellij_spellchecker", "()Lcom/intellij/spellchecker/dictionary/EditableDictionary;", "projectDictionaryPath", "", "getProjectDictionaryPath", "()Ljava/lang/String;", "projectDictionaryPath$delegate", "Lkotlin/Lazy;", "appDictionaryPath", "getAppDictionaryPath", "appDictionaryPath$delegate", "userDictionaryListenerEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/spellchecker/state/DictionaryStateListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "value", "Lcom/intellij/spellchecker/engine/SpellCheckerEngine;", "spellChecker", "getSpellChecker", "()Lcom/intellij/spellchecker/engine/SpellCheckerEngine;", "suggestionProvider", "Lcom/intellij/spellchecker/engine/SuggestionProvider;", "fullConfigurationReload", "", "updateBundledDictionaries", "removedDictionaries", "", "userDictionaryWords", "", "getUserDictionaryWords", "()Ljava/util/Set;", "userCamelCaseWords", "getUserCamelCaseWords", "fillEngineDictionary", "initUserDictionaries", "loadDictionary", "path", "removeDictionary", "(Ljava/lang/String;)Lkotlin/Unit;", "hasProblem", "", "word", "isCorrectExtensionWord", "acceptWordAsCorrect", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "dictionaryLayer", "Lcom/intellij/spellchecker/DictionaryLayer;", "acceptWordAsCorrect$intellij_spellchecker", "transform", "addWordToDictionary", "dictionary", "removeWordFromDictionary", "transformed", "fireDictionaryChanged", "updateUserDictionary", "words", "", "getSuggestions", "text", "dispose", "openDictionaryInEditor", "dictPath", "addUserDictionaryChangedListener", "listener", "parentDisposable", "Companion", "intellij.spellchecker"})
@SourceDebugExtension(value={"SMAP\nSpellCheckerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpellCheckerManager.kt\ncom/intellij/spellchecker/SpellCheckerManager\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,496:1\n30#2,2:497\n30#2,2:499\n1807#3,3:501\n1#4:504\n*S KotlinDebug\n*F\n+ 1 SpellCheckerManager.kt\ncom/intellij/spellchecker/SpellCheckerManager\n*L\n56#1:497,2\n206#1:499,2\n233#1:501,3\n*E\n"})
public final class SpellCheckerManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @ApiStatus.Internal
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy projectDictionaryPath$delegate;
    @NotNull
    private final Lazy appDictionaryPath$delegate;
    @NotNull
    private final EventDispatcher<DictionaryStateListener> userDictionaryListenerEventDispatcher;
    @ApiStatus.Internal
    @Nullable
    private SpellCheckerEngine spellChecker;
    @Nullable
    private SuggestionProvider suggestionProvider;
    private static final int MAX_METRICS = 1;
    @NotNull
    private static final String CACHED_DICTIONARY_FILE = "spellchecker-dictionary.xml";

    @ApiStatus.Internal
    public SpellCheckerManager(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.projectDictionaryPath$delegate = LazyKt.lazy(() -> SpellCheckerManager.projectDictionaryPath_delegate$lambda$0(this));
        this.appDictionaryPath$delegate = LazyKt.lazy(SpellCheckerManager::appDictionaryPath_delegate$lambda$0);
        EventDispatcher eventDispatcher = EventDispatcher.create(DictionaryStateListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.userDictionaryListenerEventDispatcher = eventDispatcher;
        this.fullConfigurationReload();
        LocalFileSystem.getInstance().addVirtualFileListener((VirtualFileListener)new CustomDictFileListener(this.project, this), (Disposable)this);
        LocalFileSystem.getInstance().addVirtualFileListener((VirtualFileListener)new ProjectDictFileListener(this), (Disposable)this);
        SpellCheckerManagerKt.access$getBUNDLED_EP_NAME$p().addChangeListener(coroutineScope, () -> SpellCheckerManager._init_$lambda$0(this));
        RuntimeDictionaryProvider.EP_NAME.addChangeListener(coroutineScope, () -> SpellCheckerManager._init_$lambda$1(this));
        CustomDictionaryProvider.EP_NAME.addChangeListener(coroutineScope, () -> SpellCheckerManager._init_$lambda$2(this));
        this.addUserDictionaryChangedListener(arg_0 -> SpellCheckerManager._init_$lambda$3(this, arg_0), this);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ProjectDictionary getProjectDictionary$intellij_spellchecker() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<ProjectDictionaryState> serviceClass$iv = ProjectDictionaryState.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ProjectDictionary projectDictionary = ((ProjectDictionaryState)object).getProjectDictionary();
        Intrinsics.checkNotNullExpressionValue((Object)projectDictionary, (String)"getProjectDictionary(...)");
        return projectDictionary;
    }

    @NotNull
    public final EditableDictionary getAppDictionary$intellij_spellchecker() {
        EditableDictionary editableDictionary = AppDictionaryState.getInstance().getDictionary();
        Intrinsics.checkNotNullExpressionValue((Object)editableDictionary, (String)"getDictionary(...)");
        return editableDictionary;
    }

    @ApiStatus.Internal
    @NotNull
    public final String getProjectDictionaryPath() {
        Lazy lazy = this.projectDictionaryPath$delegate;
        return (String)lazy.getValue();
    }

    @ApiStatus.Internal
    @NotNull
    public final String getAppDictionaryPath() {
        Lazy lazy = this.appDictionaryPath$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public final SpellCheckerEngine getSpellChecker() {
        return this.spellChecker;
    }

    public final void fullConfigurationReload() {
        SpellCheckerEngine spellChecker = SpellCheckerEngine.getInstance(this.project);
        if (spellChecker == null) {
            return;
        }
        this.spellChecker = spellChecker;
        this.suggestionProvider = new GrazieSuggestionProvider(spellChecker);
        this.fillEngineDictionary(spellChecker);
    }

    public final void updateBundledDictionaries(@NotNull List<String> removedDictionaries) {
        Intrinsics.checkNotNullParameter(removedDictionaries, (String)"removedDictionaries");
        SpellCheckerEngine spellCheckerEngine = this.spellChecker;
        if (spellCheckerEngine == null) {
            return;
        }
        SpellCheckerEngine spellChecker = spellCheckerEngine;
        for (BundledDictionaryProvider provider : SpellCheckerManagerKt.access$getBUNDLED_EP_NAME$p().getExtensionList()) {
            String[] stringArray;
            Intrinsics.checkNotNullExpressionValue((Object)provider.getBundledDictionaries(), (String)"getBundledDictionaries(...)");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String dictionary = stringArray[i];
                if (spellChecker.isDictionaryLoad(dictionary)) continue;
                Intrinsics.checkNotNull((Object)dictionary);
                SpellCheckerManagerKt.access$loadBundledDictionary(provider, dictionary, spellChecker);
            }
        }
        SpellCheckerSettings spellCheckerSettings = SpellCheckerSettings.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)spellCheckerSettings, (String)"getInstance(...)");
        SpellCheckerSettings settings = spellCheckerSettings;
        for (RuntimeDictionaryProvider provider : RuntimeDictionaryProvider.EP_NAME.getExtensionList()) {
            Dictionary[] dictionaryArray;
            Intrinsics.checkNotNullExpressionValue((Object)provider.getDictionaries(), (String)"getDictionaries(...)");
            for (Dictionary dictionary : dictionaryArray) {
                boolean dictionaryShouldBeLoad = !settings.getRuntimeDisabledDictionariesNames().contains(dictionary.getName());
                boolean dictionaryIsLoad = spellChecker.isDictionaryLoad(dictionary.getName());
                if (dictionaryIsLoad && !dictionaryShouldBeLoad) {
                    spellChecker.removeDictionary(dictionary.getName());
                    continue;
                }
                if (dictionaryIsLoad || !dictionaryShouldBeLoad) continue;
                spellChecker.addDictionary(dictionary);
            }
        }
        if (settings.getCustomDictionariesPaths() != null) {
            for (String dictionary : settings.getCustomDictionariesPaths()) {
                if (spellChecker.isDictionaryLoad(dictionary)) continue;
                Intrinsics.checkNotNull((Object)dictionary);
                this.loadDictionary(dictionary);
            }
        }
        if (!removedDictionaries.isEmpty()) {
            Iterator<Object> iterator = removedDictionaries.iterator();
            while (iterator.hasNext()) {
                String name;
                String string = name = (String)iterator.next();
                Intrinsics.checkNotNull((Object)string);
                spellChecker.removeDictionary(string);
            }
        }
        Companion.restartInspections("SpellCheckerManager.updateBundledDictionaries");
    }

    @NotNull
    public final Set<String> getUserDictionaryWords() {
        Set<String> set = this.getProjectDictionary$intellij_spellchecker().getEditableWords();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getEditableWords(...)");
        Set<String> set2 = this.getAppDictionary$intellij_spellchecker().getEditableWords();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"getEditableWords(...)");
        return SetsKt.plus(set, (Iterable)set2);
    }

    @NotNull
    public final Set<String> getUserCamelCaseWords() {
        Set<String> set = this.getProjectDictionary$intellij_spellchecker().getCamelCaseWords();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getCamelCaseWords(...)");
        Set<String> set2 = this.getAppDictionary$intellij_spellchecker().getCamelCaseWords();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"getCamelCaseWords(...)");
        return SetsKt.plus(set, (Iterable)set2);
    }

    private final void fillEngineDictionary(SpellCheckerEngine spellChecker) {
        if (spellChecker == null) {
            return;
        }
        spellChecker.reset();
        SpellCheckerSettings spellCheckerSettings = SpellCheckerSettings.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)spellCheckerSettings, (String)"getInstance(...)");
        SpellCheckerSettings settings = spellCheckerSettings;
        SpellCheckerManagerKt.access$loadBundledDictionaries(spellChecker);
        for (RuntimeDictionaryProvider provider : RuntimeDictionaryProvider.EP_NAME.getExtensionList()) {
            Dictionary[] dictionaryArray;
            Intrinsics.checkNotNullExpressionValue((Object)provider.getDictionaries(), (String)"getDictionaries(...)");
            for (Dictionary dictionary : dictionaryArray) {
                if (settings.getRuntimeDisabledDictionariesNames().contains(dictionary.getName())) continue;
                spellChecker.addDictionary(dictionary);
            }
        }
        if (settings.getCustomDictionariesPaths() != null) {
            for (String path : settings.getCustomDictionariesPaths()) {
                Intrinsics.checkNotNull((Object)path);
                this.loadDictionary(path);
            }
        }
        this.initUserDictionaries(spellChecker);
    }

    private final void initUserDictionaries(SpellCheckerEngine spellChecker) {
        AppDictionaryState appDictionaryState = AppDictionaryState.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)appDictionaryState, (String)"getInstance(...)");
        AppDictionaryState appDictionaryState2 = appDictionaryState;
        appDictionaryState2.addAppDictListener(SpellCheckerManager::initUserDictionaries$lambda$0, this);
        if (appDictionaryState2.getDictionary() == null) {
            appDictionaryState2.setDictionary(new UserDictionary("cached"));
        }
        spellChecker.addModifiableDictionary(this.getAppDictionary$intellij_spellchecker());
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<ProjectDictionaryState> serviceClass$iv = ProjectDictionaryState.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ProjectDictionaryState dictionaryState = (ProjectDictionaryState)object;
        dictionaryState.addProjectDictListener(SpellCheckerManager::initUserDictionaries$lambda$1);
        this.getProjectDictionary$intellij_spellchecker().setActiveName(SpellCheckerManagerKt.getProjectDictionaryName());
        spellChecker.addModifiableDictionary(this.getProjectDictionary$intellij_spellchecker());
    }

    public final void loadDictionary(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        SpellCheckerEngine spellCheckerEngine = this.spellChecker;
        if (spellCheckerEngine == null) {
            return;
        }
        SpellCheckerEngine spellChecker = spellCheckerEngine;
        CustomDictionaryProvider dictionaryProvider = SpellCheckerManager.Companion.findApplicable(path);
        if (dictionaryProvider == null) {
            spellChecker.loadDictionary(new FileLoader(path));
            return;
        }
        Dictionary dictionary = dictionaryProvider.get(path);
        if (dictionary != null) {
            spellChecker.addDictionary(dictionary);
        }
    }

    @Nullable
    public final Unit removeDictionary(@NotNull String path) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        SpellCheckerEngine spellCheckerEngine = this.spellChecker;
        if (spellCheckerEngine != null) {
            spellCheckerEngine.removeDictionary(path);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public final boolean hasProblem(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        SpellCheckerEngine spellCheckerEngine = this.spellChecker;
        if (spellCheckerEngine == null) {
            return false;
        }
        SpellCheckerEngine spellChecker = spellCheckerEngine;
        return !spellChecker.isCorrect(word) && !this.isCorrectExtensionWord(word);
    }

    private final boolean isCorrectExtensionWord(String word) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = DictionaryChecker.EP_NAME.getExtensionList();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DictionaryChecker it = (DictionaryChecker)element$iv;
                    boolean bl2 = false;
                    if (!it.isCorrect(this.project, word)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void acceptWordAsCorrect(@NotNull String word, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.acceptWordAsCorrect$intellij_spellchecker(word, null, project, new ProjectDictionaryLayer(project));
    }

    public final void acceptWordAsCorrect$intellij_spellchecker(@NotNull String word, @Nullable VirtualFile file, @NotNull Project project, @Nullable DictionaryLayer dictionaryLayer) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (dictionaryLayer == null) {
            return;
        }
        String string = this.transform(word);
        if (string == null) {
            return;
        }
        String transformed = string;
        EditableDictionary dictionary = dictionaryLayer.getDictionary();
        if (file != null) {
            WriteCommandAction.writeCommandAction((Project)project).run(() -> SpellCheckerManager.acceptWordAsCorrect$lambda$0(project, file, this, dictionary, transformed));
        }
        this.addWordToDictionary(dictionary, transformed);
    }

    private final String transform(String word) {
        SpellCheckerEngine spellCheckerEngine = this.spellChecker;
        if (spellCheckerEngine == null) {
            return null;
        }
        SpellCheckerEngine spellChecker = spellCheckerEngine;
        if (StringUtil.isLowerCase((CharSequence)StringUtil.decapitalize((String)word))) {
            return word;
        }
        return spellChecker.getTransformation().transform(word);
    }

    private final void addWordToDictionary(EditableDictionary dictionary, String word) {
        SpellCheckerEngine spellCheckerEngine = this.spellChecker;
        if (spellCheckerEngine == null) {
            return;
        }
        SpellCheckerEngine spellChecker = spellCheckerEngine;
        dictionary.addToDictionary(word);
        if (!spellChecker.isDictionaryLoad(dictionary.getName())) {
            spellChecker.addModifiableDictionary(dictionary);
        }
        this.fireDictionaryChanged(dictionary);
    }

    private final void removeWordFromDictionary(EditableDictionary dictionary, String transformed) {
        dictionary.removeFromDictionary(transformed);
        this.fireDictionaryChanged(dictionary);
    }

    private final void fireDictionaryChanged(EditableDictionary dictionary) {
        ((DictionaryStateListener)this.userDictionaryListenerEventDispatcher.getMulticaster()).dictChanged(dictionary);
        Companion.restartInspections("SpellCheckerManager.fireDictionaryChanged");
        SaveAndSyncHandler.Companion.getInstance().scheduleProjectSave(this.project, true);
    }

    public final void updateUserDictionary(@NotNull Collection<String> words) {
        Intrinsics.checkNotNullParameter(words, (String)"words");
        List addedToProjectWords = CollectionsKt.minus((Iterable)words, (Iterable)this.getUserDictionaryWords());
        ProjectDictionary projectDictionary = this.getProjectDictionary$intellij_spellchecker();
        for (String word : addedToProjectWords) {
            projectDictionary.addToDictionary(word);
        }
        HashSet wordSet = CollectionsKt.toHashSet((Iterable)words);
        Set<String> set = projectDictionary.getEditableWords();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getEditableWords(...)");
        Set deletedFromProjectWords = SetsKt.minus(set, (Iterable)wordSet);
        for (String word : deletedFromProjectWords) {
            projectDictionary.removeFromDictionary(word);
        }
        if (addedToProjectWords.size() + deletedFromProjectWords.size() > 0) {
            ((DictionaryStateListener)this.userDictionaryListenerEventDispatcher.getMulticaster()).dictChanged(projectDictionary);
        }
        Set<String> set2 = this.getAppDictionary$intellij_spellchecker().getEditableWords();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"getEditableWords(...)");
        Set deletedFromApplicationWords = SetsKt.minus(set2, (Iterable)wordSet);
        for (String word : deletedFromApplicationWords) {
            this.getAppDictionary$intellij_spellchecker().removeFromDictionary(word);
        }
        if (!deletedFromApplicationWords.isEmpty()) {
            ((DictionaryStateListener)this.userDictionaryListenerEventDispatcher.getMulticaster()).dictChanged(this.getAppDictionary$intellij_spellchecker());
        }
        Companion.restartInspections("SpellCheckerManager.updateUserDictionary");
    }

    @NotNull
    public final List<String> getSuggestions(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        SuggestionProvider suggestionProvider = this.suggestionProvider;
        if (suggestionProvider == null) {
            return CollectionsKt.emptyList();
        }
        SuggestionProvider suggestionProvider2 = suggestionProvider;
        int correctionLimit = Registry.Companion.intValue("spellchecker.corrections.limit", 5);
        List<String> list = suggestionProvider2.getSuggestions(text, correctionLimit, 1);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getSuggestions(...)");
        return list;
    }

    public void dispose() {
    }

    public final void openDictionaryInEditor(@NotNull String dictPath) {
        block1: {
            VirtualFile file;
            Intrinsics.checkNotNullParameter((Object)dictPath, (String)"dictPath");
            VirtualFile virtualFile = file = ((CharSequence)dictPath).length() == 0 ? null : LocalFileSystem.getInstance().refreshAndFindFileByPath(dictPath);
            if (file == null) {
                String title = SpellCheckerBundle.message("dictionary.not.found.title", new Object[0]);
                Object[] objectArray = new Object[]{dictPath};
                String message = SpellCheckerBundle.message("dictionary.not.found", objectArray);
                Messages.showMessageDialog((Project)this.project, (String)message, (String)title, (Icon)Messages.getWarningIcon());
                return;
            }
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.project);
            if (fileEditorManager == null) break block1;
            fileEditorManager.openFile(file, true);
        }
    }

    public final void addUserDictionaryChangedListener(@NotNull DictionaryStateListener listener, @Nullable Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.userDictionaryListenerEventDispatcher.addListener((EventListener)listener);
        Disposable disposable = parentDisposable;
        Intrinsics.checkNotNull((Object)disposable);
        Disposer.register((Disposable)disposable, () -> SpellCheckerManager.addUserDictionaryChangedListener$lambda$0(this, listener));
    }

    private static final String projectDictionaryPath_delegate$lambda$0(SpellCheckerManager this$0) {
        Project project;
        Project it = project = this$0.project;
        boolean bl = false;
        Object object = !it.isDefault() ? project : null;
        Path projectStoreDir = object != null && (object = ProjectKt.getStateStore((Project)object)) != null ? object.getDirectoryStorePath() : null;
        Object object2 = projectStoreDir;
        if (object2 == null || (object2 = object2.toAbsolutePath()) == null || (object2 = object2.resolve(SpellCheckerManagerKt.access$getProjectDictionaryPath())) == null || (object2 = object2.toString()) == null) {
            object2 = "";
        }
        return object2;
    }

    private static final String appDictionaryPath_delegate$lambda$0() {
        return PathManager.getOptionsPath() + "/spellchecker-dictionary.xml";
    }

    private static final void _init_$lambda$0(SpellCheckerManager this$0) {
        this$0.fillEngineDictionary(this$0.spellChecker);
    }

    private static final void _init_$lambda$1(SpellCheckerManager this$0) {
        this$0.fillEngineDictionary(this$0.spellChecker);
    }

    private static final void _init_$lambda$2(SpellCheckerManager this$0) {
        this$0.fillEngineDictionary(this$0.spellChecker);
    }

    private static final void _init_$lambda$3(SpellCheckerManager this$0, EditableDictionary it) {
        DictionaryModificationTracker.Companion.getInstance(this$0.project).incModificationCount();
    }

    private static final void initUserDictionaries$lambda$0(EditableDictionary it) {
        Companion.restartInspections("SpellCheckerManager.addAppDictListener");
    }

    private static final void initUserDictionaries$lambda$1(EditableDictionary it) {
        Companion.restartInspections("SpellCheckerManager.addProjectDictListener");
    }

    private static final void acceptWordAsCorrect$lambda$0(Project $project, VirtualFile $file, SpellCheckerManager this$0, EditableDictionary $dictionary, String $transformed) {
        VirtualFile[] virtualFileArray = new VirtualFile[]{$file};
        VirtualFile[] virtualFileArray2 = virtualFileArray;
        UndoManager.getInstance((Project)$project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(this$0, $dictionary, $transformed, virtualFileArray2){
            final /* synthetic */ SpellCheckerManager this$0;
            final /* synthetic */ EditableDictionary $dictionary;
            final /* synthetic */ String $transformed;
            {
                this.this$0 = $receiver;
                this.$dictionary = $dictionary;
                this.$transformed = $transformed;
                super($super_call_param$1);
            }

            public void undo() {
                SpellCheckerManager.access$removeWordFromDictionary(this.this$0, this.$dictionary, this.$transformed);
            }

            public void redo() {
                SpellCheckerManager.access$addWordToDictionary(this.this$0, this.$dictionary, this.$transformed);
            }
        });
    }

    private static final void addUserDictionaryChangedListener$lambda$0(SpellCheckerManager this$0, DictionaryStateListener $listener) {
        this$0.userDictionaryListenerEventDispatcher.removeListener((EventListener)$listener);
    }

    @JvmStatic
    @NotNull
    public static final SpellCheckerManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @NotNull
    public static final List<String> getBundledDictionaries() {
        return Companion.getBundledDictionaries();
    }

    @NotNull
    public static final List<Dictionary> getRuntimeDictionaries() {
        return Companion.getRuntimeDictionaries();
    }

    public static final /* synthetic */ void access$removeWordFromDictionary(SpellCheckerManager $this, EditableDictionary dictionary, String transformed) {
        $this.removeWordFromDictionary(dictionary, transformed);
    }

    public static final /* synthetic */ void access$addWordToDictionary(SpellCheckerManager $this, EditableDictionary dictionary, String word) {
        $this.addWordToDictionary(dictionary, word);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0001J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\r8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000e\u0010\u0003\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\r8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u0003\u001a\u0004\b\u0014\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/intellij/spellchecker/SpellCheckerManager$Companion;", "", "<init>", "()V", "MAX_METRICS", "", "CACHED_DICTIONARY_FILE", "", "getInstance", "Lcom/intellij/spellchecker/SpellCheckerManager;", "project", "Lcom/intellij/openapi/project/Project;", "bundledDictionaries", "", "getBundledDictionaries$annotations", "getBundledDictionaries", "()Ljava/util/List;", "runtimeDictionaries", "Lcom/intellij/spellchecker/dictionary/Dictionary;", "getRuntimeDictionaries$annotations", "getRuntimeDictionaries", "restartInspections", "", "reason", "findApplicable", "Lcom/intellij/spellchecker/dictionary/CustomDictionaryProvider;", "path", "intellij.spellchecker"})
    @SourceDebugExtension(value={"SMAP\nSpellCheckerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpellCheckerManager.kt\ncom/intellij/spellchecker/SpellCheckerManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,496:1\n30#2,2:497\n1404#3:499\n1496#3,5:500\n1404#3:505\n1496#3,5:506\n296#3,2:511\n*S KotlinDebug\n*F\n+ 1 SpellCheckerManager.kt\ncom/intellij/spellchecker/SpellCheckerManager$Companion\n*L\n96#1:497,2\n100#1:499\n100#1:500,5\n104#1:505\n104#1:506,5\n118#1:511,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SpellCheckerManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<SpellCheckerManager> serviceClass$iv = SpellCheckerManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (SpellCheckerManager)object;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> getBundledDictionaries() {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = SpellCheckerManagerKt.access$getBUNDLED_EP_NAME$p().getExtensionList();
            boolean $i$f$flatMapSequence = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapSequenceTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                BundledDictionaryProvider it = (BundledDictionaryProvider)element$iv$iv;
                boolean bl = false;
                String[] stringArray = it.getBundledDictionaries();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getBundledDictionaries(...)");
                Sequence list$iv$iv = ArraysKt.asSequence((Object[])stringArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Sequence)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @JvmStatic
        public static /* synthetic */ void getBundledDictionaries$annotations() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Dictionary> getRuntimeDictionaries() {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = RuntimeDictionaryProvider.EP_NAME.getExtensionList();
            boolean $i$f$flatMapSequence = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapSequenceTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                RuntimeDictionaryProvider it = (RuntimeDictionaryProvider)element$iv$iv;
                boolean bl = false;
                Dictionary[] dictionaryArray = it.getDictionaries();
                Intrinsics.checkNotNullExpressionValue((Object)dictionaryArray, (String)"getDictionaries(...)");
                Sequence list$iv$iv = ArraysKt.asSequence((Object[])dictionaryArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Sequence)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @JvmStatic
        public static /* synthetic */ void getRuntimeDictionaries$annotations() {
        }

        public final void restartInspections(@NotNull Object reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            ApplicationManager.getApplication().invokeLater(() -> Companion.restartInspections$lambda$0(reason));
        }

        private final CustomDictionaryProvider findApplicable(String path) {
            Object v0;
            block1: {
                Iterable $this$firstOrNull$iv = CustomDictionaryProvider.EP_NAME.getExtensionList();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    CustomDictionaryProvider it = (CustomDictionaryProvider)element$iv;
                    boolean bl = false;
                    if (!it.isApplicable(path)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        private static final void restartInspections$lambda$0(Object $reason) {
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            for (Project project : projectArray) {
                Intrinsics.checkNotNull((Object)project);
                Project project2 = project;
                if (!project2.isInitialized() || !project2.isOpen()) continue;
                DaemonCodeAnalyzer.getInstance((Project)project2).restart($reason);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

