/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.project.roots;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.lang.puppet.project.PuppetProjectModel;
import com.intellij.lang.puppet.project.roots.PuppetDirectoryInfo;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.containers.IntObjectMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PuppetRootIndex {
    private final InfoCache myInfoCache;
    private static final FileTypeRegistry ourFileTypes = FileTypeRegistry.getInstance();

    public PuppetRootIndex(@NotNull Project project) {
        if (project == null) {
            PuppetRootIndex.$$$reportNull$$$0(0);
        }
        this.myInfoCache = new InfoCache();
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
        for (VirtualFile root : PuppetProjectModel.getInstance(project).getAllRoots()) {
            this.cacheInfos(root, root, PuppetRootIndex.calcDirectoryInfo(fileIndex, root));
        }
    }

    @NotNull
    private static PuppetDirectoryInfo calcDirectoryInfo(ProjectFileIndex fileIndex, @NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            PuppetRootIndex.$$$reportNull$$$0(1);
        }
        if (!fileIndex.isInContent(virtualFile) && !fileIndex.isInLibrary(virtualFile)) {
            PuppetDirectoryInfo puppetDirectoryInfo = PuppetDirectoryInfo.UNAVAILABLE;
            if (puppetDirectoryInfo == null) {
                PuppetRootIndex.$$$reportNull$$$0(2);
            }
            return puppetDirectoryInfo;
        }
        return new PuppetDirectoryInfo(virtualFile);
    }

    boolean resetOnEvents(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            PuppetRootIndex.$$$reportNull$$$0(3);
        }
        for (VFileEvent vFileEvent : events) {
            VirtualFile file = vFileEvent.getFile();
            if (file != null && !file.isDirectory()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public PuppetDirectoryInfo getInfoForFile(@NotNull VirtualFile file) {
        VirtualFile dir;
        if (file == null) {
            PuppetRootIndex.$$$reportNull$$$0(4);
        }
        if (!file.isValid()) {
            PuppetDirectoryInfo puppetDirectoryInfo = PuppetDirectoryInfo.UNAVAILABLE;
            if (puppetDirectoryInfo == null) {
                PuppetRootIndex.$$$reportNull$$$0(5);
            }
            return puppetDirectoryInfo;
        }
        if (!file.isDirectory()) {
            PuppetDirectoryInfo info = this.myInfoCache.getCachedInfo(file);
            if (info != null) {
                PuppetDirectoryInfo puppetDirectoryInfo = info;
                if (puppetDirectoryInfo == null) {
                    PuppetRootIndex.$$$reportNull$$$0(6);
                }
                return puppetDirectoryInfo;
            }
            if (ourFileTypes.isFileIgnored(file)) {
                PuppetDirectoryInfo puppetDirectoryInfo = PuppetDirectoryInfo.UNAVAILABLE;
                if (puppetDirectoryInfo == null) {
                    PuppetRootIndex.$$$reportNull$$$0(7);
                }
                return puppetDirectoryInfo;
            }
            dir = file.getParent();
        } else {
            dir = file;
        }
        int count = 0;
        for (VirtualFile root = dir; root != null; root = root.getParent()) {
            if (++count > 1000) {
                throw new IllegalStateException("Possible loop in tree, started at " + dir.getName());
            }
            PuppetDirectoryInfo info = this.myInfoCache.getCachedInfo(root);
            if (info != null) {
                if (!dir.equals(root)) {
                    this.cacheInfos(dir, root, info);
                }
                PuppetDirectoryInfo puppetDirectoryInfo = info;
                if (puppetDirectoryInfo == null) {
                    PuppetRootIndex.$$$reportNull$$$0(8);
                }
                return puppetDirectoryInfo;
            }
            if (!ourFileTypes.isFileIgnored(root)) continue;
            return this.cacheInfos(dir, root, PuppetDirectoryInfo.UNAVAILABLE);
        }
        return this.cacheInfos(dir, null, PuppetDirectoryInfo.UNAVAILABLE);
    }

    @NotNull
    private PuppetDirectoryInfo cacheInfos(VirtualFile dir, @Nullable VirtualFile stopAt, @NotNull PuppetDirectoryInfo info) {
        if (info == null) {
            PuppetRootIndex.$$$reportNull$$$0(9);
        }
        while (dir != null) {
            this.myInfoCache.cacheInfo(dir, info);
            if (dir.equals(stopAt)) break;
            dir = dir.getParent();
        }
        PuppetDirectoryInfo puppetDirectoryInfo = info;
        if (puppetDirectoryInfo == null) {
            PuppetRootIndex.$$$reportNull$$$0(10);
        }
        return puppetDirectoryInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6, 7, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/project/roots/PuppetRootIndex";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/project/roots/PuppetRootIndex";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "calcDirectoryInfo";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoForFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "cacheInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "calcDirectoryInfo";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resetOnEvents";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInfoForFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "cacheInfos";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6, 7, 8, 10 -> new IllegalStateException(string);
        };
    }

    private static class InfoCache {
        private final IntObjectMap<PuppetDirectoryInfo> myInfoCache = ConcurrentCollectionFactory.createConcurrentIntObjectMap();

        private InfoCache() {
        }

        public void cacheInfo(@NotNull VirtualFile dir, @NotNull PuppetDirectoryInfo info) {
            if (dir == null) {
                InfoCache.$$$reportNull$$$0(0);
            }
            if (info == null) {
                InfoCache.$$$reportNull$$$0(1);
            }
            this.myInfoCache.put(((NewVirtualFile)dir).getId(), (Object)info);
        }

        public PuppetDirectoryInfo getCachedInfo(@NotNull VirtualFile dir) {
            if (dir == null) {
                InfoCache.$$$reportNull$$$0(2);
            }
            return (PuppetDirectoryInfo)this.myInfoCache.get(((NewVirtualFile)dir).getId());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/puppet/project/roots/PuppetRootIndex$InfoCache";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "cacheInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getCachedInfo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

