/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.huggingFace.cacheManager.ui;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.python.community.impl.huggingFace.service.HuggingFaceCardsUsageCollector;
import com.intellij.python.huggingFace.HuggingFaceProBundle;
import com.intellij.python.huggingFace.cacheManager.service.HfCacheEntryData;
import com.intellij.python.huggingFace.cacheManager.service.HfCacheEnvUtils;
import com.intellij.python.huggingFace.cacheManager.ui.HfPopupTableAction;
import com.intellij.python.huggingFace.cacheManager.ui.core.HfCacheMaterialTable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/python/huggingFace/cacheManager/ui/HfRemoveFromCacheAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/python/huggingFace/cacheManager/ui/HfPopupTableAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.python.huggingFace"})
public final class HfRemoveFromCacheAction
extends DumbAwareAction
implements HfPopupTableAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext context = dataContext;
        HfCacheEntryData hfCacheEntryData = this.extractItemFromContext(context);
        if (hfCacheEntryData == null) {
            return;
        }
        HfCacheEntryData item = hfCacheEntryData;
        Object[] objectArray = e.getDataContext().getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
        HfCacheMaterialTable hfCacheMaterialTable = objectArray instanceof HfCacheMaterialTable ? (HfCacheMaterialTable)objectArray : null;
        if (hfCacheMaterialTable == null) {
            return;
        }
        HfCacheMaterialTable table = hfCacheMaterialTable;
        objectArray = new Object[]{item.getRepoType().getPrintName(), item.getRepoId()};
        boolean confirmed = MessageDialogBuilder.Companion.yesNo(HuggingFaceProBundle.INSTANCE.message("action.remove.from.cache.alert.message", objectArray), HuggingFaceProBundle.INSTANCE.message("action.remove.from.cache.alert.undo.warn", new Object[0])).ask(project2);
        HuggingFaceCardsUsageCollector.INSTANCE.getHF_CACHE_MANAGEMENT_DELETE_ITEM().log((Object)HuggingFaceCardsUsageCollector.CacheManagementActionSource.CONTEXT_MENU, (Object)HuggingFaceCardsUsageCollector.INSTANCE.boolToDialogStatus(confirmed), (Object)HuggingFaceCardsUsageCollector.INSTANCE.closestPowerOfTwo(item.getSizeOnDisk()));
        if (confirmed) {
            HfCacheEnvUtils.INSTANCE.doDeleteItemAndUpdateTable(item, (Function0<Unit>)((Function0)() -> HfRemoveFromCacheAction.actionPerformed$lambda$0(table)));
        }
    }

    private static final Unit actionPerformed$lambda$0(HfCacheMaterialTable $table) {
        $table.updateTableData();
        return Unit.INSTANCE;
    }
}

