/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.debugger;

import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.python.community.helpersLocator.PythonHelpersLocator;
import com.jetbrains.python.debugger.PyDebugAsyncioCustomizer;
import com.jetbrains.python.run.EnvironmentController;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/python/pro/debugger/PyDebugAsyncioCustomizerImpl;", "Lcom/jetbrains/python/debugger/PyDebugAsyncioCustomizer;", "<init>", "()V", "enableAsyncioMode", "", "environmentController", "Lcom/jetbrains/python/run/EnvironmentController;", "isAsyncioModeSupported", "", "Companion", "intellij.python"})
public final class PyDebugAsyncioCustomizerImpl
implements PyDebugAsyncioCustomizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NonNls
    @NotNull
    public static final String ASYNCIO_ENV = "ASYNCIO_DEBUGGER_ENV";

    public void enableAsyncioMode(@NotNull EnvironmentController environmentController) {
        Intrinsics.checkNotNullParameter((Object)environmentController, (String)"environmentController");
        if (this.isAsyncioModeSupported()) {
            String pydevdAsyncioPath = PythonHelpersLocator.Companion.findPathStringInHelpers("pydevd_asyncio");
            environmentController.addHelperEntriesToPythonPath(CollectionsKt.listOf((Object)pydevdAsyncioPath));
            environmentController.putFixedValue(ASYNCIO_ENV, "True");
        }
    }

    public boolean isAsyncioModeSupported() {
        return RegistryManager.Companion.getInstance().is("python.debug.asyncio.repl");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/python/pro/debugger/PyDebugAsyncioCustomizerImpl$Companion;", "", "<init>", "()V", "ASYNCIO_ENV", "", "intellij.python"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

