/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.flask.codeInsight;

import com.intellij.codeInsight.daemon.DefaultGutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.icons.AllIcons;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.python.pro.flask.codeInsight.FlaskTemplateManager;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FlaskLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        RelatedItemLineMarkerInfo<PsiFile> info;
        if (element == null) {
            FlaskLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            FlaskLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof PyFunction) {
            RelatedItemLineMarkerInfo<PsiElement> info2 = FlaskLineMarkerProvider.createCodeLineMarker((PyFunction)element);
            if (info2 != null) {
                result.add(info2);
            }
        } else if (element instanceof PsiFile && ((PsiFile)element).getViewProvider() instanceof TemplateLanguageFileViewProvider && (info = FlaskLineMarkerProvider.createTemplateLineMarker((PsiFile)element)) != null) {
            result.add(info);
        }
    }

    @Nullable
    private static RelatedItemLineMarkerInfo<PsiElement> createCodeLineMarker(PyFunction function) {
        PsiElement identifier;
        ArrayList<PsiFile> referencedFiles = new ArrayList<PsiFile>();
        List<PyStringLiteralExpression> templateReferences = FlaskTemplateManager.collectTemplateReferences(function);
        for (PyStringLiteralExpression literal : templateReferences) {
            for (PsiReference reference : literal.getReferences()) {
                PsiElement result;
                if (!(reference instanceof FileReference) || !((result = reference.resolve()) instanceof PsiFile)) continue;
                referencedFiles.add((PsiFile)result);
            }
        }
        if (!referencedFiles.isEmpty() && (identifier = function.getNameIdentifier()) != null) {
            @Nls String message = referencedFiles.size() == 1 ? PythonProBundle.message((String)"flask.line.marker.go.to.template", (Object[])new Object[]{((PsiFile)referencedFiles.get(0)).getName()}) : PythonProBundle.message((String)"flask.line.marker.go.to.template.plural");
            return FlaskLineMarkerProvider.createNavigationLineMarker(identifier, referencedFiles, PythonProBundle.message((String)"flask.line.marker.go.to.template.target.name"), message);
        }
        return null;
    }

    private static <T extends PsiElement, U extends PsiNamedElement & NavigatablePsiElement> RelatedItemLineMarkerInfo<T> createNavigationLineMarker(T identifier, Collection<U> targets, @Nls String targetTypeName, @Nls String msg) {
        return new RelatedItemLineMarkerInfo(identifier, identifier.getTextRange(), AllIcons.FileTypes.Html, (Function)new ConstantFunction((Object)msg), (GutterIconNavigationHandler)new DefaultGutterIconNavigationHandler(targets, msg), GutterIconRenderer.Alignment.RIGHT, () -> GotoRelatedItem.createItems((Collection)targets, (String)targetTypeName));
    }

    @Nullable
    private static RelatedItemLineMarkerInfo<PsiFile> createTemplateLineMarker(PsiFile element) {
        List<PyStringLiteralExpression> references = FlaskTemplateManager.findTemplateReferences(element);
        if (!references.isEmpty()) {
            HashSet<PyFunction> viewFunctions = new HashSet<PyFunction>();
            for (PyStringLiteralExpression literal : references) {
                PyFunction containingFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)literal, PyFunction.class);
                if (containingFunction == null) continue;
                viewFunctions.add(containingFunction);
            }
            if (!viewFunctions.isEmpty()) {
                @Nls String message = viewFunctions.size() == 1 ? PythonProBundle.message((String)"flask.line.marker.go.to.view.function", (Object[])new Object[]{((PyFunction)ContainerUtil.getFirstItem(viewFunctions)).getName()}) : PythonProBundle.message((String)"flask.line.marker.go.to.view.function.plural");
                return FlaskLineMarkerProvider.createNavigationLineMarker(element, viewFunctions, PythonProBundle.message((String)"flask.line.marker.go.to.view.function.target.name"), message);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/python/pro/flask/codeInsight/FlaskLineMarkerProvider";
        objectArray[2] = "collectNavigationMarkers";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

