/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.flask.codeInsight;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.python.pro.flask.configuration.FlaskConfigurationKt;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FlaskTemplateManager {
    private static final String TEMPLATING_FILE = "templating.py";

    public static boolean isTemplateReference(PyStringLiteralExpression literal) {
        PyCallExpression callExpr = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)literal, PyCallExpression.class);
        if (callExpr == null) {
            return false;
        }
        if (DumbService.isDumb((Project)callExpr.getProject())) {
            return false;
        }
        TypeEvalContext evalContext = TypeEvalContext.codeAnalysis((Project)callExpr.getProject(), (PsiFile)callExpr.getContainingFile());
        PyResolveContext resolveContext = PyResolveContext.defaultContext((TypeEvalContext)evalContext);
        if (FlaskTemplateManager.isFirstCallArgument(literal, "render_template", TEMPLATING_FILE, resolveContext)) {
            return true;
        }
        int argIndex = PyPsiUtils.findArgumentIndex((PyCallExpression)callExpr, (PsiElement)literal);
        if (argIndex < 0) {
            return false;
        }
        List callables = callExpr.multiResolveCalleeFunction(resolveContext);
        for (PyCallable callee : callables) {
            if (!(callee instanceof PyFunction)) continue;
            PyFunction fn = (PyFunction)callee;
            if (FlaskTemplateManager.isFlaskRenderTemplate(fn)) {
                return true;
            }
            if (!FlaskTemplateManager.forwardsFirstArgToFlask(fn, resolveContext, argIndex)) continue;
            return true;
        }
        return false;
    }

    private static boolean forwardsFirstArgToFlask(@NotNull PyFunction wrapper, final @NotNull PyResolveContext ctx, int argIndex) {
        if (wrapper == null) {
            FlaskTemplateManager.$$$reportNull$$$0(0);
        }
        if (ctx == null) {
            FlaskTemplateManager.$$$reportNull$$$0(1);
        }
        if (!ctx.getTypeEvalContext().maySwitchToAST((PsiElement)wrapper)) {
            return false;
        }
        List wrapperParams = wrapper.getParameters(ctx.getTypeEvalContext());
        int offset = !wrapperParams.isEmpty() && ((PyCallableParameter)wrapperParams.getFirst()).isSelf() ? 1 : 0;
        int targetParamIndex = argIndex + offset;
        if (targetParamIndex < 0 || targetParamIndex > wrapperParams.size() - 1) {
            return false;
        }
        PyCallableParameter targetParam = (PyCallableParameter)wrapperParams.get(targetParamIndex);
        final String targetParamName = targetParam.getName();
        if (targetParamName == null || targetParamName.isEmpty()) {
            return false;
        }
        final AtomicBoolean forwarded = new AtomicBoolean(false);
        wrapper.accept((PsiElementVisitor)new PyRecursiveElementVisitor(){

            public void visitPyCallExpression(@NotNull PyCallExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (forwarded.get()) {
                    return;
                }
                List callees = node.multiResolveCalleeFunction(ctx);
                for (PyCallable callee : callees) {
                    PyReferenceExpression ref;
                    PyExpression firstArg;
                    PyExpression[] args;
                    PyFunction innerFn;
                    if (!(callee instanceof PyFunction) || !FlaskTemplateManager.isFlaskRenderTemplate(innerFn = (PyFunction)callee) || (args = node.getArguments()).length == 0 || !((firstArg = args[0]) instanceof PyReferenceExpression) || !targetParamName.equals((ref = (PyReferenceExpression)firstArg).getName())) continue;
                    forwarded.set(true);
                    return;
                }
                super.visitPyCallExpression(node);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/python/pro/flask/codeInsight/FlaskTemplateManager$1", "visitPyCallExpression"));
            }
        });
        return forwarded.get();
    }

    private static boolean isFlaskRenderTemplate(@NotNull PyFunction fn) {
        if (fn == null) {
            FlaskTemplateManager.$$$reportNull$$$0(2);
        }
        if (!"render_template".equals(fn.getName())) {
            return false;
        }
        PsiFile file = fn.getContainingFile();
        return file != null && TEMPLATING_FILE.equals(file.getName());
    }

    public static boolean isFirstCallArgument(@Nullable PyStringLiteralExpression expr, @NotNull String expectedCalleeName, @NotNull String expectedCalleeFile, @NotNull PyResolveContext resolveContext) {
        PyCallExpression call;
        if (expectedCalleeName == null) {
            FlaskTemplateManager.$$$reportNull$$$0(3);
        }
        if (expectedCalleeFile == null) {
            FlaskTemplateManager.$$$reportNull$$$0(4);
        }
        if (resolveContext == null) {
            FlaskTemplateManager.$$$reportNull$$$0(5);
        }
        if ((call = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expr, PyCallExpression.class)) != null) {
            int actualArgumentIndex = PyPsiUtils.findArgumentIndex((PyCallExpression)call, (PsiElement)expr);
            Condition callableIsInExpectedFile = callable -> {
                PsiFile containingFile = callable.getContainingFile();
                return containingFile != null && containingFile.getName().equals(expectedCalleeFile);
            };
            if (actualArgumentIndex == 0 && call.isCalleeText(new String[]{expectedCalleeName}) && ContainerUtil.exists((Iterable)call.multiResolveCalleeFunction(resolveContext), (Condition)callableIsInExpectedFile)) {
                return true;
            }
        }
        return false;
    }

    public static List<PyStringLiteralExpression> collectTemplateReferences(PyFunction function) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)function);
        if (module == null || !FlaskConfigurationKt.getFlaskConfiguration(module).isFlaskEnabled()) {
            return Collections.emptyList();
        }
        final ArrayList<PyStringLiteralExpression> result = new ArrayList<PyStringLiteralExpression>();
        function.acceptChildren((PsiElementVisitor)new PyRecursiveElementVisitor(){

            public void visitPyStringLiteralExpression(@NotNull PyStringLiteralExpression node) {
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (FlaskTemplateManager.isTemplateReference(node)) {
                    result.add(node);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/python/pro/flask/codeInsight/FlaskTemplateManager$2", "visitPyStringLiteralExpression"));
            }
        });
        return result;
    }

    public static List<PyStringLiteralExpression> findTemplateReferences(PsiFile element) {
        ArrayList<PyStringLiteralExpression> references = new ArrayList<PyStringLiteralExpression>();
        GlobalSearchScope scope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)GlobalSearchScope.projectScope((Project)element.getProject()), (FileType[])new FileType[]{PythonFileType.INSTANCE});
        ReferencesSearch.search((PsiElement)element, (SearchScope)scope).forEach(reference -> {
            PyStringLiteralExpression literal;
            PsiElement patt0$temp = reference.getElement();
            if (patt0$temp instanceof PyStringLiteralExpression && FlaskTemplateManager.isTemplateReference(literal = (PyStringLiteralExpression)patt0$temp)) {
                references.add(literal);
            }
            return true;
        });
        return references;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fn";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedCalleeName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedCalleeFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/pro/flask/codeInsight/FlaskTemplateManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "forwardsFirstArgToFlask";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isFlaskRenderTemplate";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isFirstCallArgument";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

