/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.flask.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.python.pro.flask.FlaskCompletionUtil;
import com.intellij.python.pro.flask.FlaskConfigKey;
import com.intellij.python.pro.flask.FlaskConfigRegistry;
import com.intellij.python.pro.flask.configuration.FlaskConfigurationKt;
import com.intellij.python.pro.icons.PythonUltimateIcons;
import com.intellij.util.ProcessingContext;
import com.intellij.util.text.CharArrayUtil;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0005B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0006"}, d2={"Lcom/intellij/python/pro/flask/completion/FlaskConfigValueCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "FlaskConfigurationKeyCompletionProvider", "intellij.python"})
public final class FlaskConfigValueCompletionContributor
extends CompletionContributor
implements DumbAware {
    public FlaskConfigValueCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)FlaskCompletionUtil.Companion.getCONFIG_PSI_PATTERN(), new FlaskConfigurationKeyCompletionProvider());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/python/pro/flask/completion/FlaskConfigValueCompletionContributor$FlaskConfigurationKeyCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "<init>", "()V", "addCompletions", "", "parameters", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "CLOSE_QUOTE_HANDLER", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "intellij.python"})
    private static final class FlaskConfigurationKeyCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        @NotNull
        private final InsertHandler<LookupElement> CLOSE_QUOTE_HANDLER = FlaskConfigurationKeyCompletionProvider::CLOSE_QUOTE_HANDLER$lambda$0;

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)parameters.getOriginalFile()));
            if (module == null) {
                return;
            }
            Module module2 = module;
            if (!FlaskConfigurationKt.getFlaskConfiguration(module2).isFlaskEnabled()) {
                return;
            }
            for (FlaskConfigKey key : FlaskConfigRegistry.INSTANCE.all()) {
                StringBuilder stringBuilder;
                LookupElementBuilder builder;
                Intrinsics.checkNotNullExpressionValue((Object)LookupElementBuilder.create((String)key.getName()).withIcon(PythonUltimateIcons.Flask.FlaskLogo).withTypeText(key.getValueType().getDisplayName(), true).withInsertHandler(this.CLOSE_QUOTE_HANDLER), (String)"withInsertHandler(...)");
                if (key.getDeprecatedSince() != null) {
                    LookupElementBuilder lookupElementBuilder = builder.withStrikeoutness(true);
                    Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withStrikeoutness(...)");
                    builder = lookupElementBuilder;
                }
                StringBuilder $this$addCompletions_u24lambda_u240 = stringBuilder = new StringBuilder();
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)key.getValueType().name().toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                if (key.getSinceVersion() != null) {
                    $this$addCompletions_u24lambda_u240.append(" (since " + key.getSinceVersion() + ")");
                }
                if (key.getDeprecatedSince() != null) {
                    $this$addCompletions_u24lambda_u240.append(" (deprecated since " + key.getDeprecatedSince() + ")");
                }
                if (key.getDoc() != null) {
                    $this$addCompletions_u24lambda_u240.append(" \u2014 " + key.getDoc());
                }
                String tailText = stringBuilder.toString();
                if (((CharSequence)tailText).length() > 0) {
                    LookupElementBuilder lookupElementBuilder = builder.withTailText(tailText, false);
                    Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withTailText(...)");
                    builder = lookupElementBuilder;
                }
                result.addElement((LookupElement)builder);
            }
        }

        private static final void CLOSE_QUOTE_HANDLER$lambda$0(InsertionContext context, LookupElement lookupElement) {
            int n;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)lookupElement, (String)"<unused var>");
            Document document = context.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document doc = document;
            CharSequence charSequence = doc.getCharsSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
            CharSequence text = charSequence;
            int start = context.getStartOffset();
            int end = context.getTailOffset();
            char c = context.getCompletionChar();
            if (c == '\"' || c == '\'') {
                context.setAddCompletionChar(false);
                n = c;
            } else {
                n = start > 0 && (text.charAt(start - 1) == '\"' || text.charAt(start - 1) == '\'') ? (int)text.charAt(start - 1) : (end < text.length() && (text.charAt(end) == '\"' || text.charAt(end) == '\'') ? (int)text.charAt(end) : 34);
            }
            char c2 = n;
            int nextIdx = CharArrayUtil.shiftForward((CharSequence)text, (int)end, (String)" \t");
            if (nextIdx < text.length() && text.charAt(nextIdx) == c2) {
                context.getEditor().getCaretModel().moveToOffset(nextIdx + 1);
            } else {
                doc.insertString(end, (CharSequence)String.valueOf(c2));
                context.commitDocument();
                context.getEditor().getCaretModel().moveToOffset(end + 1);
            }
        }
    }
}

