/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.flask.endpoints;

import com.intellij.microservices.url.UrlConstants;
import com.intellij.psi.util.QualifiedName;
import com.intellij.python.endpoints.CommonKt;
import com.intellij.python.endpoints.HttpHandler;
import com.intellij.python.endpoints.ObjectUID;
import com.intellij.python.endpoints.PsiFileAnchor;
import com.intellij.python.endpoints.RouterAttachment;
import com.intellij.python.endpoints.RouterIndexKt;
import com.intellij.python.endpoints.Variable;
import com.intellij.python.endpoints.VariablesCallsVisitor;
import com.intellij.python.pro.flask.FlaskFQNamesProvider;
import com.intellij.python.pro.flask.endpoints.RuleOptions;
import com.jetbrains.python.nameResolver.FQNamesProvider;
import com.jetbrains.python.nameResolver.NameResolverTools;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyReferenceExpression;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000fH\u0002J&\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/python/pro/flask/endpoints/FlaskVariablesCallsVisitor;", "Lcom/intellij/python/endpoints/VariablesCallsVisitor;", "variables", "", "", "Lcom/intellij/python/endpoints/Variable;", "<init>", "(Ljava/util/Map;)V", "onAddUrlRule", "", "objectUID", "Lcom/intellij/python/endpoints/ObjectUID;", "node", "Lcom/jetbrains/python/psi/PyCallExpression;", "onEndpoint", "Lcom/jetbrains/python/psi/PyDecorator;", "onRoute", "httpMethods", "", "onRegisterBlueprint", "visitPyCallExpression", "visitPyDecorator", "intellij.python"})
@SourceDebugExtension(value={"SMAP\nFlaskRouterIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlaskRouterIndex.kt\ncom/intellij/python/pro/flask/endpoints/FlaskVariablesCallsVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1#2:142\n*E\n"})
public final class FlaskVariablesCallsVisitor
extends VariablesCallsVisitor {
    public FlaskVariablesCallsVisitor(@NotNull Map<String, Variable> variables) {
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        super(variables);
    }

    private final void onAddUrlRule(ObjectUID objectUID, PyCallExpression node) {
        String string = CommonKt.resolveStringArgument(node, 0, "rule");
        if (string == null) {
            return;
        }
        String rule = string;
        PyReferenceExpression viewFunc = (PyReferenceExpression)node.getArgument(2, "view_func", PyReferenceExpression.class);
        String string2 = CommonKt.resolveStringArgument(node, 1, "endpoint");
        if (string2 == null) {
            PyReferenceExpression pyReferenceExpression = viewFunc;
            string2 = pyReferenceExpression != null ? pyReferenceExpression.getName() : null;
        }
        String endpoint = string2;
        List<String> httpMethods = new RuleOptions(node).methods();
        PyReferenceExpression pyReferenceExpression = viewFunc;
        HttpHandler httpHandler = new HttpHandler(RouterIndexKt.toPsiFileAnchor((PyElement)node), pyReferenceExpression != null ? RouterIndexKt.toPsiFileAnchor((PyElement)pyReferenceExpression) : null, endpoint, rule, httpMethods);
        this.getBuilder().addHttpHandler(objectUID, httpHandler);
    }

    private final void onEndpoint(ObjectUID objectUID, PyDecorator node) {
        String string = CommonKt.resolveStringArgument((PyCallExpression)node, 0, "endpoint");
        if (string == null) {
            return;
        }
        String endpoint = string;
        PyFunction pyFunction = node.getTarget();
        if (pyFunction == null) {
            return;
        }
        PyFunction target = pyFunction;
        this.getBuilder().addNamedReference(objectUID, endpoint, RouterIndexKt.toPsiFileAnchor((PyElement)target));
    }

    private final void onRoute(ObjectUID objectUID, PyDecorator node, List<String> httpMethods) {
        String string = CommonKt.resolveStringArgument((PyCallExpression)node, 0, "rule");
        if (string == null) {
            return;
        }
        String rule = string;
        PsiFileAnchor psiFileAnchor = RouterIndexKt.toPsiFileAnchor((PyElement)node);
        HttpHandler httpHandler = new HttpHandler(rule, httpMethods, psiFileAnchor);
        this.getBuilder().addHttpHandler(objectUID, httpHandler);
    }

    private final void onRegisterBlueprint(ObjectUID objectUID, PyCallExpression node) {
        PyReferenceExpression pyReferenceExpression = (PyReferenceExpression)node.getArgument(0, "blueprint", PyReferenceExpression.class);
        if (pyReferenceExpression == null) {
            return;
        }
        PyReferenceExpression blueprint = pyReferenceExpression;
        QualifiedName qualifiedName = blueprint.asQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        QualifiedName refName = qualifiedName;
        Object object = this.getVariables().get(refName.getFirstComponent());
        if (object == null || (object = ((Variable)object).getObjectUID()) == null) {
            return;
        }
        Object refObjectUID = object;
        String string = refName.removeHead(1).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String refObjectContext = string;
        String string2 = CommonKt.resolveStringArgument$default(node, null, "url_prefix", 1, null);
        if (string2 == null) {
            string2 = "";
        }
        String prefix = string2;
        RouterAttachment routerAttachment = new RouterAttachment(RouterIndexKt.toPsiFileAnchor((PyElement)node), RouterIndexKt.toPsiFileAnchor((PyElement)blueprint), prefix, (ObjectUID)refObjectUID, refObjectContext, null, 32, null);
        this.getBuilder().addAttachment(objectUID, routerAttachment);
    }

    @Override
    public void visitPyCallExpression(@NotNull PyCallExpression node, @NotNull ObjectUID objectUID) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)objectUID, (String)"objectUID");
        FQNamesProvider[] fQNamesProviderArray = new FQNamesProvider[]{FlaskFQNamesProvider.REGISTER_BLUEPRINT};
        if (NameResolverTools.isCalleeShortCut((PyCallExpression)node, (FQNamesProvider[])fQNamesProviderArray)) {
            this.onRegisterBlueprint(objectUID, node);
        } else {
            fQNamesProviderArray = new FQNamesProvider[]{FlaskFQNamesProvider.ADD_URL_RULE};
            if (NameResolverTools.isCalleeShortCut((PyCallExpression)node, (FQNamesProvider[])fQNamesProviderArray)) {
                this.onAddUrlRule(objectUID, node);
            }
        }
    }

    @Override
    public void visitPyDecorator(@NotNull PyDecorator node, @NotNull ObjectUID objectUID) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)objectUID, (String)"objectUID");
        FQNamesProvider[] fQNamesProviderArray = new FQNamesProvider[]{FlaskFQNamesProvider.ENDPOINT};
        if (NameResolverTools.isCalleeShortCut((PyCallExpression)((PyCallExpression)node), (FQNamesProvider[])fQNamesProviderArray)) {
            this.onEndpoint(objectUID, node);
        } else {
            fQNamesProviderArray = new FQNamesProvider[]{FlaskFQNamesProvider.ROUTE};
            if (NameResolverTools.isCalleeShortCut((PyCallExpression)((PyCallExpression)node), (FQNamesProvider[])fQNamesProviderArray)) {
                this.onRoute(objectUID, node, new RuleOptions((PyCallExpression)node).methods());
            } else {
                String string;
                PyFunction pyFunction = node.getTarget();
                if (!(pyFunction != null ? !pyFunction.isAsync() : false)) {
                    return;
                }
                Object object = node.getCallee();
                if (object == null || (object = object.getName()) == null) {
                    return;
                }
                Object calleeName = object;
                String string2 = ((String)calleeName).toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                String it = string = string2;
                boolean bl = false;
                String string3 = UrlConstants.HTTP_METHODS.contains(it) ? string : null;
                if (string3 == null) {
                    return;
                }
                String httpMethod = string3;
                this.onRoute(objectUID, node, CollectionsKt.listOf((Object)httpMethod));
            }
        }
    }
}

