/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.sqlalchemy;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.ast.PyAstDecorator;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.IntentionalUnstubbing;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyCallableTypeImpl;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeProviderBase;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.PyUnsafeUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SQLAlchemyTypeProvider
extends PyTypeProviderBase {
    private static final Map<String, String> ourQNameToClass = ImmutableMap.builder().put((Object)"Interval", (Object)"datetime.timedelta").put((Object)"DateTime", (Object)"datetime.datetime").put((Object)"Date", (Object)"datetime.date").put((Object)"Time", (Object)"datetime.time").put((Object)"Numeric", (Object)"decimal.Decimal").build();
    private static final Map<String, String> ourEngineToClass = ImmutableMap.builder().put((Object)"plain", (Object)"sqlalchemy.engine.base.Engine").put((Object)"threadlocal", (Object)"sqlalchemy.engine.threadlocal.TLEngine").put((Object)"mock", (Object)"sqlalchemy.engine.strategies.MockEngineStrategy.MockConnection").build();
    private static final Map<String, String> ourQNameToBuiltin = ImmutableMap.builder().put((Object)"Integer", (Object)"int").put((Object)"Numeric", (Object)"float").put((Object)"Boolean", (Object)"bool").build();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Ref<PyType> getReferenceType(@NotNull PsiElement referenceTarget, @NotNull TypeEvalContext context, @Nullable PsiElement anchor) {
        if (referenceTarget == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(1);
        }
        PyResolveContext resolveContext = PyResolveContext.defaultContext((TypeEvalContext)context);
        if (referenceTarget instanceof PyTargetExpression) {
            PyTargetExpression target = (PyTargetExpression)referenceTarget;
            if (referenceTarget.getContainingFile() instanceof PyFile) {
                PyCallExpression call;
                QualifiedName calleeName = target.getCalleeName();
                PyFile pyFile = (PyFile)target.getContainingFile();
                if (SQLAlchemyTypeProvider.isColumnDefinition(target, context)) {
                    PyCallExpression call2 = (PyCallExpression)IntentionalUnstubbing.onFileOf((PsiElement)target, () -> (PyCallExpression)PyUtil.as((Object)target.findAssignedValue(), PyCallExpression.class));
                    if (call2 != null) {
                        int index;
                        PyExpression typeArgument = call2.getKeywordArgument("type_");
                        if (typeArgument != null) {
                            return Ref.create((Object)SQLAlchemyTypeProvider.getColumnType(typeArgument, context));
                        }
                        PyExpression[] args = call2.getArguments();
                        int n = index = args.length > 0 && args[0] instanceof PyStringLiteralExpression ? 1 : 0;
                        if (args.length > index) {
                            return Ref.create((Object)SQLAlchemyTypeProvider.getColumnType(args[index], context));
                        }
                    }
                } else if (SQLAlchemyTypeProvider.isRelationshipDefinition(target, context) && (call = (PyCallExpression)IntentionalUnstubbing.onFileOf((PsiElement)target, () -> (PyCallExpression)PyUtil.as((Object)target.findAssignedValue(), PyCallExpression.class))) != null) {
                    StreamEx modelReferenceTypes;
                    boolean isManyToMany;
                    PyBuiltinCache instance = PyBuiltinCache.getInstance((PsiElement)call);
                    PyClass list = instance.getClass("list");
                    if (list == null) {
                        return null;
                    }
                    PyExpression modelReference = (PyExpression)call.getArgument(0, PyExpression.class);
                    boolean bl = isManyToMany = call.getKeywordArgument("secondary") != null;
                    if (modelReference instanceof PyReferenceExpression) {
                        modelReferenceTypes = PyTypeUtil.toStream((PyType)context.getType((PyTypedElement)modelReference));
                        return ((StreamEx)modelReferenceTypes.select(PyClassType.class).filter(x -> SQLAlchemyTypeProvider.isDeclarativeModelClass(x.getPyClass(), context))).map(PyClassType::toInstance).map(x -> isManyToMany ? new PyCollectionTypeImpl(list, false, Collections.singletonList(x)) : x).select(PyType.class).foldLeft(PyUnionType::union).map(Ref::create).orElse(null);
                    } else {
                        if (!(modelReference instanceof PyStringLiteralExpression)) return null;
                        String stringValue = ((PyStringLiteralExpression)modelReference).getStringValue();
                        QualifiedName referencedName = QualifiedName.fromDottedString((String)stringValue);
                        modelReferenceTypes = StreamEx.of((Collection)PyResolveUtil.resolveQualifiedNameInScope((QualifiedName)referencedName, (ScopeOwner)pyFile, (TypeEvalContext)context)).select(PyTypedElement.class).map(arg_0 -> ((TypeEvalContext)context).getType(arg_0));
                    }
                    return ((StreamEx)modelReferenceTypes.select(PyClassType.class).filter(x -> SQLAlchemyTypeProvider.isDeclarativeModelClass(x.getPyClass(), context))).map(PyClassType::toInstance).map(x -> isManyToMany ? new PyCollectionTypeImpl(list, false, Collections.singletonList(x)) : x).select(PyType.class).foldLeft(PyUnionType::union).map(Ref::create).orElse(null);
                }
                if (calleeName == null || !SQLAlchemyTypeProvider.resolvesToQualifiedNameOwner(calleeName, pyFile, context, PyFunction.class, "sqlalchemy.orm.decl_api.declarative_base", "sqlalchemy.ext.declarative.declarative_base")) return null;
                return PyTypeUtil.notNullToRef((PyType)SQLAlchemyTypeProvider.getDeclarativeBaseStubType((PsiElement)target));
            }
        }
        if (!(referenceTarget instanceof PyFunction)) return null;
        return PyTypeUtil.notNullToRef((PyType)SQLAlchemyTypeProvider.getHybridPropertyType((PyFunction)referenceTarget, resolveContext));
    }

    private static boolean isColumnDefinition(@NotNull PyTargetExpression target, @NotNull TypeEvalContext context) {
        PyFile pyFile;
        PsiFile psiFile;
        if (target == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(2);
        }
        if (context == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(3);
        }
        if (!(ScopeUtil.getScopeOwner((PsiElement)target) instanceof PyClass)) {
            return false;
        }
        QualifiedName calleeName = target.getCalleeName();
        return calleeName != null && (psiFile = target.getContainingFile()) instanceof PyFile && (SQLAlchemyTypeProvider.resolvesToQualifiedNameOwner(calleeName, pyFile = (PyFile)psiFile, context, PyClass.class, "sqlalchemy.sql.schema.Column") || SQLAlchemyTypeProvider.resolvesToQualifiedNameOwner(calleeName, pyFile, context, PyFunction.class, "sqlalchemy.orm._orm_constructors.mapped_column", "sqlalchemy.orm.properties.MappedColumn"));
    }

    @Nullable
    private static PyCollectionType getMappedTypeFromAnnotation(@NotNull PyTargetExpression target, @NotNull TypeEvalContext context) {
        PyCollectionType genericType;
        PyType annotatedType;
        if (target == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(4);
        }
        if (context == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(5);
        }
        if ((annotatedType = (PyType)Ref.deref((Ref)new PyTypingTypeProvider().getReferenceType((PsiElement)target, context, (PsiElement)target))) instanceof PyCollectionType && "sqlalchemy.orm.base.Mapped".equals((genericType = (PyCollectionType)annotatedType).getClassQName())) {
            return genericType;
        }
        return null;
    }

    private static boolean isRelationshipDefinition(@NotNull PyTargetExpression target, @NotNull TypeEvalContext context) {
        if (target == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(6);
        }
        if (context == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(7);
        }
        if (!(ScopeUtil.getScopeOwner((PsiElement)target) instanceof PyClass)) {
            return false;
        }
        QualifiedName calleeName = target.getCalleeName();
        PyFile pyFile = (PyFile)PyUtil.as((Object)target.getContainingFile(), PyFile.class);
        return calleeName != null && pyFile != null && SQLAlchemyTypeProvider.resolvesToQualifiedNameOwner(calleeName, pyFile, context, PyQualifiedNameOwner.class, "sqlalchemy.orm.relation", "sqlalchemy.orm.relationship");
    }

    @Nullable
    private PyType createTypeForArgument(@NotNull PyTargetExpression attr, @NotNull TypeEvalContext context) {
        PyCollectionType mappedColumnType;
        if (attr == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(8);
        }
        if (context == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(9);
        }
        if ((mappedColumnType = SQLAlchemyTypeProvider.getMappedTypeFromAnnotation(attr, context)) != null) {
            return mappedColumnType.getIteratedItemType();
        }
        return context.getType((PyTypedElement)attr);
    }

    @Nullable
    public PyType getReferenceExpressionType(@NotNull PyReferenceExpression referenceExpression, @NotNull TypeEvalContext context) {
        List resolved;
        PyClassType qualifierType;
        PyClass modelClass;
        if (referenceExpression == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(10);
        }
        if (context == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(11);
        }
        PyResolveContext resolveContext = PyResolveContext.defaultContext((TypeEvalContext)context);
        PyCallExpression call = (PyCallExpression)PyUtil.as((Object)referenceExpression.getParent(), PyCallExpression.class);
        if (call != null && (modelClass = SQLAlchemyTypeProvider.findDeclarativeModelClass(referenceExpression.getReference(resolveContext), context)) != null) {
            if (modelClass.findInitOrNew(false, context) != null) {
                return null;
            }
            List allClassAttributes = modelClass.getClassAttributesInherited(context);
            List parameters = ((StreamEx)StreamEx.of((Collection)allClassAttributes).filter(target -> SQLAlchemyTypeProvider.isColumnDefinition(target, context) || SQLAlchemyTypeProvider.isRelationshipDefinition(target, context) || SQLAlchemyTypeProvider.getMappedTypeFromAnnotation(target, context) != null)).map(attr -> PyCallableParameterImpl.nonPsi((String)attr.getName(), (PyType)this.createTypeForArgument((PyTargetExpression)attr, context), (PyExpression)SQLAlchemyTypeProvider.getColumnDefaultValue(attr, context))).toList();
            return new PyCallableTypeImpl(parameters, (PyType)new PyClassTypeImpl(modelClass, false));
        }
        PyExpression qualifier = referenceExpression.getQualifier();
        if (qualifier != null && (qualifierType = (PyClassType)PyUtil.as((Object)context.getType((PyTypedElement)qualifier), PyClassType.class)) != null && qualifierType.isDefinition() && SQLAlchemyTypeProvider.isDeclarativeModelClass(qualifierType.getPyClass(), context) && StreamEx.of((Collection)(resolved = PyUtil.multiResolveTopPriority((PsiElement)referenceExpression, (PyResolveContext)resolveContext))).select(PyTargetExpression.class).anyMatch(e -> SQLAlchemyTypeProvider.isColumnDefinition(e, context) && SQLAlchemyTypeProvider.getMappedTypeFromAnnotation(e, context) == null)) {
            return (PyType)StreamEx.of((Collection)resolved).select(PyTypedElement.class).map(elem -> {
                PyTargetExpression target;
                if (elem instanceof PyTargetExpression && SQLAlchemyTypeProvider.isColumnDefinition(target = (PyTargetExpression)elem, context)) {
                    return SQLAlchemyTypeProvider.getClassType((PsiElement)elem, "sqlalchemy.orm.attributes.InstrumentedAttribute", false);
                }
                return context.getType(elem);
            }).collect(PyTypeUtil.toUnion());
        }
        return null;
    }

    @Nullable
    private static PyClass findDeclarativeModelClass(@NotNull PsiPolyVariantReference reference, @NotNull TypeEvalContext context) {
        if (reference == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(12);
        }
        if (context == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(13);
        }
        return StreamEx.of((Collection)PyUtil.multiResolveTopPriority((PsiPolyVariantReference)reference)).select(PyClass.class).findFirst(cls -> SQLAlchemyTypeProvider.isDeclarativeModelClass(cls, context)).orElse(null);
    }

    public static boolean isDeclarativeModelClass(@NotNull PyClass pyClass, @NotNull TypeEvalContext context) {
        PyClassLikeType metaClass;
        if (pyClass == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(14);
        }
        if (context == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(15);
        }
        if ((metaClass = pyClass.getMetaClassType(true, context)) instanceof PyClassType && ((PyClassType)metaClass).getPyClass() == SQLAlchemyTypeProvider.getDeclarativeMetaClass((PsiElement)pyClass)) {
            return true;
        }
        List ancestors = pyClass.getAncestorClasses(context);
        PyClass declarativeModelStub = (PyClass)ObjectUtils.doIfNotNull((Object)SQLAlchemyTypeProvider.getDeclarativeBaseStubType((PsiElement)pyClass), PyClassType::getPyClass);
        boolean isDeclarativeModel = ContainerUtil.exists((Iterable)ancestors, cls -> SQLAlchemyTypeProvider.isDecoratedWithAsDeclarative(cls, context) || cls.equals((Object)declarativeModelStub));
        boolean isMappedAsDataclass = ContainerUtil.exists((Iterable)ancestors, cls -> cls.getQualifiedName() != null && cls.getQualifiedName().equals("sqlalchemy.orm.decl_api.MappedAsDataclass"));
        return isDeclarativeModel && !isMappedAsDataclass;
    }

    private static boolean isDecoratedWithAsDeclarative(@NotNull PyClass pyClass, @NotNull TypeEvalContext context) {
        if (pyClass == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(16);
        }
        if (context == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(17);
        }
        PyDecoratorList decoratorList = pyClass.getDecoratorList();
        PsiFile file = pyClass.getContainingFile();
        if (decoratorList != null && file instanceof PyFile) {
            return StreamEx.of((Object[])decoratorList.getDecorators()).map(PyAstDecorator::getQualifiedName).nonNull().anyMatch(qn -> SQLAlchemyTypeProvider.resolvesToQualifiedNameOwner(qn, (PyFile)file, context, PyFunction.class, "sqlalchemy.orm.decl_api.as_declarative"));
        }
        return false;
    }

    private static boolean resolvesToQualifiedNameOwner(@NotNull QualifiedName actual, @NotNull PyFile anchor, @NotNull TypeEvalContext context, @NotNull Class<? extends PyQualifiedNameOwner> expectedClass, String ... expected) {
        if (actual == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(18);
        }
        if (anchor == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(19);
        }
        if (context == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(20);
        }
        if (expectedClass == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(21);
        }
        if (expected == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(22);
        }
        List expectedQualified = ContainerUtil.map((Object[])expected, QualifiedName::fromDottedString);
        HashSet expectedUnique = Sets.newHashSet((Object[])expected);
        if (ContainerUtil.exists((Iterable)expectedQualified, qn -> actual.endsWith(qn.getLastComponent()))) {
            return StreamEx.of((Collection)PyResolveUtil.resolveQualifiedNameInScope((QualifiedName)actual, (ScopeOwner)anchor, (TypeEvalContext)context)).select(expectedClass).map(PyQualifiedNameOwner::getQualifiedName).anyMatch(expectedUnique::contains);
        }
        return false;
    }

    @Nullable
    public static PyClassType getDeclarativeBaseStubType(@NotNull PsiElement anchor) {
        PyPsiFacade facade;
        PyClass declApiClass;
        if (anchor == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(23);
        }
        if ((declApiClass = (facade = PyPsiFacade.getInstance((Project)anchor.getProject())).createClassByQName("sqlalchemy.orm.decl_api.DeclarativeBase", anchor)) != null) {
            return facade.createClassType(declApiClass, true);
        }
        QualifiedName declApiFqn = QualifiedName.fromDottedString((String)"sqlalchemy.orm.decl_api._DeclarativeBase").removeLastComponent();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)ObjectUtils.notNull((Object)anchor.getContainingFile(), (Object)anchor)));
        if (module == null) {
            return null;
        }
        PyQualifiedNameResolveContext resolveContext = PyResolveImportUtil.fromModule((Module)module).copyWithMembers();
        PyiFile declApiStub = StreamEx.of((Collection)PyResolveImportUtil.resolveQualifiedName((QualifiedName)declApiFqn, (PyQualifiedNameResolveContext)resolveContext)).select(PyiFile.class).findFirst().orElse(null);
        if (declApiStub == null) {
            return null;
        }
        PyClass declarativeBaseStub = StreamEx.of((Collection)declApiStub.multiResolveName("_DeclarativeBase", false)).map(RatedResolveResult::getElement).select(PyClass.class).findFirst().orElse(null);
        if (declarativeBaseStub == null) {
            return null;
        }
        return facade.createClassType(declarativeBaseStub, true);
    }

    @Nullable
    private static PyClass getDeclarativeMetaClass(@NotNull PsiElement anchor) {
        if (anchor == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(24);
        }
        PyPsiFacade facade = PyPsiFacade.getInstance((Project)anchor.getProject());
        return facade.createClassByQName("sqlalchemy.orm.decl_api.DeclarativeMeta", anchor);
    }

    @Nullable
    private static PyClassType getClassType(@NotNull PsiElement anchor, @NotNull String qualifiedName, boolean isDefinition) {
        PyPsiFacade facade;
        PyClass pyClass;
        if (anchor == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(25);
        }
        if (qualifiedName == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(26);
        }
        return (pyClass = (facade = PyPsiFacade.getInstance((Project)anchor.getProject())).createClassByQName(qualifiedName, anchor)) != null ? facade.createClassType(pyClass, isDefinition) : null;
    }

    @Nullable
    private static PyType getHybridPropertyType(@NotNull PyFunction target, @NotNull PyResolveContext resolveContext) {
        PyDecoratorList decoratorList;
        if (target == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(27);
        }
        if (resolveContext == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(28);
        }
        if ((decoratorList = target.getDecoratorList()) != null) {
            PyPsiFacade pyPsiFacade = PyPsiFacade.getInstance((Project)target.getProject());
            PyClass hybridPropertyClass = pyPsiFacade.createClassByQName("sqlalchemy.ext.hybrid.hybrid_property", (PsiElement)target);
            if (hybridPropertyClass == null) {
                return null;
            }
            if (decoratorList.findDecorator("hybrid_property") != null) {
                return new PyClassTypeImpl(hybridPropertyClass, false);
            }
            boolean resolvesToHybridProperty = Arrays.stream(decoratorList.getDecorators()).filter(decorator -> {
                QualifiedName qualifiedName = decorator.getQualifiedName();
                return qualifiedName != null && ArrayUtil.contains((String)qualifiedName.getLastComponent(), (String[])new String[]{"setter", "deleter", "getter", "expression", "comparator"});
            }).flatMap(decorator -> decorator.multiResolveCalleeFunction(resolveContext).stream()).map(PyQualifiedNameOwner::getQualifiedName).anyMatch(callableQName -> callableQName != null && callableQName.startsWith("sqlalchemy.ext.hybrid.hybrid_property"));
            if (resolvesToHybridProperty) {
                return new PyClassTypeImpl(hybridPropertyClass, false);
            }
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getEngineType(@NotNull PyCallExpression callExpr) {
        PyExpression argument;
        if (callExpr == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(29);
        }
        String strategy = (argument = callExpr.getKeywordArgument("strategy")) instanceof PyStringLiteralExpression ? ((PyStringLiteralExpression)argument).getStringValue() : "plain";
        return Optional.ofNullable(ourEngineToClass.get(strategy)).map(className -> PyClassTypeImpl.createTypeByQName((PsiElement)callExpr, (String)className, (boolean)false)).map(Ref::create).orElse(null);
    }

    @Nullable
    public Ref<PyType> getCallType(@NotNull PyFunction function, @NotNull PyCallSiteExpression callSite, @NotNull TypeEvalContext context) {
        PyDecoratorList decoratorList;
        if (function == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(30);
        }
        if (callSite == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(31);
        }
        if (context == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(32);
        }
        if ((decoratorList = function.getDecoratorList()) != null) {
            PyClass containingClass = function.getContainingClass();
            if (containingClass == null) {
                return null;
            }
            for (PyDecorator decorator : decoratorList.getDecorators()) {
                PyResolveContext resolveContext;
                boolean resolvesToGenerative;
                if (!"_generative".equals(decorator.getName()) || !(resolvesToGenerative = decorator.multiResolveCalleeFunction(resolveContext = PyResolveContext.defaultContext((TypeEvalContext)context)).stream().map(PyQualifiedNameOwner::getQualifiedName).anyMatch(qName -> "sqlalchemy.sql.expression._generative".equals(qName) || "sqlalchemy.orm.query._generative".equals(qName)))) continue;
                return Ref.create((Object)new PyClassTypeImpl(containingClass, false));
            }
        }
        if (callSite instanceof PyCallExpression && "sqlalchemy.engine.create_engine".equals(function.getQualifiedName())) {
            return SQLAlchemyTypeProvider.getEngineType((PyCallExpression)callSite);
        }
        return null;
    }

    @Nullable
    private static PyType getColumnType(@Nullable PyExpression expression, @NotNull TypeEvalContext context) {
        if (context == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(33);
        }
        if (expression instanceof PyCallExpression) {
            expression = ((PyCallExpression)expression).getCallee();
        }
        if (!(expression instanceof PyReferenceExpression)) {
            return null;
        }
        PyResolveContext resolveContext = PyResolveContext.defaultContext((TypeEvalContext)context);
        PsiElement result = ((PyReferenceExpression)expression).getReference(resolveContext).resolve();
        if (result instanceof PyFunction) {
            result = PyUtil.turnConstructorIntoClass((PyFunction)((PyFunction)result));
        }
        if (!(result instanceof PyClass)) {
            return null;
        }
        Property pythonType = ((PyClass)result).findProperty("python_type", true, null);
        if (pythonType != null && pythonType.getGetter().isDefined()) {
            PyCallable value2 = (PyCallable)pythonType.getGetter().value();
            if (!(value2 instanceof PyFunction)) {
                return null;
            }
            PyClass containingClass = ((PyFunction)value2).getContainingClass();
            if (containingClass == null) {
                return null;
            }
            return SQLAlchemyTypeProvider.getColumnType(containingClass);
        }
        return null;
    }

    @Nullable
    private static PyType getColumnType(@NotNull PyClass columnClass) {
        PyClassType classType;
        String builtinName;
        PyClass aClass;
        if (columnClass == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(34);
        }
        PyBuiltinCache cache = PyBuiltinCache.getInstance((PsiElement)columnClass);
        String text = columnClass.getName();
        assert (text != null);
        if (text.equals("String")) {
            return cache.getStringType(LanguageLevel.forElement((PsiElement)columnClass));
        }
        if (text.equals("_Binary")) {
            return cache.getBytesType(LanguageLevel.forElement((PsiElement)columnClass));
        }
        ArrayList<Object> classTypes = new ArrayList<Object>();
        String className = ourQNameToClass.get(text);
        if (className != null && (aClass = PyPsiFacade.getInstance((Project)columnClass.getProject()).createClassByQName(className, (PsiElement)columnClass)) != null) {
            classTypes.add(new PyClassTypeImpl(aClass, false));
        }
        if ((builtinName = ourQNameToBuiltin.get(text)) != null && (classType = cache.getObjectType(builtinName)) != null) {
            classTypes.add(classType);
        }
        if (!classTypes.isEmpty()) {
            return PyUnsafeUnionType.unsafeUnion(classTypes);
        }
        return null;
    }

    @NotNull
    private static PyExpression getColumnDefaultValue(@NotNull PyTargetExpression target, @NotNull TypeEvalContext context) {
        PyCallExpression callExpression;
        if (target == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(35);
        }
        if (context == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(36);
        }
        PyElementGenerator generator = PyElementGenerator.getInstance((Project)target.getProject());
        PyExpression defaultExpression = generator.createExpressionFromText(LanguageLevel.forElement((PsiElement)target), "None");
        if (context.maySwitchToAST((PsiElement)target) && (callExpression = (PyCallExpression)PyUtil.as((Object)target.findAssignedValue(), PyCallExpression.class)) != null) {
            for (PyExpression arg : callExpression.getArguments()) {
                if (arg.getName() == null || !arg.getName().equals("default") || !(arg instanceof PyKeywordArgument)) continue;
                PyKeywordArgument keywordArgument = (PyKeywordArgument)arg;
                PyExpression defaultValueExpr = keywordArgument.getValueExpression();
                if (defaultValueExpr == null) break;
                defaultExpression = defaultValueExpr;
                break;
            }
        }
        PyExpression pyExpression = defaultExpression;
        if (pyExpression == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(37);
        }
        return pyExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceTarget";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 32: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 27: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actual";
                break;
            }
            case 19: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedClass";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpr";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSite";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnClass";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/pro/sqlalchemy/SQLAlchemyTypeProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/pro/sqlalchemy/SQLAlchemyTypeProvider";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnDefaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isColumnDefinition";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMappedTypeFromAnnotation";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isRelationshipDefinition";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTypeForArgument";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceExpressionType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findDeclarativeModelClass";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isDeclarativeModelClass";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isDecoratedWithAsDeclarative";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "resolvesToQualifiedNameOwner";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarativeBaseStubType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarativeMetaClass";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getClassType";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getHybridPropertyType";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getEngineType";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getCallType";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getColumnType";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getColumnDefaultValue";
                break;
            }
            case 37: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 37 -> new IllegalStateException(string);
        };
    }
}

