/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.statistics;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.platform.feedback.InIdeFeedbackSurveyConfig;
import com.intellij.platform.feedback.dialog.BlockBasedFeedbackDialog;
import com.intellij.platform.feedback.dialog.SystemDataJsonSerializable;
import com.intellij.platform.feedback.impl.notification.RequestFeedbackNotification;
import com.intellij.python.pro.statistics.PythonWebSurveyDialog;
import com.intellij.ui.LicensingFacade;
import com.intellij.util.PlatformUtils;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.psi.resolve.PackageAvailabilityKt;
import com.jetbrains.python.psi.resolve.PackageAvailabilitySpec;
import com.jetbrains.python.sdk.PySdkExtKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.LocalDate;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\rH\u0016J \u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\rH\u0016J\b\u0010\u001a\u001a\u00020\rH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lcom/intellij/python/pro/statistics/PythonWebFeedbackSurveyConfig;", "Lcom/intellij/platform/feedback/InIdeFeedbackSurveyConfig;", "<init>", "()V", "surveyId", "", "getSurveyId", "()Ljava/lang/String;", "lastDayOfFeedbackCollection", "Lkotlinx/datetime/LocalDate;", "getLastDayOfFeedbackCollection", "()Lkotlinx/datetime/LocalDate;", "requireIdeEAP", "", "getRequireIdeEAP", "()Z", "checkIdeIsSuitable", "checkExtraConditionSatisfied", "project", "Lcom/intellij/openapi/project/Project;", "createNotification", "Lcom/intellij/platform/feedback/impl/notification/RequestFeedbackNotification;", "forTest", "createFeedbackDialog", "Lcom/intellij/platform/feedback/dialog/BlockBasedFeedbackDialog;", "Lcom/intellij/platform/feedback/dialog/SystemDataJsonSerializable;", "isApplicableLicense", "updateStateAfterNotificationShowed", "", "updateStateAfterDialogClosedOk", "Companion", "intellij.python"})
@SourceDebugExtension(value={"SMAP\nPythonWebFeedbackSurveyConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonWebFeedbackSurveyConfig.kt\ncom/intellij/python/pro/statistics/PythonWebFeedbackSurveyConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1807#2,3:67\n*S KotlinDebug\n*F\n+ 1 PythonWebFeedbackSurveyConfig.kt\ncom/intellij/python/pro/statistics/PythonWebFeedbackSurveyConfig\n*L\n28#1:67,3\n*E\n"})
public final class PythonWebFeedbackSurveyConfig
implements InIdeFeedbackSurveyConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String surveyId;
    @NotNull
    private final LocalDate lastDayOfFeedbackCollection = new LocalDate(2025, 2, 15);
    private final boolean requireIdeEAP;
    @NotNull
    private static final List<PackageAvailabilitySpec> WEB_FRAMEWORK_MARKERS;

    public PythonWebFeedbackSurveyConfig() {
        this.surveyId = "pycharm_web_experience_survey";
    }

    @NotNull
    public String getSurveyId() {
        return this.surveyId;
    }

    @NotNull
    public LocalDate getLastDayOfFeedbackCollection() {
        return this.lastDayOfFeedbackCollection;
    }

    public boolean getRequireIdeEAP() {
        return this.requireIdeEAP;
    }

    public boolean checkIdeIsSuitable() {
        return PlatformUtils.isPyCharmPro();
    }

    public boolean checkExtraConditionSatisfied(@NotNull Project project) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (!this.isApplicableLicense()) {
                return false;
            }
            Sdk sdk = PySdkExtKt.getPythonSdk((Project)project);
            if (sdk == null) {
                return false;
            }
            Sdk sdk2 = sdk;
            Iterable $this$any$iv = WEB_FRAMEWORK_MARKERS;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PackageAvailabilitySpec it = (PackageAvailabilitySpec)element$iv;
                    boolean bl2 = false;
                    if (!PackageAvailabilityKt.isPackageAvailable((Project)project, (Sdk)sdk2, (PackageAvailabilitySpec)it)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public RequestFeedbackNotification createNotification(@NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = PythonProBundle.message((String)"python.web.survey.notification.group");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = PythonProBundle.message((String)"python.web.survey.notification.title");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String string3 = PythonProBundle.message((String)"python.web.survey.notification.content");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        return new RequestFeedbackNotification(string, string2, string3);
    }

    @NotNull
    public BlockBasedFeedbackDialog<? extends SystemDataJsonSerializable> createFeedbackDialog(@NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (BlockBasedFeedbackDialog)new PythonWebSurveyDialog(project, forTest);
    }

    private final boolean isApplicableLicense() {
        Object[] objectArray;
        Object object = LicensingFacade.getInstance();
        if (object == null || (object = ((LicensingFacade)object).metadata) == null) {
            return false;
        }
        Object metadata = object;
        return ((String)metadata).length() > 10 && CollectionsKt.listOf((Object[])(objectArray = new Character[]{Character.valueOf('C'), Character.valueOf('P'), Character.valueOf('O')})).contains(Character.valueOf(((String)metadata).charAt(10)));
    }

    public void updateStateAfterNotificationShowed(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }

    public void updateStateAfterDialogClosedOk(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }

    static {
        Object[] objectArray = new PackageAvailabilitySpec[3];
        String[] stringArray = new String[]{"django.conf.settings"};
        objectArray[0] = new PackageAvailabilitySpec("Django", stringArray);
        stringArray = new String[]{"flask.Flask"};
        objectArray[1] = new PackageAvailabilitySpec("Flask", stringArray);
        stringArray = new String[]{"fastapi.FastAPI"};
        objectArray[2] = new PackageAvailabilitySpec("fastapi", stringArray);
        WEB_FRAMEWORK_MARKERS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/python/pro/statistics/PythonWebFeedbackSurveyConfig$Companion;", "", "<init>", "()V", "WEB_FRAMEWORK_MARKERS", "", "Lcom/jetbrains/python/psi/resolve/PackageAvailabilitySpec;", "intellij.python"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

