/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.profiler;

import com.intellij.python.profiler.CallStat;
import com.intellij.python.profiler.ProfileStatData;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0016\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0006H\u0016J\b\u0010\u0016\u001a\u00020\u0006H\u0016J\b\u0010\u0017\u001a\u00020\u0006H\u0016J\b\u0010\u0018\u001a\u00020\u0006H\u0016J\b\u0010\u0019\u001a\u00020\u0006H\u0016J\b\u0010\u001a\u001a\u00020\u0003H\u0016J\b\u0010\u001b\u001a\u00020\u0003H\u0016J\n\u0010\u001c\u001a\u00020\u0003H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/python/profiler/CallStatData;", "Lcom/intellij/python/profiler/CallStat;", "fileName", "", "funcName", "lineNumber", "", "callCnt", "totalTime", "", "ownTime", "profileStatData", "Lcom/intellij/python/profiler/ProfileStatData;", "threadName", "threadId", "<init>", "(Ljava/lang/String;Ljava/lang/String;IIDDLcom/intellij/python/profiler/ProfileStatData;Ljava/lang/String;Ljava/lang/String;)V", "getFileName", "()Ljava/lang/String;", "getFile", "getName", "getLine", "getCallCount", "getTotalTimeMs", "getOwnTimeMs", "getBaseTotalTime", "getThreadName", "getThreadId", "toString", "intellij.python.profiler"})
public class CallStatData
implements CallStat {
    @NotNull
    private final String fileName;
    @NotNull
    private final String funcName;
    private final int lineNumber;
    private final int callCnt;
    private final double totalTime;
    private final double ownTime;
    @NotNull
    private final ProfileStatData profileStatData;
    @NotNull
    private final String threadName;
    @NotNull
    private final String threadId;

    public CallStatData(@NotNull String fileName, @NotNull String funcName, int lineNumber, int callCnt, double totalTime, double ownTime, @NotNull ProfileStatData profileStatData, @NotNull String threadName, @NotNull String threadId) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)funcName, (String)"funcName");
        Intrinsics.checkNotNullParameter((Object)profileStatData, (String)"profileStatData");
        Intrinsics.checkNotNullParameter((Object)threadName, (String)"threadName");
        Intrinsics.checkNotNullParameter((Object)threadId, (String)"threadId");
        this.fileName = fileName;
        this.funcName = funcName;
        this.lineNumber = lineNumber;
        this.callCnt = callCnt;
        this.totalTime = totalTime;
        this.ownTime = ownTime;
        this.profileStatData = profileStatData;
        this.threadName = threadName;
        this.threadId = threadId;
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    @Override
    @NotNull
    public String getFile() {
        return this.fileName;
    }

    @Override
    @NotNull
    public String getName() {
        return this.funcName;
    }

    @Override
    public int getLine() {
        return this.lineNumber;
    }

    @Override
    public int getCallCount() {
        return this.callCnt;
    }

    @Override
    public int getTotalTimeMs() {
        return (int)(this.totalTime * (double)1000);
    }

    @Override
    public int getOwnTimeMs() {
        return (int)(this.ownTime * (double)1000);
    }

    @Override
    public int getBaseTotalTime() {
        return this.profileStatData.getBaseTotalTimeMs();
    }

    @Override
    @NotNull
    public String getThreadName() {
        return this.threadName;
    }

    @Override
    @NotNull
    public String getThreadId() {
        return this.threadId;
    }

    @NotNull
    public String toString() {
        return this.getName();
    }
}

