/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.profiler;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.python.profiler.CallTreeNode;
import com.intellij.python.profiler.FunctionStat;
import com.intellij.python.profiler.ProfileDataKt;
import com.intellij.python.profiler.ProfileStats;
import com.intellij.python.profiler.Stats;
import com.intellij.python.profiler.TreeStats;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0017\u001a\u00020\u0016H\u0016J\u0010\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eH\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u001a\u001a\u00020\u0011H\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/python/profiler/ProfileStatData;", "Lcom/intellij/python/profiler/ProfileStats;", "stats", "Lcom/intellij/python/profiler/Stats;", "tree", "Lcom/intellij/python/profiler/TreeStats;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/python/profiler/Stats;Lcom/intellij/python/profiler/TreeStats;[Lcom/intellij/openapi/vfs/VirtualFile;)V", "getStats", "()Lcom/intellij/python/profiler/Stats;", "callStatsList", "", "Lcom/intellij/python/profiler/FunctionStat;", "baseTotalTime", "", "Ljava/lang/Integer;", "callTreeRoot", "Lcom/intellij/python/profiler/CallTreeNode;", "empty", "", "isEmpty", "getFunctionStats", "getCallTree", "getBaseTotalTimeMs", "getProfiler", "", "intellij.python.profiler"})
@SourceDebugExtension(value={"SMAP\nProfileData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileData.kt\ncom/intellij/python/profiler/ProfileStatData\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,387:1\n1#2:388\n*E\n"})
public final class ProfileStatData
implements ProfileStats {
    @Nullable
    private final Stats stats;
    @Nullable
    private final List<FunctionStat> callStatsList;
    @Nullable
    private final Integer baseTotalTime;
    @Nullable
    private final CallTreeNode callTreeRoot;
    private final boolean empty;

    public ProfileStatData(@Nullable Stats stats, @Nullable TreeStats tree, @NotNull VirtualFile[] roots) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)roots, (String)"roots");
        this.stats = stats;
        this.callStatsList = ProfileDataKt.access$createCallStatsList(this.stats, tree, this, roots);
        ProfileStatData profileStatData = this;
        List<FunctionStat> list = this.callStatsList;
        if (list != null) {
            Comparable comparable;
            Iterable iterable = list;
            ProfileStatData profileStatData2 = profileStatData;
            Iterator iterator = iterable.iterator();
            if (!iterator.hasNext()) {
                comparable = null;
            } else {
                FunctionStat stats2 = (FunctionStat)iterator.next();
                boolean bl = false;
                Comparable comparable2 = Integer.valueOf(stats2.getTotalTimeMs());
                while (iterator.hasNext()) {
                    FunctionStat stats3 = (FunctionStat)iterator.next();
                    $i$a$-maxOfOrNull-ProfileStatData$baseTotalTime$1 = false;
                    Comparable comparable3 = Integer.valueOf(stats3.getTotalTimeMs());
                    if (comparable2.compareTo(comparable3) >= 0) continue;
                    comparable2 = comparable3;
                }
                comparable = comparable2;
            }
            profileStatData = profileStatData2;
            n = (Integer)comparable;
        } else {
            n = null;
        }
        profileStatData.baseTotalTime = n;
        TreeStats treeStats = tree;
        this.callTreeRoot = (treeStats != null ? treeStats.call_tree : null) != null ? (CallTreeNode)ProfileDataKt.access$createCallTree(tree.call_tree, tree.call_tree.count, null, tree.sampling_interval, this.stats) : null;
        this.empty = tree != null && tree.call_tree == null;
    }

    @Nullable
    public final Stats getStats() {
        return this.stats;
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    @Nullable
    public List<FunctionStat> getFunctionStats() {
        return this.callStatsList;
    }

    @Override
    @Nullable
    public CallTreeNode getCallTree() {
        return this.callTreeRoot;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getBaseTotalTimeMs() {
        if (this.baseTotalTime == null) return 1;
        Integer n = this.baseTotalTime;
        if (n != null && n == 0) {
            return 1;
        }
        int n2 = this.baseTotalTime;
        return n2;
    }

    @Override
    @Nullable
    public String getProfiler() {
        Stats stats = this.stats;
        return stats != null ? stats.profiler : null;
    }
}

