/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.profiler.lines;

import com.google.common.collect.Maps;
import com.intellij.coverage.BaseCoverageSuite;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.python.pro.coverage.PyCoverageEngine;
import com.intellij.python.profiler.CallTreeNode;
import com.intellij.python.profiler.ProfileStats;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\u0006\u0010\u0019\u001a\u00020\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\f\u001a$\u0012\t\u0012\u00070\u000e\u00a2\u0006\u0002\b\u000f\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u00a2\u0006\u0002\b\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/python/profiler/lines/LineProfileSuite;", "Lcom/intellij/coverage/BaseCoverageSuite;", "stats", "Lcom/intellij/python/profiler/ProfileStats;", "<init>", "(Lcom/intellij/python/profiler/ProfileStats;)V", "engine", "Lcom/intellij/python/pro/coverage/PyCoverageEngine;", "getCoverageEngine", "Lcom/intellij/coverage/CoverageEngine;", "isCoverageByTestApplicable", "", "myFilesWithLines", "Ljava/util/HashMap;", "", "Lkotlin/jvm/internal/EnhancedNullability;", "", "", "Lcom/intellij/rt/coverage/data/LineData;", "walkTree", "", "tree", "Lcom/intellij/python/profiler/CallTreeNode;", "loadProjectInfo", "Lcom/intellij/rt/coverage/data/ProjectData;", "projectData", "intellij.python.profiler"})
@SourceDebugExtension(value={"SMAP\nLineProfileSuite.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineProfileSuite.kt\ncom/intellij/python/profiler/lines/LineProfileSuite\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,77:1\n383#2,7:78\n383#2,7:85\n*S KotlinDebug\n*F\n+ 1 LineProfileSuite.kt\ncom/intellij/python/profiler/lines/LineProfileSuite\n*L\n45#1:78,7\n48#1:85,7\n*E\n"})
public final class LineProfileSuite
extends BaseCoverageSuite {
    @NotNull
    private final PyCoverageEngine engine;
    @NotNull
    private final HashMap<String, Map<Integer, LineData>> myFilesWithLines;

    public LineProfileSuite(@NotNull ProfileStats stats) {
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        super("LineProfiling", null, null, new CoverageFileProvider(){

            public String getCoverageDataFilePath() {
                return "";
            }

            public boolean ensureFileExists() {
                return true;
            }

            public boolean isValid() {
                return true;
            }
        }, System.currentTimeMillis());
        this.engine = new PyCoverageEngine(){

            public Object[] postProcessExecutableLines(Object[] executableLines, Editor editor) {
                Intrinsics.checkNotNullParameter((Object)executableLines, (String)"executableLines");
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                return executableLines;
            }
        };
        HashMap hashMap = Maps.newHashMap();
        Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMap(...)");
        this.myFilesWithLines = hashMap;
        this.walkTree(stats.getCallTree());
    }

    @NotNull
    public CoverageEngine getCoverageEngine() {
        return this.engine;
    }

    public boolean isCoverageByTestApplicable() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void walkTree(CallTreeNode tree) {
        Object object;
        Map answer$iv;
        Map.Entry<Integer, Integer> $this$getOrPut$iv2;
        if (tree == null) {
            return;
        }
        Map map = this.myFilesWithLines;
        String key$iv = tree.getFile();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv2.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            answer$iv = Maps.newHashMap();
            $this$getOrPut$iv2.put((Integer)((Object)key$iv), (Integer)((Object)answer$iv));
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
        Map lineDataMap = (Map)object;
        for (Map.Entry<Integer, Integer> $this$getOrPut$iv2 : tree.getLineHits().entrySet()) {
            Object object2;
            void $this$getOrPut$iv3;
            int line = ((Number)$this$getOrPut$iv2.getKey()).intValue();
            int hits = ((Number)$this$getOrPut$iv2.getValue()).intValue();
            answer$iv = lineDataMap;
            Integer key$iv2 = line;
            boolean $i$f$getOrPut2 = false;
            Object value$iv2 = $this$getOrPut$iv3.get(key$iv2);
            if (value$iv2 == null) {
                boolean bl = false;
                LineData answer$iv2 = new LineData(line, "");
                $this$getOrPut$iv3.put(key$iv2, answer$iv2);
                object2 = answer$iv2;
            } else {
                object2 = value$iv2;
            }
            LineData lineData = (LineData)object2;
            lineData.setHits(lineData.getHits() + hits);
        }
        for (CallTreeNode c : tree.getChildren()) {
            this.walkTree(c);
        }
    }

    @NotNull
    protected ProjectData loadProjectInfo() {
        return this.projectData();
    }

    @NotNull
    public final ProjectData projectData() {
        ProjectData data = new ProjectData();
        for (Map.Entry entry : ((Map)this.myFilesWithLines).entrySet()) {
            Integer max;
            Object k = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
            String k2 = (String)k;
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
            Map lines = (Map)v;
            ClassData file = data.getOrCreateClassData(k2);
            Integer n = max = (Integer)CollectionsKt.maxOrNull((Iterable)lines.keySet());
            LineData[] linesArray = new LineData[n != null ? n + 1 : 0];
            for (Map.Entry entry2 : lines.entrySet()) {
                LineData v2;
                int k3 = ((Number)entry2.getKey()).intValue();
                linesArray[k3] = v2 = (LineData)entry2.getValue();
            }
            file.setLines(linesArray);
        }
        return data;
    }
}

