/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.profiler.lines;

import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.LineMarkerRendererWithErrorStripe;
import com.intellij.openapi.project.Project;
import com.intellij.python.profiler.ProfileStats;
import com.intellij.python.profiler.PythonProfilerCustomizer;
import com.intellij.python.profiler.Sample;
import com.intellij.python.profiler.lines.LineProfileSuite;
import com.intellij.python.profiler.lines.ProfileDataManager;
import com.intellij.python.profiler.lines.ProfileLineMarkerRenderer;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.util.Function;
import com.intellij.util.ui.UIUtil;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/python/profiler/lines/PythonLineProfiler;", "Lcom/intellij/python/profiler/PythonProfilerCustomizer;", "<init>", "()V", "postprocessProfile", "", "project", "Lcom/intellij/openapi/project/Project;", "profile", "Lcom/intellij/python/profiler/ProfileStats;", "parseSample", "Lcom/intellij/python/profiler/Sample;", "name", "", "createCommandLinePatcher", "", "ProfileSuiteBundle", "intellij.python.profiler"})
public final class PythonLineProfiler
implements PythonProfilerCustomizer {
    @Override
    public void postprocessProfile(@NotNull Project project, @NotNull ProfileStats profile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        ProfileDataManager profileDataManager = ProfileDataManager.getInstance(project);
        ProfileSuiteBundle coverageSuitesBundle = new ProfileSuiteBundle(new LineProfileSuite(profile));
        UIUtil.invokeLaterIfNeeded(() -> PythonLineProfiler.postprocessProfile$lambda$0(profileDataManager, coverageSuitesBundle));
    }

    @Override
    @Nullable
    public Sample parseSample(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return null;
    }

    @Nullable
    public Void createCommandLinePatcher() {
        return null;
    }

    private static final void postprocessProfile$lambda$0(ProfileDataManager $profileDataManager, ProfileSuiteBundle $coverageSuitesBundle) {
        $profileDataManager.chooseSuitesBundle($coverageSuitesBundle);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005Jt\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00012\u0014\u0010\u0012\u001a\u0010\u0012\u0006\b\u0000\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00132\u0014\u0010\u0014\u001a\u0010\u0012\u0006\b\u0000\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00132\u0006\u0010\u0015\u001a\u00020\u0010H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/python/profiler/lines/PythonLineProfiler$ProfileSuiteBundle;", "Lcom/intellij/coverage/CoverageSuitesBundle;", "suite", "Lcom/intellij/python/profiler/lines/LineProfileSuite;", "<init>", "(Lcom/intellij/python/profiler/lines/LineProfileSuite;)V", "getLineMarkerRenderer", "Lcom/intellij/coverage/LineMarkerRendererWithErrorStripe;", "lineNumber", "", "className", "", "lines", "Ljava/util/TreeMap;", "Lcom/intellij/rt/coverage/data/LineData;", "coverageByTestApplicable", "", "coverageSuite", "newToOldConverter", "Lcom/intellij/util/Function;", "oldToNewConverter", "subCoverageActive", "intellij.python.profiler"})
    public static final class ProfileSuiteBundle
    extends CoverageSuitesBundle {
        public ProfileSuiteBundle(@NotNull LineProfileSuite suite) {
            Intrinsics.checkNotNullParameter((Object)((Object)suite), (String)"suite");
            super((CoverageSuite)suite);
        }

        @Nullable
        public LineMarkerRendererWithErrorStripe getLineMarkerRenderer(int lineNumber, @Nullable String className, @NotNull TreeMap<Integer, LineData> lines, boolean coverageByTestApplicable, @NotNull CoverageSuitesBundle coverageSuite, @NotNull Function<? super Integer, Integer> newToOldConverter, @NotNull Function<? super Integer, Integer> oldToNewConverter, boolean subCoverageActive) {
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            Intrinsics.checkNotNullParameter((Object)coverageSuite, (String)"coverageSuite");
            Intrinsics.checkNotNullParameter(newToOldConverter, (String)"newToOldConverter");
            Intrinsics.checkNotNullParameter(oldToNewConverter, (String)"oldToNewConverter");
            return ProfileLineMarkerRenderer.getRenderer(lineNumber, lines, null, subCoverageActive);
        }
    }
}

