/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pyramid.templates.file;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.python.pyramid.templates.ChameleonLanguage;
import com.intellij.python.pyramid.templates.psi.ChameleonElementTypes;
import com.jetbrains.django.util.DjangoCoreUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class ChameleonFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements TemplateLanguageFileViewProvider {
    private Set<Language> myLanguages;

    public ChameleonFileViewProvider(PsiManager manager, VirtualFile virtualFile, boolean physical) {
        super(manager, virtualFile, physical);
    }

    @NotNull
    public Language getBaseLanguage() {
        ChameleonLanguage chameleonLanguage = ChameleonLanguage.INSTANCE;
        if (chameleonLanguage == null) {
            ChameleonFileViewProvider.$$$reportNull$$$0(0);
        }
        return chameleonLanguage;
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        VirtualFile file = this.getVirtualFile();
        FileType type = file.getFileType();
        if (XmlFileType.INSTANCE == type) {
            XMLLanguage xMLLanguage = XMLLanguage.INSTANCE;
            if (xMLLanguage == null) {
                ChameleonFileViewProvider.$$$reportNull$$$0(1);
            }
            return xMLLanguage;
        }
        if (type instanceof LanguageFileType && DjangoCoreUtil.isJavaScriptFileType((LanguageFileType)type)) {
            Language language = ((LanguageFileType)type).getLanguage();
            if (language == null) {
                ChameleonFileViewProvider.$$$reportNull$$$0(2);
            }
            return language;
        }
        HTMLLanguage hTMLLanguage = HTMLLanguage.INSTANCE;
        if (hTMLLanguage == null) {
            ChameleonFileViewProvider.$$$reportNull$$$0(3);
        }
        return hTMLLanguage;
    }

    @NotNull
    protected MultiplePsiFilesPerDocumentFileViewProvider cloneInner(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            ChameleonFileViewProvider.$$$reportNull$$$0(4);
        }
        return new ChameleonFileViewProvider((PsiManager)this.getManager(), virtualFile, false);
    }

    @NotNull
    public Set<Language> getLanguages() {
        if (this.myLanguages == null) {
            HashSet<Language> languages = new HashSet<Language>();
            languages.add(this.getBaseLanguage());
            languages.add(this.getTemplateDataLanguage());
            this.myLanguages = languages;
        }
        Set<Language> set = this.myLanguages;
        if (set == null) {
            ChameleonFileViewProvider.$$$reportNull$$$0(5);
        }
        return set;
    }

    protected PsiFile createFile(@NotNull Language lang) {
        ParserDefinition def;
        if (lang == null) {
            ChameleonFileViewProvider.$$$reportNull$$$0(6);
        }
        if ((def = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang)) != null) {
            if (lang == this.getTemplateDataLanguage()) {
                PsiFileImpl file = (PsiFileImpl)def.createFile((FileViewProvider)this);
                file.setContentElementType((IElementType)ChameleonElementTypes.TEMPLATE_DATA);
                return file;
            }
            if (lang == ChameleonLanguage.INSTANCE) {
                return def.createFile((FileViewProvider)this);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/pyramid/templates/file/ChameleonFileViewProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseLanguage";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateDataLanguage";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/pyramid/templates/file/ChameleonFileViewProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cloneInner";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 6 -> new IllegalArgumentException(string);
        };
    }
}

