/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.remoteInterpreter.console;

import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.python.remoteInterpreter.PythonRemoteInterpreterBundle;
import com.intellij.remote.RemoteConnectionType;
import com.intellij.remote.RemoteConnector;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.util.Consumer;
import com.jetbrains.plugins.remotesdk.SshConnectionProvider;
import com.jetbrains.plugins.remotesdk.console.RemoteDataProducer;
import com.jetbrains.plugins.remotesdk.target.ssh.target.SshTargetEnvironmentConfigurationBase;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.sdk.legacy.PythonSdkUtil;
import com.jetbrains.python.target.PyTargetAwareAdditionalData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PyRemoteSdkConnectionProvider
implements SshConnectionProvider {
    PyRemoteSdkConnectionProvider() {
    }

    @NotNull
    public Collection<? extends RemoteConnector> collectRemoteConnectors() {
        return PyRemoteSdkConnectionProvider.collectRemoteInterpreters();
    }

    @NotNull
    private static List<RemoteConnector> collectRemoteInterpreters() {
        ArrayList<RemoteConnector> result = new ArrayList<RemoteConnector>();
        for (Sdk sdk : PythonSdkUtil.getAllSdks()) {
            PyTargetAwareAdditionalData pyTargetData;
            TargetEnvironmentConfiguration configuration;
            SdkAdditionalData data = sdk.getSdkAdditionalData();
            if (!(data instanceof PyTargetAwareAdditionalData) || !((configuration = (pyTargetData = (PyTargetAwareAdditionalData)data).getTargetEnvironmentConfiguration()) instanceof SshTargetEnvironmentConfigurationBase)) continue;
            SshTargetEnvironmentConfigurationBase sshConfig = (SshTargetEnvironmentConfigurationBase)configuration;
            result.add(new SshTargetInterpreterConnector(sdk, pyTargetData, sshConfig));
        }
        ArrayList<RemoteConnector> arrayList = result;
        if (arrayList == null) {
            PyRemoteSdkConnectionProvider.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Nullable
    public RemoteConnector getRemoteConnector(@NotNull RemoteConnectionType type, @Nullable String id, @NotNull Project project, @Nullable Module module) {
        if (type == null) {
            PyRemoteSdkConnectionProvider.$$$reportNull$$$0(1);
        }
        if (project == null) {
            PyRemoteSdkConnectionProvider.$$$reportNull$$$0(2);
        }
        if (type == RemoteConnectionType.DEFAULT_SDK) {
            SdkAdditionalData data = PyRemoteSdkConnectionProvider.getCurrentSdkAdditionalData(project, module);
            if (data != null) {
                String title = (String)RemoteDataProducer.NO_HOST_TO_CONNECT_SUPPLIER.get();
                Messages.showWarningDialog((Project)project, (String)PythonRemoteInterpreterBundle.message("remote.connection.error.current.interpreter.is.not.remote", new Object[0]), (String)title);
            }
        } else if (type == RemoteConnectionType.REMOTE_SDK) {
            throw new IllegalArgumentException("Pre-target SDKs aren't suported");
        }
        return null;
    }

    @Nls
    public String getSettingCreationDescription() {
        return PythonRemoteInterpreterBundle.message("settings.add.python.remote.interpreter", new Object[0]);
    }

    @Nls
    @NotNull
    public String getRadioButtonDescription() {
        String string = PyBundle.message((String)"settings.default.remote.interpreter", (Object[])new Object[0]);
        if (string == null) {
            PyRemoteSdkConnectionProvider.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public RemoteConnectionType getTypeForConfigurable() {
        RemoteConnectionType remoteConnectionType = RemoteConnectionType.DEFAULT_SDK;
        if (remoteConnectionType == null) {
            PyRemoteSdkConnectionProvider.$$$reportNull$$$0(4);
        }
        return remoteConnectionType;
    }

    @Nullable
    private static SdkAdditionalData getCurrentSdkAdditionalData(Project project, @Nullable Module contextModule) {
        Sdk sdk = PyRemoteSdkConnectionProvider.findCurrentSdk(project, contextModule);
        return sdk != null ? sdk.getSdkAdditionalData() : null;
    }

    @Nullable
    private static Sdk findCurrentSdk(Project project, @Nullable Module contextModule) {
        Sdk sdk = PythonSdkUtil.findPythonSdk((Module)contextModule);
        return sdk != null ? sdk : (Sdk)((Stream)Arrays.stream(ModuleManager.getInstance((Project)project).getModules()).sequential()).map(PythonSdkUtil::findPythonSdk).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/remoteInterpreter/console/PyRemoteSdkConnectionProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRemoteInterpreters";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/remoteInterpreter/console/PyRemoteSdkConnectionProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRadioButtonDescription";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeForConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteConnector";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static class SshTargetInterpreterConnector
    extends SdkConnector<PyTargetAwareAdditionalData> {
        private final SshTargetEnvironmentConfigurationBase mySshTargetConfiguration;

        private SshTargetInterpreterConnector(Sdk sdk, PyTargetAwareAdditionalData sdkAdditionalData, SshTargetEnvironmentConfigurationBase sshTargetConfiguration) {
            super(sdk, sdkAdditionalData);
            this.mySshTargetConfiguration = sshTargetConfiguration;
        }

        public void produceRemoteCredentials(@NotNull Consumer<? super RemoteCredentials> remoteCredentialsConsumer) {
            if (remoteCredentialsConsumer == null) {
                SshTargetInterpreterConnector.$$$reportNull$$$0(0);
            }
            remoteCredentialsConsumer.consume((Object)this.mySshTargetConfiguration.findRemoteCredentials(null));
        }

        @NotNull
        public Object getConnectorKey() {
            SshTargetEnvironmentConfigurationBase sshTargetEnvironmentConfigurationBase = this.mySshTargetConfiguration;
            if (sshTargetEnvironmentConfigurationBase == null) {
                SshTargetInterpreterConnector.$$$reportNull$$$0(1);
            }
            return sshTargetEnvironmentConfigurationBase;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "remoteCredentialsConsumer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/python/remoteInterpreter/console/PyRemoteSdkConnectionProvider$SshTargetInterpreterConnector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/python/remoteInterpreter/console/PyRemoteSdkConnectionProvider$SshTargetInterpreterConnector";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConnectorKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "produceRemoteCredentials";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static abstract class SdkConnector<T extends RemoteSdkProperties>
    implements RemoteConnector {
        @NotNull
        private final Sdk mySdk;
        @NotNull
        protected final T mySdkAdditionalData;

        protected SdkConnector(@NotNull Sdk sdk, @NotNull T sdkAdditionalData) {
            if (sdk == null) {
                SdkConnector.$$$reportNull$$$0(0);
            }
            if (sdkAdditionalData == null) {
                SdkConnector.$$$reportNull$$$0(1);
            }
            this.mySdk = sdk;
            this.mySdkAdditionalData = sdkAdditionalData;
        }

        public final String getId() {
            return this.mySdkAdditionalData.getSdkId();
        }

        @NlsSafe
        @NotNull
        public final String getName() {
            String string = this.mySdk.getName();
            if (string == null) {
                SdkConnector.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public final RemoteConnectionType getType() {
            RemoteConnectionType remoteConnectionType = RemoteConnectionType.REMOTE_SDK;
            if (remoteConnectionType == null) {
                SdkConnector.$$$reportNull$$$0(3);
            }
            return remoteConnectionType;
        }

        @NotNull
        public String toString() {
            return this.getName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdkAdditionalData";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/python/remoteInterpreter/console/PyRemoteSdkConnectionProvider$SdkConnector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/python/remoteInterpreter/console/PyRemoteSdkConnectionProvider$SdkConnector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

