/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific.cells;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.psi.PsiElement;
import com.intellij.python.scientific.cells.PyCellActionHelperKt;
import com.jetbrains.python.PyCellUtil;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/python/scientific/cells/PyCellMoveBaseAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "direction", "Lcom/intellij/python/scientific/cells/PyCellMoveBaseAction$CellMoveDirection;", "<init>", "(Lcom/intellij/python/scientific/cells/PyCellMoveBaseAction$CellMoveDirection;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "CellMoveDirection", "intellij.python.scientific"})
public abstract class PyCellMoveBaseAction
extends DumbAwareAction {
    @NotNull
    private final CellMoveDirection direction;

    public PyCellMoveBaseAction(@NotNull CellMoveDirection direction) {
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        this.direction = direction;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        PsiElement psiElement = PyCellActionHelperKt.getCellElement(e);
        if (psiElement == null) {
            return;
        }
        PsiElement element = psiElement;
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        Pair pair = switch (WhenMappings.$EnumSwitchMapping$0[this.direction.ordinal()]) {
            case 1 -> TuplesKt.to((Object)element, (Object)PyCellUtil.findNextCell((PsiElement)element));
            case 2 -> TuplesKt.to((Object)PyCellUtil.findSeparatorOfPrevCell((PsiElement)element), (Object)element);
            default -> throw new NoWhenBranchMatchedException();
        };
        PsiElement cellElement = (PsiElement)pair.component1();
        PsiElement nextElement = (PsiElement)pair.component2();
        if (cellElement == null || nextElement == null) {
            return;
        }
        PyCellUtil.CellRange cellRange = PyCellUtil.getCellTextRangeIncludingSeparators((PsiElement)cellElement);
        PyCellUtil.CellRange nextRange = PyCellUtil.getCellTextRangeIncludingSeparators((PsiElement)nextElement);
        int caretOffsetWithinCell = editor2.getCaretModel().getPrimaryCaret().getOffset() - (this.direction == CellMoveDirection.DOWN ? cellRange.textRange.getStartOffset() : nextRange.textRange.getStartOffset());
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        Ref.ObjectRef cellText = new Ref.ObjectRef();
        String string = document2.getText(cellRange.textRange);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        cellText.element = string;
        if (nextRange.lastCell.booleanValue() && StringsKt.endsWith$default((CharSequence)((CharSequence)cellText.element), (char)'\n', (boolean)false, (int)2, null)) {
            cellText.element = StringsKt.dropLast((String)((String)cellText.element), (int)1);
        }
        Ref.ObjectRef nextText = new Ref.ObjectRef();
        String string2 = document2.getText(nextRange.textRange);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        nextText.element = string2;
        if (nextRange.lastCell.booleanValue()) {
            nextText.element = nextText.element + "\n";
        }
        ActionsKt.runUndoTransparentWriteAction(() -> PyCellMoveBaseAction.actionPerformed$lambda$0(document2, nextRange, cellText, cellRange, nextText));
        int cellsDiff = nextRange.textRange.getLength() - cellRange.textRange.getLength() + (nextRange.lastCell != false ? 1 : 0);
        editor2.getCaretModel().moveToOffset((this.direction == CellMoveDirection.DOWN ? nextRange.textRange.getStartOffset() + cellsDiff : cellRange.textRange.getStartOffset()) + caretOffsetWithinCell);
        editor2.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
    }

    private static final Unit actionPerformed$lambda$0(Document $document, PyCellUtil.CellRange $nextRange, Ref.ObjectRef $cellText, PyCellUtil.CellRange $cellRange, Ref.ObjectRef $nextText) {
        $document.replaceString($nextRange.textRange.getStartOffset(), $nextRange.textRange.getEndOffset(), (CharSequence)$cellText.element);
        $document.replaceString($cellRange.textRange.getStartOffset(), $cellRange.textRange.getEndOffset(), (CharSequence)$nextText.element);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/python/scientific/cells/PyCellMoveBaseAction$CellMoveDirection;", "", "<init>", "(Ljava/lang/String;I)V", "UP", "DOWN", "intellij.python.scientific"})
    public static final class CellMoveDirection
    extends Enum<CellMoveDirection> {
        public static final /* enum */ CellMoveDirection UP = new CellMoveDirection();
        public static final /* enum */ CellMoveDirection DOWN = new CellMoveDirection();
        private static final /* synthetic */ CellMoveDirection[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CellMoveDirection[] values() {
            return (CellMoveDirection[])$VALUES.clone();
        }

        public static CellMoveDirection valueOf(String value2) {
            return Enum.valueOf(CellMoveDirection.class, value2);
        }

        @NotNull
        public static EnumEntries<CellMoveDirection> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = cellMoveDirectionArray = new CellMoveDirection[]{CellMoveDirection.UP, CellMoveDirection.DOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CellMoveDirection.values().length];
            try {
                nArray[CellMoveDirection.DOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CellMoveDirection.UP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

