/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific.cells;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.python.scientific.cells.PyCellActionHelperKt;
import com.jetbrains.python.actions.PyExecuteInConsole;
import com.jetbrains.python.console.PyExecuteConsoleCustomizer;
import com.jetbrains.python.run.PythonRunConfiguration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/python/scientific/cells/PyExecuteCellAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "showConsoleAndExecuteCode", "cellText", "", "intellij.python.scientific"})
public class PyExecuteCellAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor instanceof EditorImpl) {
            PyExecuteConsoleCustomizer.Companion.getInstance().notifySciCellGutterExecuted((EditorImpl)editor, "PyExecuteCellAction");
        }
        String string = PyCellActionHelperKt.getCellText(e);
        if (string == null) {
            return;
        }
        String cellText = string;
        this.showConsoleAndExecuteCode(e, cellText);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(PyCellActionHelperKt.isStructuredPyFile(e));
    }

    private final void showConsoleAndExecuteCode(AnActionEvent e, String cellText) {
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        PyExecuteConsoleCustomizer pyExecuteConsoleCustomizer = PyExecuteConsoleCustomizer.Companion.getInstance();
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        PythonRunConfiguration config = pyExecuteConsoleCustomizer.getContextConfig(dataContext);
        PyExecuteInConsole.executeCodeInConsole((Project)project, (String)cellText, (Editor)editor, (boolean)true, (boolean)false, (boolean)false, (PythonRunConfiguration)config);
    }
}

