/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific.figures;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.python.community.helpersLocator.PythonHelpersLocator;
import com.intellij.python.scientific.PySciApplicationComponent;
import com.intellij.python.scientific.figures.PlotsBackend;
import com.intellij.python.scientific.ui.PyPlotToolWindow;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.Tunnelable;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.console.PydevConsoleRunnerImpl;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.PythonCommandLineEnvironmentProvider;
import com.jetbrains.python.run.PythonRunConfigurationExtension;
import com.jetbrains.python.run.PythonRunParams;
import com.jetbrains.python.sdk.PythonEnvUtil;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;

public final class PySciEnvironmentProvider
extends PythonRunConfigurationExtension
implements PythonCommandLineEnvironmentProvider {
    private static final Logger LOG = Logger.getInstance(PySciEnvironmentProvider.class);

    public boolean isApplicableFor(@NotNull AbstractPythonRunConfiguration configuration) {
        Project project;
        if (configuration == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(0);
        }
        return !(project = configuration.getProject()).isDefault() && !PySciApplicationComponent.getInstance().isPortForwarded();
    }

    public boolean isEnabledFor(@NotNull AbstractPythonRunConfiguration applicableConfiguration, @Nullable RunnerSettings runnerSettings) {
        if (applicableConfiguration == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(1);
        }
        return PySciApplicationComponent.getInstance().isMatplotlibInToolwindow();
    }

    protected void patchCommandLine(@NotNull AbstractPythonRunConfiguration configuration, @Nullable RunnerSettings runnerSettings, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId) {
        if (configuration == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(2);
        }
        if (cmdLine == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(3);
        }
        if (runnerId == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(4);
        }
    }

    protected void attachToProcess(@NotNull AbstractPythonRunConfiguration configuration, @NotNull ProcessHandler handler, @Nullable RunnerSettings runnerSettings) {
        if (configuration == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(5);
        }
        if (handler == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(6);
        }
        try {
            Process process = PySciEnvironmentProvider.tryGetProcess(handler);
            if (process instanceof Tunnelable && !PySciApplicationComponent.getInstance().isPortForwarded()) {
                int port = BuiltInServerManager.getInstance().getPort();
                ((Tunnelable)process).addRemoteTunnel(port, "localhost", port);
                PySciApplicationComponent.getInstance().enablePortForwarding();
            }
        }
        catch (RemoteSdkException exception) {
            LOG.info("Failed to forward ports: " + String.valueOf((Object)exception));
        }
    }

    @Nullable
    private static Process tryGetProcess(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(7);
        }
        if (processHandler instanceof BaseProcessHandler) {
            return ((BaseProcessHandler)processHandler).getProcess();
        }
        return null;
    }

    public void extendEnvironment(@NotNull Project project, @Nullable SdkAdditionalData data, @NotNull GeneralCommandLine cmdLine, @NotNull PythonRunParams runParams) {
        int port;
        if (project == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(8);
        }
        if (cmdLine == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(9);
        }
        if (runParams == null) {
            PySciEnvironmentProvider.$$$reportNull$$$0(10);
        }
        Map envs = cmdLine.getEnvironment();
        if (runParams instanceof PydevConsoleRunnerImpl.PythonConsoleRunParams) {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                envs.put("PYCHARM_MATPLOTLIB_INTERACTIVE", "true");
                envs.put("PYCHARM_MATPLOTLIB_INDEX", String.valueOf(PyPlotToolWindow.getInstance(project).getLastPlotIndex()));
            });
        }
        if (PySciApplicationComponent.getInstance().isMatplotlibInToolwindow() && (port = BuiltInServerManager.getInstance().getPort()) != -1) {
            envs.put("PYCHARM_DISPLAY_PORT", String.valueOf(port));
            envs.put("PYCHARM_PROJECT_ID", project.getLocationHash());
            envs.put("PYCHARM_UUID", PlotsBackend.GENERATED_UUID);
            int isInteractive = PySciApplicationComponent.getInstance().isInteractivePlotsMode() ? 1 : 0;
            envs.put("PYCHARM_INTERACTIVE_PLOTS", String.valueOf(isInteractive));
            LOG.info("Plots on port: " + port);
            PythonEnvUtil.addToPythonPath((Map)envs, (Collection)ContainerUtil.map(PlotsBackend.PYCHARM_PLOTS_BACKEND_PACKAGES, PythonHelpersLocator::findPathStringInHelpers));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicableConfiguration";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runParams";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/scientific/figures/PySciEnvironmentProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableFor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledFor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "patchCommandLine";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "attachToProcess";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "tryGetProcess";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "extendEnvironment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

