/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.templateLanguages;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.template.lang.core.templateLanguages.PyTemplatesBundle;
import com.intellij.template.lang.core.templateLanguages.TemplatesService;
import com.intellij.ui.treeStructure.ProjectViewUpdateCause;
import com.jetbrains.python.PythonProBundle;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyMarkTemplateDirectoryAction
extends AnAction {
    private static boolean allDirectoriesAreTemplateRoots(Module module, VirtualFile[] files) {
        List<VirtualFile> folders = TemplatesService.getInstance(module).getTemplateFolders();
        return folders.containsAll(Arrays.asList(files));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            PyMarkTemplateDirectoryAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            PyMarkTemplateDirectoryAction.$$$reportNull$$$0(1);
        }
        VirtualFile[] virtualFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        Module module = (Module)e.getData(PlatformCoreDataKeys.MODULE);
        boolean isEnabled = module != null && virtualFiles != null && virtualFiles.length > 0 && PyMarkTemplateDirectoryAction.allFilesAreDirectories(virtualFiles);
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(isEnabled);
        presentation.setIcon(AllIcons.Nodes.TemplateRoot);
        presentation.setText(PythonProBundle.message((String)(PyMarkTemplateDirectoryAction.isSelected(module, virtualFiles) ? "python.template.unmark.as.template.folder" : "python.template.folder")));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            PyMarkTemplateDirectoryAction.$$$reportNull$$$0(2);
        }
        Module module = (Module)e.getData(PlatformCoreDataKeys.MODULE);
        VirtualFile[] virtualFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (module == null || virtualFiles == null) {
            return;
        }
        List<VirtualFile> folders = TemplatesService.getInstance(module).getTemplateFolders();
        List<VirtualFile> fileList = Arrays.asList(virtualFiles);
        boolean isSelected = PyMarkTemplateDirectoryAction.isSelected(module, virtualFiles);
        if (!isSelected) {
            folders.addAll(fileList);
        } else {
            folders.removeAll(fileList);
        }
        TemplatesService.getInstance(module).setTemplateFolders(folders.toArray(VirtualFile.EMPTY_ARRAY));
        Project project = module.getProject();
        ProjectView.getInstance((Project)project).refresh(ProjectViewUpdateCause.ACTION);
        if (!isSelected && TemplatesService.getInstance(module).getTemplateLanguage() == null && Messages.showYesNoDialog((Project)project, (String)PyTemplatesBundle.message("no_selected_template_language", new Object[0]), (String)PyTemplatesBundle.message("no_selected_template_language_header", new Object[0]), null) == 0) {
            ShowSettingsUtil.getInstance().showSettingsDialog(project, PythonProBundle.message((String)"python.template.languages"));
        }
    }

    private static boolean isSelected(@Nullable Module module, VirtualFile @Nullable [] virtualFiles) {
        return module != null && virtualFiles != null && virtualFiles.length > 0 && PyMarkTemplateDirectoryAction.allDirectoriesAreTemplateRoots(module, virtualFiles);
    }

    private static boolean allFilesAreDirectories(VirtualFile[] files) {
        for (VirtualFile file : files) {
            if (file.isDirectory()) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/templateLanguages/PyMarkTemplateDirectoryAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/templateLanguages/PyMarkTemplateDirectoryAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

