/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.inspections;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.scientific.py.tables.PyTablesBundle;
import com.intellij.scientific.py.tables.inspections.tree.InspectionsTreeComponent;
import com.intellij.scientific.tables.panel.UtilKt;
import com.intellij.scientific.tables.settings.DSTablesSettingsState;
import com.intellij.ui.WindowMoveListener;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0003;<=B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020\bJ\u0006\u0010'\u001a\u00020\bJ\u001e\u0010(\u001a\u00020\b2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0001\u0010*\u001a\u00020\u001fJ\u000e\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020%J\b\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020\b2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u00100\u001a\u0002012\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u00102\u001a\u00020\b2\u0006\u0010\u0016\u001a\u0002012\u0006\u00103\u001a\u00020\u0012H\u0002J\u0010\u00104\u001a\u00020\b2\u0006\u0010\u0016\u001a\u000201H\u0002J\b\u00105\u001a\u00020\bH\u0002J\u0010\u00106\u001a\u0002072\u0006\u00108\u001a\u00020.H\u0002J\u0006\u00109\u001a\u00020\bJ\b\u0010:\u001a\u00020\bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001b0\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u001f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/intellij/scientific/py/tables/inspections/InspectionPopupBuilder;", "Lcom/intellij/openapi/Disposable$Default;", "project", "Lcom/intellij/openapi/project/Project;", "tree", "Lcom/intellij/scientific/py/tables/inspections/tree/InspectionsTreeComponent;", "stopComputationAction", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/scientific/py/tables/inspections/tree/InspectionsTreeComponent;Lkotlin/jvm/functions/Function0;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getTree", "()Lcom/intellij/scientific/py/tables/inspections/tree/InspectionsTreeComponent;", "getStopComputationAction", "()Lkotlin/jvm/functions/Function0;", "popUp", "Lcom/intellij/openapi/ui/popup/JBPopup;", "headerInsets", "Ljava/awt/Insets;", "Lorg/jetbrains/annotations/NotNull;", "headerComponent", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "quickFixesComponent", "currentHeaderListeners", "", "Lkotlin/Pair;", "Ljava/awt/event/MouseListener;", "Ljava/awt/event/MouseMotionListener;", "quickFixButtonLabel", "", "onQuickFix", "quickFixButton", "Ljavax/swing/JButton;", "createPopUp", "isRunning", "", "setRunningState", "setCompletedState", "setOnQuickFix", "onQuickFixCallback", "buttonLabel", "setOnQuickFixEnabled", "isEnabled", "createComponentWithComment", "Ljava/awt/Component;", "updateHeader", "createPopupHeader", "Ljavax/swing/JComponent;", "makeHeaderDraggable", "popup", "addDragListeners", "removeHeaderListeners", "computeMinSizePopup", "Ljava/awt/Dimension;", "scrollPane", "closePopUp", "addQuickFixesComponent", "SetUpAutoStartToggleAction", "HidePopupAction", "StopExecutionAction", "intellij.scientific.py.tables"})
@SourceDebugExtension(value={"SMAP\nInspectionPopupBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectionPopupBuilder.kt\ncom/intellij/scientific/py/tables/inspections/InspectionPopupBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,290:1\n1915#2,2:291\n*S KotlinDebug\n*F\n+ 1 InspectionPopupBuilder.kt\ncom/intellij/scientific/py/tables/inspections/InspectionPopupBuilder\n*L\n208#1:291,2\n*E\n"})
public final class InspectionPopupBuilder
implements Disposable.Default {
    @NotNull
    private final Project project;
    @NotNull
    private final InspectionsTreeComponent tree;
    @NotNull
    private final Function0<Unit> stopComputationAction;
    @Nullable
    private JBPopup popUp;
    @NotNull
    private final Insets headerInsets;
    @NotNull
    private final BorderLayoutPanel headerComponent;
    @NotNull
    private final BorderLayoutPanel quickFixesComponent;
    @NotNull
    private List<Pair<MouseListener, MouseMotionListener>> currentHeaderListeners;
    @NlsContexts.Button
    @Nullable
    private String quickFixButtonLabel;
    @Nullable
    private Function0<Unit> onQuickFix;
    @Nullable
    private JButton quickFixButton;

    public InspectionPopupBuilder(@NotNull Project project, @NotNull InspectionsTreeComponent tree, @NotNull Function0<Unit> stopComputationAction) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)tree), (String)"tree");
        Intrinsics.checkNotNullParameter(stopComputationAction, (String)"stopComputationAction");
        this.project = project;
        this.tree = tree;
        this.stopComputationAction = stopComputationAction;
        Insets insets = JBUI.CurrentTheme.Popup.headerInsets();
        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"headerInsets(...)");
        this.headerInsets = insets;
        this.headerComponent = new BorderLayoutPanel();
        this.quickFixesComponent = new BorderLayoutPanel();
        this.currentHeaderListeners = new ArrayList();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final InspectionsTreeComponent getTree() {
        return this.tree;
    }

    @NotNull
    public final Function0<Unit> getStopComputationAction() {
        return this.stopComputationAction;
    }

    @NotNull
    public final JBPopup createPopUp(boolean isRunning) {
        JBPopup jBPopup;
        BorderLayoutPanel borderLayoutPanel;
        BorderLayoutPanel mainPopupPanel = new BorderLayoutPanel();
        this.headerComponent.removeAll();
        BorderLayoutPanel $this$createPopUp_u24lambda_u240 = borderLayoutPanel = this.headerComponent;
        boolean bl = false;
        $this$createPopUp_u24lambda_u240.addToCenter((Component)this.createPopupHeader(isRunning));
        $this$createPopUp_u24lambda_u240.setBorder((Border)JBUI.Borders.empty());
        BorderLayoutPanel $this$createPopUp_u24lambda_u241 = $this$createPopUp_u24lambda_u240 = new BorderLayoutPanel();
        boolean bl2 = false;
        $this$createPopUp_u24lambda_u241.addToTop(this.createComponentWithComment());
        $this$createPopUp_u24lambda_u241.addToLeft((Component)((Object)this.tree));
        BorderLayoutPanel panelInsideScroll = $this$createPopUp_u24lambda_u240;
        JBScrollPane scrollPane = new JBScrollPane((Component)panelInsideScroll, 20, 31);
        scrollPane.setBorder((Border)JBUI.Borders.empty((int)0, (int)this.headerInsets.left));
        this.quickFixesComponent.setBorder((Border)JBUI.Borders.empty((int)0, (int)this.headerInsets.left));
        this.tree.setBorder((Border)JBUI.Borders.empty());
        mainPopupPanel.addToTop((Component)this.headerComponent);
        mainPopupPanel.addToCenter((Component)scrollPane);
        mainPopupPanel.addToBottom((Component)this.quickFixesComponent);
        JBPopup $this$createPopUp_u24lambda_u242 = jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)mainPopupPanel, null).setProject(this.project).setRequestFocus(true).setResizable(true).setMovable(true).setCancelOnClickOutside(true).setMinSize(this.computeMinSizePopup((Component)scrollPane)).setLocateWithinScreenBounds(false).createPopup();
        boolean bl3 = false;
        $this$createPopUp_u24lambda_u242.canClose();
        JBPopup jBPopup2 = jBPopup;
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup2, (String)"apply(...)");
        JBPopup mainPopup = jBPopup2;
        this.makeHeaderDraggable((JComponent)this.headerComponent, mainPopup);
        this.popUp = mainPopup;
        mainPopup.setSize(mainPopupPanel.getPreferredSize());
        return mainPopup;
    }

    public final void setRunningState() {
        this.updateHeader(true);
    }

    public final void setCompletedState() {
        this.updateHeader(false);
        this.addQuickFixesComponent();
    }

    public final void setOnQuickFix(@NotNull Function0<Unit> onQuickFixCallback, @NlsContexts.Button @NotNull String buttonLabel) {
        Intrinsics.checkNotNullParameter(onQuickFixCallback, (String)"onQuickFixCallback");
        Intrinsics.checkNotNullParameter((Object)buttonLabel, (String)"buttonLabel");
        this.onQuickFix = onQuickFixCallback;
        this.quickFixButtonLabel = buttonLabel;
    }

    public final void setOnQuickFixEnabled(boolean isEnabled) {
        block0: {
            JButton jButton = this.quickFixButton;
            if (jButton == null) break block0;
            jButton.setEnabled(isEnabled);
        }
    }

    private final Component createComponentWithComment() {
        DialogPanel dialogPanel;
        DialogPanel $this$createComponentWithComment_u24lambda_u241 = dialogPanel = BuilderKt.panel(InspectionPopupBuilder::createComponentWithComment$lambda$0);
        boolean bl = false;
        $this$createComponentWithComment_u24lambda_u241.setBorder((Border)JBUI.Borders.empty());
        return (Component)dialogPanel;
    }

    private final void updateHeader(boolean isRunning) {
        this.removeHeaderListeners();
        this.headerComponent.removeAll();
        this.headerComponent.addToCenter((Component)this.createPopupHeader(isRunning));
        JBPopup jBPopup = this.popUp;
        if (jBPopup != null) {
            JBPopup popup = jBPopup;
            boolean bl = false;
            this.makeHeaderDraggable((JComponent)this.headerComponent, popup);
        }
        this.headerComponent.revalidate();
        this.headerComponent.repaint();
    }

    private final JComponent createPopupHeader(boolean isRunning) {
        ActionToolbar actionToolbar;
        DefaultActionGroup defaultActionGroup;
        AnAction[] anActionArray;
        BorderLayoutPanel headerPanel = new BorderLayoutPanel();
        String titleMessage = isRunning ? PyTablesBundle.message("popup.inspections.running.title", new Object[0]) : PyTablesBundle.message("popup.inspections.finished.title", new Object[0]);
        AnAction[] $this$createPopupHeader_u24lambda_u240 = anActionArray = new JLabel(titleMessage);
        boolean bl2 = false;
        $this$createPopupHeader_u24lambda_u240.setFont(JBFont.label().deriveFont(1));
        $this$createPopupHeader_u24lambda_u240.setBorder(BorderFactory.createEmptyBorder(this.headerInsets.top, this.headerInsets.left, this.headerInsets.bottom, 0));
        AnAction[] titleLabel = anActionArray;
        headerPanel.addToLeft((Component)titleLabel);
        headerPanel.setBackground(JBUI.CurrentTheme.Popup.headerBackground((boolean)true));
        headerPanel.setBorder(JBUI.Borders.customLine((Color)JBUI.CurrentTheme.Popup.separatorColor(), (int)0, (int)0, (int)1, (int)0));
        if (isRunning) {
            $this$createPopupHeader_u24lambda_u240 = new AnAction[]{new StopExecutionAction()};
            DefaultActionGroup defaultActionGroup2 = new DefaultActionGroup($this$createPopupHeader_u24lambda_u240);
            defaultActionGroup = defaultActionGroup2;
        } else {
            DefaultActionGroup popupGroup = DefaultActionGroup.createPopupGroup(InspectionPopupBuilder::createPopupHeader$lambda$1);
            popupGroup.getTemplatePresentation().setIcon(AllIcons.General.GearPlain);
            popupGroup.add((AnAction)new SetUpAutoStartToggleAction());
            AnAction[] bl2 = new AnAction[]{popupGroup, new HidePopupAction()};
            DefaultActionGroup defaultActionGroup3 = new DefaultActionGroup(bl2);
            defaultActionGroup = defaultActionGroup3;
        }
        DefaultActionGroup actionGroup = defaultActionGroup;
        String toolbarId = isRunning ? "InspectionsHeaderToolbarRunning" : "InspectionsHeaderToolbarFinished";
        ActionToolbar $this$createPopupHeader_u24lambda_u242 = actionToolbar = ActionManager.getInstance().createActionToolbar(toolbarId, (ActionGroup)actionGroup, true);
        boolean bl3 = false;
        $this$createPopupHeader_u24lambda_u242.getComponent().setBorder(BorderFactory.createEmptyBorder(this.headerInsets.top, 0, this.headerInsets.bottom, this.headerInsets.right));
        $this$createPopupHeader_u24lambda_u242.getComponent().setBackground(JBUI.CurrentTheme.Popup.headerBackground((boolean)true));
        $this$createPopupHeader_u24lambda_u242.setTargetComponent((JComponent)headerPanel);
        ActionToolbar actionToolbar2 = actionToolbar;
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"apply(...)");
        ActionToolbar headerToolbar = actionToolbar2;
        headerPanel.addToRight((Component)headerToolbar.getComponent());
        return (JComponent)headerPanel;
    }

    private final void makeHeaderDraggable(JComponent headerComponent, JBPopup popup) {
        popup.addListener(new JBPopupListener(this, headerComponent){
            final /* synthetic */ InspectionPopupBuilder this$0;
            final /* synthetic */ JComponent $headerComponent;
            {
                this.this$0 = $receiver;
                this.$headerComponent = $headerComponent;
            }

            public void beforeShown(LightweightWindowEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                InspectionPopupBuilder.access$addDragListeners(this.this$0, this.$headerComponent);
            }

            public void onClosed(LightweightWindowEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                InspectionPopupBuilder.access$removeHeaderListeners(this.this$0);
                event.asPopup().removeListener((JBPopupListener)this);
            }
        });
    }

    private final void addDragListeners(JComponent headerComponent) {
        Window window = SwingUtilities.getWindowAncestor(headerComponent);
        if (window != null) {
            WindowMoveListener moveListener = new WindowMoveListener((Component)window);
            headerComponent.addMouseListener((MouseListener)moveListener);
            headerComponent.addMouseMotionListener((MouseMotionListener)moveListener);
            this.currentHeaderListeners.add((Pair<MouseListener, MouseMotionListener>)new Pair((Object)moveListener, (Object)moveListener));
        }
    }

    private final void removeHeaderListeners() {
        Iterable $this$forEach$iv = this.currentHeaderListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            MouseListener mouseListener2 = (MouseListener)pair.component1();
            MouseMotionListener mouseMotionListener = (MouseMotionListener)pair.component2();
            this.headerComponent.removeMouseListener(mouseListener2);
            this.headerComponent.removeMouseMotionListener(mouseMotionListener);
        }
        this.currentHeaderListeners.clear();
    }

    private final Dimension computeMinSizePopup(Component scrollPane) {
        int newWidth = (int)((double)scrollPane.getPreferredSize().width * 1.2);
        int newHeight = (int)((double)newWidth * 1.2);
        return new Dimension(newWidth, newHeight);
    }

    public final void closePopUp() {
        JBPopup jBPopup = this.popUp;
        if (jBPopup != null) {
            jBPopup.cancel();
        }
        this.popUp = null;
    }

    private final void addQuickFixesComponent() {
        Function0<Unit> function0 = this.onQuickFix;
        if (function0 == null) {
            return;
        }
        Function0<Unit> onQuickFixCallback = function0;
        String string = this.quickFixButtonLabel;
        if (string == null) {
            return;
        }
        String buttonLabel = string;
        this.quickFixesComponent.addToBottom((Component)BuilderKt.panel(arg_0 -> InspectionPopupBuilder.addQuickFixesComponent$lambda$0(this, buttonLabel, onQuickFixCallback, arg_0)));
    }

    private static final Unit createComponentWithComment$lambda$0$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.comment$default((Row)$this$row, (String)PyTablesBundle.message("popup.inspections.finished.comment", new Object[0]), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createComponentWithComment$lambda$0(Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, InspectionPopupBuilder::createComponentWithComment$lambda$0$0, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final String createPopupHeader$lambda$1() {
        return PyTablesBundle.message("popup.inspections.header.setting.popup.group.text", new Object[0]);
    }

    private static final Unit addQuickFixesComponent$lambda$0$0$0(Function0 $onQuickFixCallback, InspectionPopupBuilder this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $onQuickFixCallback.invoke();
        this$0.closePopUp();
        return Unit.INSTANCE;
    }

    private static final Unit addQuickFixesComponent$lambda$0$1$0(JEditorPane $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setFont((Font)JBFont.small());
        $this$applyToComponent.setAlignmentY(0.0f);
        return Unit.INSTANCE;
    }

    private static final Unit addQuickFixesComponent$lambda$0$0(InspectionPopupBuilder this$0, String $buttonLabel, Function0 $onQuickFixCallback, Row $this$row) {
        block0: {
            JButton jButton;
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            JButton jButton2 = this$0.quickFixButton = (JButton)$this$row.button($buttonLabel, arg_0 -> InspectionPopupBuilder.addQuickFixesComponent$lambda$0$0$0($onQuickFixCallback, this$0, arg_0)).getComponent();
            if (jButton2 == null) break block0;
            JButton $this$addQuickFixesComponent_u24lambda_u240_u240_u241 = jButton = jButton2;
            boolean bl = false;
            UtilKt.defaultStyle((JButton)$this$addQuickFixesComponent_u24lambda_u240_u240_u241);
            $this$addQuickFixesComponent_u24lambda_u240_u240_u241.setEnabled(false);
        }
        return Unit.INSTANCE;
    }

    private static final Unit addQuickFixesComponent$lambda$0$1(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.comment$default((Row)$this$row, (String)PyTablesBundle.message("popup.inspections.quick.fix.button.comment", new Object[0]), (int)0, null, (int)6, null).applyToComponent(InspectionPopupBuilder::addQuickFixesComponent$lambda$0$1$0).align((Align)AlignY.TOP.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit addQuickFixesComponent$lambda$0(InspectionPopupBuilder this$0, String $buttonLabel, Function0 $onQuickFixCallback, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> InspectionPopupBuilder.addQuickFixesComponent$lambda$0$0(this$0, $buttonLabel, $onQuickFixCallback, arg_0), (int)1, null).bottomGap(BottomGap.NONE);
        Panel.row$default((Panel)$this$panel, null, InspectionPopupBuilder::addQuickFixesComponent$lambda$0$1, (int)1, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$addDragListeners(InspectionPopupBuilder $this, JComponent headerComponent) {
        $this.addDragListeners(headerComponent);
    }

    public static final /* synthetic */ void access$removeHeaderListeners(InspectionPopupBuilder $this) {
        $this.removeHeaderListeners();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/scientific/py/tables/inspections/InspectionPopupBuilder$HidePopupAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "(Lcom/intellij/scientific/py/tables/inspections/InspectionPopupBuilder;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.scientific.py.tables"})
    public final class HidePopupAction
    extends AnAction {
        public HidePopupAction() {
            super(PyTablesBundle.message("popup.inspections.hide.popup.action.text", new Object[0]), PyTablesBundle.message("popup.inspections.hide.popup.action.description", new Object[0]), AllIcons.General.HideToolWindow);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            InspectionPopupBuilder.this.closePopUp();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/scientific/py/tables/inspections/InspectionPopupBuilder$SetUpAutoStartToggleAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.scientific.py.tables"})
    public static final class SetUpAutoStartToggleAction
    extends ToggleAction {
        public SetUpAutoStartToggleAction() {
            super(SetUpAutoStartToggleAction::_init_$lambda$0, AllIcons.General.GearPlain);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return DSTablesSettingsState.Companion.getInstance().getRunInspectionRightAfterTableCreation();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            DSTablesSettingsState.Companion.getInstance().setRunInspectionRightAfterTableCreation(state);
        }

        private static final String _init_$lambda$0() {
            return PyTablesBundle.message("popup.inspections.auto.run.action.text", new Object[0]);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/scientific/py/tables/inspections/InspectionPopupBuilder$StopExecutionAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "(Lcom/intellij/scientific/py/tables/inspections/InspectionPopupBuilder;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.scientific.py.tables"})
    public final class StopExecutionAction
    extends AnAction {
        public StopExecutionAction() {
            super(PyTablesBundle.message("popup.inspections.stop.computation.action.text", new Object[0]), PyTablesBundle.message("popup.inspections.stop.computation.action.description", new Object[0]), AllIcons.Run.Stop);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            InspectionPopupBuilder.this.getStopComputationAction().invoke();
        }
    }
}

