/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.inspections.utils;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.scientific.tables.api.DSTableDataRetrieverFromDataSource;
import com.intellij.scientific.tables.api.DSTableDataType;
import com.intellij.scientific.tables.panel.DSTableImpl;
import com.intellij.scientific.tables.settings.DSTablesSettingsState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\u000e\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0014\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/scientific/py/tables/inspections/utils/TableInspectionSupportService;", "", "<init>", "()V", "REGISTRY_KEY", "", "MAX_ROWS", "", "MAX_COLUMNS", "canAutoStartInspection", "", "table", "Lcom/intellij/scientific/tables/panel/DSTableImpl;", "canRunInspection", "isFeatureEnabledInRegistryKey", "isInsideNotebookTable", "retriever", "Lcom/intellij/scientific/tables/api/DSTableDataRetrieverFromDataSource;", "isTableSupported", "isWithinSizeConstraints", "isAutoRunEnabledInSettings", "intellij.scientific.py.tables"})
public final class TableInspectionSupportService {
    @NotNull
    public static final TableInspectionSupportService INSTANCE = new TableInspectionSupportService();
    @NotNull
    private static final String REGISTRY_KEY = "tables.show.inspection.action";
    private static final int MAX_ROWS = 100000;
    private static final int MAX_COLUMNS = 200;

    private TableInspectionSupportService() {
    }

    public final boolean canAutoStartInspection(@NotNull DSTableImpl table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        DSTableDataRetrieverFromDataSource dSTableDataRetrieverFromDataSource = table.getTableDataRetrieverFromDataSource();
        if (dSTableDataRetrieverFromDataSource == null) {
            return false;
        }
        DSTableDataRetrieverFromDataSource retriever = dSTableDataRetrieverFromDataSource;
        return this.isFeatureEnabledInRegistryKey() && this.isAutoRunEnabledInSettings() && this.isInsideNotebookTable(retriever) && this.isTableSupported(retriever) && this.isWithinSizeConstraints(retriever);
    }

    public final boolean canRunInspection(@NotNull DSTableImpl table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        DSTableDataRetrieverFromDataSource dSTableDataRetrieverFromDataSource = table.getTableDataRetrieverFromDataSource();
        if (dSTableDataRetrieverFromDataSource == null) {
            return false;
        }
        DSTableDataRetrieverFromDataSource retriever = dSTableDataRetrieverFromDataSource;
        return this.isFeatureEnabledInRegistryKey() && this.isTableSupported(retriever);
    }

    private final boolean isFeatureEnabledInRegistryKey() {
        return Registry.Companion.is(REGISTRY_KEY, false);
    }

    private final boolean isInsideNotebookTable(DSTableDataRetrieverFromDataSource retriever) {
        return retriever.getPanelInfo().getInsideNotebook();
    }

    private final boolean isTableSupported(DSTableDataRetrieverFromDataSource retriever) {
        return retriever.isDynamicTable() && retriever.getDataFrameInfo().getTableType() == DSTableDataType.PANDAS_DATA_FRAME;
    }

    private final boolean isWithinSizeConstraints(DSTableDataRetrieverFromDataSource retriever) {
        return retriever.getNRows() <= 100000 && retriever.getNColumns() <= 200;
    }

    private final boolean isAutoRunEnabledInSettings() {
        return DSTablesSettingsState.Companion.getInstance().getRunInspectionRightAfterTableCreation();
    }
}

