/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.statistics;

import com.intellij.database.run.ui.table.statisticsPanel.types.ColumnVisualisationType;
import com.intellij.database.run.ui.table.statisticsPanel.types.ColumnVisualizationData;
import com.intellij.database.run.ui.table.statisticsPanel.types.ColumnVisualizationDataAxisXLabels;
import com.intellij.database.run.ui.table.statisticsPanel.types.ColumnVisualizationDataHistogram;
import com.intellij.database.run.ui.table.statisticsPanel.types.ColumnVisualizationDataPercentage;
import com.intellij.database.run.ui.table.statisticsPanel.types.ColumnVisualizationDataTooltip;
import com.intellij.database.run.ui.table.statisticsPanel.types.ColumnVisualizationDataUnique;
import com.intellij.database.run.ui.table.statisticsPanel.types.HistogramData;
import com.intellij.grid.charts.impl.StatisticsPanelRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.scientific.py.tables.util.UtilKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u000b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\fJ(\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f2\u0006\u0010\u0012\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\fH\u0002J\u001e\u0010\u0013\u001a\u0004\u0018\u00010\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000fH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J\u001c\u0010\u0019\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001a\u001a\u00020\u000f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000fH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001f\u001a\u00020\u000fH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001f\u001a\u00020\u000fH\u0002J\u0010\u0010!\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u000fH\u0002J(\u0010&\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\f0'2\u0006\u0010(\u001a\u00020\u000fH\u0002J,\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u000f2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000f0\f2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\"\u001a\u00020#*\u00020$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010%\u00a8\u0006."}, d2={"Lcom/intellij/scientific/py/tables/statistics/PyStatisticsTableVisualisationDataParser;", "", "<init>", "()V", "CHARS_TO_REMOVE", "", "EXPECTED_RESULT_PARTS", "", "MIN_BAR_HEIGHT", "", "MIN_VISIBLE_BAR_HEIGHT", "parseVisualizationCommandResult", "", "Lcom/intellij/database/run/ui/table/statisticsPanel/types/ColumnVisualizationData;", "visualizationData", "", "columnTypes", "parseVisualizationDataAllColumns", "occurrencesCount", "parseVisualizationDataOneColumn", "statistic", "colType", "createUniqueVisualization", "Lcom/intellij/database/run/ui/table/statisticsPanel/types/ColumnVisualizationDataUnique;", "values", "createHistogramVisualization", "pythonResultString", "columnDataType", "createPercentageVisualization", "Lcom/intellij/database/run/ui/table/statisticsPanel/types/ColumnVisualizationDataPercentage;", "formatNumberForPercentage", "value", "formatFloat", "castToIntIfPossible", "isMathematicalInteger", "", "", "(F)Z", "parsePythonData", "Lkotlin/Pair;", "input", "getValuesNeededFormat", "Lcom/intellij/database/run/ui/table/statisticsPanel/types/HistogramData;", "type", "xList", "yList", "intellij.scientific.py.tables"})
@SourceDebugExtension(value={"SMAP\nPyStatisticsTableVisualisationDataParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyStatisticsTableVisualisationDataParser.kt\ncom/intellij/scientific/py/tables/statistics/PyStatisticsTableVisualisationDataParser\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n23#2:162\n1596#3:163\n1629#3,4:164\n1586#3:168\n1661#3,3:169\n1586#3:172\n1661#3,3:173\n1586#3:176\n1661#3,3:177\n777#3:181\n873#3,2:182\n1915#3,2:184\n1586#3:186\n1661#3,3:187\n1586#3:190\n1661#3,3:191\n1586#3:194\n1661#3,3:195\n1#4:180\n*S KotlinDebug\n*F\n+ 1 PyStatisticsTableVisualisationDataParser.kt\ncom/intellij/scientific/py/tables/statistics/PyStatisticsTableVisualisationDataParser\n*L\n28#1:162\n47#1:163\n47#1:164,4\n77#1:168\n77#1:169,3\n90#1:172\n90#1:173,3\n91#1:176\n91#1:177,3\n123#1:181\n123#1:182,2\n124#1:184,2\n142#1:186\n142#1:187,3\n156#1:190\n156#1:191,3\n138#1:194\n138#1:195,3\n*E\n"})
public final class PyStatisticsTableVisualisationDataParser {
    @NotNull
    public static final PyStatisticsTableVisualisationDataParser INSTANCE = new PyStatisticsTableVisualisationDataParser();
    @NotNull
    private static final char[] CHARS_TO_REMOVE;
    private static final int EXPECTED_RESULT_PARTS = 2;
    private static final double MIN_BAR_HEIGHT = 0.05;
    private static final double MIN_VISIBLE_BAR_HEIGHT = 0.08;

    private PyStatisticsTableVisualisationDataParser() {
    }

    @Nullable
    public final List<ColumnVisualizationData> parseVisualizationCommandResult(@NotNull String visualizationData, @NotNull List<String> columnTypes) {
        Intrinsics.checkNotNullParameter((Object)visualizationData, (String)"visualizationData");
        Intrinsics.checkNotNullParameter(columnTypes, (String)"columnTypes");
        String[] stringArray = new String[]{"__pydev_val__"};
        List resultParts = StringsKt.split$default((CharSequence)visualizationData, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (resultParts.size() != 2) {
            String[] $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PyStatisticsTableVisualisationDataParser.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            $this$thisLogger$iv = new String[]{"__pydev_val__"};
            logger.warn("The size of visualization command result is not 2. The size is " + StringsKt.split$default((CharSequence)visualizationData, (String[])$this$thisLogger$iv, (boolean)false, (int)0, (int)6, null).size() + ". The result is: " + UtilKt.cleanString(visualizationData));
            return null;
        }
        String occurrencesCount = (String)resultParts.get(0);
        if (StringsKt.isBlank((CharSequence)occurrencesCount)) {
            return null;
        }
        return this.parseVisualizationDataAllColumns(occurrencesCount, columnTypes);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ColumnVisualizationData> parseVisualizationDataAllColumns(String occurrencesCount, List<String> columnTypes) {
        void $this$mapIndexedTo$iv$iv;
        String[] stringArray = new String[]{"__pydev_table_occurrences_count_next_column__"};
        List visualizationDataSplitByColumns = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)occurrencesCount, (String)"\n", (String)"", (boolean)false, (int)4, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        Iterable $this$mapIndexed$iv = visualizationDataSplitByColumns;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void occurrence;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(INSTANCE.parseVisualizationDataOneColumn((String)occurrence, (String)CollectionsKt.getOrNull(columnTypes, (int)index)));
        }
        return (List)destination$iv$iv;
    }

    private final ColumnVisualizationData parseVisualizationDataOneColumn(String statistic, String colType) {
        String string = statistic;
        if (string == null || (string = StringsKt.removeSurrounding((String)string, (CharSequence)"{", (CharSequence)"}")) == null) {
            return null;
        }
        String stringMap = string;
        char[] cArray = new char[]{':'};
        List parts = StringsKt.split$default((CharSequence)stringMap, (char[])cArray, (boolean)false, (int)2, (int)2, null);
        char[] cArray2 = CHARS_TO_REMOVE;
        String visualizationTypeString = StringsKt.trim((String)((String)parts.get(0)), (char[])Arrays.copyOf(cArray2, cArray2.length));
        char[] cArray3 = CHARS_TO_REMOVE;
        String values = StringsKt.trim((String)((String)parts.get(1)), (char[])Arrays.copyOf(cArray3, cArray3.length));
        ColumnVisualisationType columnVisualisationType = ColumnVisualisationType.Companion.fromPythonString(visualizationTypeString);
        if (columnVisualisationType == null) {
            return null;
        }
        ColumnVisualisationType visualizationType = columnVisualisationType;
        return switch (WhenMappings.$EnumSwitchMapping$0[visualizationType.ordinal()]) {
            case 1 -> this.createHistogramVisualization(values, colType);
            case 2 -> (ColumnVisualizationData)this.createUniqueVisualization(values);
            case 3 -> (ColumnVisualizationData)this.createPercentageVisualization(values);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final ColumnVisualizationDataUnique createUniqueVisualization(String values) {
        return new ColumnVisualizationDataUnique(values);
    }

    /*
     * WARNING - void declaration
     */
    private final ColumnVisualizationData createHistogramVisualization(String pythonResultString, String columnDataType) {
        Collection<Integer> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (columnDataType == null) {
            return null;
        }
        Pair<List<String>, List<String>> pair = this.parsePythonData(pythonResultString);
        List xList = (List)pair.component1();
        List yList = (List)pair.component2();
        Iterable iterable = yList;
        List list = xList;
        String string = columnDataType;
        PyStatisticsTableVisualisationDataParser pyStatisticsTableVisualisationDataParser = this;
        boolean $i$f$map = false;
        void var9_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Integer.parseInt((String)it));
        }
        collection = (List)destination$iv$iv;
        HistogramData histogramValues = pyStatisticsTableVisualisationDataParser.getValuesNeededFormat(string, list, (List<Integer>)collection);
        ColumnVisualizationDataTooltip histogramTooltips = StatisticsPanelRenderer.Companion.getTooltips(columnDataType);
        ColumnVisualizationDataAxisXLabels axisXLabels = StatisticsPanelRenderer.Companion.getAxisXLabels(xList, columnDataType);
        return (ColumnVisualizationData)new ColumnVisualizationDataHistogram(histogramValues, histogramTooltips, axisXLabels);
    }

    /*
     * WARNING - void declaration
     */
    private final ColumnVisualizationDataPercentage createPercentageVisualization(String pythonResultString) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable<String> iterable;
        void $this$mapTo$iv$iv2;
        Pair<List<String>, List<String>> pair = this.parsePythonData(pythonResultString);
        List xList = (List)pair.component1();
        List yList = (List)pair.component2();
        Iterable $this$map$iv2 = yList;
        boolean $i$f$map22 = false;
        Iterable iterable2 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            String string = (String)item$iv$iv;
            iterable = destination$iv$iv;
            boolean bl = false;
            iterable.add(INSTANCE.formatNumberForPercentage((String)it));
        }
        List formattedYList = (List)destination$iv$iv;
        Iterable $i$f$map22 = formattedYList;
        iterable = xList;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String bl = (String)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(CollectionsKt.listOf((Object)it));
        }
        Map percentageMap = MapsKt.toMap((Iterable)CollectionsKt.zip(iterable, (Iterable)((List)destination$iv$iv2)));
        return new ColumnVisualizationDataPercentage(percentageMap);
    }

    private final String formatNumberForPercentage(String value2) {
        String string;
        String string2 = this.formatFloat(value2);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            string = INSTANCE.castToIntIfPossible(it);
        } else {
            string = null;
        }
        return string;
    }

    private final String formatFloat(String value2) {
        Object object = StringsKt.toIntOrNull((String)value2);
        if (object == null || (object = String.valueOf((Integer)object)) == null) {
            Float f = StringsKt.toFloatOrNull((String)value2);
            if (f != null) {
                float it = ((Number)f).floatValue();
                boolean bl = false;
                Locale locale = Locale.US;
                String string = "%.1f";
                Object[] objectArray = new Object[]{Float.valueOf(it)};
                String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                object = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            } else {
                object = null;
            }
        }
        return object;
    }

    private final String castToIntIfPossible(String value2) {
        Object object;
        block4: {
            block3: {
                object = StringsKt.toFloatOrNull((String)value2);
                if (object == null) break block3;
                float f = ((Number)object).floatValue();
                boolean bl = false;
                String string = INSTANCE.isMathematicalInteger(f) ? String.valueOf((int)f) : value2;
                object = string;
                if (string != null) break block4;
            }
            object = value2;
        }
        return object;
    }

    private final boolean isMathematicalInteger(float $this$isMathematicalInteger) {
        return $this$isMathematicalInteger % 1.0f == 0.0f;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<List<String>, List<String>> parsePythonData(String input) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        List xList = new ArrayList();
        List yList = new ArrayList();
        Object object = new String[]{"__pydev_table_occurrences_count_next_value__"};
        object = StringsKt.split$default((CharSequence)StringsKt.removeSurrounding((String)input, (CharSequence)"{", (CharSequence)"}"), (String[])object, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String entry = (String)element$iv;
            boolean bl = false;
            Object[] objectArray = new String[]{"__pydev_table_occurrences_count_dict__"};
            List parts = StringsKt.split$default((CharSequence)entry, (String[])objectArray, (boolean)false, (int)0, (int)6, null);
            if (parts.size() != 2) continue;
            objectArray = CHARS_TO_REMOVE;
            xList.add(StringsKt.trim((String)((String)parts.get(0)), (char[])Arrays.copyOf((char[])objectArray, objectArray.length)));
            yList.add(parts.get(1));
        }
        return new Pair((Object)xList, (Object)yList);
    }

    /*
     * WARNING - void declaration
     */
    private final HistogramData getValuesNeededFormat(String type, List<String> xList, List<Integer> yList) {
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = PyStatisticsTableVisualisationDataParser.getValuesNeededFormat$normalizeList(yList);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            double d = ((Number)item$iv$iv).doubleValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it == 0.0 ? 0.05 : (it < 0.08 ? 0.08 : it));
        }
        List barHeights = (List)destination$iv$iv;
        HistogramData data = new HistogramData(barHeights, xList, yList, null, 8, null);
        if (StringsKt.startsWith$default((String)type, (String)"bool", (boolean)false, (int)2, null)) {
            void $this$mapTo$iv$iv2;
            int sum = CollectionsKt.sumOfInt((Iterable)yList);
            Iterable $this$map$iv2 = yList;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                int n = ((Number)item$iv$iv).intValue();
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add((int)((double)it * 100.0 / (double)sum));
            }
            List percentageList = (List)destination$iv$iv2;
            data.setPercentageList(percentageList);
        }
        return data;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Double> getValuesNeededFormat$normalizeList(List<Integer> listOfBarHeights) {
        void $this$mapTo$iv$iv;
        int maxValuesCountInBars = ((Number)((Object)CollectionsKt.maxOrThrow((Iterable)listOfBarHeights))).intValue();
        Iterable $this$map$iv = listOfBarHeights;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((double)it / (double)maxValuesCountInBars);
        }
        return (List)destination$iv$iv;
    }

    static {
        char[] cArray = new char[]{'\'', '\"', ' '};
        CHARS_TO_REMOVE = cArray;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ColumnVisualisationType.values().length];
            try {
                nArray[ColumnVisualisationType.HISTOGRAM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColumnVisualisationType.UNIQUE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColumnVisualisationType.PERCENTAGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

