/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.util;

import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.intellij.scientific.tables.api.DSTableDataType;
import com.jetbrains.python.debugger.PyDebugValue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u00a8\u0006\u0007"}, d2={"getDSTableDataType", "Lcom/intellij/scientific/tables/api/DSTableDataType;", "debugValue", "Lcom/jetbrains/python/debugger/PyDebugValue;", "cleanString", "", "stringWithAnsi", "intellij.scientific.py.tables"})
public final class UtilKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final DSTableDataType getDSTableDataType(@NotNull PyDebugValue debugValue) {
        String typeQualifier;
        Intrinsics.checkNotNullParameter((Object)debugValue, (String)"debugValue");
        String string = typeQualifier = debugValue.getTypeQualifier();
        boolean bl = string != null ? StringsKt.startsWith$default((String)string, (String)"polars.dataframe", (boolean)false, (int)2, null) : false;
        if (bl) {
            return DSTableDataType.POLARS_DATA_FRAME;
        }
        String string2 = typeQualifier;
        boolean bl2 = string2 != null ? StringsKt.startsWith$default((String)string2, (String)"polars.series", (boolean)false, (int)2, null) : false;
        if (bl2) {
            return DSTableDataType.POLARS_SERIES;
        }
        String string3 = debugValue.getType();
        if (string3 == null) return null;
        int n = -1;
        switch (string3.hashCode()) {
            case -1821971817: {
                if (string3.equals("Series")) {
                    n = 1;
                }
                break;
            }
            case 411652298: {
                if (string3.equals("ResourceVariable")) {
                    n = 2;
                }
                break;
            }
            case 1460321977: {
                if (string3.equals("SparseTensor")) {
                    n = 3;
                }
                break;
            }
            case -1793451911: {
                if (string3.equals("Tensor")) {
                    n = 4;
                }
                break;
            }
            case -1643374328: {
                if (string3.equals("GeoSeries")) {
                    n = 5;
                }
                break;
            }
            case 2021122961: {
                if (string3.equals("EagerTensor")) {
                    n = 6;
                }
                break;
            }
            case -1187099560: {
                if (string3.equals("Dataset")) {
                    n = 7;
                }
                break;
            }
            case 1617437635: {
                if (string3.equals("DataFrame")) {
                    n = 8;
                }
                break;
            }
            case 750752690: {
                if (string3.equals("GeoDataFrame")) {
                    n = 9;
                }
                break;
            }
            case 1797162595: {
                if (string3.equals("ndarray")) {
                    n = 10;
                }
                break;
            }
            case -812149815: {
                if (string3.equals("recarray")) {
                    n = 11;
                }
                break;
            }
        }
        switch (n) {
            case 8: {
                DSTableDataType dSTableDataType = DSTableDataType.PANDAS_DATA_FRAME;
                return dSTableDataType;
            }
            case 9: {
                DSTableDataType dSTableDataType = DSTableDataType.PANDAS_DATA_FRAME;
                return dSTableDataType;
            }
            case 1: {
                DSTableDataType dSTableDataType = DSTableDataType.PANDAS_SERIES;
                return dSTableDataType;
            }
            case 5: {
                DSTableDataType dSTableDataType = DSTableDataType.PANDAS_SERIES;
                return dSTableDataType;
            }
            case 10: {
                DSTableDataType dSTableDataType = DSTableDataType.NUMPY_ARRAY;
                return dSTableDataType;
            }
            case 11: {
                DSTableDataType dSTableDataType = DSTableDataType.NUMPY_RECARRAY;
                return dSTableDataType;
            }
            case 6: {
                DSTableDataType dSTableDataType = DSTableDataType.EAGER_TENSOR;
                return dSTableDataType;
            }
            case 2: {
                DSTableDataType dSTableDataType = DSTableDataType.RESOURCE_VARIABLE;
                return dSTableDataType;
            }
            case 3: {
                DSTableDataType dSTableDataType = DSTableDataType.SPARSE_TENSOR;
                return dSTableDataType;
            }
            case 4: {
                DSTableDataType dSTableDataType = DSTableDataType.TORCH_TENSOR;
                return dSTableDataType;
            }
            case 7: {
                DSTableDataType dSTableDataType = DSTableDataType.HF_DATASET;
                return dSTableDataType;
            }
            default: {
                return null;
            }
        }
    }

    @NotNull
    public static final String cleanString(@NotNull String stringWithAnsi) {
        Intrinsics.checkNotNullParameter((Object)stringWithAnsi, (String)"stringWithAnsi");
        AnsiEscapeDecoder decoder = new AnsiEscapeDecoder();
        StringBuilder plainTextBuilder = new StringBuilder();
        decoder.escapeText(stringWithAnsi, ProcessOutputTypes.STDOUT, (arg_0, arg_1) -> UtilKt.cleanString$lambda$0(plainTextBuilder, arg_0, arg_1));
        String string = plainTextBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final void cleanString$lambda$0(StringBuilder $plainTextBuilder, String text, Key key) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)key, (String)"<unused var>");
        $plainTextBuilder.append(text);
    }
}

