/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.model.modelApi;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiCacheKey;
import com.intellij.util.Function;
import com.jetbrains.django.DjangoFQNamesProvider;
import com.jetbrains.django.DjangoFunctionParams;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.django.model.modelApi.DjangoUrlArgumentDefinition;
import com.jetbrains.django.model.modelApi.DjangoUrlPatternsKt;
import com.jetbrains.django.model.modelApi.NamesBuilder;
import com.jetbrains.python.FunctionParameter;
import com.jetbrains.python.extensions.python.PyCallExpressionExtKt;
import com.jetbrains.python.nameResolver.FQNamesProvider;
import com.jetbrains.python.psi.PsiQuery;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyAnyExpressionEvaluator;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.blockEvaluator.PyBlockEvaluator;
import com.jetbrains.python.psi.impl.blockEvaluator.PyEvaluationContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoUrlModel {
    private static final PsiCacheKey<List<DjangoUrlModel>, PyFile> URLS_MODELS_BY_FILE = PsiCacheKey.create((String)DjangoUrlModel.class.getName(), (Function)new UrlsByFileObtainer());
    private static final NoEmptyFilter NO_EMPTY_FILTER = new NoEmptyFilter();
    private static final MyParentInfo NO_PARENT = new MyParentInfo(null);
    @NotNull
    private final PyArgumentList myUrlCallArgumentList;
    @NotNull
    private final MyParentInfo myParentInfo;
    @NotNull
    private final PyEvaluationContext myEvaluationContext;
    @NotNull
    private final Set<String> myNames;

    private DjangoUrlModel(@NotNull PyArgumentList urlCallArgumentList, @NotNull MyParentInfo parentGroups, @NotNull PyEvaluationContext evaluationContext) {
        if (urlCallArgumentList == null) {
            DjangoUrlModel.$$$reportNull$$$0(0);
        }
        if (parentGroups == null) {
            DjangoUrlModel.$$$reportNull$$$0(1);
        }
        if (evaluationContext == null) {
            DjangoUrlModel.$$$reportNull$$$0(2);
        }
        this.myUrlCallArgumentList = urlCallArgumentList;
        this.myParentInfo = parentGroups;
        this.myEvaluationContext = evaluationContext;
        String name = PyPsiUtils.getStringValue((PsiElement)this.myUrlCallArgumentList.getValueExpressionForParam((FunctionParameter)DjangoFunctionParams.URL_NAME));
        if (name == null) {
            this.myNames = Collections.emptySet();
            return;
        }
        Set<String> nameSet = Collections.singleton(name);
        if (this.myParentInfo.myNamespaces == null) {
            this.myNames = nameSet;
            return;
        }
        List<List<String>> parentNamespaces = parentGroups.myNamespaces;
        this.myNames = NamesBuilder.buildNames(name, parentNamespaces);
    }

    @Nullable
    public static DjangoUrlModel getUrlByName(@NotNull Module djangoModule, @NotNull String urlNameToSearch) {
        if (djangoModule == null) {
            DjangoUrlModel.$$$reportNull$$$0(3);
        }
        if (urlNameToSearch == null) {
            DjangoUrlModel.$$$reportNull$$$0(4);
        }
        for (DjangoUrlModel urlModel : DjangoUrlModel.getAllUrls(djangoModule, urlNameToSearch)) {
            if (!urlModel.getUrlNames().contains(urlNameToSearch)) continue;
            return urlModel;
        }
        return null;
    }

    @NotNull
    public static Set<DjangoUrlModel> getAllUrls(@NotNull Module djangoModule, @Nullable String stopIfNameMatches) {
        if (djangoModule == null) {
            DjangoUrlModel.$$$reportNull$$$0(5);
        }
        HashSet<DjangoUrlModel> result = new HashSet<DjangoUrlModel>();
        DjangoModelApi api = (DjangoModelApi)DjangoModelApi.create(djangoModule).getSuccessOrNull();
        if (api == null) {
            Set<DjangoUrlModel> set = Collections.emptySet();
            if (set == null) {
                DjangoUrlModel.$$$reportNull$$$0(6);
            }
            return set;
        }
        DjangoUrlModel.collectUrls(result, api.getRootUrls(), stopIfNameMatches);
        HashSet<DjangoUrlModel> hashSet = result;
        if (hashSet == null) {
            DjangoUrlModel.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    private static void collectUrls(@NotNull Set<DjangoUrlModel> result, @NotNull Iterable<DjangoUrlModel> source, @Nullable String stopIfNameMatches) {
        if (result == null) {
            DjangoUrlModel.$$$reportNull$$$0(8);
        }
        if (source == null) {
            DjangoUrlModel.$$$reportNull$$$0(9);
        }
        for (DjangoUrlModel urlModel : source) {
            result.add(urlModel);
            if (stopIfNameMatches != null && urlModel.getUrlNames().contains(stopIfNameMatches)) continue;
            DjangoUrlModel.collectUrls(result, urlModel.getSubUrls(), stopIfNameMatches);
        }
    }

    @NotNull
    public Set<String> getUrlNames() {
        Set<String> set = Collections.unmodifiableSet(this.myNames);
        if (set == null) {
            DjangoUrlModel.$$$reportNull$$$0(10);
        }
        return set;
    }

    @NotNull
    public List<DjangoUrlModel> getSubUrls() {
        PyExpression appNameFromUrlConf;
        PyFile includedFile;
        PyExpression viewExpression = (PyExpression)PyUtil.as((Object)this.myUrlCallArgumentList.getValueExpressionForParam((FunctionParameter)DjangoFunctionParams.URL_VIEW), PyExpression.class);
        if (viewExpression == null) {
            List<DjangoUrlModel> list = Collections.emptyList();
            if (list == null) {
                DjangoUrlModel.$$$reportNull$$$0(11);
            }
            return list;
        }
        PyCallExpression viewCall = (PyCallExpression)PyAnyExpressionEvaluator.evaluateOne((PyExpression)viewExpression, PyCallExpression.class);
        if (viewCall == null) {
            List<DjangoUrlModel> list = Collections.emptyList();
            if (list == null) {
                DjangoUrlModel.$$$reportNull$$$0(12);
            }
            return list;
        }
        PyArgumentList includeUrlList = (PyArgumentList)new PsiQuery((PsiElement)viewCall).filter(o -> PyCallExpressionExtKt.isCalleeName((PyCallExpression)o, (FQNamesProvider[])new FQNamesProvider[]{DjangoFQNamesProvider.INCLUDE_FUNCTION})).descendants(PyArgumentList.class).getFirstElement();
        if (includeUrlList == null) {
            List<DjangoUrlModel> list = Collections.emptyList();
            if (list == null) {
                DjangoUrlModel.$$$reportNull$$$0(13);
            }
            return list;
        }
        MyIncludeInfo includeInfo = DjangoUrlModel.getIncludeInfo(includeUrlList);
        if (includeInfo == null) {
            List<DjangoUrlModel> list = Collections.emptyList();
            if (list == null) {
                DjangoUrlModel.$$$reportNull$$$0(14);
            }
            return list;
        }
        ArrayList<String> currentNamespaces = new ArrayList<String>();
        if (includeInfo.myAppName != null) {
            currentNamespaces.add(PyAnyExpressionEvaluator.evaluateString((PyExpression)includeInfo.myAppName));
        }
        if (includeInfo.myInstanceName != null) {
            currentNamespaces.add(PyAnyExpressionEvaluator.evaluateString((PyExpression)includeInfo.myInstanceName));
        }
        if ((includedFile = (PyFile)PyAnyExpressionEvaluator.evaluateOne((PyExpression)includeInfo.myArg, PyFile.class)) == null) {
            includedFile = (PyFile)PyUtil.findReference((PsiElement)includeInfo.myArg, PyFile.class);
        }
        if (includedFile != null && (appNameFromUrlConf = DjangoUrlModel.getAppNameFromUrlConf(includedFile)) != null) {
            currentNamespaces.add(PyAnyExpressionEvaluator.evaluateString((PyExpression)appNameFromUrlConf));
        }
        ArrayList<List<String>> namespaces = new ArrayList<List<String>>();
        if (this.myParentInfo.myNamespaces != null) {
            namespaces.addAll(this.myParentInfo.myNamespaces);
        }
        namespaces.add(currentNamespaces);
        MyParentInfo patentInfo = new MyParentInfo(namespaces);
        if (includedFile != null) {
            return DjangoUrlModel.getUrlsByFile(includedFile, patentInfo, this.myEvaluationContext);
        }
        List expressions = PyAnyExpressionEvaluator.evaluateIterable((PyExpression)includeInfo.myArg, PyCallExpression.class);
        List<PyArgumentList> urls = DjangoUrlModel.getUrlCallArgumentListsFromUrlPatterns(expressions);
        ArrayList<DjangoUrlModel> result = new ArrayList<DjangoUrlModel>();
        for (PyArgumentList url : urls) {
            result.add(new DjangoUrlModel(url, patentInfo, this.myEvaluationContext));
        }
        ArrayList<DjangoUrlModel> arrayList = result;
        if (arrayList == null) {
            DjangoUrlModel.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @Nullable
    public static PyExpression getAppNameFromUrlConf(@NotNull PyFile urlFile) {
        PyTargetExpression appNameExpression;
        if (urlFile == null) {
            DjangoUrlModel.$$$reportNull$$$0(16);
        }
        if ((appNameExpression = urlFile.findTopLevelAttribute("app_name")) != null) {
            return appNameExpression.findAssignedValue();
        }
        return null;
    }

    @Nullable
    private static MyIncludeInfo getIncludeInfo(@NotNull PyArgumentList includeUrlList) {
        PyExpression includeArg;
        if (includeUrlList == null) {
            DjangoUrlModel.$$$reportNull$$$0(17);
        }
        if ((includeArg = (PyExpression)PyUtil.as((Object)includeUrlList.getValueExpressionForParam((FunctionParameter)DjangoFunctionParams.INCLUDE_ARG), PyExpression.class)) == null) {
            return null;
        }
        PyExpression appNameExp = null;
        PyExpression instanceNameExp = null;
        PyTupleExpression tuple = (PyTupleExpression)PyAnyExpressionEvaluator.evaluateOne((PyExpression)includeArg, PyTupleExpression.class);
        if (tuple != null) {
            PyExpression[] expressionArgs = (PyExpression[])Iterables.toArray((Iterable)tuple, PyExpression.class);
            if (expressionArgs.length > 0) {
                includeArg = expressionArgs[0];
            }
            if (expressionArgs.length > 1) {
                appNameExp = expressionArgs[1];
            }
            if (expressionArgs.length > 2) {
                instanceNameExp = expressionArgs[2];
            }
        } else {
            appNameExp = (PyExpression)PyUtil.as((Object)includeUrlList.getValueExpressionForParam((FunctionParameter)DjangoFunctionParams.INCLUDE_APP_NAMESPACE), PyExpression.class);
            instanceNameExp = (PyExpression)PyUtil.as((Object)includeUrlList.getValueExpressionForParam((FunctionParameter)DjangoFunctionParams.INCLUDE_INSTANCE_NAMESPACE), PyExpression.class);
        }
        return new MyIncludeInfo(includeArg, appNameExp, instanceNameExp);
    }

    @NotNull
    public List<DjangoUrlArgumentDefinition<?>> getArguments() {
        List<DjangoUrlArgumentDefinition<?>> list = DjangoUrlPatternsKt.getArgumentDefinitions(this.myUrlCallArgumentList);
        if (list == null) {
            DjangoUrlModel.$$$reportNull$$$0(18);
        }
        return list;
    }

    @Nullable
    public PyExpression getUrlRouteExpression() {
        return this.myUrlCallArgumentList.getValueExpressionForParam((FunctionParameter)DjangoFunctionParams.URL_ROUTE);
    }

    @Nullable
    public PyExpression getUrlNameExpression() {
        return this.myUrlCallArgumentList.getValueExpressionForParam((FunctionParameter)DjangoFunctionParams.URL_NAME);
    }

    @NotNull
    public static List<DjangoUrlModel> getUrlsByFile(@NotNull PyFile urlsPy) {
        if (urlsPy == null) {
            DjangoUrlModel.$$$reportNull$$$0(19);
        }
        List list = (List)URLS_MODELS_BY_FILE.getValue((PsiElement)urlsPy);
        if (list == null) {
            DjangoUrlModel.$$$reportNull$$$0(20);
        }
        return list;
    }

    @NotNull
    private static List<DjangoUrlModel> getUrlsByFile(@NotNull PyFile urlsPy, @NotNull MyParentInfo parentInfo, @Nullable PyEvaluationContext evaluationContext) {
        if (urlsPy == null) {
            DjangoUrlModel.$$$reportNull$$$0(21);
        }
        if (parentInfo == null) {
            DjangoUrlModel.$$$reportNull$$$0(22);
        }
        MyPatternsToUrlBlockEvaluator evaluator = evaluationContext != null ? new MyPatternsToUrlBlockEvaluator(evaluationContext) : new MyPatternsToUrlBlockEvaluator();
        evaluator.trackDeclarations("urlpatterns");
        evaluator.evaluate((PyElement)urlsPy);
        List<PyArgumentList> urlCallArgumentLists = DjangoUrlModel.getUrlCallArgumentListsFromUrlPatterns(evaluator.getValueAsList("urlpatterns"));
        ArrayList<DjangoUrlModel> models = new ArrayList<DjangoUrlModel>();
        for (PyArgumentList urlCall : urlCallArgumentLists) {
            models.add(new DjangoUrlModel(urlCall, parentInfo, evaluator.getContext()));
        }
        ArrayList<DjangoUrlModel> arrayList = models;
        if (arrayList == null) {
            DjangoUrlModel.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    @NotNull
    private static List<PyArgumentList> getUrlCallArgumentListsFromUrlPatterns(List<?> list) {
        List oldSyntaxExpressions = PyUtil.asList(list, PyArgumentList.class);
        if (!oldSyntaxExpressions.isEmpty()) {
            List list2 = oldSyntaxExpressions;
            if (list2 == null) {
                DjangoUrlModel.$$$reportNull$$$0(24);
            }
            return list2;
        }
        List newSyntaxExpressions = PyUtil.asList(list, PyCallExpression.class);
        ArrayList<PyArgumentList> result = new ArrayList<PyArgumentList>();
        for (PyCallExpression expression : newSyntaxExpressions) {
            PyArgumentList argumentList = expression.getArgumentList();
            if (argumentList == null) continue;
            result.add(argumentList);
        }
        ArrayList<PyArgumentList> arrayList = result;
        if (arrayList == null) {
            DjangoUrlModel.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    public String toString() {
        return this.myNames.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 10, 11, 12, 13, 14, 15, 18, 20, 23, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlCallArgumentList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentGroups";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "djangoModule";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlNameToSearch";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 20: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/model/modelApi/DjangoUrlModel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlFile";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeUrlList";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlsPy";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/model/modelApi/DjangoUrlModel";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllUrls";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlNames";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubUrls";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 20: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlsByFile";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlCallArgumentListsFromUrlPatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getUrlByName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAllUrls";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 20: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectUrls";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAppNameFromUrlConf";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getIncludeInfo";
                break;
            }
            case 19: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getUrlsByFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 10, 11, 12, 13, 14, 15, 18, 20, 23, 24, 25 -> new IllegalStateException(string);
        };
    }

    private static final class MyParentInfo {
        @Nullable
        private final List<List<String>> myNamespaces;

        private MyParentInfo(@Nullable List<List<String>> namespaces) {
            this.myNamespaces = namespaces == null ? null : new ArrayList<List<String>>(Collections2.filter(namespaces, (Predicate)NO_EMPTY_FILTER));
        }
    }

    private static final class MyIncludeInfo {
        @NotNull
        private final PyExpression myArg;
        @Nullable
        private final PyExpression myAppName;
        @Nullable
        private final PyExpression myInstanceName;

        private MyIncludeInfo(@NotNull PyExpression arg, @Nullable PyExpression appName, @Nullable PyExpression instanceName) {
            if (arg == null) {
                MyIncludeInfo.$$$reportNull$$$0(0);
            }
            this.myArg = arg;
            this.myAppName = appName;
            this.myInstanceName = instanceName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/jetbrains/django/model/modelApi/DjangoUrlModel$MyIncludeInfo", "<init>"));
        }
    }

    private static final class MyPatternsToUrlBlockEvaluator
    extends PyBlockEvaluator {
        private MyPatternsToUrlBlockEvaluator() {
        }

        private MyPatternsToUrlBlockEvaluator(@NotNull PyEvaluationContext evaluationContext) {
            if (evaluationContext == null) {
                MyPatternsToUrlBlockEvaluator.$$$reportNull$$$0(0);
            }
            super(evaluationContext);
        }

        protected PyEvaluator createEvaluator() {
            return new MyPatternsToUrlExpressionEvaluator();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluationContext", "com/jetbrains/django/model/modelApi/DjangoUrlModel$MyPatternsToUrlBlockEvaluator", "<init>"));
        }
    }

    private static class UrlsByFileObtainer
    implements Function<PyFile, List<DjangoUrlModel>> {
        private UrlsByFileObtainer() {
        }

        public List<DjangoUrlModel> fun(PyFile file) {
            return DjangoUrlModel.getUrlsByFile(file, NO_PARENT, null);
        }
    }

    private static class NoEmptyFilter
    implements Predicate<List<String>> {
        private NoEmptyFilter() {
        }

        public boolean apply(List<String> input) {
            return !input.isEmpty();
        }
    }

    private static class MyPatternsToUrlExpressionEvaluator
    extends PyAnyExpressionEvaluator {
        MyPatternsToUrlExpressionEvaluator() {
            super(true);
        }

        @NotNull
        public Object applyPlus(@Nullable Object lhs, @Nullable Object rhs) {
            if (lhs instanceof List && rhs instanceof PsiElement) {
                Object object = lhs;
                if (object == null) {
                    MyPatternsToUrlExpressionEvaluator.$$$reportNull$$$0(0);
                }
                return object;
            }
            Object object = super.applyPlus(lhs, rhs);
            if (object == null) {
                MyPatternsToUrlExpressionEvaluator.$$$reportNull$$$0(1);
            }
            return object;
        }

        @NotNull
        protected Object evaluateCall(@NotNull PyCallExpression expression) {
            if (expression == null) {
                MyPatternsToUrlExpressionEvaluator.$$$reportNull$$$0(2);
            }
            if (PyCallExpressionExtKt.isCalleeName((PyCallExpression)expression, (FQNamesProvider[])new FQNamesProvider[]{DjangoFQNamesProvider.URL_I18N_PATTERNS_FUNCTION})) {
                List list = new PsiQuery((PsiElement)expression).descendants(new PsiQuery.PsiFilter(PyCallExpression.class, o -> PyCallExpressionExtKt.isCalleeName((PyCallExpression)o, (FQNamesProvider[])new FQNamesProvider[]{DjangoFQNamesProvider.URL_PATH_OR_RE_PATH_FUNCTION}))).descendants(PyArgumentList.class).getElements();
                if (list == null) {
                    MyPatternsToUrlExpressionEvaluator.$$$reportNull$$$0(3);
                }
                return list;
            }
            Object object = super.evaluateCall(expression);
            if (object == null) {
                MyPatternsToUrlExpressionEvaluator.$$$reportNull$$$0(4);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/django/model/modelApi/DjangoUrlModel$MyPatternsToUrlExpressionEvaluator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "applyPlus";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/django/model/modelApi/DjangoUrlModel$MyPatternsToUrlExpressionEvaluator";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "evaluateCall";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "evaluateCall";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

