/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.unattendedHost.ui;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.StackingPopupDispatcher;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.jetbrains.rd.ide.model.IdeFrameSynchronizerModel;
import com.jetbrains.rd.ide.model.LxEvent;
import com.jetbrains.rd.ide.model.LxMouseEvent;
import com.jetbrains.rd.ide.model.LxMouseEventBase;
import com.jetbrains.rd.ide.model.LxPoint;
import com.jetbrains.rd.ide.model.LxSize;
import com.jetbrains.rd.platform.codeWithMe.lux.UtilKt;
import com.jetbrains.rd.platform.codeWithMe.lux.util.EventsKt;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdserver.lux.util.UnattendedHostEventHelper;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/ui/UnattendedHostFrameSyncProtocolListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rd/ide/model/IdeFrameSynchronizerModel;", "<init>", "()V", "getProjectFrame", "Lcom/intellij/openapi/wm/impl/IdeFrameImpl;", "project", "Lcom/intellij/openapi/project/Project;", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "getPoint", "Ljava/awt/Point;", "mouseEventPanel", "Ljavax/swing/JPanel;", "Companion", "intellij.platform.remoteController.backend"})
@SourceDebugExtension(value={"SMAP\nUnattendedHostFrameSyncProtocolListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnattendedHostFrameSyncProtocolListener.kt\ncom/jetbrains/rdserver/unattendedHost/ui/UnattendedHostFrameSyncProtocolListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,65:1\n67#2,4:66\n67#2,4:70\n13#2:74\n*S KotlinDebug\n*F\n+ 1 UnattendedHostFrameSyncProtocolListener.kt\ncom/jetbrains/rdserver/unattendedHost/ui/UnattendedHostFrameSyncProtocolListener\n*L\n38#1:66,4\n43#1:70,4\n26#1:74\n*E\n"})
public final class UnattendedHostFrameSyncProtocolListener
implements SolutionExtListener<IdeFrameSynchronizerModel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    private final IdeFrameImpl getProjectFrame(Project project) {
        IdeFrame ideFrame = WindowManager.getInstance().getIdeFrame(project);
        ProjectFrameHelper projectFrameHelper = ideFrame instanceof ProjectFrameHelper ? (ProjectFrameHelper)ideFrame : null;
        return projectFrameHelper != null ? projectFrameHelper.getFrame() : null;
    }

    public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull IdeFrameSynchronizerModel model) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        if (session.getType() != ClientType.CONTROLLER) {
            return;
        }
        model.getFrameLocation().advise(lifetime, arg_0 -> UnattendedHostFrameSyncProtocolListener.extensionCreated$lambda$0(this, session, arg_0));
        model.getFrameSize().advise(lifetime, arg_0 -> UnattendedHostFrameSyncProtocolListener.extensionCreated$lambda$1(this, session, arg_0));
        model.getTransferEvent().advise(lifetime, arg_0 -> UnattendedHostFrameSyncProtocolListener.extensionCreated$lambda$2(this, session, arg_0));
    }

    private final Point getPoint(JPanel mouseEventPanel) {
        Point point;
        Point $this$getPoint_u24lambda_u240 = point = mouseEventPanel.getLocationOnScreen();
        boolean bl = false;
        $this$getPoint_u24lambda_u240.translate(mouseEventPanel.getWidth() / 2, mouseEventPanel.getHeight() / 2);
        Point point2 = point;
        Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"apply(...)");
        return point2;
    }

    private static final Unit extensionCreated$lambda$0(UnattendedHostFrameSyncProtocolListener this$0, ClientProjectSession $session, LxPoint it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IdeFrameImpl ideFrameImpl = this$0.getProjectFrame($session.getProject());
        if (ideFrameImpl == null) {
            return Unit.INSTANCE;
        }
        IdeFrameImpl frame = ideFrameImpl;
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Received frame location: " + UtilKt.fromLxInt((LxPoint)it) + " for frame " + frame);
        }
        frame.setLocation(UtilKt.fromLxInt((LxPoint)it));
        return Unit.INSTANCE;
    }

    private static final Unit extensionCreated$lambda$1(UnattendedHostFrameSyncProtocolListener this$0, ClientProjectSession $session, LxSize it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IdeFrameImpl ideFrameImpl = this$0.getProjectFrame($session.getProject());
        if (ideFrameImpl == null) {
            return Unit.INSTANCE;
        }
        IdeFrameImpl frame = ideFrameImpl;
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Received frame size: " + UtilKt.fromLx((LxSize)it) + " for frame " + frame);
        }
        frame.setSize(UtilKt.fromLx((LxSize)it));
        return Unit.INSTANCE;
    }

    private static final Unit extensionCreated$lambda$2(UnattendedHostFrameSyncProtocolListener this$0, ClientProjectSession $session, LxEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it instanceof LxMouseEvent) {
            IdeFrameImpl ideFrameImpl = this$0.getProjectFrame($session.getProject());
            if (ideFrameImpl == null) {
                throw new IllegalStateException(("Can't get ide frame for project " + $session.getProject().getName()).toString());
            }
            IdeFrameImpl ideFrame = ideFrameImpl;
            MouseEvent mouseEvent = EventsKt.fromLx$default((LxMouseEventBase)((LxMouseEventBase)it), (ClientId)$session.getClientId(), (Component)((Component)ideFrame), (boolean)false, null, (int)12, null);
            if (mouseEvent == null) {
                return Unit.INSTANCE;
            }
            MouseEvent event = mouseEvent;
            StackingPopupDispatcher.getInstance().eventDispatched((AWTEvent)event);
        } else {
            IdeFrameImpl ideFrameImpl = this$0.getProjectFrame($session.getProject());
            if (ideFrameImpl == null) {
                return Unit.INSTANCE;
            }
            IdeFrameImpl frame = ideFrameImpl;
            UnattendedHostEventHelper.convertAndDispatchLxEvent$default((UnattendedHostEventHelper)UnattendedHostEventHelper.INSTANCE, (ClientAppSession)$session.getAppSession(), (LxEvent)it, (Window)((Window)frame), null, (int)8, null);
        }
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(UnattendedHostFrameSyncProtocolListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        UnattendedHostFrameSyncProtocolListener.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/ui/UnattendedHostFrameSyncProtocolListener$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.remoteController.backend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

