/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483648)
@ApiStatus.Internal
public final class ProjectDataServiceImpl
extends AbstractProjectDataService<ProjectData, Project> {
    @NotNull
    public Key<ProjectData> getTargetDataKey() {
        Key key = ProjectKeys.PROJECT;
        if (key == null) {
            ProjectDataServiceImpl.$$$reportNull$$$0(0);
        }
        return key;
    }

    public void importData(@NotNull Collection<? extends DataNode<ProjectData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            ProjectDataServiceImpl.$$$reportNull$$$0(1);
        }
        if (project == null) {
            ProjectDataServiceImpl.$$$reportNull$$$0(2);
        }
        if (modelsProvider == null) {
            ProjectDataServiceImpl.$$$reportNull$$$0(3);
        }
        if (toImport.isEmpty()) {
            return;
        }
        if (toImport.size() != 1) {
            throw new IllegalArgumentException(String.format("Expected to get a single project but got %d: %s", toImport.size(), toImport));
        }
        DataNode<ProjectData> node = toImport.iterator().next();
        assert (projectData == node.getData());
        if (!ExternalSystemApiUtil.isOneToOneMapping((Project)project, (ProjectData)((ProjectData)node.getData()), (Module[])modelsProvider.getModules())) {
            return;
        }
        if (!project.getName().equals(projectData.getInternalName())) {
            ProjectDataServiceImpl.renameProject(projectData.getInternalName(), projectData.getOwner(), project);
        }
    }

    private static void renameProject(@NotNull String newName, @NotNull ProjectSystemId externalSystemId, @NotNull Project project) {
        if (newName == null) {
            ProjectDataServiceImpl.$$$reportNull$$$0(4);
        }
        if (externalSystemId == null) {
            ProjectDataServiceImpl.$$$reportNull$$$0(5);
        }
        if (project == null) {
            ProjectDataServiceImpl.$$$reportNull$$$0(6);
        }
        if (!(project instanceof ProjectEx) || newName.equals(project.getName())) {
            return;
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (ComponentManager)project, () -> {
            String oldName = project.getName();
            ((ProjectEx)project).setProjectName(newName);
            ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)externalSystemId).getPublisher().onProjectRenamed(oldName, newName);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataServiceImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataServiceImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "renameProject";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

