/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ModuleNode;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectNode
extends ExternalSystemNode<ProjectData> {
    @Nls
    private String myTooltipCache;
    private ModuleNode effectiveRoot = null;

    public ProjectNode(ExternalProjectsView externalProjectsView, DataNode<ProjectData> projectDataNode) {
        super(externalProjectsView, null, projectDataNode);
        this.updateProject();
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            ProjectNode.$$$reportNull$$$0(0);
        }
        super.update(presentation);
        presentation.setIcon(this.getUiAware().getProjectIcon());
    }

    public ExternalSystemNode getGroup() {
        return (ExternalSystemNode)this.getParent();
    }

    @Override
    @NotNull
    protected List<? extends ExternalSystemNode<?>> doBuildChildren() {
        this.setIdeGrouping(null);
        List<ExternalSystemNode<?>> children = super.doBuildChildren();
        List visibleChildren = ContainerUtil.filter(children, node -> node.isVisible());
        if (this.getExternalProjectsView().getGroupModules()) {
            ExternalSystemNode child;
            List topLevelChildren = ContainerUtil.filter((Collection)visibleChildren, node -> !(node instanceof ModuleNode) || ((ModuleNode)node).getIdeParentGrouping() == null);
            if (topLevelChildren.size() == 1 && (child = (ExternalSystemNode)topLevelChildren.get(0)) instanceof ModuleNode) {
                this.effectiveRoot = (ModuleNode)child;
                List<ExternalSystemNode<?>> list = this.effectiveRoot.doBuildChildren();
                if (list == null) {
                    ProjectNode.$$$reportNull$$$0(1);
                }
                return list;
            }
            List list = topLevelChildren;
            if (list == null) {
                ProjectNode.$$$reportNull$$$0(2);
            }
            return list;
        }
        this.effectiveRoot = null;
        List list = visibleChildren;
        if (list == null) {
            ProjectNode.$$$reportNull$$$0(3);
        }
        return list;
    }

    void updateProject() {
        this.myTooltipCache = this.makeDescription();
        this.getStructure().updateFrom(this.getParent());
    }

    @Override
    protected void doUpdate(@NotNull PresentationData presentation) {
        if (presentation == null) {
            ProjectNode.$$$reportNull$$$0(4);
        }
        this.setNameAndTooltip(presentation, this.getName(), this.myTooltipCache);
    }

    @NlsSafe
    private String makeDescription() {
        ProjectData projectData = (ProjectData)this.getData();
        StringBuilder desc = new StringBuilder();
        desc.append(ExternalSystemBundle.message((String)"external.project.structure.project", (Object[])new Object[0])).append(": ").append(this.getName());
        if (projectData != null) {
            desc.append("\n\r").append(ExternalSystemBundle.message((String)"external.project.structure.project.location", (Object[])new Object[0])).append(": ").append(projectData.getLinkedExternalProjectPath());
            String description = projectData.getDescription();
            if (!StringUtil.isEmptyOrSpaces((String)description)) {
                desc.append("\n\r").append(description);
            }
        }
        return desc.toString();
    }

    @Nullable
    public String getIdeGrouping() {
        ProjectData data = (ProjectData)this.getData();
        if (data == null) {
            return null;
        }
        return data.getIdeGrouping();
    }

    private void setIdeGrouping(@Nullable String ideGrouping) {
        ProjectData data = (ProjectData)this.getData();
        if (data != null) {
            data.setIdeGrouping(ideGrouping);
        }
    }

    @Override
    @Nullable
    @NonNls
    protected String getMenuId() {
        return "ExternalSystemView.ProjectMenu";
    }

    public ModuleNode getEffectiveRoot() {
        return this.effectiveRoot;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/view/ProjectNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/view/ProjectNode";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doBuildChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doUpdate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

