/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.polySymbols.search;

import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiExternalReferenceHost;
import com.intellij.model.psi.PsiSymbolReferenceHints;
import com.intellij.model.psi.PsiSymbolReferenceService;
import com.intellij.model.psi.PsiSymbolService;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.polySymbols.PolySymbol;
import com.intellij.polySymbols.references.PolySymbolReference;
import com.intellij.polySymbols.search.PolySymbolReferenceHints;
import com.intellij.polySymbols.search.PsiSourcedPolySymbol;
import com.intellij.polySymbols.search.PsiSourcedPolySymbolReference;
import com.intellij.polySymbols.search.PsiSourcedPolySymbolRequestResultProcessor$processTextOccurrence$;
import com.intellij.polySymbols.utils.PolySymbolUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ(\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00190\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/polySymbols/search/PsiSourcedPolySymbolRequestResultProcessor;", "Lcom/intellij/psi/search/RequestResultProcessor;", "targetElement", "Lcom/intellij/psi/PsiElement;", "targetSymbols", "", "Lcom/intellij/polySymbols/PolySymbol;", "includeRegularReferences", "", "<init>", "(Lcom/intellij/psi/PsiElement;Ljava/util/List;Z)V", "mySymbolReferenceService", "Lcom/intellij/model/psi/PsiSymbolReferenceService;", "Lorg/jetbrains/annotations/NotNull;", "myPsiReferenceService", "Lcom/intellij/psi/PsiReferenceService;", "kotlin.jvm.PlatformType", "myTargetSymbol", "Lcom/intellij/model/Symbol;", "processTextOccurrence", "element", "offsetInElement", "", "consumer", "Lcom/intellij/util/Processor;", "Lcom/intellij/psi/PsiReference;", "intellij.platform.polySymbols.backend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPsiSourcedPolySymbolRequestResultProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsiSourcedPolySymbolRequestResultProcessor.kt\ncom/intellij/polySymbols/search/PsiSourcedPolySymbolRequestResultProcessor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n479#2:76\n1342#2:77\n1343#2:94\n812#3,12:78\n1807#3,3:91\n1#4:90\n*S KotlinDebug\n*F\n+ 1 PsiSourcedPolySymbolRequestResultProcessor.kt\ncom/intellij/polySymbols/search/PsiSourcedPolySymbolRequestResultProcessor\n*L\n38#1:76\n40#1:77\n40#1:94\n42#1:78,12\n48#1:91,3\n*E\n"})
public final class PsiSourcedPolySymbolRequestResultProcessor
extends RequestResultProcessor {
    @NotNull
    private final PsiElement targetElement;
    @NotNull
    private final List<PolySymbol> targetSymbols;
    private final boolean includeRegularReferences;
    @NotNull
    private final PsiSymbolReferenceService mySymbolReferenceService;
    private final PsiReferenceService myPsiReferenceService;
    @NotNull
    private final Symbol myTargetSymbol;

    public PsiSourcedPolySymbolRequestResultProcessor(@NotNull PsiElement targetElement, @NotNull List<? extends PolySymbol> targetSymbols, boolean includeRegularReferences) {
        Intrinsics.checkNotNullParameter((Object)targetElement, (String)"targetElement");
        Intrinsics.checkNotNullParameter(targetSymbols, (String)"targetSymbols");
        super(new Object[0]);
        this.targetElement = targetElement;
        this.targetSymbols = targetSymbols;
        this.includeRegularReferences = includeRegularReferences;
        PsiSymbolReferenceService psiSymbolReferenceService = PsiSymbolReferenceService.getService();
        Intrinsics.checkNotNullExpressionValue((Object)psiSymbolReferenceService, (String)"getService(...)");
        this.mySymbolReferenceService = psiSymbolReferenceService;
        this.myPsiReferenceService = PsiReferenceService.getService();
        Symbol symbol = PsiSymbolService.getInstance().asSymbol(this.targetElement);
        Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"asSymbol(...)");
        this.myTargetSymbol = symbol;
    }

    /*
     * WARNING - void declaration
     */
    public boolean processTextOccurrence(@NotNull PsiElement element, int offsetInElement, @NotNull Processor<? super PsiReference> consumer) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (!this.targetElement.isValid()) {
            return false;
        }
        if (element instanceof PsiExternalReferenceHost) {
            void $this$forEach$iv;
            Sequence $this$filterIsInstance$iv;
            PolySymbol polySymbol = PolySymbolUtils.asSingleSymbol$default(this.targetSymbols, (boolean)false, (int)1, null);
            Symbol targetSymbol = polySymbol != null ? (Symbol)polySymbol : this.myTargetSymbol;
            Collection collection = this.mySymbolReferenceService.getReferences(element, (PsiSymbolReferenceHints)new PolySymbolReferenceHints(targetSymbol, offsetInElement));
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getReferences(...)");
            Sequence sequence = CollectionsKt.asSequence((Iterable)collection);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)processTextOccurrence$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            $this$filterIsInstance$iv = SequencesKt.filter((Sequence)sequence2, arg_0 -> PsiSourcedPolySymbolRequestResultProcessor.processTextOccurrence$lambda$0(offsetInElement, arg_0));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PolySymbol equivalentSymbol;
                PolySymbol polySymbol2;
                void $this$filterIsInstanceTo$iv$iv;
                PolySymbolReference ref = (PolySymbolReference)element$iv;
                boolean bl = false;
                ProgressManager.checkCanceled();
                Iterable $this$filterIsInstance$iv2 = ref.resolveReference();
                boolean $i$f$filterIsInstance2 = false;
                Iterable iterable = $this$filterIsInstance$iv2;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof PsiSourcedPolySymbol)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List psiSourcedPolySymbols = (List)destination$iv$iv;
                if (psiSourcedPolySymbols.isEmpty()) continue;
                if (this.targetSymbols.isEmpty()) {
                    Object v3;
                    block13: {
                        iterable = psiSourcedPolySymbols;
                        for (Object t : iterable) {
                            PsiSourcedPolySymbol it = (PsiSourcedPolySymbol)t;
                            boolean bl2 = false;
                            if (!it.isEquivalentTo(this.myTargetSymbol)) continue;
                            v3 = t;
                            break block13;
                        }
                        v3 = null;
                    }
                    polySymbol2 = v3;
                } else {
                    Object v6;
                    block15: {
                        iterable = this.targetSymbols;
                        for (Object t : iterable) {
                            boolean bl3;
                            block14: {
                                PolySymbol targetSymbol2 = (PolySymbol)t;
                                boolean bl4 = false;
                                Iterable $this$any$iv = psiSourcedPolySymbols;
                                boolean $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl3 = false;
                                } else {
                                    for (Object element$iv2 : $this$any$iv) {
                                        PsiSourcedPolySymbol it = (PsiSourcedPolySymbol)element$iv2;
                                        boolean bl5 = false;
                                        if (!it.isEquivalentTo((Symbol)targetSymbol2)) continue;
                                        bl3 = true;
                                        break block14;
                                    }
                                    bl3 = false;
                                }
                            }
                            if (!bl3) continue;
                            v6 = t;
                            break block15;
                        }
                        v6 = null;
                    }
                    polySymbol2 = v6;
                }
                if ((equivalentSymbol = polySymbol2) == null) continue;
                PsiExternalReferenceHost psiExternalReferenceHost = (PsiExternalReferenceHost)element;
                TextRange textRange = ref.getRangeInElement();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getRangeInElement(...)");
                if (consumer.process((Object)new PsiSourcedPolySymbolReference(equivalentSymbol, this.targetElement, psiExternalReferenceHost, textRange))) continue;
                return false;
            }
        }
        if (this.includeRegularReferences) {
            List list = this.myPsiReferenceService.getReferences(element, new PsiReferenceService.Hints(this.targetElement, Integer.valueOf(offsetInElement)));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getReferences(...)");
            List references = list;
            int n = ((Collection)references).size();
            for (int i = 0; i < n; ++i) {
                PsiReference ref = (PsiReference)references.get(i);
                ProgressManager.checkCanceled();
                if (!ReferenceRange.containsOffsetInElement((PsiReference)ref, (int)offsetInElement) || !ref.isReferenceTo(this.targetElement) || consumer.process((Object)ref)) continue;
                return false;
            }
        }
        return true;
    }

    private static final boolean processTextOccurrence$lambda$0(int $offsetInElement, PolySymbolReference it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getRangeInElement().containsOffset($offsetInElement);
    }
}

