/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.thinClientLink;

import com.intellij.openapi.util.BuildNumber;
import com.intellij.remoteDev.util.LifetimeExKt;
import com.jetbrains.gateway.thinClientLink.ClientLifetimeTracker;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.Signal;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\f\u0012\u0004\u0012\u00020\u00110\u0013j\u0002`\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/gateway/thinClientLink/SingleClientLifetimeTracker;", "Lcom/jetbrains/gateway/thinClientLink/ClientLifetimeTracker;", "parentLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "buildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/util/BuildNumber;)V", "getBuildNumber", "()Lcom/intellij/openapi/util/BuildNumber;", "lifetimeDef", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "lifetime", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "clientsTerminatedSignal", "Lcom/jetbrains/rd/util/reactive/Signal;", "", "clientsTerminated", "Lcom/jetbrains/rd/util/reactive/ISource;", "Lcom/jetbrains/rd/util/reactive/IVoidSource;", "getClientsTerminated", "()Lcom/jetbrains/rd/util/reactive/ISource;", "registerClientProcessLifetime", "processLifetime", "uid", "", "registerClientHandleLifetime", "clientHandleLifetime", "intellij.gateway.core"})
public final class SingleClientLifetimeTracker
implements ClientLifetimeTracker {
    @NotNull
    private final BuildNumber buildNumber;
    @NotNull
    private final LifetimeDefinition lifetimeDef;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Signal<Unit> clientsTerminatedSignal;
    @NotNull
    private final ISource<Unit> clientsTerminated;

    public SingleClientLifetimeTracker(@NotNull Lifetime parentLifetime, @NotNull BuildNumber buildNumber) {
        Intrinsics.checkNotNullParameter((Object)parentLifetime, (String)"parentLifetime");
        Intrinsics.checkNotNullParameter((Object)buildNumber, (String)"buildNumber");
        this.buildNumber = buildNumber;
        this.lifetimeDef = parentLifetime.createNested();
        this.lifetime = (Lifetime)this.lifetimeDef;
        this.clientsTerminatedSignal = new Signal();
        this.clientsTerminated = (ISource)this.clientsTerminatedSignal;
    }

    @Override
    @NotNull
    public BuildNumber getBuildNumber() {
        return this.buildNumber;
    }

    @Override
    @NotNull
    public Lifetime getLifetime() {
        return this.lifetime;
    }

    @Override
    @NotNull
    public ISource<Unit> getClientsTerminated() {
        return this.clientsTerminated;
    }

    @Override
    public void registerClientProcessLifetime(@NotNull Lifetime processLifetime, @NotNull String uid) {
        Intrinsics.checkNotNullParameter((Object)processLifetime, (String)"processLifetime");
        Intrinsics.checkNotNullParameter((Object)uid, (String)"uid");
        LifetimeExKt.onTerminationOrNow((Lifetime)processLifetime, () -> SingleClientLifetimeTracker.registerClientProcessLifetime$lambda$0(this));
    }

    @Override
    public void registerClientHandleLifetime(@NotNull Lifetime clientHandleLifetime, @NotNull String uid) {
        Intrinsics.checkNotNullParameter((Object)clientHandleLifetime, (String)"clientHandleLifetime");
        Intrinsics.checkNotNullParameter((Object)uid, (String)"uid");
        clientHandleLifetime.attach(this.lifetimeDef, true);
    }

    private static final Unit registerClientProcessLifetime$lambda$0(SingleClientLifetimeTracker this$0) {
        InterfacesKt.fire((ISignal)((ISignal)this$0.clientsTerminatedSignal));
        return Unit.INSTANCE;
    }
}

