/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.navbar.frontend;

import com.intellij.ide.navigationToolbar.NavBarLeftSideExtension;
import com.intellij.ide.ui.NavBarLocation;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.ui.customization.CustomisedActionGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.platform.navbar.frontend.NavBarContainer;
import com.intellij.platform.navbar.frontend.NavBarRootPaneExtension;
import com.intellij.platform.navbar.frontend.NavBarRootPaneExtensionKt;
import com.intellij.platform.navbar.frontend.NavBarService;
import com.intellij.platform.navbar.frontend.NavBarServiceKt;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.concurrent.CompletableFuture;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0010\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0015\u001a\u00020\tJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0005H\u0002J\b\u0010\u001d\u001a\u00020\u0005H\u0002J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0019H\u0002J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lcom/intellij/platform/navbar/frontend/MyNavBarWrapperPanel;", "Lcom/intellij/platform/navbar/frontend/NavBarRootPaneExtension$NavBarWrapperPanel;", "project", "Lcom/intellij/openapi/project/Project;", "useAsComponent", "", "<init>", "(Lcom/intellij/openapi/project/Project;Z)V", "navBarPanel", "Ljavax/swing/JComponent;", "runPanel", "Ljavax/swing/JPanel;", "navToolbarGroupExist", "Ljava/lang/Boolean;", "navigationBar", "scrollPane", "Ljavax/swing/JScrollPane;", "getScrollPane", "()Ljavax/swing/JScrollPane;", "setScrollPane", "(Ljavax/swing/JScrollPane;)V", "getNavBarPanel", "uiSettingsChanged", "", "uiSettings", "Lcom/intellij/ide/ui/UISettings;", "getInsets", "Ljava/awt/Insets;", "shouldPaintWrapperPanel", "runToolbarExists", "toggleNavPanel", "settings", "toggleRunPanel", "show", "intellij.platform.navbar.frontend"})
@SourceDebugExtension(value={"SMAP\nNavBarRootPaneExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavBarRootPaneExtension.kt\ncom/intellij/platform/navbar/frontend/MyNavBarWrapperPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,469:1\n1#2:470\n*E\n"})
public class MyNavBarWrapperPanel
extends NavBarRootPaneExtension.NavBarWrapperPanel {
    @NotNull
    private final Project project;
    @Nullable
    private JComponent navBarPanel;
    @Nullable
    private JPanel runPanel;
    @Nullable
    private Boolean navToolbarGroupExist;
    @Nullable
    private JComponent navigationBar;
    @Nullable
    private JScrollPane scrollPane;

    public MyNavBarWrapperPanel(@NotNull Project project, boolean useAsComponent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(new BorderLayout());
        this.project = project;
        if (useAsComponent) {
            this.add((Component)this.getNavBarPanel(), "Center");
            this.revalidate();
            this.uiSettingsChanged(UISettings.Companion.getInstance());
        }
    }

    @Nullable
    public final JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public final void setScrollPane(@Nullable JScrollPane jScrollPane) {
        this.scrollPane = jScrollPane;
    }

    @NotNull
    public final JComponent getNavBarPanel() {
        JComponent navigationBar;
        JComponent jComponent = this.navBarPanel;
        if (jComponent != null) {
            JComponent it = jComponent;
            boolean bl = false;
            return it;
        }
        this.navigationBar = navigationBar = NavBarService.Companion.getInstance(this.project).createNavBarPanel();
        this.putClientProperty("NavBarPanel", navigationBar);
        JScrollPane jScrollPane = this.scrollPane = ScrollPaneFactory.createScrollPane((Component)navigationBar);
        Intrinsics.checkNotNull((Object)jScrollPane);
        NavBarRootPaneExtensionKt.access$updateScrollBarFlippedState(null, jScrollPane);
        JScrollPane jScrollPane2 = this.scrollPane;
        Intrinsics.checkNotNull((Object)jScrollPane2);
        NavBarContainer navBarPanel = NavBarRootPaneExtensionKt.access$createNavBarPanel(jScrollPane2, navigationBar);
        navBarPanel.putClientProperty("NavBarPanel", navigationBar);
        this.navBarPanel = navBarPanel;
        return navBarPanel;
    }

    public void uiSettingsChanged(@NotNull UISettings uiSettings) {
        Component c;
        Intrinsics.checkNotNullParameter((Object)uiSettings, (String)"uiSettings");
        if (this.project.isDisposed()) {
            return;
        }
        this.toggleRunPanel(NavBarRootPaneExtensionKt.access$isShowToolPanel(uiSettings));
        this.toggleNavPanel(uiSettings);
        NavBarService.Companion.getInstance(this.project).uiSettingsChanged(uiSettings);
        JComponent jComponent = this.navigationBar;
        if (jComponent == null) {
            return;
        }
        JComponent navigationBar = jComponent;
        boolean visible = NavBarServiceKt.isNavbarShown(uiSettings);
        if (ExperimentalUI.Companion.isNewUI()) {
            JScrollPane jScrollPane = this.scrollPane;
            Intrinsics.checkNotNull((Object)jScrollPane);
            jScrollPane.setVisible(visible);
        }
        navigationBar.revalidate();
        this.setVisible(visible);
        this.revalidate();
        this.repaint();
        if (this.getComponentCount() > 0 && (c = this.getComponent(0)) instanceof JComponent) {
            ((JComponent)c).setOpaque(false);
        }
    }

    @Override
    @NotNull
    public Insets getInsets() {
        JBInsets jBInsets = JBInsets.create((Insets)super.getInsets());
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"create(...)");
        JBInsets result = jBInsets;
        if (this.shouldPaintWrapperPanel()) {
            result.top += JBUIScale.scale((int)1);
        }
        return (Insets)result;
    }

    private final boolean shouldPaintWrapperPanel() {
        return false;
    }

    private final boolean runToolbarExists() {
        boolean bl;
        Boolean bl2 = this.navToolbarGroupExist;
        if (bl2 != null) {
            bl = bl2;
        } else {
            boolean bl3;
            MyNavBarWrapperPanel $this$runToolbarExists_u24lambda_u240 = this;
            boolean bl4 = false;
            AnAction o = CustomActionsSchema.Companion.getInstance().getCorrectedAction("NavBarToolBar");
            boolean it = bl3 = o instanceof DefaultActionGroup ? ((DefaultActionGroup)o).getChildrenCount() > 0 : (o instanceof CustomisedActionGroup ? ((CustomisedActionGroup)o).getDefaultChildrenOrStubs().length > 0 : false);
            boolean bl5 = false;
            $this$runToolbarExists_u24lambda_u240.navToolbarGroupExist = it;
            bl = bl3;
        }
        return bl;
    }

    private final void toggleNavPanel(UISettings settings) {
        boolean show;
        boolean bl = ExperimentalUI.Companion.isNewUI() ? settings.getShowNavigationBar() && settings.getNavBarLocation() == NavBarLocation.TOP : (show = NavBarServiceKt.isNavbarShown(settings));
        if (show) {
            ApplicationManager.getApplication().invokeLater(() -> MyNavBarWrapperPanel.toggleNavPanel$lambda$0(this));
        } else {
            LayoutManager layoutManager = this.getLayout();
            Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type java.awt.BorderLayout");
            Component component2 = ((BorderLayout)layoutManager).getLayoutComponent("Center");
            if (component2 != null) {
                Component it = component2;
                boolean bl2 = false;
                this.remove(it);
            }
        }
        NavBarLocation navBarLocation = settings.getNavBarLocation();
        JScrollPane jScrollPane = this.scrollPane;
        Intrinsics.checkNotNull((Object)jScrollPane);
        NavBarRootPaneExtensionKt.access$updateScrollBarFlippedState(navBarLocation, jScrollPane);
        this.setVisible(show);
    }

    private final void toggleRunPanel(boolean show) {
        CompletableFuture.supplyAsync(MyNavBarWrapperPanel::toggleRunPanel$lambda$0, AppExecutorUtil.getAppExecutorService()).thenAcceptAsync(arg_0 -> MyNavBarWrapperPanel.toggleRunPanel$lambda$2(arg_0 -> MyNavBarWrapperPanel.toggleRunPanel$lambda$1(show, this, arg_0), arg_0), arg_0 -> MyNavBarWrapperPanel.toggleRunPanel$lambda$3(this, arg_0));
    }

    private static final void toggleNavPanel$lambda$0(MyNavBarWrapperPanel this$0) {
        JComponent navBarPanel = this$0.getNavBarPanel();
        if (!Intrinsics.areEqual((Object)navBarPanel.getParent(), (Object)this$0)) {
            this$0.add((Component)navBarPanel, "Center");
        }
        navBarPanel.updateUI();
    }

    private static final Unit toggleRunPanel$lambda$1$0(MyNavBarWrapperPanel this$0, NavBarLeftSideExtension extension) {
        extension.process((JComponent)this$0, this$0.project);
        return Unit.INSTANCE;
    }

    private static final void toggleRunPanel$lambda$1$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final AnAction toggleRunPanel$lambda$0() {
        return CustomActionsSchema.Companion.getInstance().getCorrectedAction("NavBarToolBar");
    }

    private static final Unit toggleRunPanel$lambda$1(boolean $show, MyNavBarWrapperPanel this$0, AnAction action) {
        if ($show && this$0.runPanel == null && this$0.runToolbarExists()) {
            if (this$0.runPanel != null) {
                this$0.remove(this$0.runPanel);
                this$0.runPanel = null;
            }
            ActionManager manager = ActionManager.getInstance();
            if (action instanceof ActionGroup) {
                ActionToolbar actionToolbar = manager.createActionToolbar("NavBarToolbar", (ActionGroup)action, true);
                Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
                ActionToolbar actionToolbar2 = actionToolbar;
                actionToolbar2.setTargetComponent(null);
                BorderLayout borderLayout = new BorderLayout();
                JPanel runPanel2 = new JPanel(borderLayout){

                    public void doLayout() {
                        NavBarRootPaneExtensionKt.access$alignVertically(this);
                    }
                };
                this$0.runPanel = runPanel2;
                runPanel2.setOpaque(false);
                runPanel2.add((Component)actionToolbar2.getComponent(), "Center");
                boolean needGap = NavBarRootPaneExtensionKt.access$isNeedGap(action);
                runPanel2.setBorder((Border)JBUI.Borders.emptyLeft((int)(needGap ? 5 : 1)));
                NavBarLeftSideExtension.EP_NAME.forEachExtensionSafe(arg_0 -> MyNavBarWrapperPanel.toggleRunPanel$lambda$1$1(arg_0 -> MyNavBarWrapperPanel.toggleRunPanel$lambda$1$0(this$0, arg_0), arg_0));
                this$0.add((Component)runPanel2, "East");
            }
        } else if (!$show && this$0.runPanel != null) {
            this$0.remove(this$0.runPanel);
            this$0.runPanel = null;
        }
        return Unit.INSTANCE;
    }

    private static final void toggleRunPanel$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void toggleRunPanel$lambda$3(MyNavBarWrapperPanel this$0, Runnable command) {
        ApplicationManager.getApplication().invokeLater(command, this$0.project.getDisposed());
    }
}

