/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.storage;

import com.intellij.AbstractBundle;
import com.intellij.DynamicBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.util.indexing.storage.FileBasedIndexLayoutProvider;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.ResourceBundle;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class FileBasedIndexLayoutProviderBean
implements PluginAware {
    @RequiredElement
    @Attribute(value="providerClass")
    public String providerClass;
    @RequiredElement
    @Attribute(value="id")
    public String id;
    @Attribute(value="priority")
    public int priority = 0;
    @RequiredElement
    @Attribute(value="presentableNameKey")
    @NonNls
    public String presentableNameKey;
    @Attribute(value="bundleName")
    @NonNls
    public String bundleName;
    @RequiredElement
    @Attribute(value="version")
    @NonNls
    public int version;
    private FileBasedIndexLayoutProvider myLayoutProvider;
    private volatile PluginDescriptor myPluginDescriptor;

    @NotNull
    @Nls
    public String getLocalizedPresentableName() {
        String resourceBundleBaseName;
        String string = resourceBundleBaseName = this.bundleName != null ? this.bundleName : this.myPluginDescriptor.getResourceBundleBaseName();
        if (resourceBundleBaseName == null) {
            Logger.getInstance(FileBasedIndexLayoutProviderBean.class).error("Can't find resource bundle name for " + this.myPluginDescriptor.getName());
            String string2 = "!" + this.presentableNameKey + "!";
            if (string2 == null) {
                FileBasedIndexLayoutProviderBean.$$$reportNull$$$0(0);
            }
            return string2;
        }
        ResourceBundle resourceBundle = DynamicBundle.getResourceBundle((ClassLoader)this.myPluginDescriptor.getClassLoader(), (String)resourceBundleBaseName);
        String string3 = AbstractBundle.message((ResourceBundle)resourceBundle, (String)this.presentableNameKey, (Object[])new Object[0]);
        if (string3 == null) {
            FileBasedIndexLayoutProviderBean.$$$reportNull$$$0(1);
        }
        return string3;
    }

    @NotNull
    public synchronized FileBasedIndexLayoutProvider getLayoutProvider() {
        if (this.myLayoutProvider == null) {
            this.myLayoutProvider = (FileBasedIndexLayoutProvider)ApplicationManager.getApplication().instantiateClass(this.providerClass, this.myPluginDescriptor);
        }
        FileBasedIndexLayoutProvider fileBasedIndexLayoutProvider = this.myLayoutProvider;
        if (fileBasedIndexLayoutProvider == null) {
            FileBasedIndexLayoutProviderBean.$$$reportNull$$$0(2);
        }
        return fileBasedIndexLayoutProvider;
    }

    public void setPluginDescriptor(@NotNull PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            FileBasedIndexLayoutProviderBean.$$$reportNull$$$0(3);
        }
        this.myPluginDescriptor = pluginDescriptor;
    }

    public String toString() {
        return "FileBasedIndexLayoutProviderBean[" + this.id + "]{priority: " + this.priority + ", version: " + this.version + "}{providerClass: " + this.providerClass + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/storage/FileBasedIndexLayoutProviderBean";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalizedPresentableName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayoutProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/storage/FileBasedIndexLayoutProviderBean";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setPluginDescriptor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3 -> new IllegalArgumentException(string);
        };
    }
}

