/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasType;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlExpressionBase;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.symbols.DasSymbolUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016J*\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\n\u0010#\u001a\u0004\u0018\u00010\u0017H\u0016J\u0012\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010$\u001a\u00020%H\u0016J\u0012\u0010'\u001a\u00020\f2\b\u0010(\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010)\u001a\u00020\u0011H\u0016J\b\u0010*\u001a\u00020\u0011H\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020%H\u0016J\b\u0010.\u001a\u00020\nH\u0016J\u0010\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020100H\u0016J\u001b\u00102\u001a\b\u0012\u0004\u0012\u000204032\u0006\u00105\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u00106J\n\u00107\u001a\u0004\u0018\u000104H\u0016J\n\u00108\u001a\u0004\u0018\u00010\u0017H\u0016J\n\u00109\u001a\u0004\u0018\u00010:H\u0016J\u0015\u0010;\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010:03H\u0016\u00a2\u0006\u0002\u0010<J\u0010\u0010A\u001a\u00020%2\u0006\u0010B\u001a\u00020CH\u0016J\n\u0010D\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010E\u001a\u00020CH\u0016J\b\u0010F\u001a\u00020\u0011H\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\u0004\u0018\u00010 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010=\u001a\u00020>8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010@\u00a8\u0006G"}, d2={"Lcom/intellij/sql/psi/impl/SqlReferenceExpressionImpl;", "Lcom/intellij/sql/psi/impl/SqlExpressionBase;", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "Lcom/intellij/psi/meta/PsiMetaData;", "Lcom/intellij/psi/meta/PsiMetaOwner;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Lcom/intellij/psi/tree/IElementType;)V", "myReference", "Lcom/intellij/sql/psi/impl/SqlReferenceImpl;", "accept", "", "visitor", "Lcom/intellij/sql/psi/SqlVisitor;", "clearCaches", "processDeclarations", "", "processor", "Lcom/intellij/sql/psi/SqlScopeProcessor;", "state", "Lcom/intellij/psi/ResolveState;", "lastParent", "Lcom/intellij/psi/PsiElement;", "place", "getDasType", "Lcom/intellij/database/types/DasType;", "qualifierExpression", "Lcom/intellij/sql/psi/SqlExpression;", "getQualifierExpression", "()Lcom/intellij/sql/psi/SqlExpression;", "identifier", "Lcom/intellij/sql/psi/SqlIdentifier;", "getIdentifier", "()Lcom/intellij/sql/psi/SqlIdentifier;", "getDeclaration", "getName", "", "context", "init", "element", "isPlainIdentifier", "isQuotedIdentifier", "setName", "Lcom/intellij/sql/psi/SqlNameElement;", "newElementName", "getReference", "getOwnReferences", "", "Lcom/intellij/model/psi/PsiSymbolReference;", "multiResolve", "", "Lcom/intellij/psi/ResolveResult;", "incompleteCode", "(Z)[Lcom/intellij/psi/ResolveResult;", "resolveSingle", "resolve", "resolveSymbol", "Lcom/intellij/database/symbols/DasSymbol;", "multiResolveSymbol", "()[Lcom/intellij/database/symbols/DasSymbol;", "referenceElementType", "Lcom/intellij/sql/psi/SqlReferenceElementType;", "getReferenceElementType", "()Lcom/intellij/sql/psi/SqlReferenceElementType;", "getReferencePart", "kind", "Lcom/intellij/database/model/ObjectKind;", "getMetaData", "getKind", "isQuoted", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlReferenceExpressionImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlReferenceExpressionImpl.kt\ncom/intellij/sql/psi/impl/SqlReferenceExpressionImpl\n+ 2 util.kt\ncom/intellij/util/containers/UtilKt\n*L\n1#1,207:1\n254#2:208\n*S KotlinDebug\n*F\n+ 1 SqlReferenceExpressionImpl.kt\ncom/intellij/sql/psi/impl/SqlReferenceExpressionImpl\n*L\n183#1:208\n*E\n"})
public class SqlReferenceExpressionImpl
extends SqlExpressionBase
implements SqlReferenceExpression,
PsiMetaData,
PsiMetaOwner {
    @Nullable
    private volatile SqlReferenceImpl myReference;

    public SqlReferenceExpressionImpl(@NotNull IElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        super(elementType);
    }

    @Override
    public void accept(@NotNull SqlVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        visitor2.visitSqlReferenceExpression((SqlReferenceExpression)this);
    }

    public void clearCaches() {
        super.clearCaches();
        this.myReference = null;
    }

    @Override
    public boolean processDeclarations(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        return !(lastParent instanceof SqlClause) || ((SqlClause)lastParent).getParent() != this || SqlImplUtil.processQualifierImpl(this, processor, state, place);
    }

    @NotNull
    public DasType getDasType() {
        DasType dasType = this.getReference().getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
        return dasType;
    }

    @Nullable
    public SqlExpression getQualifierExpression() {
        PsiElement parent = this.getParent();
        PsiElement parentFirst = parent.getFirstChild();
        PsiElement parentLast = parent.getLastChild();
        if (parentFirst == this && parentLast instanceof SqlReferenceExpression && ((SqlReferenceExpression)parentLast).getReferenceElementType().getTargetKind() == ObjectKind.DB_LINK) {
            return (SqlExpression)parentLast;
        }
        return this.findChildByClass(SqlExpression.class);
    }

    @Nullable
    public SqlIdentifier getIdentifier() {
        SqlIdentifier identifier = this.findChildByClass(SqlIdentifier.class);
        if (identifier == null) {
            PsiElement lastChild = this.getLastChild();
            if (this.getFirstChild() == lastChild && lastChild instanceof SqlReferenceExpression && this.getReferenceElementType().getTargetKind() == ObjectKind.BODY) {
                identifier = ((SqlReferenceExpression)lastChild).getIdentifier();
            }
        }
        return identifier;
    }

    @Nullable
    public PsiElement getDeclaration() {
        return this.resolve();
    }

    @NotNull
    public String getName(@Nullable PsiElement context) {
        return this.getName();
    }

    @Override
    @NotNull
    public String getName() {
        if (SqlImplUtil.isAsteriskRef((PsiElement)this)) {
            return "*";
        }
        SqlIdentifier identifier = this.getIdentifier();
        if (identifier != null) {
            String string = identifier.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }
        if (this.getReferenceElementType() == SqlCompositeElementTypes.SQL_PROCEDURE_REFERENCE) {
            PsiElement child = this.getLastChild();
            if (child instanceof SqlLiteralExpression) {
                String string = ((SqlLiteralExpression)child).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                return string;
            }
            PsiElement first = this.getFirstChild();
            if (first == child && child instanceof SqlReferenceExpression) {
                return "";
            }
        }
        String string = this.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    public void init(@Nullable PsiElement element) {
    }

    public boolean isPlainIdentifier() {
        SqlIdentifier identifier = this.getIdentifier();
        return identifier != null && identifier.isPlainIdentifier();
    }

    public boolean isQuotedIdentifier() {
        SqlIdentifier identifier = this.getIdentifier();
        return identifier != null && identifier.isQuotedIdentifier();
    }

    @NotNull
    public SqlNameElement setName(@NotNull String newElementName) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
            SqlIdentifier sqlIdentifier = this.getIdentifier();
            if (sqlIdentifier == null) break block0;
            sqlIdentifier.setName(newElementName);
        }
        return (SqlNameElement)this;
    }

    @NotNull
    public SqlReferenceImpl getReference() {
        if (this.myReference == null) {
            this.myReference = new SqlReferenceImpl(this){
                final /* synthetic */ SqlReferenceExpressionImpl this$0;
                {
                    this.this$0 = $receiver;
                    super((SqlElement)$receiver);
                }

                public SqlExpression getQualifierExpression() {
                    return this.this$0.getQualifierExpression();
                }

                public String getReferenceName() {
                    return this.this$0.getName();
                }

                protected boolean shouldProcessFunctionVariants() {
                    return this.this$0.getIdentifier() != null;
                }

                public TextRange getRangeInElement() {
                    PsiElement element;
                    SqlNameElement anchor;
                    SqlReferenceExpressionImpl expr = this.this$0;
                    SqlNameElement sqlNameElement = anchor = SqlImplUtil.isRefWithDblink((PsiElement)expr) ? (SqlNameElement)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)expr), SqlReferenceExpression.class) : (SqlNameElement)this.this$0.getIdentifier();
                    if (sqlNameElement != null) {
                        TextRange textRange = TextRange.from((int)sqlNameElement.getStartOffsetInParent(), (int)anchor.getTextLength());
                        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"from(...)");
                        return textRange;
                    }
                    PsiElement psiElement = element = this.this$0.findPsiChildByType((IElementType)SqlCommonTokens.SQL_PERIOD);
                    return new TextRange(psiElement != null ? psiElement.getStartOffsetInParent() + 1 : 0, this.this$0.getTextLength());
                }

                public PsiElement handleElementRename(String newElementName) {
                    Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
                    return (PsiElement)this.this$0.setName(newElementName);
                }
            };
        }
        SqlReferenceImpl sqlReferenceImpl = this.myReference;
        Intrinsics.checkNotNull((Object)sqlReferenceImpl);
        return sqlReferenceImpl;
    }

    @NotNull
    public Collection<? extends PsiSymbolReference> getOwnReferences() {
        Object[] objectArray = new SqlReferenceImpl[]{this.getReference()};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = this.getReference().multiResolve(incompleteCode);
        Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
        return resolveResultArray;
    }

    @Nullable
    public ResolveResult resolveSingle() {
        return this.getReference().resolveSingle();
    }

    @Nullable
    public PsiElement resolve() {
        return this.getReference().resolve();
    }

    @Nullable
    public DasSymbol resolveSymbol() {
        return DasSymbolUtil.getSymbol(this.resolveSingle());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public DasSymbol[] multiResolveSymbol() {
        ResolveResult[] $this$map2Array$iv = this.multiResolve(false);
        boolean $i$f$map2Array = false;
        int n = 0;
        int n2 = $this$map2Array$iv.length;
        DasSymbol[] dasSymbolArray = new DasSymbol[n2];
        while (n < n2) {
            void p0;
            DasSymbol dasSymbol;
            int n3 = n++;
            ResolveResult resolveResult = $this$map2Array$iv[n3];
            int n4 = n3;
            DasSymbol[] dasSymbolArray2 = dasSymbolArray;
            boolean bl = false;
            dasSymbolArray2[n4] = dasSymbol = DasSymbolUtil.getSymbol((ResolveResult)p0);
        }
        return dasSymbolArray;
    }

    @NotNull
    public SqlReferenceElementType getReferenceElementType() {
        SqlReferenceElementType sqlReferenceElementType = this.getReference().getReferenceElementType();
        Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceElementType, (String)"getReferenceElementType(...)");
        return sqlReferenceElementType;
    }

    @NotNull
    public String getReferencePart(@NotNull ObjectKind kind) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        String string = SqlImplUtil.getCasedPart(this, kind);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCasedPart(...)");
        return string;
    }

    @Nullable
    public PsiMetaData getMetaData() {
        return this;
    }

    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = this.getReferenceElementType().getTargetKind();
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getTargetKind(...)");
        return objectKind;
    }

    public boolean isQuoted() {
        return this.isQuotedIdentifier();
    }
}

