/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.types.DasType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlDasTypeAwareDeepRecursiveElement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlSelectModifierClauseBase;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import kotlin.DeepRecursiveScope;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J*\u0010\u0006\u001a\u00020\u0007*\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/psi/impl/SqlSelectRegexFilterClause;", "Lcom/intellij/sql/psi/impl/SqlSelectModifierClauseBase;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Lcom/intellij/psi/tree/IElementType;)V", "adjustQueryType", "Lcom/intellij/sql/psi/SqlTableType;", "Lkotlin/DeepRecursiveScope;", "Lcom/intellij/sql/psi/impl/SqlDasTypeAwareDeepRecursiveElement;", "Lcom/intellij/database/types/DasType;", "Lcom/intellij/sql/psi/impl/SqlDeepRecursiveTypeEvaluationScope;", "type", "(Lkotlin/DeepRecursiveScope;Lcom/intellij/sql/psi/SqlTableType;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.database.sql.core.impl"})
public final class SqlSelectRegexFilterClause
extends SqlSelectModifierClauseBase {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public SqlSelectRegexFilterClause(@NotNull IElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        super(elementType);
    }

    @Override
    @Nullable
    public Object adjustQueryType(@NotNull DeepRecursiveScope<SqlDasTypeAwareDeepRecursiveElement, DasType> $this$adjustQueryType, @NotNull SqlTableType type, @NotNull Continuation<? super SqlTableType> $completion) {
        Pattern pattern;
        if (type.getColumnCount() == 0) {
            return type;
        }
        PsiElement psiElement = this.getLastChild();
        SqlStringLiteralExpression sqlStringLiteralExpression = psiElement instanceof SqlStringLiteralExpression ? (SqlStringLiteralExpression)psiElement : null;
        if (sqlStringLiteralExpression == null) {
            return type;
        }
        SqlStringLiteralExpression literal = sqlStringLiteralExpression;
        String string = literal.getValue();
        if (string == null) {
            return type;
        }
        String pattern2 = string;
        int wildcardsThreshold = 10;
        if (StringUtil.countChars((CharSequence)pattern2, (char)'%') > wildcardsThreshold) {
            return type;
        }
        String string2 = StringUtil.escapeToRegexp((String)pattern2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"escapeToRegexp(...)");
        String javaPattern = StringsKt.replace$default((String)StringsKt.replace$default((String)string2, (char)'_', (char)'.', (boolean)false, (int)4, null), (String)"%", (String)".*", (boolean)false, (int)4, null);
        try {
            pattern = Pattern.compile(javaPattern, 2);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return type;
        }
        Pattern compiled = pattern;
        try {
            Intrinsics.checkNotNull((Object)compiled);
            List patternSyntaxException = SqlSelectRegexFilterClause.Companion.filterColumns(type, compiled);
        }
        catch (StackOverflowError stackOverflowError) {
            return type;
        }
        List columns = patternSyntaxException;
        PsiElement qualifier = type.getColumnQualifier(0);
        SqlTableType sqlTableType = SqlImplUtil.createType(null, ":", columns, qualifier);
        Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"createType(...)");
        return sqlTableType;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/sql/psi/impl/SqlSelectRegexFilterClause$Companion;", "", "<init>", "()V", "filterColumns", "", "Lcom/intellij/sql/psi/impl/SqlImplUtil$Column;", "type", "Lcom/intellij/sql/psi/SqlTableType;", "compiled", "Ljava/util/regex/Pattern;", "intellij.database.sql.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final List<SqlImplUtil.Column> filterColumns(SqlTableType type, Pattern compiled) {
            ArrayList<SqlImplUtil.Column> columns = new ArrayList<SqlImplUtil.Column>();
            int n = type.getColumnCount();
            for (int i2 = 0; i2 < n; ++i2) {
                String columnName = type.getColumnName(i2);
                Matcher matcher = compiled.matcher(columnName);
                if (!matcher.matches()) continue;
                columns.add(new SqlImplUtil.Column(columnName, type.getColumnDasType(i2), type.getColumnElement(i2), type.getSourceColumnElement(i2)));
            }
            return columns;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

