/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.json;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.CharRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.json.JsonLexer;
import org.jetbrains.letsPlot.commons.intern.json.JsonSupportKt;
import org.jetbrains.letsPlot.commons.intern.json.Token;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0002J$\u0010\u0013\u001a\u00020\u00122\n\u0010\u0014\u001a\u00020\u0015\"\u00020\u00062\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u0017H\u0002J\u001c\u0010\u0018\u001a\u00020\u00122\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\b\u0010\u001c\u001a\u00020\u0003H\u0002J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u001bJ\u0006\u0010 \u001a\u00020\u0012J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0003H\u0002J\b\u0010#\u001a\u00020\u001bH\u0002J\b\u0010$\u001a\u00020\u0012H\u0002J\b\u0010%\u001a\u00020\u0012H\u0002J\u0006\u0010&\u001a\u00020\u0003R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\"\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/letsPlot/commons/intern/json/JsonLexer;", "", "input", "", "(Ljava/lang/String;)V", "currentChar", "", "getCurrentChar", "()C", "<set-?>", "Lorg/jetbrains/letsPlot/commons/intern/json/Token;", "currentToken", "getCurrentToken", "()Lorg/jetbrains/letsPlot/commons/intern/json/Token;", "i", "", "tokenStart", "advance", "", "advanceIfCurrent", "expected", "", "then", "Lkotlin/Function0;", "advanceWhile", "pred", "Lkotlin/Function1;", "", "formatLexerError", "getHighlight", "Lorg/jetbrains/letsPlot/commons/intern/json/JsonLexer$Companion$Highlight;", "isFinished", "nextToken", "read", "str", "readNumber", "readString", "startToken", "tokenValue", "Companion", "commons"})
@SourceDebugExtension(value={"SMAP\nJsonLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonLexer.kt\norg/jetbrains/letsPlot/commons/intern/json/JsonLexer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,165:1\n1#2:166\n1174#3,2:167\n1099#3,3:169\n*S KotlinDebug\n*F\n+ 1 JsonLexer.kt\norg/jetbrains/letsPlot/commons/intern/json/JsonLexer\n*L\n99#1:167,2\n133#1:169,3\n*E\n"})
public final class JsonLexer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String input;
    private int i;
    private int tokenStart;
    @Nullable
    private Token currentToken;
    @NotNull
    private static final CharRange digits = new CharRange('0', '9');

    public JsonLexer(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.input = input;
        this.nextToken();
    }

    @Nullable
    public final Token getCurrentToken() {
        return this.currentToken;
    }

    private final char getCurrentChar() {
        return this.input.charAt(this.i);
    }

    public final void nextToken() {
        Token token;
        Token it;
        Token token2;
        this.advanceWhile((Function1<? super Character, Boolean>)((Function1)nextToken.1.INSTANCE));
        if (this.isFinished()) {
            return;
        }
        if (this.getCurrentChar() == '{') {
            it = token2 = Token.LEFT_BRACE;
            boolean bl = false;
            this.advance();
            token = token2;
        } else if (this.getCurrentChar() == '}') {
            it = token2 = Token.RIGHT_BRACE;
            boolean bl = false;
            this.advance();
            token = token2;
        } else if (this.getCurrentChar() == '[') {
            it = token2 = Token.LEFT_BRACKET;
            boolean bl = false;
            this.advance();
            token = token2;
        } else if (this.getCurrentChar() == ']') {
            it = token2 = Token.RIGHT_BRACKET;
            boolean bl = false;
            this.advance();
            token = token2;
        } else if (this.getCurrentChar() == ',') {
            it = token2 = Token.COMMA;
            boolean bl = false;
            this.advance();
            token = token2;
        } else if (this.getCurrentChar() == ':') {
            it = token2 = Token.COLON;
            boolean bl = false;
            this.advance();
            token = token2;
        } else if (this.getCurrentChar() == 't') {
            it = token2 = Token.TRUE;
            boolean bl = false;
            this.read("true");
            token = token2;
        } else if (this.getCurrentChar() == 'f') {
            it = token2 = Token.FALSE;
            boolean bl = false;
            this.read("false");
            token = token2;
        } else if (this.getCurrentChar() == 'n') {
            it = token2 = Token.NULL;
            boolean bl = false;
            this.read("null");
            token = token2;
        } else if (this.getCurrentChar() == '\"') {
            it = token2 = Token.STRING;
            boolean bl = false;
            this.readString();
            token = token2;
        } else if (this.readNumber()) {
            token = Token.NUMBER;
        } else {
            throw new IllegalStateException(this.formatLexerError().toString());
        }
        it = token2 = token;
        boolean bl = false;
        this.currentToken = it;
    }

    @NotNull
    public final String tokenValue() {
        String string = this.input.substring(this.tokenStart, this.i);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    private final void readString() {
        this.startToken();
        this.advance();
        while (this.getCurrentChar() != '\"') {
            if (this.getCurrentChar() == '\\') {
                this.advance();
                char c = this.getCurrentChar();
                if (c == 'u') {
                    this.advance();
                    int n = 4;
                    int n2 = 0;
                    while (n2 < n) {
                        int it = n2++;
                        boolean bl = false;
                        if (!JsonLexer.Companion.isHex(this.getCurrentChar())) {
                            String string = "Failed requirement.";
                            throw new IllegalArgumentException(string.toString());
                        }
                        this.advance();
                    }
                    continue;
                }
                Character c2 = Character.valueOf(c);
                if (JsonSupportKt.getSPECIAL_CHARS().containsKey(c2)) {
                    this.advance();
                    continue;
                }
                throw new IllegalStateException("Invalid escape sequence".toString());
            }
            this.advance();
        }
        this.advance();
    }

    private final boolean readNumber() {
        if (!JsonLexer.Companion.isDigit(Character.valueOf(this.getCurrentChar())) && this.getCurrentChar() != '-') {
            return false;
        }
        this.startToken();
        char[] cArray = new char[]{'-'};
        JsonLexer.advanceIfCurrent$default(this, cArray, null, 2, null);
        this.advanceWhile((Function1<? super Character, Boolean>)((Function1)readNumber.1.INSTANCE));
        cArray = new char[]{'.'};
        this.advanceIfCurrent(cArray, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ JsonLexer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (!org.jetbrains.letsPlot.commons.intern.json.JsonLexer$Companion.access$isDigit(JsonLexer.Companion, Character.valueOf(JsonLexer.access$getCurrentChar(this.this$0)))) {
                    boolean bl = false;
                    String string = "Number should have decimal part";
                    throw new IllegalArgumentException(string.toString());
                }
                JsonLexer.access$advanceWhile(this.this$0, readNumber.2.INSTANCE);
            }
        }));
        cArray = new char[]{'e', 'E'};
        this.advanceIfCurrent(cArray, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ JsonLexer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                char[] cArray = new char[]{'+', '-'};
                JsonLexer.advanceIfCurrent$default(this.this$0, cArray, null, 2, null);
                JsonLexer.access$advanceWhile(this.this$0, readNumber.1.INSTANCE);
            }
        }));
        return true;
    }

    public final boolean isFinished() {
        return this.i == this.input.length();
    }

    private final void startToken() {
        this.tokenStart = this.i;
    }

    private final void advance() {
        ++this.i;
    }

    private final void read(String str) {
        CharSequence $this$forEach$iv = str;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            if (!(this.getCurrentChar() == it)) {
                boolean $i$a$-require-JsonLexer$read$1$32 = false;
                String $i$a$-require-JsonLexer$read$1$32 = "Wrong data: " + str;
                throw new IllegalArgumentException($i$a$-require-JsonLexer$read$1$32.toString());
            }
            if (!(!this.isFinished())) {
                boolean bl2 = false;
                String string = "Unexpected end of string";
                throw new IllegalArgumentException(string.toString());
            }
            this.advance();
        }
    }

    private final void advanceWhile(Function1<? super Character, Boolean> pred) {
        while (!this.isFinished() && ((Boolean)pred.invoke((Object)Character.valueOf(this.getCurrentChar()))).booleanValue()) {
            this.advance();
        }
    }

    private final void advanceIfCurrent(char[] expected, Function0<Unit> then) {
        if (!this.isFinished() && ArraysKt.contains((char[])expected, (char)this.getCurrentChar())) {
            this.advance();
            then.invoke();
        }
    }

    static /* synthetic */ void advanceIfCurrent$default(JsonLexer jsonLexer, char[] cArray, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = advanceIfCurrent.1.INSTANCE;
        }
        jsonLexer.advanceIfCurrent(cArray, (Function0<Unit>)function0);
    }

    @NotNull
    public final Companion.Highlight getHighlight() {
        Pair pair2;
        int it = StringsKt.lastIndexOf$default((CharSequence)this.input.subSequence(0, this.i), (char)'\n', (int)0, (boolean)false, (int)6, null);
        boolean bl = false;
        int lineStart = it == -1 ? 0 : it + 1;
        int it2 = StringsKt.indexOf$default((CharSequence)this.input, (char)'\n', (int)this.i, (boolean)false, (int)4, null);
        boolean bl2 = false;
        int lineEnd = it2 == -1 ? this.input.length() : it2;
        int lineLength = lineEnd - lineStart;
        if (lineLength <= 81) {
            pair2 = new Pair((Object)lineStart, (Object)lineEnd);
        } else if (lineLength > 81) {
            pair2 = new Pair((Object)Math.max(lineStart, this.i - 40), (Object)Math.min(lineEnd, this.i + 41));
        } else {
            if (lineLength < 0) {
                throw new IllegalStateException("Negative line length".toString());
            }
            throw new IllegalStateException(("Unexpected line length: " + lineLength).toString());
        }
        Pair pair3 = pair2;
        int fragmentStart = ((Number)pair3.component1()).intValue();
        int fragmentEnd = ((Number)pair3.component2()).intValue();
        CharSequence $this$count$iv = this.input.subSequence(0, this.i);
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it3 = element$iv = $this$count$iv.charAt(i);
            boolean bl3 = false;
            if (!(it3 == '\n')) continue;
            ++count$iv;
        }
        int it4 = count$iv;
        boolean bl4 = false;
        int lineNumber = it4 == 0 ? 1 : it4 + 1;
        int symbolLinePos = this.i - lineStart + 1;
        String string = this.input.substring(fragmentStart, fragmentEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return new Companion.Highlight(lineNumber, symbolLinePos, string, StringsKt.repeat((CharSequence)" ", (int)(this.i - fragmentStart)) + '^');
    }

    private final String formatLexerError() {
        Companion.Highlight highlight = this.getHighlight();
        return "Unknown token >" + this.input.charAt(this.i) + "< at " + this.i + " (" + highlight.getLineNumber() + ':' + highlight.getSymbolLinePos() + ")\n" + highlight.getFragment() + '\n' + highlight.getPointer();
    }

    public static final /* synthetic */ char access$getCurrentChar(JsonLexer $this) {
        return $this.getCurrentChar();
    }

    public static final /* synthetic */ void access$advanceWhile(JsonLexer $this, Function1 pred) {
        $this.advanceWhile((Function1<? super Character, Boolean>)pred);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\f\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0005\u001a\u00020\u0006*\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010\bJ\f\u0010\t\u001a\u00020\u0006*\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/json/JsonLexer$Companion;", "", "()V", "digits", "Lkotlin/ranges/CharRange;", "isDigit", "", "", "(Ljava/lang/Character;)Z", "isHex", "Highlight", "commons"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isDigit(Character $this$isDigit) {
            CharRange charRange = digits;
            return $this$isDigit != null && charRange.contains($this$isDigit.charValue());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isHex(char $this$isHex) {
            boolean bl;
            if (this.isDigit(Character.valueOf($this$isHex))) return true;
            if ('a' <= $this$isHex) {
                if ($this$isHex < 'g') {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
            if ('A' > $this$isHex) return false;
            if ($this$isHex >= 'G') return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/json/JsonLexer$Companion$Highlight;", "", "lineNumber", "", "symbolLinePos", "fragment", "", "pointer", "(IILjava/lang/String;Ljava/lang/String;)V", "getFragment", "()Ljava/lang/String;", "getLineNumber", "()I", "getPointer", "getSymbolLinePos", "commons"})
        public static final class Highlight {
            private final int lineNumber;
            private final int symbolLinePos;
            @NotNull
            private final String fragment;
            @NotNull
            private final String pointer;

            public Highlight(int lineNumber, int symbolLinePos, @NotNull String fragment, @NotNull String pointer) {
                Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
                Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
                this.lineNumber = lineNumber;
                this.symbolLinePos = symbolLinePos;
                this.fragment = fragment;
                this.pointer = pointer;
            }

            public final int getLineNumber() {
                return this.lineNumber;
            }

            public final int getSymbolLinePos() {
                return this.symbolLinePos;
            }

            @NotNull
            public final String getFragment() {
                return this.fragment;
            }

            @NotNull
            public final String getPointer() {
                return this.pointer;
            }
        }
    }
}

